/**
 * Select3 Japanese translation.
 */
(function ($) {
    "use strict";

    $.fn.select3.locales['ja'] = {
        formatNoMatches: function () { return "該当なし"; },
        formatInputTooShort: function (input, min) { var n = min - input.length; return "後" + n + "文字入れてください"; },
        formatInputTooLong: function (input, max) { var n = input.length - max; return "検索文字列が" + n + "文字長すぎます"; },
        formatSelectionTooBig: function (limit) { return "最多で" + limit + "項目までしか選択できません"; },
        formatLoadMore: function (pageNumber) { return "読込中･･･"; },
        formatSearching: function () { return "検索中･･･"; }
    };

    $.extend($.fn.select3.defaults, $.fn.select3.locales['ja']);
})(jQuery);
