SET AUTOCOMMIT = 0;
START TRANSACTION;
DROP TABLE IF EXISTS `wp_awb_critical_css`;
CREATE TABLE `wp_awb_critical_css` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `css_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile_css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `desktop_css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile_preloads` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `desktop_preloads` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `updated_at` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_fusion_form_entries`;
CREATE TABLE `wp_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_fusion_form_entries` VALUES (1,1,3,1,'CYNTHIA',0,NULL),(2,1,3,2,'morena-pris@hotmail.com',0,NULL),(3,1,3,3,'633233406',0,NULL),(4,1,3,4,'Ford',0,NULL),(5,2,3,1,'Yaiza',0,NULL),(6,2,3,2,'yaiza.c@setroiprensa.net',0,NULL),(7,2,3,3,'621342118',0,NULL),(8,2,3,4,'Ford',0,NULL),(9,3,3,1,'CYNTHIA Mora Barahona',0,NULL),(10,3,3,2,'morena-pris@hotmail.com',0,NULL),(11,3,3,3,'633233406',0,NULL),(12,3,3,4,'Otro',0,NULL),(13,4,3,1,'cynthia priscilla',0,NULL),(14,4,3,2,'morena-pris@hotmail.com',0,NULL),(15,4,3,3,'633233406',0,NULL),(16,4,3,4,'Ford',0,NULL),(17,5,3,1,'David Pueyo',0,NULL),(18,5,3,2,'davigochi@gmail.com',0,NULL),(19,5,3,3,'608891319',0,NULL),(20,5,3,4,'Otro',0,NULL),(21,6,3,1,'Cynthia Mora',0,NULL),(22,6,3,2,'morena-pris@hotmail.com',0,NULL),(23,6,3,3,'+34633233406',0,NULL),(24,6,3,4,'Ford',0,NULL),(25,7,3,1,'Jose',0,NULL),(26,7,3,2,'jose.b@aparecerenperiodicos.com',0,NULL),(27,7,3,3,'632078881',0,NULL),(28,7,3,4,'Tesla',0,NULL),(29,8,1,5,'luis',0,NULL),(30,8,1,6,'',0,NULL),(31,9,3,1,'Naun Patricio Rodriguez Garcia',0,NULL),(32,9,3,2,'makpato@hotmail.es',0,NULL),(33,9,3,3,'633472161',0,NULL),(34,9,3,4,'Ford',0,NULL),(35,10,3,1,'Alberto',0,NULL),(36,10,3,2,'posicionamiento@seoparaempresas.net',0,NULL),(37,10,3,3,'964921014',0,NULL),(38,10,3,4,'Ford',0,NULL);
DROP TABLE IF EXISTS `wp_fusion_form_fields`;
CREATE TABLE `wp_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_fusion_form_fields` VALUES (1,3,'name','',NULL),(2,3,'email','',NULL),(3,3,'phone','',NULL),(4,3,'model','',NULL),(5,1,'nombre','',NULL),(6,1,'telefono','',NULL);
DROP TABLE IF EXISTS `wp_fusion_form_submissions`;
CREATE TABLE `wp_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_fusion_form_submissions` VALUES (1,3,'2021-11-16 09:14:47','https://customcarvalencia.com/contact/',41,0,'','',0,'2025-10-26','ignore',NULL),(2,3,'2021-12-10 07:19:05','https://customcarvalencia.com/contact/',41,0,'','',0,'2025-11-19','ignore',NULL),(3,3,'2021-12-12 21:16:25','https://customcarvalencia.com/contact/',41,0,'','',0,'2025-11-21','ignore',NULL),(4,3,'2022-01-12 16:41:14','https://customcarvalencia.com/contact/',41,0,'','',0,'2025-12-22','ignore',NULL),(5,3,'2022-01-13 17:56:49','https://customcarvalencia.com/contact/',41,1,'','',0,'2025-12-23','ignore',NULL),(6,3,'2022-01-13 18:02:37','https://customcarvalencia.com/contact/',41,0,'','',0,'2025-12-23','ignore',NULL),(7,3,'2022-01-28 12:55:29','https://customcarvalencia.com/contact/',41,0,'','',0,'2026-01-07','ignore',NULL),(8,1,'2022-02-22 17:14:12','https://customcarvalencia.com/',1277,0,'','',0,'2026-02-01','anonymize',NULL),(9,3,'2022-02-22 17:22:25','https://customcarvalencia.com/contact/',41,0,'','',0,'2026-02-01','ignore',NULL),(10,3,'2022-02-24 10:07:42','https://customcarvalencia.com/contact/',41,0,'','',0,'2026-02-03','ignore',NULL);
DROP TABLE IF EXISTS `wp_fusion_forms`;
CREATE TABLE `wp_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT 0,
  `submissions_count` bigint(20) DEFAULT 0,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_fusion_forms` VALUES (1,106,506,1,NULL),(2,300,1013,0,NULL),(3,641,84,9,NULL),(4,381,4,0,NULL);
DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_litespeed_url`;
CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_litespeed_url_file`;
CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=8478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_options` VALUES (1,'siteurl','https://customcarvalencia.com','yes'),(2,'home','https://customcarvalencia.com','yes'),(3,'blogname','Custom Car Valencia','yes'),(4,'blogdescription','Tintado de lunas para coches en Valencia','yes'),(5,'users_can_register','0','yes'),(6,'admin_email','info@customcarvalencia.com','yes'),(7,'start_of_week','1','yes'),(8,'use_balanceTags','0','yes'),(9,'use_smilies','0','yes'),(10,'require_name_email','1','yes'),(11,'comments_notify','1','yes'),(12,'posts_per_rss','10','yes'),(13,'rss_use_excerpt','0','yes'),(14,'mailserver_url','mail.example.com','yes'),(15,'mailserver_login','login@example.com','yes'),(16,'mailserver_pass','password','yes'),(17,'mailserver_port','110','yes'),(18,'default_category','1','yes'),(19,'default_comment_status','open','yes'),(20,'default_ping_status','open','yes'),(21,'default_pingback_flag','1','yes'),(22,'posts_per_page','10','yes'),(23,'date_format','d/m/Y','yes'),(24,'time_format','H:i','yes'),(25,'links_updated_date_format','F j, Y g:i a','yes'),(26,'comment_moderation','0','yes'),(27,'moderation_notify','1','yes'),(28,'permalink_structure','/%postname%/','yes'),(29,'rewrite_rules','a:299:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"portfolio-items/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:48:\"portfolio-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:43:\"portfolio-items/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:35:\"portfolio-items/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:44:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"fusion_tb_layout/([^/]+)/embed/?$\";s:49:\"index.php?fusion_tb_layout=$matches[1]&embed=true\";s:37:\"fusion_tb_layout/([^/]+)/trackback/?$\";s:43:\"index.php?fusion_tb_layout=$matches[1]&tb=1\";s:45:\"fusion_tb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\";s:52:\"fusion_tb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\";s:41:\"fusion_tb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\";s:33:\"fusion_tb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"fusion_tb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"fusion_tb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_tb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"fusion_tb_section/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"fusion_tb_section/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"fusion_tb_section/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"fusion_tb_section/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"fusion_tb_section/([^/]+)/embed/?$\";s:50:\"index.php?fusion_tb_section=$matches[1]&embed=true\";s:38:\"fusion_tb_section/([^/]+)/trackback/?$\";s:44:\"index.php?fusion_tb_section=$matches[1]&tb=1\";s:46:\"fusion_tb_section/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\";s:53:\"fusion_tb_section/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\";s:42:\"fusion_tb_section/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\";s:34:\"fusion_tb_section/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"fusion_tb_section/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"fusion_tb_section/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_tb_section/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"fusion_tb_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:54:\"fusion_tb_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:35:\"fusion_tb_category/([^/]+)/embed/?$\";s:51:\"index.php?fusion_tb_category=$matches[1]&embed=true\";s:47:\"fusion_tb_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?fusion_tb_category=$matches[1]&paged=$matches[2]\";s:29:\"fusion_tb_category/([^/]+)/?$\";s:40:\"index.php?fusion_tb_category=$matches[1]\";s:39:\"fusion_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"fusion_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"fusion_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"fusion_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"fusion_form/([^/]+)/embed/?$\";s:44:\"index.php?fusion_form=$matches[1]&embed=true\";s:32:\"fusion_form/([^/]+)/trackback/?$\";s:38:\"index.php?fusion_form=$matches[1]&tb=1\";s:40:\"fusion_form/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&paged=$matches[2]\";s:47:\"fusion_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\";s:36:\"fusion_form/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?fusion_form=$matches[1]&page=$matches[2]\";s:28:\"fusion_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"fusion_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"fusion_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"fusion_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:36:\"seedprod/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"seedprod/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"seedprod/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"seedprod/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"seedprod/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"seedprod/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"seedprod/([^/]+)/embed/?$\";s:41:\"index.php?seedprod=$matches[1]&embed=true\";s:29:\"seedprod/([^/]+)/trackback/?$\";s:35:\"index.php?seedprod=$matches[1]&tb=1\";s:37:\"seedprod/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&paged=$matches[2]\";s:44:\"seedprod/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&cpage=$matches[2]\";s:33:\"seedprod/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?seedprod=$matches[1]&page=$matches[2]\";s:25:\"seedprod/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"seedprod/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"seedprod/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"seedprod/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"seedprod/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"seedprod/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"portfolio-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-items/([^/]+)/embed/?$\";s:48:\"index.php?avada_portfolio=$matches[1]&embed=true\";s:36:\"portfolio-items/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:56:\"portfolio-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-items/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-items/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:33:\"portfolio_skills/([^/]+)/embed/?$\";s:49:\"index.php?portfolio_skills=$matches[1]&embed=true\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:42:\"index.php?avada_faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=slide-page&term=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=slide-page&term=$matches[1]&feed=$matches[2]\";s:27:\"slide-page/([^/]+)/embed/?$\";s:57:\"index.php?taxonomy=slide-page&term=$matches[1]&embed=true\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?taxonomy=slide-page&term=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:46:\"index.php?taxonomy=slide-page&term=$matches[1]\";s:43:\"fusion_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"fusion_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"fusion_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"fusion_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"fusion_template/([^/]+)/embed/?$\";s:48:\"index.php?fusion_template=$matches[1]&embed=true\";s:36:\"fusion_template/([^/]+)/trackback/?$\";s:42:\"index.php?fusion_template=$matches[1]&tb=1\";s:44:\"fusion_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&paged=$matches[2]\";s:51:\"fusion_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?fusion_template=$matches[1]&page=$matches[2]\";s:32:\"fusion_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"fusion_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"fusion_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"fusion_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"fusion_element/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"fusion_element/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"fusion_element/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"fusion_element/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"fusion_element/([^/]+)/embed/?$\";s:47:\"index.php?fusion_element=$matches[1]&embed=true\";s:35:\"fusion_element/([^/]+)/trackback/?$\";s:41:\"index.php?fusion_element=$matches[1]&tb=1\";s:43:\"fusion_element/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&paged=$matches[2]\";s:50:\"fusion_element/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_element/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?fusion_element=$matches[1]&page=$matches[2]\";s:31:\"fusion_element/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"fusion_element/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"fusion_element/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"fusion_element/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"element_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=element_category&term=$matches[1]&feed=$matches[2]\";s:52:\"element_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=element_category&term=$matches[1]&feed=$matches[2]\";s:33:\"element_category/([^/]+)/embed/?$\";s:63:\"index.php?taxonomy=element_category&term=$matches[1]&embed=true\";s:45:\"element_category/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?taxonomy=element_category&term=$matches[1]&paged=$matches[2]\";s:27:\"element_category/([^/]+)/?$\";s:52:\"index.php?taxonomy=element_category&term=$matches[1]\";s:58:\"template_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=template_category&term=$matches[1]&feed=$matches[2]\";s:53:\"template_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=template_category&term=$matches[1]&feed=$matches[2]\";s:34:\"template_category/([^/]+)/embed/?$\";s:64:\"index.php?taxonomy=template_category&term=$matches[1]&embed=true\";s:46:\"template_category/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?taxonomy=template_category&term=$matches[1]&paged=$matches[2]\";s:28:\"template_category/([^/]+)/?$\";s:53:\"index.php?taxonomy=template_category&term=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1277&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}','yes'),(30,'hack_file','0','yes'),(31,'blog_charset','UTF-8','yes'),(32,'moderation_keys','','no'),(33,'active_plugins','a:6:{i:0;s:27:\"coming-soon/coming-soon.php\";i:1;s:29:\"easy-wp-smtp/easy-wp-smtp.php\";i:2;s:33:\"fusion-builder/fusion-builder.php\";i:3;s:27:\"fusion-core/fusion-core.php\";i:4;s:35:\"litespeed-cache/litespeed-cache.php\";i:5;s:23:\"revslider/revslider.php\";}','yes'),(34,'category_base','','yes'),(35,'ping_sites','http://rpc.pingomatic.com/','yes'),(36,'comment_max_links','2','yes'),(37,'gmt_offset','0','yes'),(38,'default_email_category','1','yes'),(39,'recently_edited','','no'),(40,'template','Avada','yes'),(41,'stylesheet','Avada-Child-Theme','yes'),(42,'comment_registration','0','yes'),(43,'html_type','text/html','yes'),(44,'use_trackback','0','yes'),(45,'default_role','subscriber','yes'),(46,'db_version','49752','yes'),(47,'uploads_use_yearmonth_folders','1','yes'),(48,'upload_path','/home/customcar/public_html/wp-content/uploads','yes'),(49,'blog_public','1','yes'),(50,'default_link_category','2','yes'),(51,'show_on_front','page','yes'),(52,'tag_base','','yes'),(53,'show_avatars','1','yes'),(54,'avatar_rating','G','yes'),(55,'upload_url_path','','yes'),(56,'thumbnail_size_w','150','yes'),(57,'thumbnail_size_h','150','yes'),(58,'thumbnail_crop','1','yes'),(59,'medium_size_w','300','yes'),(60,'medium_size_h','300','yes'),(61,'avatar_default','mystery','yes'),(62,'large_size_w','1024','yes'),(63,'large_size_h','1024','yes'),(64,'image_default_link_type','none','yes'),(65,'image_default_size','','yes'),(66,'image_default_align','','yes'),(67,'close_comments_for_old_posts','0','yes'),(68,'close_comments_days_old','14','yes'),(69,'thread_comments','1','yes'),(70,'thread_comments_depth','5','yes'),(71,'page_comments','0','yes'),(72,'comments_per_page','50','yes'),(73,'default_comments_page','newest','yes'),(74,'comment_order','asc','yes'),(75,'sticky_posts','a:0:{}','yes'),(76,'widget_categories','a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}','yes'),(77,'widget_text','a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}','yes'),(78,'widget_rss','a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}','yes'),(79,'uninstall_plugins','a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:29:\"easy-wp-smtp/easy-wp-smtp.php\";s:17:\"swpsmtp_uninstall\";}','no'),(80,'timezone_string','','yes'),(81,'page_for_posts','0','yes'),(82,'page_on_front','1277','yes'),(83,'default_post_format','0','yes'),(84,'link_manager_enabled','0','yes'),(85,'finished_splitting_shared_terms','1','yes'),(86,'site_icon','0','yes'),(87,'medium_large_size_w','768','yes'),(88,'medium_large_size_h','0','yes'),(89,'wp_page_for_privacy_policy','3','yes'),(90,'show_comments_cookies_opt_in','1','yes'),(91,'admin_email_lifespan','1651921604','yes'),(92,'disallowed_keys','','no'),(93,'comment_previously_approved','1','yes'),(94,'auto_plugin_theme_update_emails','a:0:{}','no'),(95,'auto_update_core_dev','enabled','yes'),(96,'auto_update_core_minor','enabled','yes'),(97,'auto_update_core_major','enabled','yes'),(98,'wp_force_deactivated_plugins','a:0:{}','yes'),(99,'initial_db_version','49752','yes'),(100,'wp_user_roles','a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}','yes'),(101,'fresh_site','0','yes'),(102,'widget_block','a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}','yes'),(103,'sidebars_widgets','a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:8:\"search-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";}s:21:\"avada-footer-widget-1\";a:5:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";i:4;s:6:\"meta-2\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;}','yes'),(104,'cron','a:8:{i:1647040774;a:2:{s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1647043605;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1647083205;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1647083375;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647083376;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647096620;a:1:{s:22:\"seedprod_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1647342405;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}','yes'),(105,'widget_pages','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(106,'widget_calendar','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(107,'widget_archives','a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}','yes'),(108,'widget_media_audio','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(109,'widget_media_image','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(110,'widget_media_gallery','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(111,'widget_media_video','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(112,'widget_meta','a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}','yes'),(113,'widget_search','a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}','yes'),(114,'widget_tag_cloud','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(115,'widget_nav_menu','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(116,'widget_custom_html','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(118,'recovery_keys','a:0:{}','yes'),(119,'theme_mods_twentytwentyone','a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1636371757;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}','yes'),(120,'https_detection_errors','a:0:{}','yes'),(128,'_transient_update_plugins','O:8:\"stdClass\":2:{s:12:\"last_checked\";i:0;s:8:\"response\";a:2:{s:33:\"fusion-builder/fusion-builder.php\";O:8:\"stdClass\":8:{s:2:\"id\";s:33:\"fusion-builder/fusion-builder.php\";s:4:\"slug\";s:14:\"fusion-builder\";s:6:\"plugin\";s:33:\"fusion-builder/fusion-builder.php\";s:11:\"new_version\";s:3:\"3.5\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:98:\"https://updates.theme-fusion.com/?avada_action=get_download&item_name=Avada%20Builder&ver=7.5&code\";s:5:\"icons\";a:2:{s:2:\"1x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:2:\"2x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:7:\"default\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";}}s:27:\"fusion-core/fusion-core.php\";O:8:\"stdClass\":8:{s:2:\"id\";s:27:\"fusion-core/fusion-core.php\";s:4:\"slug\";s:11:\"fusion-core\";s:6:\"plugin\";s:27:\"fusion-core/fusion-core.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:95:\"https://updates.theme-fusion.com/?avada_action=get_download&item_name=Avada%20Core&ver=7.5&code\";s:5:\"icons\";a:2:{s:2:\"1x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:2:\"2x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:7:\"default\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";}}}}','yes'),(129,'_transient_update_themes','O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}','yes'),(142,'can_compress_scripts','1','no'),(151,'finished_updating_comment_type','1','yes'),(162,'current_theme','Avada Child','yes'),(163,'theme_mods_Avada-Child-Theme','a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:9;}s:18:\"custom_css_post_id\";i:-1;}','yes'),(164,'theme_switched','','yes'),(165,'avada_version','7.5.0','yes'),(170,'_transient_timeout_avada_demos','1636458158','no'),(172,'shop_catalog_image_size','a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}','yes'),(173,'shop_single_image_size','a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}','yes'),(174,'shop_thumbnail_image_size','a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}','yes'),(175,'woocommerce_single_image_width','700','yes'),(176,'woocommerce_thumbnail_image_width','500','yes'),(177,'woocommerce_thumbnail_cropping','uncropped','yes'),(178,'fusion_dynamic_css_posts','a:32:{i:1277;b:1;i:892;b:1;i:39;b:1;i:41;b:1;i:37;b:1;s:6:\"global\";b:1;i:880;b:1;i:951;b:1;i:664;b:1;i:894;b:1;s:9:\"1-archive\";b:1;i:715;b:1;i:718;b:1;s:9:\"2-archive\";b:1;i:1;b:1;i:712;b:1;i:161;b:1;i:963;b:1;i:1339;b:1;i:1341;b:1;i:1343;b:1;i:1523;b:0;i:641;b:0;s:9:\"6-archive\";b:1;s:9:\"5-archive\";b:1;s:9:\"4-archive\";b:1;i:2;b:1;s:9:\"3-archive\";b:1;i:975;b:1;i:961;b:1;i:159;b:1;i:163;b:1;}','yes'),(179,'fusion_dynamic_css_ids','a:32:{i:1277;s:32:\"9f3dff2df38fc8469471c8151646ad00\";i:892;s:32:\"56fcb754e04a882fc86c76f84d3c1011\";i:39;s:32:\"e17993d685e567e4228dee6620bbb5c5\";i:41;s:32:\"ae0a1098d186941f51d39006a59301e8\";i:37;s:32:\"45f0db870d0b7cd793b0b54f007d16f3\";i:802;s:32:\"c7613c293b7361cc9d229b8731e9c5e7\";i:880;s:32:\"56fcb754e04a882fc86c76f84d3c1011\";i:951;s:32:\"56fcb754e04a882fc86c76f84d3c1011\";i:664;s:32:\"56fcb754e04a882fc86c76f84d3c1011\";i:894;s:32:\"56fcb754e04a882fc86c76f84d3c1011\";s:9:\"1-archive\";s:32:\"82065efb85b6c45344fe0e8b6ce35bae\";i:715;s:32:\"d1618a84e96f207c5d067eccfa6ee14c\";i:718;s:32:\"d1618a84e96f207c5d067eccfa6ee14c\";s:9:\"2-archive\";s:32:\"82065efb85b6c45344fe0e8b6ce35bae\";i:1;s:32:\"a3ea4f3a202857c66561352595402472\";i:712;s:32:\"d1618a84e96f207c5d067eccfa6ee14c\";i:161;s:32:\"a3ea4f3a202857c66561352595402472\";i:963;s:32:\"a3ea4f3a202857c66561352595402472\";i:1339;s:32:\"a3ea4f3a202857c66561352595402472\";i:1341;s:32:\"a3ea4f3a202857c66561352595402472\";i:1343;s:32:\"a3ea4f3a202857c66561352595402472\";i:1523;b:0;i:641;b:0;s:9:\"6-archive\";s:32:\"60e7dc3deb988bb01cb5c08e7fa92d92\";s:9:\"5-archive\";s:32:\"60e7dc3deb988bb01cb5c08e7fa92d92\";s:9:\"4-archive\";s:32:\"60e7dc3deb988bb01cb5c08e7fa92d92\";i:2;s:32:\"d638309a79343157055b450a4da45919\";s:9:\"3-archive\";s:32:\"60e7dc3deb988bb01cb5c08e7fa92d92\";i:975;s:32:\"1edc2befdbaa2e562ede861f32d066ba\";i:961;s:32:\"9dfe6017db1f4fde0e56945edfb78aaf\";i:159;s:32:\"9dfe6017db1f4fde0e56945edfb78aaf\";i:163;s:32:\"9dfe6017db1f4fde0e56945edfb78aaf\";}','yes'),(181,'revslider-valid-notice','false','yes'),(189,'_transient_timeout_avada_ri_Fusion Core','1636372362','no'),(193,'_transient_timeout_avada_ri_Fusion Builder','1636372362','no'),(197,'_transient_timeout_avada_ri_Fusion White Label Branding','1636372362','no'),(201,'_transient_timeout_avada_ri_Slider Revolution','1636372362','no'),(205,'_transient_timeout_avada_ri_LayerSlider WP','1636372362','no'),(209,'_transient_timeout_avada_ri_Advanced Custom Fields PRO','1636372363','no'),(213,'_transient_timeout_avada_ri_Convert Plus','1636372363','no'),(217,'_transient_timeout_avada_ri_FileBird','1636372363','no'),(223,'_site_transient_fusion_wordpress_org_plugins','a:7:{s:3:\"pwa\";a:25:{s:4:\"name\";s:3:\"PWA\";s:4:\"slug\";s:3:\"pwa\";s:7:\"version\";s:5:\"0.6.0\";s:6:\"author\";s:100:\"<a href=\"https://github.com/GoogleChromeLabs/pwa-wp/graphs/contributors\">PWA Plugin Contributors</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/westonruter\";s:12:\"contributors\";a:4:{s:6:\"google\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/google\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/2adafb3bf578fd97d8d2ea1c2ccb3db3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Google\";}s:3:\"xwp\";a:3:{s:7:\"profile\";s:34:\"https://profiles.wordpress.org/xwp\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4fde309f8e69e623b883692b9bea5cb1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"XWP\";}s:11:\"westonruter\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/westonruter\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/989838a2534d491ccb184d5b8a654f99?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Weston Ruter\";}s:13:\"albertomedina\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/albertomedina\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c61e7d8efedcd6e9bf7a0c6025f80489?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"albertomedina\";}}s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:3:\"5.6\";s:6:\"rating\";i:86;s:7:\"ratings\";a:5:{i:5;i:13;i:4;i:0;i:3;i:0;i:2;i:0;i:1;i:3;}s:11:\"num_ratings\";i:16;s:15:\"support_threads\";i:13;s:24:\"support_threads_resolved\";i:5;s:15:\"active_installs\";i:40000;s:12:\"last_updated\";s:21:\"2021-09-21 7:17pm GMT\";s:5:\"added\";s:10:\"2018-07-12\";s:8:\"homepage\";s:42:\"https://github.com/GoogleChromeLabs/pwa-wp\";s:8:\"sections\";a:4:{s:11:\"description\";s:4312:\"<blockquote cite=\"https://developers.google.com/web/progressive-web-apps/\"><p>\nProgressive Web Apps are user experiences that have the reach of the web, and are:</p>\n<ul>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#reliable\" rel=\"nofollow ugc\">Confiable</a> &#8211; Carga inmediatamente y nunca muestra el downasaur, incluso en condiciones de red inciertas.</li>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#fast\" rel=\"nofollow ugc\">Rápido</a> &#8211; Responde rápidamente a la interacción de usuario con animaciones suaves como la seda y sin desplazamiento a tirones.</li>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#engaging\" rel=\"nofollow ugc\">Cautivador</a> &#8211; Se percibe como una app natural en el dispositivo, con una experiencia de usuario inmersiva.</li>\n</ul>\n<p>This new level of quality allows Progressive Web Apps to earn a place on the user&#8217;s home screen.\n</p></blockquote>\n<p>Sigue leyendo más acerca de <a href=\"https://web.dev/progressive-web-apps/\" rel=\"nofollow ugc\">aplicaciones web progresivas</a> (PWA) en Google.</p>\n<p>En general, un PWA depende de las siguientes tecnologías para estar disponible:</p>\n<ul>\n<li><a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API\" rel=\"nofollow ugc\">Service Workers</a></li>\n<li><a href=\"https://developer.mozilla.org/en-US/docs/Web/Manifest\" rel=\"nofollow ugc\">Manifest de aplicación web</a></li>\n<li><a href=\"https://en.wikipedia.org/wiki/HTTPS\" rel=\"nofollow ugc\">HTTPS</a></li>\n</ul>\n<p>Este plugin sirve como un lugar de encuentro para dar soporte a aquellos en WordPress que tienen la intención de que sea propuesto para un merge con el core , pieza a pieza.</p>\n<p>This feature plugin is <em>not</em> intended to obsolete the other plugins and themes which turn WordPress sites into PWAs. Rather, this plugin is intended to provide the PWA building blocks and coordination mechanism for these themes and plugins to not reinvent the wheel and also to not conflict with each other. For example, a theme that implements the app shell model should be able to extend the core service worker while a plugin that provides push notifications should be able to do the same. Themes and plugins no longer should have to each create a service worker on their own, something which is inherently problematic because only one service worker can be active at a time: only one service worker can win. If you are developing a plugin or theme that includes a service worker, consider relying on this PWA plugin, or at least only use the built-in implementation as a fallback for when the PWA plugin is not available.</p>\n<p>In versions prior to 0.6, no caching strategies were added by default. The only service worker behavior was to serve an offline template when the client&#8217;s connection is down or the site is down, and also to serve an error page when the server returns with 500 Internal Server Error. As of 0.6, there is a new “Offline browsing” toggle on the Reading Settings screen in the admin. It is disabled by default, but when enabled a <a href=\"https://web.dev/offline-cookbook/#network-falling-back-to-cache\" rel=\"nofollow ugc\">network-first</a> caching strategy is registered for navigations so that the offline page won&#8217;t be shown when accessing previously-accessed pages. The network-first strategy is also used for assets from themes, plugins, and WordPress core. In addition, uploaded images get served with a <a href=\"https://web.dev/offline-cookbook/#stale-while-revalidate\" rel=\"nofollow ugc\">stale-while-revalidate</a> strategy. For all the details on these changes, see the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/pull/338\" rel=\"nofollow ugc\">pull request</a>.</p>\n<p>Documentation for the plugin can be found on the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/wiki\" rel=\"nofollow ugc\">GitHub project Wiki</a>.</p>\n<p><strong>Development of this plugin is done <a href=\"https://github.com/GoogleChromeLabs/pwa-wp\" rel=\"nofollow ugc\">on GitHub</a>. Pull requests welcome. Please see <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/issues\" rel=\"nofollow ugc\">issues</a> reported there before going to the <a href=\"https://wordpress.org/support/plugin/pwa\">plugin forum</a>.</strong></p>\n\";s:3:\"faq\";s:446:\"<p>Please see the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/wiki/FAQ\" rel=\"nofollow ugc\">frequently asked questions</a> on the GitHub project wiki. Don&#8217;t see an answer to your question? Please <a href=\"https://wordpress.org/support/plugin/pwa/\">search the support forum</a> to see if someone has asked your question. Otherwise, please <a href=\"https://wordpress.org/support/plugin/pwa/#new-post\">open a new support topic</a>.</p>\n\";s:9:\"changelog\";s:162:\"<p>For the plugin’s changelog, please see <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/releases\" rel=\"nofollow ugc\">the Releases page on GitHub</a>.</p>\n\";s:7:\"reviews\";s:13642:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works neatly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/aurelienpierre\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e0fb97531f28593a553b2b2a657de0d7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e0fb97531f28593a553b2b2a657de0d7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/aurelienpierre\" class=\"reviewer-name\">aurelienpierre</a> el <span class=\"review-date\">octubre 2, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Plus nice support</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Nice Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/ngbaze\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/178787c8ff4cc319849d8545fd6e0e57?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/178787c8ff4cc319849d8545fd6e0e57?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/ngbaze\" class=\"reviewer-name\">NG Baze <small>(ngbaze)</small></a> el <span class=\"review-date\">julio 17, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Nice one.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can&#039;t get it to work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/crocoart\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/cdae8b25f64ba65fd615b1af09bc3c3c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/cdae8b25f64ba65fd615b1af09bc3c3c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/crocoart\" class=\"reviewer-name\">crocoart</a> el <span class=\"review-date\">julio 4, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Can\'t get the Add to home screen to show on ios devices which pretty much makes this useless.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">nice</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/calvin85mathias\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a3555307b29e54b42c7cbf760c8c7f11?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a3555307b29e54b42c7cbf760c8c7f11?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/calvin85mathias\" class=\"reviewer-name\">calvin85mathias</a> el <span class=\"review-date\">febrero 19, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">nice</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works like a charme</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/per4mance\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6e6215f8c6a6fad37e40b996fdd4a8f9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6e6215f8c6a6fad37e40b996fdd4a8f9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/per4mance\" class=\"reviewer-name\">Thorsten :-) <small>(per4mance)</small></a> el <span class=\"review-date\">febrero 5, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Hi,\nThank you for this great plugin it works for me on WP/BP. This is an amazing idea, and it works with W3 Total Cache too.\n\nDo you have any suggestions for me, how to implement a feature as \"add website to home\" when a user uses an iPhone or android?\n\nThank you :-)</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">It worked very well</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/heitor_tito\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ca0bf246069ecc57b41cdc0fee1268e0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ca0bf246069ecc57b41cdc0fee1268e0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/heitor_tito\" class=\"reviewer-name\">Heitor_tito</a> el <span class=\"review-date\">febrero 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Certainly the idea of not reinventing the wheel makes perfect sense.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Simple and usefull</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/fellyph\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6f9ecd567b678e503b3ee10ebb0f050c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6f9ecd567b678e503b3ee10ebb0f050c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/fellyph\" class=\"reviewer-name\">Fellyph Cintra <small>(fellyph)</small></a> el <span class=\"review-date\">julio 6, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">The plugin helped me to convert my blog in a PWA, only the short_name was an issue and fixed using the small plugin to include an extra field.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Thank You</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/stesab92\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/59f1367d15bebdb55b55fed0fc669f33?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/59f1367d15bebdb55b55fed0fc669f33?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/stesab92\" class=\"reviewer-name\">Stephen Sabatini <small>(stesab92)</small></a> el <span class=\"review-date\">mayo 30, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I\'ve been baking this into my themes and boilerplate manually for a while now. I\'m stoked to see this on it\'s way to the core of WordPress. Thank you for your contributions!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Doesn&#039;t work for me</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/gavinhaughey\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/062d2846124aa44b1b04b6ff99d2b0d2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/062d2846124aa44b1b04b6ff99d2b0d2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/gavinhaughey\" class=\"reviewer-name\">gavinhaughey</a> el <span class=\"review-date\">mayo 2, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"> . . . I think it needs HTTPS.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Future of mobile</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/fem-1\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/fb2856d777932b1b276e7c3b827e5b35?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/fb2856d777932b1b276e7c3b827e5b35?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/fem-1\" class=\"reviewer-name\">Alex Borsody <small>(F.E.M)</small></a> el <span class=\"review-date\">enero 24, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I believe PWAs are the future of mobile, I am using this plugin as well as the Drupal PWA module on 3 different sites/apps currently. I like how this uses Workbox and wondering when will support for background sync be included.  Very useful and customizable plugin as it is.</div>\n</div>\n\";}s:13:\"download_link\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.6.0.zip\";s:11:\"screenshots\";a:0:{}s:4:\"tags\";a:5:{s:5:\"https\";s:5:\"https\";s:20:\"progressive-web-apps\";s:20:\"progressive web apps\";s:3:\"pwa\";s:3:\"pwa\";s:15:\"service-workers\";s:16:\"service-workers.\";s:16:\"web-app-manifest\";s:16:\"web app manifest\";}s:8:\"versions\";a:7:{s:5:\"0.1.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.1.0.zip\";s:5:\"0.2.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.2.0.zip\";s:5:\"0.3.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.3.0.zip\";s:5:\"0.4.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.4.0.zip\";s:5:\"0.5.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.5.0.zip\";s:5:\"0.6.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.6.0.zip\";s:5:\"trunk\";s:46:\"https://downloads.wordpress.org/plugin/pwa.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:58:\"https://ps.w.org/pwa/assets/banner-772x250.png?rev=2272148\";s:4:\"high\";s:59:\"https://ps.w.org/pwa/assets/banner-1544x500.png?rev=2272148\";}}s:11:\"woocommerce\";a:25:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"5.8.0\";s:6:\"author\";s:48:\"<a href=\"https://woocommerce.com\">Automattic</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/woothemes\";s:12:\"contributors\";a:14:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/automattic\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/687b3bf96c41800814e3b93766444283?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/mikejolley\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9b87f99f47e30735e1136c5141531fdf?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Mike Jolley (a11n)\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/jameskoster\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/19a6a101c57df54bc1c40adcfba785d8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/claudiosanches\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/908480753c07509e76322dc17d305c8b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/rodrigosprimo\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/f2271ae6814a29d8cbf38ae2d0305a72?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/peterfabian1000\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/be249b86dddbf495565a36196625d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/vedjain\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7a640eb2847d9a0a0d5e6af385e21881?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Vedanshu Jain\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/jamosova\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eb515897a71b0df82ccd2788548588c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/obliviousharmony\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/185f31c1e5af65fee78506769ca13276?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/konamiman\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b9a819e803dd87615c4aeb33192db976?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"konamiman\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/sadowski\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/766381c51d7072d1f48ee8878e2ce3af?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/wpmuguru\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7b8ff059b9a4504dfbaebd4dd190466e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/royho\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/715b4097a10f874f8681b15608687f83?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/barryhughes-1\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4d7aea8e7879e3ea257ddb4a99a300f1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}}s:8:\"requires\";s:3:\"5.6\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:3:\"7.0\";s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3153;i:4;i:156;i:3;i:83;i:2;i:83;i:1;i:323;}s:11:\"num_ratings\";i:3798;s:15:\"support_threads\";i:2178;s:24:\"support_threads_resolved\";i:1757;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2021-10-12 6:32pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:12535:\"<p>WooCommerce es la solución de comercio electrónico de código abierto <a href=\"https://trends.builtwith.com/shop\" rel=\"nofollow ugc\">más popular del mundo</a>.</p>\n<p>Nuestra plataforma central es gratuita y flexible, y se ha ampliado gracias a la comunidad global. La libertad que proporciona el código abierto significa que podrás conservar la propiedad completa del contenido y los datos de tu tienda para siempre.</p>\n<p>Tanto si emprendes un negocio como si realizas la actividad comercial en tiendas físicas en línea o desarrollas sitios para clientes, utiliza WooCommerce para que tu tienda pueda aprovechar la combinación de contenido y comercio.</p>\n<ul>\n<li><strong>Crea escaparates bonitos y atractivos</strong> con <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">temas</a> apropiados para tu marca y sector.</li>\n<li><strong>Personaliza páginas en cuestión de minutos</strong> mediante los <a href=\"https://docs.woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">bloques de producto</a> modulares.</li>\n<li>Realza tus artículos físicos y digitales, las variaciones de productos, las configuraciones personalizadas, las descargas instantáneas y los productos para afiliados. Las <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">reservas</a>, <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">membresías</a>, <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">suscripciones</a> y las <a href=\"https://woocommerce.com/products/dynamic-pricing/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">reglas dinámicas de precios</a> están solo a una extensión.</li>\n<li><strong>Consigue aparecer en los primeros resultados</strong> gracias a la <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">ventaja SEO de WordPress</a>.</li>\n</ul>\n<p>Las herramientas incorporadas y las integraciones conocidas te ayudarán a gestionar de manera eficiente tus operaciones comerciales. Puedes añadir muchos servicios gratuitamente mediante un solo clic a través del <a href=\"https://docs.woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">asistente de configuración</a> opcional.</p>\n<ul>\n<li><strong>Elige cómo quieres pagar</strong>. Gestiona fácilmente los pagos desde la comodidad de tu tienda con <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Payments</a> (solo EE. UU.). Acepta de forma segura tarjetas, carteras para dispositivos móviles, transferencias bancarias y efectivo gracias a <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">más de 100 pasarelas de pago</a> (<a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">PayPal</a> y <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Square</a> incluidos).</li>\n<li><strong>Configura tus opciones de envío</strong>. Imprime etiquetas de USPS directamente desde tu escritorio y programa incluso una recogida con <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Shipping</a> (solo EE. UU.). Conecta con <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">transportistas conocidos</a>, como UPS, FedEx y ShipStation, y disfruta de una amplia variedad de soluciones de entrega, inventario y finalización para tu configuración regional.</li>\n<li><strong>Simplifica los impuestos de ventas</strong>. Añade <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Tax</a> o <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">servicios similares integrados</a> para que los cálculos automatizados se conviertan en realidad.</li>\n</ul>\n<h4>Haz crecer tu negocio, añade características, y haz seguimiento de tu tienda sobre la marcha</h4>\n<p>WooCommerce significa actividad comercial. Conserva las pestañas sobre las métricas de rendimiento más importantes para ti con <a href=\"https://wordpress.org/plugins/woocommerce-admin/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\">WooCommerce Admin</a>, un escritorio central potente y personalizable para tu tienda.</p>\n<p>Amplía tu audiencia en los canales sociales y de marketing con <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Google Ads</a>, <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">HubSpot</a>, <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Mailchimp</a> e integraciones de <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Facebook</a>. Siempre puedes consultar el <a href=\"https://docs.woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">centro de marketing</a> del escritorio para obtener ideas y consejos nuevos que te ayuden a conseguir el éxito.</p>\n<p>Mejora la funcionalidad de las tiendas con un gran número de extensiones gratuitas y de pago desde el <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\"> WooCommerce Marketplace</a> oficial. Nuestros desarrolladores <a href=\"https://docs.woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">investigan cada extensión</a> y revisan regularmente el inventario existente para mantener las normas de calidad del Marketplace. <a href=\"https://docs.woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Buscamos activamente productos que ayuden a los creadores de tiendas a conseguir tiendas de éxito</a>.</p>\n<p>Gestiona tu tienda desde cualquier sitio con la <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">aplicación para dispositivos móviles</a> (Android y iOS) de WooCommerce. Alerta de spoiler: intenta obviar el adictivo sonido de notificación cada vez que consigas una nueva venta.</p>\n<h4>Posee y controla los datos de tu tienda – siempre</h4>\n<p>Con WooCommerce, tus datos son tuyos siempre.</p>\n<p>Si optas por compartir <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">datos sobre el uso</a> con nosotros, puedes estar seguro de que seguirán siendo anónimos y estarán protegidos. Puedes desactivar la opción de compartir datos sobre el uso sin que afecte a tu tienda.</p>\n<p>A diferencia de las soluciones de comercio electrónico alojadas, los datos de la tienda de WooCommerce están preparados para el futuro. Si quieres migrar a una plataforma diferente, puedes exportar todo tu contenido y llevar tu sitio allá donde quieras. No hay restricciones.</p>\n<h4>Por qué los desarrolladores eligen (y les encanta) WooCommerce</h4>\n<p>Los desarrolladores pueden usar WooCommerce para crear, personalizar y escalar una tienda para cumplir con las especificaciones exactas de un cliente, y realizar mejoras a través de extensiones o soluciones personalizadas.</p>\n<ul>\n<li>Aprovecha los <a href=\"https://docs.woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">ganchos y filtros</a> para modificar o crear la funcionalidad.</li>\n<li>Integra prácticamente cualquier servicio mediante una <a href=\"https://docs.woocommerce.com/document/woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">API de REST</a> sólida y webhooks.</li>\n<li>Diseña y crea bloques de contenido personalizados con React.</li>\n<li><a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/extending/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Examina y modifica</a> cualquier aspecto del código del plugin central.</li>\n<li>Acelera el desarrollo con una <a href=\"https://woocommerce.github.io/code-reference/classes/wc-cli-rest-command.html?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a> ultrarrápida.</li>\n</ul>\n<p>La plataforma central se prueba de forma rigurosa y frecuente con el apoyo de un equipo de desarrollo dedicado que trabaja en distintas zonas horarias. La documentación completa se actualiza con cada versión, lo que te permite crear exactamente la tienda que necesitas.</p>\n<h4>Sé parte de una comunidad internacional creciente</h4>\n<p>WooCommerce dispone de una comunidad grande y apasionada dedicada a ayudar a los vendedores a alcanzar el éxito, y está creciendo rápidamente.</p>\n<p>Hay <a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">encuentros de WooCommerce</a> en ciudades en todo el mundo a los que puedes asistir gratis y en los que puedes participar para la puesta en marcha. Estos eventos son una forma fantástica de aprender de los demás, compartir tus conocimientos y encontrar gente con intereses comunes.</p>\n<p>WooCommerce también está presente normalmente en los WordCamps de todo el mundo. Nos encantaría verte allí.</p>\n<h4>Contribuye y traduce</h4>\n<p>Automattic, la empresa creadora de WordPress.com y Jetpack, es la encargada del desarrollo y soporte de WooCommerce. También contamos con la ayuda de una gran cantidad de colaboradores independientes, y sigue habiendo espacio para muchos más. Dirígete al <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">repositorio de GitHub de WooCommerce</a> para ver cómo puedes colaborar.</p>\n<p>WooCommerce se ha traducido a varios idiomas, incluidos el danés, el ucraniano y el persa. Ayúdanos a mejorar la traducción de WooCommerce añadiendo tu configuración regional: visita <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n\";s:12:\"installation\";s:2643:\"<h4>Requisitos mínimos</h4>\n<ul>\n<li>Se recomienda PHP 7.2 o superior</li>\n<li>Se recomienda MySQL 5.6 o superior</li>\n</ul>\n<p>Visita la <a href=\"https://docs.woocommerce.com/document/server-requirements/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">documentación sobre requisitos del servidor para WooCommerce</a> para obtener una lista detallada de los requisitos del servidor.</p>\n<h4>Instalación automática</h4>\n<p>La instalación automática es la opción más sencilla, ya que WordPress gestiona las transferencias de archivos y no tendrás que salir de tu navegador web. Para hacer una instalación automática de WooCommerce, accede a tu escritorio de WordPress, ve al menú de plugins y haz clic en «Añadir nuevo».</p>\n<p>En el campo de búsqueda teclea «WooCommerce» y haz clic en «Buscar plugins». Una vez que nos hayas encontrado, puedes ver los detalles, como la versión, la clasificación y la descripción. ¡Lo más importante, por supuesto, es que puedas instalarlo! Haz clic en «Instalar ahora» y WordPress se encargará de ello.</p>\n<h4>Instalación manual</h4>\n<p>El método de instalación manual pasa por descargar el plugin WooCommerce y subirlo a tu servidor mediante tu aplicación FTP favorita. El codex de WordPress tiene <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\">instrucciones de cómo se hace</a>.</p>\n<h4>Actualizaciones</h4>\n<p>Las actualizaciones automáticas deberían funcionar sin problemas, pero aún así te recomendamos que hagas una copia de seguridad de tu sitio.</p>\n<p>Si por algún motivo tienes problemas con las páginas de tienda/categoría después de actualizar, solo tienes que forzar los enlaces permanentes yendo a WordPress &gt; Ajustes &gt; Enlaces permanentes y pulsando en «Guardar». Esto debería devolver las cosas a la normalidad.</p>\n<h4>Datos de ejemplo</h4>\n<p>WooCommerce viene con algunos datos de muestra que puedes usar para ver qué aspecto tienen los productos; importa el archivo «sample_products.xml» con el <a href=\"https://wordpress.org/plugins/wordpress-importer/\">importador de WordPress</a>. También puedes usar el <a href=\"https://docs.woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">importador CSV</a> del núcleo o nuestra <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">extensión de solución completa de importación CSV</a> para importar el archivo «sample_products.csv»</p>\n\";s:3:\"faq\";s:8453:\"\n<dt id=\'where%20can%20i%20find%20woocommerce%20documentation%20and%20user%20guides%3F\'>\n¿Dónde puedo encontrar documentación y guías de uso de WooCommerce?\n</h4>\n<p>\n<p>Para obtener ayuda para configurar WooCommerce, consulta la <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guía de inicio</a> y la <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">nueva guía para propietarios de la tiendas de WooCommerce</a>.</p>\n<p>Para ampliar o tematizar WooCommerce, consulta nuestro <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">códex</a>, así como el <a href=\"https://docs.woocommerce.com/document/create-a-plugin/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">manual del desarrollador de plugins</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20or%20talk%20to%20other%20users%20about%20woocommerce%20core%3F\'>\n¿Dónde puedo obtener ayuda o hablar con otros usuarios sobre el núcleo de WooCommerce?\n</h4>\n<p>\n<p>Si continúas teniendo problemas, puedes solicitar ayuda en el <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\">foro de soporte de WooCommerce</a> siguiendo <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\">estas directrices</a>. También puedes contactar a través de <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Community Slack</a> o publicar una entrada en el <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">grupo de la comunidad de WooCommerce</a> en Facebook.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20for%20extensions%20i%20have%20purchased%20on%20woocommerce.com%3F\'>\n¿Dónde puedo obtener ayuda sobre extensiones que he comprado en WooCommerce.com?\n</h4>\n<p>\n<p>Para obtener ayuda en relación con las extensiones de pago de WooCommerce.com Marketplace: primero, revisa nuestra <a href=\"https://docs.woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">guía de solución de problemas de autoservicio</a>. Si el problema continúa, registra un ticket de soporte a través de <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">nuestro servicio de asistencia</a>. Nuestros Happiness Engineers te responderán en un plazo de 24 horas.</p>\n</p>\n<dt id=\'i%E2%80%99m%20having%20trouble%20logging%20in%20to%20woocommerce.com%20%E2%80%93%20what%20now%3F\'>\nEstoy teniendo problemas al acceder a WooCommerce.com &#8211; ¿qué hago?\n</h4>\n<p>\n<p>Primero, soluciona los problemas de inicio de sesión frecuentes mediante está útil <a href=\"https://docs.woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guía paso a paso</a>. ¿Sigue sin funcionar? <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Ponte en contacto con nosotros</a>.</p>\n</p>\n<dt id=\'will%20woocommerce%20work%20with%20my%20theme%3F\'>\n¿Funcionará WooCommerce con mi tema?\n</h4>\n<p>\n<p>Sí. WooCommerce funcionará con cualquier tema, pero es posible que requiera algún estilo adicional. Si buscas un tema que ofrezca una integración profunda con WooCommerce, recomendamos <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20update%20woocommerce%3F\'>\n¿Cómo actualizo WooCommerce?\n</h4>\n<p>\n<p>Disponemos de una guía detallada sobre <a href=\"https://docs.woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">cómo actualizar WooCommerce</a>.</p>\n</p>\n<dt id=\'my%20site%20broke%20%E2%80%93%20what%20do%20i%20do%3F\'>\nMi sitio está roto &#8211; ¿qué hago?\n</h4>\n<p>\n<p>Primero diagnostica el problema mediante nuestra útil <a href=\"https://docs.woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">guía de solución de problemas</a>.</p>\n<p>Si has detectado el error después de actualizar un tema o plugin, es posible que haya problemas de compatibilidad entre ellos y WooCommerce. Si el problema apareció después de actualizar WooCommerce, es posible que haya un conflicto entre WooCommerce y un tema o plugin obsoletos.</p>\n<p>En ambas instancias, recomendamos realizar una prueba de conflictos mediante <a href=\"https://docs.woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Health Check</a> (que te permite deshabilitar temas y plugins sin que afecte a los visitantes) o aplicar la solución de problemas mediante un <a href=\"https://docs.woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">sitio de pruebas</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20report%20bugs%3F\'>\n¿Dónde puedo informar de fallos?\n</h4>\n<p>\n<p>Informa de los errores en el <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">repositorio de GitHub de WooCommerce</a>. También puedes informarnos a través del foro de soporte. Busca el error en los foros para asegurarte de que no se haya informado ya de él.</p>\n</p>\n<dt id=\'where%20can%20i%20request%20new%20features%2C%20themes%2C%20and%20extensions%3F\'>\n¿Dónde puedo solicitar nuevas características, temas y extensiones?\n</h4>\n<p>\n<p>Solicita nuevas funciones y extensiones, y vota las sugerencias existentes en nuestro <a href=\"https://ideas.woocommerce.com/forums/133476-woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">panel de ideas</a> oficial. Nuestros equipos de productos revisan regularmente las solicitudes y las tienen en cuenta en la planificación de los productos.</p>\n</p>\n<dt id=\'woocommerce%20is%20awesome%21%20can%20i%20contribute%3F\'>\n¡WooCommerce es alucinante! ¿Puedo contribuir?\n</h4>\n<p>\n<p>¡Sí, puedes! Únete a nuestro <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">repositorio en GitHub</a> y sigue el <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">blog de desarrollo</a> para estar al día de todo lo que pasa en el proyecto.</p>\n</p>\n<dt id=\'where%20can%20i%20find%20rest%20api%20documentation%3F\'>\n¿Dónde puedo encontrar la documentación de la API REST?\n</h4>\n<p>\n<p>Amplia <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">documentación sobre la API REST de WooCommerce</a> disponible en GitHub.</p>\n</p>\n<dt id=\'my%20question%20is%20not%20listed%20here.%20where%20can%20i%20find%20more%20answers%3F\'>\nMi pregunta no está en esta lista. ¿Dónde puedo encontrar más respuestas?\n</h4>\n<p>\n<p>Echa un vistazo a las <a href=\"https://docs.woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">preguntas frecuentes</a> para más información.</p>\n</p>\n\n\";s:9:\"changelog\";s:6979:\"<h4>5.8.0 2021-10-12</h4>\n<p><strong>WooCommerce</strong></p>\n<ul>\n<li>Añadido: Parámetros de filtrado <code>modified_before</code> y <code>modified_after</code> a la API REST para productos, pedidos y cupones. #30585</li>\n<li>Añadido: Filtros <code>woocommerce_quantity_input_min_admin</code> y <code>woocommerce_quantity_input_step_admin</code>. #30705</li>\n<li>Desarrollo: Actualizado el programador de acciones a la versión 3.3.0. #30719</li>\n<li>Desarrollo: Añadir un argumento de pedido al filtro <code>woocommerce_order_actions</code>. #30475</li>\n<li>Corrección: Durante la edición rápida del producto, algunas veces, los ajustes destacados no se muestran correctamente como marcados. #30639</li>\n<li>Corrección: Las compensaciones no se calculan correctamente a veces en los desplegables Select2 causando problemas de usabilidad. #30690</li>\n<li>Corrección: La entrada de búsqueda desplegable Select2 no se enfoca cuando el elemento desplegable select2 se enfoca. #30626</li>\n<li>Retoque: Añadir avisos de eliminación de artículos individuales según el contexto de la línea del artículo en el pedido. #30650</li>\n<li>Retoque: Cambiar el resumen de la página de la tienda que no era relevante para el público. #30573</li>\n<li>Retoque: Borrados los espacios dobles innecesarios en las cadenas de texto. #30487</li>\n<li>Retoque: Abrir el enlace de examinar todas las extensiones en una nueva pestaña. #30640</li>\n</ul>\n<p>** WooCommerce Admin &#8211; 2.7.1 y 2.7.2**</p>\n<ul>\n<li>Corrección: Corregir la ruptura de las analíticas en el horario de verano. #7763</li>\n<li>Corrección: Permitir a los superadministradores todas las capacidades dentro de WooCommerce Admin. #7489</li>\n<li>Corrección: Corregir la fecha final para los últimos períodos. #6584</li>\n<li>Corrección: Corregido el perfilador de puesta en marcha que no funciona cuando no se acepta el seguimiento. #7490</li>\n<li>Corrección: Hacer fijos los detalles del negocio en el asistente de puesta en marcha. #7426</li>\n<li>Corrección: Estilos RTL faltantes para la puesta en marcha. #7531</li>\n<li>Corrección: Omitir la acción de programación si no se han configurado las tablas del programador de acciones. #7521</li>\n<li>Corrección: Actualizar la región del país por adelantado para una mejor compatibilidad de relleno automático. #7497</li>\n<li>Corrección: Usar extensiones instalables para el estado local frente a las extensiones gratuitas. #7585</li>\n<li>Corrección: Corregir un error fatal y los resultados no relacionados en las analíticas. #7682</li>\n<li>Corrección: Endurecer el directorio de informes. #7691</li>\n<li>Corrección: Actualizar la lógica de la tarea para que solo se muestre el contenido cuando la ampliación es «true». #7611</li>\n<li>Añadir: Mostrar Pinterest en las extensiones de marketing instaladas (si están instaladas). #7417</li>\n<li>Añadir: Añadido MailchimpScheduler que se ejecuta diariamente para suscribir `store_email` en los datos del perfil. #7579</li>\n<li>Añadir: Añadidas recomendaciones de plugins de envío a la página de ajustes. #7446</li>\n<li>Añadir: Añadida una variable para adormecer la tarea de puesta en marcha. #7539</li>\n<li>Añadir: Añadida la cancelación de la variable para adormecer la tarea. #7560</li>\n<li>Añadir: Añadidas variables para rechazar la tarea. #7538</li>\n<li>Actualización: Añadir los países HK y SG al soporte internacional de WC Pay. #7558</li>\n<li>Actualización: Crear las variables de la API REST de la lista de tareas. #7512</li>\n<li>Actualización: Borrada la clase de la nota `OnboardingEmailMarketing`. #7595</li>\n<li>Actualización: Eliminado el uso del gancho obsoleto `woocommerce_shared_settings`. #7480</li>\n<li>Actualización: Elimina los ajustes no específicos de WooCommerce Admin del espacio de nombres <code>wc_admin</code> en el almacén de ajustes <code>wc/data</code> (por ejemplo: países). #7480</li>\n<li>Actualización: Actualizado el logotipo de «eway» en las sugerencias de pago por defecto. #7562</li>\n<li>Actualización: Actualizar la lógica de finalización de las tareas de marketing. #7586</li>\n<li>Desarrollo: Añadir el campo de la dirección de correo electrónico a OBW. #7552</li>\n<li>Retoque: Añadir elementos de navegación para el menú del mercado. #7529</li>\n<li>Retoque: Cambiar todas las cadenas y etiquetas de análisis a mayúsculas y minúsculas. #6501</li>\n<li>Retoque: Borrar los espacios dobles innecesarios en las cadenas de texto. #7502</li>\n<li>Retoque: Eliminar las opciones precargadas de la puesta en marcha. #7338</li>\n<li>Retoque: Actualizar los estilos del texto de la cabecera de la tarjeta de análisis. #6506</li>\n<li>Mejora: Alinear los campos de la tabla con el respaldo en `isNumeric`. #7431</li>\n</ul>\n<p><strong>WooCommerce Blocks &#8211; 5.7.1, 5.8.0, 5.9.0 y 5.9.1</strong></p>\n<ul>\n<li>Añadido: Punto de extensibilidad para extensiones para filtrar métodos de pago. #4668</li>\n<li>Añadido: Bloque «Filtrar productos por stock». #4145</li>\n<li>Añadido: Se presentó el enlace <code>__experimental_woocommerce_blocks_checkout_update_order_from_request</code> a la API de Checkout Store. #4610.</li>\n<li>Corregido: Añade un elemento de etiqueta al componente <code>BlockTitle</code>.  #4585</li>\n<li>Corrección &#8211; Desactivar el carrito, el pago, todos los productos y los boques de filtro de la pantalla de widgets.</li>\n<li>Corrección: Recursividad infinita al eliminar un filtro de atributos del bloque de filtros activos. #4816</li>\n<li>Corregido: Evita que la lista de categorías de productos se muestre incorrectamente cuando se usa en la página de la tienda. #4587</li>\n<li>Corregido: El bloque de búsqueda de productos se muestra incorrectamente. #4740</li>\n<li>Retoque: Añade información de extensibilidad al archivo readme de la API de la tienda. #4605</li>\n<li>Retoque: Actualiza la documentación para el filtro snackbarNoticeVisibility. #4508</li>\n<li>Retoque: Añade documentación para el método <code>extensionCartUpdate</code> &#8211; esto permite que las extensiones actualicen el carrito del lado del cliente después de que se haya modificado en el servidor. #4377</li>\n</ul>\n<p><strong>Action Scheduler 3.3.0</strong></p>\n<ul>\n<li>Mejora: Añade as_has_scheduled_action () para proporcionar una forma eficaz de probar las acciones existentes. #645</li>\n<li>Dev: Ahora es compatible con consultas que utilizan varios estados. #649</li>\n<li>Dev: Los requisitos mínimos para WordPress y PHP aumentaron (a 5.2 y 5.6 respectivamente). #723</li>\n<li>Corregido: Mejora la compatibilidad con entornos donde NO_ZERO_DATE está activado. #519</li>\n<li>Corregido: Añade comprobantes de seguridad para protegerse contra errores cuando no se pueden crear nuestras tablas de base de datos. #645</li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">Ver el registro de cambios para todas las versiones</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:14433:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Awesome Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/ashimkumar\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/deadb8cca2fe768c23bcbf85f8827a4a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/deadb8cca2fe768c23bcbf85f8827a4a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/ashimkumar\" class=\"reviewer-name\">ashimkumar</a> el <span class=\"review-date\">noviembre 7, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I do not know the language to praise it. 5 stars and an extra star from the sky should be given</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very Nice . I love it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/jahedinia\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/575516a15873e333d540799d8ac13db1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/575516a15873e333d540799d8ac13db1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/jahedinia\" class=\"reviewer-name\">jahedinia</a> el <span class=\"review-date\">noviembre 4, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Very Nice . I love it</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">WooCommerce is great _ I have suggestions and criticisms</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/user1online\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/655afbe3259bc9aa11372761314d0559?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/655afbe3259bc9aa11372761314d0559?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/user1online\" class=\"reviewer-name\">user1online</a> el <span class=\"review-date\">octubre 28, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">WooCommerce is great but heavy and consumer, please make it lighter | Lightweight, agile, fast\nAre all features and extras used?\nMake settings to disable additional features to enable or disable as needed.\nI say I love WooCommerce.\nso long live.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">A+++ plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/kurner\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f51da6fd8455d4ee01d94cf523fd0eff?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f51da6fd8455d4ee01d94cf523fd0eff?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/kurner\" class=\"reviewer-name\">kurner</a> el <span class=\"review-date\">octubre 28, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I love woocommerce! This is one of the best plugins for the WP.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">VERY POOR SUPPORT--SITE IS UNUSABLE AND I CAN&#039;T GET HELP!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/larsenfamily\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3be5dfb7b044c936f1376750f7cf7c93?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3be5dfb7b044c936f1376750f7cf7c93?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/larsenfamily\" class=\"reviewer-name\">larsenfamily</a> el <span class=\"review-date\">octubre 26, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I chose woocommerce over shopify or the other stand-alone options because I saw such good ratings.  Boy what a mistake!  I have had nothing but difficulty with my site and I can\'t get the help I need without investing even MORE money for developers I shouldn\'t need!  I am extremely disappointed and am looking for other options because obviously woocommerce is not nearly what it advertises itself to be!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Incredible! Better than Shopify</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/flinty2000\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dae19df45b014ffeb207521eda23360b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dae19df45b014ffeb207521eda23360b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/flinty2000\" class=\"reviewer-name\">flinty2000</a> el <span class=\"review-date\">octubre 26, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Amazing ecommerce software that keeps getting better and better. The flexibility is great and the details with how things are thought out for the modern ecommerce world is exceptional. Their app store is actually okay too with some very useful plugins that works very well. I just wish they would add the Stripe plugin by \'Payment Plugins\' as THE authorised Stripe payment plugin rather than try and do it on their own with a plugin that obviously has issues. \n\nI had some technical issues with a downloadable error and they were right on it trying to work through the issue and helped me identify the problem. I know for a fact that is something you usually have to pay enormous amounts of money to get help with. \n\nWoocommerce has come a long way since I first toyed with the idea of using it 8 years ago. It has finally matured and my customers are happier for it. \n\nA BIG THANK YOU!\n </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">nice</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/deepanshi12\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e07d8892315c2286ad967a3e6b081c29?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e07d8892315c2286ad967a3e6b081c29?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/deepanshi12\" class=\"reviewer-name\">deepanshi12</a> el <span class=\"review-date\">octubre 23, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">excellent</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">very helpful</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/ebobazar\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d4bf1561d76a48c5ee058d757887fe2e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d4bf1561d76a48c5ee058d757887fe2e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/ebobazar\" class=\"reviewer-name\">ebobazar</a> el <span class=\"review-date\">octubre 22, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">very helpfull to all.  </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Bad support and plugin - WhiteScreen Of death</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/florpez\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/fe7bc7fd34c725755f4460db2a4d61ca?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/fe7bc7fd34c725755f4460db2a4d61ca?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/florpez\" class=\"reviewer-name\">florpez</a> el <span class=\"review-date\">octubre 18, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">After updating it started showing the white screen of death. The support team replies every week and with no proper solutions.\nTerrible.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">I love it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/mston\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/147f43f452951e43324993200411375a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/147f43f452951e43324993200411375a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/mston\" class=\"reviewer-name\">mston</a> el <span class=\"review-date\">octubre 14, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Woocommerce is awesome</div>\n</div>\n\";}s:13:\"download_link\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\";s:7:\"caption\";b:0;}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\";s:7:\"caption\";b:0;}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\";s:7:\"caption\";b:0;}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\";s:7:\"caption\";b:0;}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\";s:7:\"caption\";b:0;}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\";s:7:\"caption\";b:0;}}s:4:\"tags\";a:5:{s:10:\"e-commerce\";s:10:\"e-commerce\";s:5:\"sales\";s:5:\"sales\";s:4:\"sell\";s:4:\"sell\";s:5:\"store\";s:5:\"store\";s:3:\"woo\";s:3:\"woo\";}s:8:\"versions\";a:219:{s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=2366418\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=2366418\";}}s:19:\"the-events-calendar\";a:25:{s:4:\"name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:7:\"version\";s:6:\"5.10.1\";s:6:\"author\";s:52:\"<a href=\"https://evnt.is/1x\">The Events Calendar</a>\";s:14:\"author_profile\";s:48:\"https://profiles.wordpress.org/theeventscalendar\";s:12:\"contributors\";a:16:{s:17:\"theeventscalendar\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/theeventscalendar\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/004d5851721c5bd2b3491b51429f771e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"The Events Calendar\";}s:7:\"borkweb\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/borkweb\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1e656e49ac69899daa3ff81232b041eb?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Matthew Batchelder\";}s:7:\"bordoni\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/bordoni\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c412fa91c51f4e2cff375f74efb663e3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Gustavo Bordoni\";}s:11:\"brianjessee\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/brianjessee\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a35212d9e01d2ca4e96ecdd05b110b4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Brian\";}s:6:\"aguseo\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/aguseo\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/57554805e57d21c1036c8b91f944c8ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"András Guseo\";}s:8:\"camwynsp\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/camwynsp\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/77839cc0bde9eb1b58dff6777ae61942?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Camwyn\";}s:8:\"geoffbel\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/geoffbel\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7d6fd85658178125baa17b6055dd3be1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"GeoffBel\";}s:11:\"geoffgraham\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/geoffgraham\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/ac0d6274a6cea04669e66a20ec0ea204?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"geoffgraham\";}s:7:\"jentheo\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/jentheo\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e02959cfbac1b4fab42cd6019c0e70c6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"Jennifer\";}s:11:\"leahkoerper\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/leahkoerper\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9fe5fa3836f54c58936a3979212da076?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"leahkoerper\";}s:8:\"lucatume\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/lucatume\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d393fcb75e0801c42fe5559ae1e846e6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"lucatume\";}s:11:\"neillmcshea\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/neillmcshea\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/43599a71b1b6506a26d029221f1d61a9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"neillmcshea\";}s:19:\"patriciahillebrandt\";a:3:{s:7:\"profile\";s:50:\"https://profiles.wordpress.org/patriciahillebrandt\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/754f035dc61fdb1ee0c421d0dd9b6548?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"patriciahillebrandt\";}s:6:\"vicskf\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/vicskf\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/3a2a95b83191dc10b76ba61aba61c618?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Victor Zarranz\";}s:9:\"zbtirrell\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/zbtirrell\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eeb48b1ae8eca09700c2c2642a1f7dcf?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Zach Tirrell\";}s:7:\"juanfra\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/juanfra\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/bb8f8e3c87dfce235f6bfe5a2d8ece2b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Juan Aldasoro\";}}s:8:\"requires\";s:3:\"5.6\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:3:\"7.1\";s:6:\"rating\";i:86;s:7:\"ratings\";a:5:{i:5;i:1436;i:4;i:108;i:3;i:66;i:2;i:50;i:1;i:207;}s:11:\"num_ratings\";i:1867;s:15:\"support_threads\";i:192;s:24:\"support_threads_resolved\";i:85;s:15:\"active_installs\";i:800000;s:12:\"last_updated\";s:21:\"2021-11-04 7:25pm GMT\";s:5:\"added\";s:10:\"2010-01-19\";s:8:\"homepage\";s:0:\"\";s:8:\"sections\";a:6:{s:11:\"description\";s:6709:\"<p>Easily create and manage an events calendar on your WordPress site with <a href=\"https://evnt.is/mj\" rel=\"nofollow ugc\">The Events Calendar</a> free plugin. Whether your events are in-person or virtual events, this WordPress calendar plugin boasts professional features backed by our world-class team of developers and designers.</p>\n<p><div class=\"embed-vimeo\" style=\"text-align: center;\"><iframe loading=\"lazy\" src=\"https://player.vimeo.com/video/425323974\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>\n</p>\n<p>Repleto de características útiles, The Events Calendar está listo para funcionar tras ser instalado. También es ampliable, fácil de usar y completamente personalizable.</p>\n<h4>📅 The #1 Calendar for WordPress</h4>\n<p>See the calendar in action on our <a href=\"https://evnt.is/1ajs\" rel=\"nofollow ugc\">demo experience</a>. Just getting started? Read through the <a href=\"https://evnt.is/2d\" rel=\"nofollow ugc\">New User Primer</a> to get set up.</p>\n<p>Looking for additional features like recurring events, ticket sales, user-submitted events, automatic imports, and more?</p>\n<p><strong>Check out <a href=\"https://evnt.is/mj\" rel=\"nofollow ugc\">Events Calendar Pro</a>, <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>, and <a href=\"https://evnt.is/2a\" rel=\"nofollow ugc\">more add-ons</a>.</strong></p>\n<h4>🔌🎨 Plug and Play or Customize</h4>\n<p>The Events Calendar is built to work out of the box. Simply install the plugin, configure your settings, and start creating events in minutes.</p>\n<p>Want to add your personal touch? Use The Events Calendar as the foundation for customization. Personalize to your heart&#8217;s content with the help of a skeleton stylesheet, partial template overrides, template tags, hooks and filters, <a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">careful documentation</a>, and a <a href=\"https://evnt.is/1a0r\" rel=\"nofollow ugc\">library of free extensions</a>.</p>\n<p>Whether your vision is big or small, you&#8217;re in good company. Hundreds of thousands of small businesses, musicians, venues, restaurants, and non-profits are publishing and promoting their in-person and virtual events with The Events Calendar. Our plugins have also been scaled to work on large networks for Fortune 100 companies, universities, and government institutions.</p>\n<h4>✨ Features</h4>\n<p>Our feature-rich plugin comes with everything you need to create and manage your calendar.</p>\n<p>✔️ Rapidly create events<br />\n✔️ Saved venues &amp; organizers<br />\n✔️ Calendar month view with tooltips<br />\n✔️ Event List view<br />\n✔️ Day view<br />\n✔️ Block Editor support<br />\n✔️ Event search<br />\n✔️ Google maps<br />\n✔️ Widget: Upcoming events list<br />\n✔️ Events Taxonomies (Categories &amp; Tags)<br />\n✔️ Google Calendar and iCal exporting<br />\n✔️ WP REST API endpoints<br />\n✔️ Completely ajaxified for super smooth browsing<br />\n✔️ Completely responsive from mobile to tablet to desktop<br />\n✔️ Tested on the major theme frameworks such as Avada, Divi, Enfold, Genesis, and many more.<br />\n✔️ Increase your SEO with JSON-LD Structured Data<br />\n✔️ Internationalized &amp; translated<br />\n✔️ Multiple stylesheets to improve integration<br />\n✔️ Extensive template tags for customization<br />\n✔️ Hooks &amp; filters galore<br />\n✔️ Caching support<br />\n✔️ Debug mode for developers<br />\n✔️ <a href=\"https://evnt.is/1a0r\" rel=\"nofollow ugc\">Library of extensions</a></p>\n<h3>📃 Documentación</h3>\n<p>All of our documentation can be found in <a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">our Knowledgebase</a>.</p>\n<p>Additional helpful links:</p>\n<ul>\n<li><a href=\"https://evnt.is/2l\" rel=\"nofollow ugc\">The Events Calendar New User Primer</a></li>\n<li><a href=\"https://evnt.is/2m\" rel=\"nofollow ugc\">The Themer’s Guide to The Events Calendar</a></li>\n</ul>\n<p>If you have any questions about this plugin, you can post a thread in the <a href=\"https://wordpress.org/support/plugin/the-events-calendar\">WordPress.org forum</a>. Please search existing threads before starting a new one.</p>\n<h3>Add-Ons</h3>\n<p>Take your calendar to the next level by pairing it with our plugins for ticketing, crowdsourcing, email marketing, and more. Learn more about all our products on <a href=\"https://evnt.is/18wn\" rel=\"nofollow ugc\">our website</a>.</p>\n<p>Our Free Plugins:</p>\n<p>🎟️ <a href=\"https://wordpress.org/plugins/event-tickets/\">Event Tickets</a><br />\n📐 <a href=\"https://wordpress.org/plugins/advanced-post-manager/\">Advanced Post Manager</a></p>\n<p>Nuestros plugins y servicios premium:</p>\n<p>⚡ <a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar PRO</a><br />\n↪️ <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a> (service)<br />\n🎟️ <a href=\"https://evnt.is/18wk\" rel=\"nofollow ugc\">Event Tickets Plus</a><br />\n✉️ <a href=\"https://evnt.is/1ajt\" rel=\"nofollow ugc\">Promoter</a><br />\n👥 <a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a><br />\n🎟️ <a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a><br />\n✏️ <a href=\"https://evnt.is/fa\" rel=\"nofollow ugc\">Filter Bar</a><br />\n🗓️ <a href=\"https://evnt.is/2e\" rel=\"nofollow ugc\">Eventbrite Tickets</a><br />\n📡 <a href=\"https://evnt.is/1aky\" rel=\"nofollow ugc\">Virtual Events</a></p>\n<h3>Ayuda</h3>\n<p>If you aren’t familiar with The Events Calendar, check out our <a href=\"https://evnt.is/2p\" rel=\"nofollow ugc\">New User Primer</a>. It will have you creating events in no time.</p>\n<p>Ready to dig deeper? Check out these resources:</p>\n<ul>\n<li><a href=\"https://evnt.is/2u\" rel=\"nofollow ugc\">Tutoriales</a></li>\n<li><a href=\"https://theeventscalendar.com/release-schedule/\" rel=\"nofollow ugc\">Calendario de releases</a></li>\n<li><a href=\"https://theeventscalendar.com/known-issues/\" rel=\"nofollow ugc\">Problemas conocidos<br />\n</a></li>\n<li><a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">Documentación</a></li>\n<li><a href=\"https://evnt.is/2t\" rel=\"nofollow ugc\">Vídeos de ayuda</a></li>\n<li><a href=\"https://evnt.is/2v\" rel=\"nofollow ugc\">Notas de la versión</a></li>\n</ul>\n<p>We check in on the <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\">The Events Calendar forum here on WordPress.org</a> about once a week to help users with basic troubleshooting and identifying bugs. If you’re looking for premium, personalized support, consider upgrading to Events Calendar Pro.</p>\n<p>Still have a question? Shoot us an email at support@theeventscalendar.com.</p>\n\";s:12:\"installation\";s:1302:\"<p>Installing the plugin is easy. Just follow one of the following methods:</p>\n<h4>Install The Events Calendar from within WordPress</h4>\n<ol>\n<li>Visit the plugins page within your dashboard and select ‘Add New’</li>\n<li>Search for «Events Calendar»</li>\n<li>Activate The Events Calendar from your Plugins page</li>\n<li>You&#8217;re done!</li>\n</ol>\n<h4>Install The Events Calendar Manually</h4>\n<ol>\n<li>From the dashboard of your site, navigate to Plugins &#8211;&gt; Add New.</li>\n<li>Select the Upload option and hit «Choose File.»</li>\n<li>When the popup appears select the the-events-calendar-x.x.zip file from your desktop. (The &#8216;x.x&#8217; will change depending on the current version number).</li>\n<li>Follow the on-screen instructions and wait as the upload completes.</li>\n<li>When it&#8217;s finished, activate the plugin via the prompt. A message will show confirming activation was successful. A link to access the calendar directly on the frontend will be presented here as well.</li>\n</ol>\n<p>That&#8217;s it! Just configure your settings as you see fit, and you&#8217;re on your way to creating events in style. Need help getting things started? Check out our <a href=\"https://evnt.is/2l\" rel=\"nofollow ugc\">new user primer</a> for help with settings and features.</p>\n\";s:3:\"faq\";s:8773:\"\n<dt id=\'are%20there%20any%20troubleshooting%20steps%20you%27d%20suggest%20i%20try%20that%20might%20resolve%20my%20issue%20before%20i%20post%20a%20new%20thread%3F\'>\nAre there any troubleshooting steps you&#8217;d suggest I try that might resolve my issue before I post a new thread?\n</h4>\n<p>\n<p>First, make sure that you&#8217;re running the latest version of The Events Calendar. If you’re running Events Calendar PRO or  any other add-ons, make sure those are current / running the latest code as well.</p>\n<p>The most common issues we see are either plugin or theme conflicts. You can test if a plugin or theme is conflicting by manually deactivating other plugins until just The Events Calendar is running on your site. If the issue persists from there, revert to the default <a href=\"https://wordpress.org/themes/twentytwenty/\">Twenty Twenty</a> theme. If the issue is resolved after deactivating a specific plugin or your theme, you’ll know that is the source of the conflict.</p>\n<p>Note that we aren’t going to say “tough luck” if you identify a plugin/theme conflict. While we can’t guarantee 100% integration with any plugin or theme out there, we will do our best (and reach out the plugin/theme author as needed) to figure out a solution that benefits everyone.</p>\n</p>\n<dt id=\'i%27m%20still%20stuck.%20where%20do%20i%20go%20to%20file%20a%20bug%20or%20ask%20a%20question%3F\'>\nI&#8217;m still stuck. Where do I go to file a bug or ask a question?\n</h4>\n<p>\n<p>Users of the free The Events Calendar should post their questions in the plugin&#8217;s <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\">WordPress.org forum</a>, which we visit about once a week. Please make sure to read <a href=\"https://evnt.is/19oc\" rel=\"nofollow ugc\">our sticky post</a> providing an overview of the support we provide free users BEFORE posting. If you find you&#8217;re not getting support in as timely a fashion as you wish, you might want to consider purchasing a license for Events Calendar Pro.</p>\n<p>If you&#8217;re already an Events Calendar Pro user, you&#8217;re entitled access to our actively-monitored <a href=\"https://evnt.is/1aju\" rel=\"nofollow ugc\">Premium Support</a> on our website. We can provide a deeper level of support here and hit these forums on a daily basis during the work week. Generally, except in times of increased support loads, we reply to all tickets within 24-48 hours during the business week.</p>\n</p>\n<dt id=\'what%27s%20the%20difference%20between%20the%20events%20calendar%20and%20events%20calendar%20pro%3F\'>\nWhat&#8217;s the difference between The Events Calendar and Events Calendar Pro?\n</h4>\n<p>\n<p>The Events Calendar is our cornerstone plugin, and it’s required in order to run any of our premium calendar add-ons, including Events Calendar Pro, Community Events, Filter Bar, and others.</p>\n<p>In other words, Events Calendar Pro runs alongside The Events Calendar and enhances it with extra features, including recurring events, additional calendar views, calendar shortcodes, advanced widgets, custom event fields and more.</p>\n</p>\n<dt id=\'what%20add-ons%20are%20available%20for%20the%20events%20calendar%2C%20and%20where%20can%20i%20read%20more%20about%20them%3F\'>\nWhat add-ons are available for The Events Calendar, and where can I read more about them?\n</h4>\n<p>\n<p>The following add-ons are available for The Events Calendar:</p>\n<ul>\n<li><a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar Pro</a>, for adding premium calendar features like recurring events, advanced views, cool widgets, <a href=\"https://evnt.is/1ajw\" rel=\"nofollow ugc\">shortcodes</a>, additional fields, and more!</li>\n<li><a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>, a service that effortlessly fills your calendar with events from Meetup, Google Calendar, iCalendar, Eventbrite, CSV, and ICS.</li>\n<li><a href=\"https://evnt.is/1aky\" rel=\"nofollow ugc\">Virtual Events</a>, which optimizes your calendar for virtual events including Zoom integration, video and livestream embeds, SEO optimization for online events and more.</li>\n<li><a href=\"https://wordpress.org/plugins/event-tickets/\">Event Tickets</a> (free), which allows you to sell tickets and collect RSVPs to events. It can run alongside The Events Calendar or as a standalone plugin that adds ticket and RSVP functionality to WordPress posts and pages.</li>\n<li><a href=\"https://evnt.is/18wk\" rel=\"nofollow ugc\">Event Tickets Plus</a>, which allows you to sell tickets for your events using your favorite e-commerce platform.</li>\n<li><a href=\"https://evnt.is/1ajt\" rel=\"nofollow ugc\">Promoter</a>, automated email communication made just for The Events Calendar and Event Tickets. Stay in touch with your attendees every step of the way.</li>\n<li><a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a>, for allowing frontend event submission from your readers.</li>\n<li><a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a>, which allows event organizers to sell tickets to the events they submit via Community Events.</li>\n<li><a href=\"https://evnt.is/fa\" rel=\"nofollow ugc\">Filter Bar</a>, for adding advanced frontend filtering capabilities to your events calendar.</li>\n<li><a href=\"https://evnt.is/2e\" rel=\"nofollow ugc\">Eventbrite Tickets</a>, for selling tickets to your event directly through Eventbrite.</li>\n</ul>\n</p>\n<dt id=\'can%20i%20import%20events%20to%20my%20calendar%3F\'>\nCan I import events to my calendar?\n</h4>\n<p>\n<p>Yes! The Events Calendar has a built-in CSV import tool. If you want to step it up and automatically import events from Google Calendar, Meetup, Eventbrite and more, check out <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20sell%20tickets%20to%20events%20on%20my%20calendar%3F\'>\nHow do I sell tickets to events on my calendar?\n</h4>\n<p>\n<p>You&#8217;ll want to use our <a href=\"https://wordpress.org/plugins/event-tickets/\">Event Tickets</a> plugin for that. This free plugin works alongside The Events Calendar and lets you create RSVPs and tickets for events. Event Tickets integrates with PayPal so you can collect payments for tickets, while our premium solution, Event Tickets Plus fully integrates with WooCommerce or Easy Digital Downloads.</p>\n</p>\n<dt id=\'can%20i%20have%20more%20than%20one%20calendar%20on%20my%20site%3F\'>\nCan I have more than one calendar on my site?\n</h4>\n<p>\n<p>Unfortunately, no. However, you can use event categories or tags to create calendar views that only display certain events. For example, you could create a direct link to a calendar view that only shows events categorized as «Fitness,» <a href=\"https://evnt.is/1ajv\" rel=\"nofollow ugc\">like this example from our demo site</a>.</p>\n<p>With Events Calendar Pro, you can use <a href=\"https://evnt.is/1ajw\" rel=\"nofollow ugc\">shortcodes</a> to embed your calendar on other WordPress pages and posts, then filter that calendar by category.</p>\n</p>\n<dt id=\'can%20i%20allow%20people%20to%20submit%20events%20to%20my%20calendar%3F\'>\nCan I allow people to submit events to my calendar?\n</h4>\n<p>\n<p>This is available with the <a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a> add-on to facilitate submissions. Install Community Events alongside The Events Calendar and a page will be added to your WordPress site with a form that visitors can use to submit events. As the calendar owner, you have full control over whether event submissions are published immediately or require moderation first.</p>\n<p>If you want to let users sell tickets for the events they submit, check out <a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a>. It runs with The Events Calendar, Community Events, and Event Tickets and empowers visitors to create and sell tickets, splitting the profits with you.</p>\n</p>\n<dt id=\'i%20have%20a%20feature%20idea.%20what%27s%20the%20best%20way%20to%20tell%20you%20about%20it%3F\'>\nI have a feature idea. What&#8217;s the best way to tell you about it?\n</h4>\n<p>\n<p>We&#8217;ve got a <a href=\"https://tribe.uservoice.com/forums/195723-feature-ideas\" rel=\"nofollow ugc\">UserVoice page</a> where we&#8217;re actively watching for feature ideas from the community. Vote up existing feature requests or add your own, and help us shape the future of the products business in a way that best meets the community&#8217;s needs.</p>\n</p>\n<dt id=\'i%27ve%20still%20got%20questions.%20where%20can%20i%20find%20answers%3F\'>\nI&#8217;ve still got questions. Where can I find answers?\n</h4>\n<p>\n<p>Check out our extensive <a href=\"https://evnt.is/18wm\" rel=\"nofollow ugc\">knowledgebase</a> for articles on using, tweaking, and troubleshooting our plugins.</p>\n</p>\n\n\";s:9:\"changelog\";s:208367:\"<h4>[5.10.1] 2021-11-04</h4>\n<ul>\n<li>Feature &#8211; Added Black Friday promo to the General Settings panel. [TCMN-127]</li>\n<li>Tweak &#8211; Update Black Friday banner. [TCMN-126]</li>\n</ul>\n<h4>[5.10.0] 2021-10-19</h4>\n<ul>\n<li>Tweak &#8211; Improve the look and feel of the single events page when using the block editor. These changes can be bypassed by defining the following constant to your wp-config.php file: <code>define( \'TRIBE_EVENTS_SINGLE_VIEW_V2_DISABLED\', true );</code> [TEC-3979]</li>\n<li>Language &#8211; 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.2] 2021-10-12</h4>\n<ul>\n<li>Fix &#8211; Ensure the day view on mobile displays the not found message when no events are present. [TEC-3944]</li>\n<li>Fix &#8211; Ensure a map preview is displayed on the venue block in the admin area when using TEC&#8217;s default Google API Key. [TEC-3042]</li>\n<li>Fix &#8211; Add some missing text domains for string translation. [TEC-3908]</li>\n<li>Fix &#8211; Correct block use checks around the Classic Editor plugin. [TEC-4099]</li>\n<li>Tweak &#8211; Set the appropriate Content-Type for REST responses that return just HTML during view partial requests. [TEC-4087]</li>\n<li>Language &#8211; 0 new strings added, 164 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.1] 2021-09-14</h4>\n<ul>\n<li>Feature &#8211; Updated swagger docs generated from swagger 2.0 to openapi 3.0.0</li>\n<li>Fix &#8211; Initialize $local_time_zone to ensure we don&#8217;t have notices displayed in the frontend. [TEC-3791]</li>\n<li>Fix &#8211; Ensure the correct timezone label is being displayed on the Classic and Block editors when site-wide timezone is set. [TEC-3791]</li>\n<li>Fix &#8211; Ensure that venue state or province are displayed next to the city in list view. [TEC-3332]</li>\n<li>Fix &#8211; Ensure the category archive event breadcrumb links to the main events page. [TEC-3330]</li>\n<li>Fix &#8211; Ensure that the page title does not encode (em)dashes before passing it on. [TEC-4049]</li>\n<li>Fix &#8211; Ensure that the page title does not encode apostrophes before passing it on. [TEC-4058]</li>\n<li>Fix &#8211; Ensure that filter_single_event_details_event_website_label() only filters the label for the website field. [ECP-921]</li>\n<li>Tweak &#8211; Remove unused template file to avoid confusion.</li>\n<li>Language &#8211; 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.0] 2021-08-24</h4>\n<ul>\n<li>Fix &#8211; Ensure that $eventDisplay is defined before we use it in the default template. [TEC-4060]</li>\n<li>Feature &#8211; Alter Customizer to leverage the new exposed CSS custom properties. [TCMN-104]</li>\n<li>Feature &#8211; Reduce the CSS load of The Events Calendar Customizer style overrides. [TEC-3011]</li>\n<li>Feature &#8211; Allow easier style overrides by users and third-party themes/plugins. [TEC-3011]</li>\n<li>Feature &#8211; Add new Font Sections to Customizer -&gt; The Events Calendar -&gt; Global Events. [TEC-3872]</li>\n<li>Feature &#8211; Add new font family control to allow The Events Calendar styles to inherit theme fonts. [TEC-3895]</li>\n<li>Feature &#8211; Add new font size controls for accessibility and to allow users to more closely match the font sizes of their theme. [TEC-3891]</li>\n<li>Tweak &#8211; Support optionally passing start dates to the Event Edit page so targeted event creation can be triggered by The Events Calendar Pro&#8217;s Event Manager.</li>\n<li>Language &#8211; 16 new strings added, 429 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.8.2] 2021-08-17</h4>\n<ul>\n<li>Feature &#8211; Redesign In-App help and troubleshooting pages. [TEC-3741]</li>\n<li>Fix &#8211; Try to ensure that when we do an event search the query post type remains <code>tribe_events</code>. [TEC-4012]</li>\n<li>Fix &#8211; Ensure the year is displayed in the block editor event single page for events that are occurring in a different year from the current one. [TEC-3740]</li>\n<li>Fix &#8211; Fix the issue of the Event Date Time block Timezone dropdown taking up a lot of space. [TEC-4029]</li>\n<li>Fix &#8211; Ensure WPML translated event posts show up on translated venue and organizer pages. (props @NicoX13) [TEC-4036]</li>\n<li>Fix &#8211; Fix issue of month names not being translatable. This was caused by a missing moment js localization dependency. [ECP-739]</li>\n<li>Fix &#8211; Ensure we test the value of tribe_events_get_current_month_day() before using it. [ECP-912]</li>\n<li>Fix &#8211; Add a new function to add «Event Blocks» category to the editor for WP &gt;= 5.8. [TEC-4037]</li>\n<li>Tweak &#8211; Change label of API Settings tab to «Integrations» and alter helper text. [TEC-4015]</li>\n<li>Language &#8211; 2 new strings added, 251 updated, 1 fuzzied, and 18 obsoleted</li>\n</ul>\n<h4>[5.8.1] 2021-07-20</h4>\n<ul>\n<li>Fix &#8211; Ensure that the Block Editor saves cost data when submitted. [TEC-3987]</li>\n<li>Fix &#8211; Ensure that when viewing a single event we load the correct template when tribe_context is «confused». [TEC-3975]</li>\n<li>Tweak &#8211; Remove some CSS on the single events page that was causing a random border to appear on avada theme [TEC-3952]</li>\n<li>Tweak &#8211; Add CSS class to the event tags label on the event details section on the single event page. [TEC-3951]</li>\n<li>Tweak &#8211; Correct the messaging and link for the v1 deprecation notice. [TEC-3958]</li>\n<li>Tweak &#8211; Include filter to allow modifications to the Grid query for By Day Views like Month and Week, <code>tribe_events_views_v2_by_day_view_day_repository</code></li>\n<li>Language &#8211; 5 new strings added, 26 updated, 2 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.8.0] 2021-07-01</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.8.0 is only compatible with Events Calendar PRO 5.8.0 and higher</li>\n<li>Feature &#8211; Add new Events bar section to the Customizer for control of the Events Bar styles. [TEC-3672]</li>\n<li>Fix &#8211; Correct instance where the date &amp; time symbols («@») are not changing color along with the text. [TEC-3883]</li>\n<li>Tweak &#8211; Ensure that the Month view date and time default colors match up with the rest [TEC-3709]</li>\n<li>Tweak &#8211; Ensure the Customizer Accent Color defaults to «royal blue» (#334aff) [TEC-3884]</li>\n<li>Tweak &#8211; Stop doing all the work here and leverage the new tribe-common Theme_Compatibility. [TCMN-106]</li>\n<li>Tweak &#8211; Add new hooks to the single event templates to allow more third-party control over content without custom templates. [TEC-3948]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_bootstrap_html</code>, <code>tribe_default_events_template_classes</code>, <code>tribe_events_single_event_title_classes</code>, <code>tribe_events_single_event_title_html_before</code>, <code>tribe_events_single_event_title_html_after</code>, <code>tribe_events_single_event_title_html</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_views_v2_compatibility_classes</code>, <code>tribe_events_views_v2_theme_compatibility_registered</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_default_events_template_after_header</code>, <code>tribe_default_events_template_before_footer</code></li>\n<li>Tweak &#8211; Changed views: <code>default-template</code>, <code>single-event</code>, <code>v2/default-template</code></li>\n<li>Language &#8211; 13 new strings added, 64 updated, 6 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[5.7.1] 2021-06-23</h4>\n<ul>\n<li>Fix &#8211; Properly recalculate event cost when creating events via the Block Editor. [TEC-3141]</li>\n<li>Fix &#8211; Resolve a compatibility issue with the new single view and the tickets block when using the <code>twentynineteen</code> theme. [TEC-3937]</li>\n<li>Fix &#8211; Ensure that <code>view_data</code> is an array when fetching values from the request. [TEC-3946]</li>\n<li>Fix &#8211; Ensure that the events block editor is disabled when «Activate Block Editor for Events» is unchecked. [TEC-3964]</li>\n<li>Tweak &#8211; Make custom post types available from the REST API so they can be compatible with the Navigation block. [TEC-3907]</li>\n<li>Tweak &#8211; Remove aria-labeled attribute from featured icons. [TEC-3396]</li>\n<li>Language &#8211; 0 new strings added, 154 updated, 3 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.7.0] 2021-05-27</h4>\n<ul>\n<li>Feature &#8211; Add new Month View section to the Customizer for v2 views. [TEC-3836]</li>\n<li>Fix &#8211; Apply responsive breakpoints once the page has fully loaded with all JavaScript and Elements on the page [TEC-3797]</li>\n<li>Fix &#8211; Resolve conflicts with Gravity Forms plugin that would prevent correct submission of forms data. [ECP-466]</li>\n<li>Fix &#8211; Correctly handle start and end of day cutoff in Day View when the server timezone is not the same as the site (thanks @therealgilles). [TEC-3877]</li>\n<li>Fix &#8211; Do not remove the <code>archive</code> body class from post tag and category pages when using Page as Event Template. [TEC-3846]</li>\n<li>Fix &#8211; Correctly translate calendar view in WPML language switcher (thanks @dgwatkins). [TEC-3810]</li>\n<li>Fix &#8211; Styles with the default theme <code>twenty twenty one</code> in <code>&lt;buttons&gt;</code> around the calendar. [TEC-3887]</li>\n<li>Fix &#8211; Single event iCalendar export will correctly export only that event information. [TEC-3886]</li>\n<li>Fix &#8211; Use the correct date and time in the Day View time separator when Timezone Mode is set to «Manual time zones for each event». [TEC-3877]</li>\n<li>Fix &#8211; Correctly integrate with the «Hello Elementor» theme to avoid issues with The Events Calendar and The Events Calendar PRO Views. [ECP-648]</li>\n<li>Fix &#8211; Correct typo in style output from Customizer.  Thanks @apmatthews for catching and correcting this!</li>\n<li>Fix &#8211; Avoid PHP warnings when linked post types are filtered out (thanks @baden03). [TEC#3533]</li>\n<li>Tweak &#8211; Make sure events from latest past events display the featured image correctly. [TEC-3655]</li>\n<li>Tweak &#8211; Reduced the usage of the word «onwards» on list-style view date range headings where simpler headings are better suited. [TEC-3831]</li>\n<li>Tweak &#8211; Move messages below the calendar grid in the mobile version of Month View. [TEC-3793]</li>\n<li>Tweak &#8211; Display a message to let visitors know the selected Month View day has no events in mobile. [TEC-3812]</li>\n<li>Tweak &#8211; Add compatibility for the Full Site Editor navigation block. [TEC-3850]</li>\n<li>Tweak &#8211; Filter the type of files allowed to upload into the EA Client. [TEC-3882]</li>\n<li>Tweak &#8211; Updating lodash to 4.17.21. [TEC-3885]</li>\n<li>Tweak &#8211; Prevent to list changes of hash on URL changes like <code>#content</code> [TEC-3890]</li>\n<li>Tweak &#8211; Update Google Calendar link to use the timezone based on the Timezone Settings from the Calendar [TEC-3143]</li>\n<li>Tweak &#8211; Add the <code>tribe_views_v2_after_setup_loop</code> filter to modify the loop context set up in the View (v2). [ECP-811]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_by_day_view_grid_days</code> to allow pre-filling Month and Week Views (v2) Events. [ECP-529]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_by_day_view_day_results</code> to allow fine-grained control over Month and Week Views (v2) Event data. [ECP-529]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_view_ical_repository_args</code>, <code>tribe_events_views_v2_view_{$slug}_asset_origin_object</code>, <code>tribe_events_views_v2_by_day_view_grid_days</code>, <code>tribe_events_views_v2_by_day_view_day_results</code>, <code>tribe_events_views_v2_month_mobile_messages</code>, <code>tribe_events_views_v2_view_cached_html</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_cached_html</code>, <code>tribe_ical_template_event_ids</code>, <code>tribe_get_view_permalink</code>, <code>tribe_get_{$slug}_view_permalink</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_views_v2_after_setup_loop</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/parts/details</code>, <code>modules/meta/details</code>, <code>v2/components/breakpoints</code>, <code>v2/components/messages</code>, <code>v2/day/time-separator</code>, <code>v2/month</code>, <code>v2/month/calendar-body/day</code>, <code>v2/month/mobile-events</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code></li>\n<li>Language &#8211; 27 new strings added, 133 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.6.0] 2021-04-29</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.6.0 is only compatible with Events Calendar PRO 5.6.0 and higher</li>\n<li>Fix &#8211; Correct implementation of filters in Views/V2/Hooks.php to avoid fatals. [BTRIA-791]</li>\n<li>Fix &#8211; Ensure when saving on Blocks editor Organizer and Venue IDs don&#8217;t throw notices for failed deletion. [TEC-3844]</li>\n<li>Fix &#8211; Resolve compatibility problem between The Events Calendar and other plugins using Select2. [TEC-3748]</li>\n<li>Fix &#8211; Enqueue full styles for v2 event single only when using full styles. [TEC-3848]</li>\n<li>Fix &#8211; Modify Select2 to clone the <code>jQuery.fn.select2</code> into <code>jQuery.fn.select2TEC</code> to avoid conflicting with third-party usage that didn&#8217;t include the full version of Select2 [TEC-3748]</li>\n<li>Fix &#8211; Add filtering hooks to Cache Listener to allow modifications of which options trigger an occurrence. [ECP-826] [ECP-824]</li>\n<li>Fix &#8211; Improve escaping for messages when no results were found using search (Thanks Steve Pollak)</li>\n<li>Tweak &#8211; Added the ability to filter cached view HTML. Hooks added were: <code>tribe_events_views_v2_view_cached_html</code> and <code>tribe_events_views_v2_view_{$view_slug}_cached_html</code>. [ECP-770]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_view_ical_repository_args</code>, <code>tribe_events_views_v2_view_cached_html</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_cached_html</code>, <code>tribe_ical_template_event_ids</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/parts/details</code>, <code>modules/meta/details</code>, <code>v2/components/messages</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code></li>\n<li>Language &#8211; 3 new strings added, 176 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.5.0.1] 2021-04-05</h4>\n<ul>\n<li>Fix &#8211; Reduce overhead of widget setup on every page load by setting up the widgets only as needed. [TEC-3833]</li>\n</ul>\n<h4>[5.5.0] 2021-03-29</h4>\n<ul>\n<li>Feature &#8211; Add <code>has_event</code> and <code>has_no_events</code> to the Venue and Organizer ORM so we can filter requests for both by whether they have events or not.</li>\n<li>Fix &#8211; Invert quotes to protect against issue with MySQL in <code>ANSI_QUOTES</code> mode. [TEC-3785]</li>\n<li>Fix &#8211; correct display order of sticky, featured, and «normal» events on Month View. Adds a class for targeting sticky posts for styling. [TEC-3770]</li>\n<li>Fix &#8211; Ensure the Events List widget also shows the Time Zone when displaying it is set in the admin. [TEC-3747]</li>\n<li>Fix &#8211; Saving on Blocks editor without Organizer is working as expected again [TEC-3788]</li>\n<li>Fix &#8211; Fusion Core/Avada Widget implementation of The Events Calendar will no longer throw warnings on the frontend display. [ECP-538]</li>\n<li>Fix &#8211; Usage of <code>tribe_get_events()</code> for non-existent posts will no longer throw warnings on the Blocks Editor, impacted Community Events Shortcode usage [BTPLAN-121]</li>\n<li>Tweak &#8211; Added rel=noreferrer to Google Map links. [TEC-3795]</li>\n<li>Tweak &#8211; Include actions before and after the creation of a view for REST API requests. Hooks added were: <code>tribe_events_views_v2_before_make_view_for_rest</code> and <code>tribe_events_views_v2_after_make_view_for_rest</code></li>\n<li>Tweak &#8211; Allow specific filtering to add other views into the HTML caching for performance using hook <code>tribe_events_views_v2_cached_views</code>.</li>\n<li>Tweak &#8211; Include Legacy views deprecation notice [TEC-4809]</li>\n<li>Language &#8211; 8 new strings added, 181 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.4.0.2] 2021-03-10</h4>\n<ul>\n<li>Fix &#8211; Saving organizers properly work on WordPress 5.7 with Blocks Editor [TEC-3788]</li>\n</ul>\n<h4>[5.4.0.1] 2021-03-04</h4>\n<ul>\n<li>Fix &#8211; Prevent fatals happening with PHP 5.6 due to duplicated class for templates [BTRIA-767]</li>\n</ul>\n<h4>[5.4.0] 2021-02-24</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.4.0 is only compatible with Events Calendar PRO 5.3.0 and higher</li>\n<li>Fix &#8211; Compatibility with WordPress 5.7 and jQuery 3.5.X</li>\n<li>Fix &#8211; Updated views JavaScript manager is now deferred to the end of the request, to make sure all dependencies are loaded.</li>\n<li>Fix &#8211; Navigation for the Views will no longer use current browser URL as previous url, preventing problems on shortcodes.</li>\n<li>Fix &#8211; Latest Past view moved to not publicly visible, which was the intended behavior.</li>\n<li>Tweak &#8211; Add compatibility container to widgets &#8211; to allow for a non-body target for compatibility classes.</li>\n<li>Tweak &#8211; Include the <code>tribe_events_views_v2_view_page_reset_ignored_params</code> filter to prevent certain params from interfering with pagination resetting. [FBAR-222]</li>\n<li>Tweak &#8211; Use filterable attributes for the view more link and text. Add customizer styling for the link. [ECP-568]</li>\n<li>Tweak &#8211; Removed <code>tribe_events_views_v2_widget_admin_form_{$field_type}_input</code> from the List Widget admin form in favor of using <code>Tribe__Template::do_entry_point()</code> [ECP-486]</li>\n<li>Tweak &#8211; Moved administration templates for List Widget components to Common. [ECP-486]</li>\n<li>Language &#8211; 1 new strings added, 10 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.3.2.1] 2021-02-02</h4>\n<ul>\n<li>Fix &#8211; Prevent Event Aggregator ASYNC requests from failing to import after 5 Events, Venues, RSVP, Tickets and/or Organizers. [TEC-3769]</li>\n<li>Fix &#8211; Update compatibility with PHP 7.4 for ForceUTF8 vendor module. [TEC-3769]</li>\n</ul>\n<h4>[5.3.2] 2021-01-28</h4>\n<ul>\n<li>Feature &#8211; Add customizer support for custom location pins on single events when Views V2 is active. [TEC-3276]</li>\n<li>Fix &#8211; Use dynamic label for fast-forward link on the month view. [TEC-3452]</li>\n<li>Fix &#8211; Correctly filter <code>locale</code> in the <code>Tribe\\Events\\I18n</code> class to avoid errors.</li>\n<li>Fix &#8211; Prevent heartbeat warning when null data param is passed on Cron and AJAX requests [BTRIA-687]</li>\n<li>Fix &#8211; Increase the minimum width of the datetime dropdown when editing an event with the block editor. [TEC-3126]</li>\n<li>Fix &#8211; Ordering with an Array when using <code>Tribe__Repository</code> now properly ignores the global order passed as the default. [ECP-598]</li>\n<li>Fix &#8211; Resolve PHP 8.0 incompatibility with <code>__wakeup</code> and <code>__clone</code> visibility on Extension class.</li>\n<li>Fix &#8211; Prevent <code>tribe_sort_by_priority</code> from throwing warnings on <code>uasort</code> usage for PHP 8+ compatibility.</li>\n<li>Fix &#8211; Update Di52 to include PHP 8+ compatibility.</li>\n<li>Fix &#8211; Modify Freemius <code>class-fs-logger.php</code> file to prevent PHP 8+ warnings.</li>\n<li>Fix &#8211; Correctly handle *nix and Windows server paths that contain falsy values (e.g. <code>0</code> or spaces) when building template paths. [TEC-3712]</li>\n<li>Tweak &#8211; Increase top padding above date stamp in list view. [TEC-3656]</li>\n<li>Tweak &#8211; Reduce bottom margin of the event title in list/day views. [TEC-3656]</li>\n<li>Tweak &#8211; Round featured event line corners. [TEC-3656]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_build_url_data</code> to customize the URL delivered to EA server.</li>\n<li>Tweak &#8211; Update V2 Customizer admin styles of TEC sections. [TEC-3696]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_aggregator_build_url_data</code></li>\n<li>Language &#8211; 4 new strings added, 187 updated, 3 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.3.1] 2020-12-15</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator &#8211; Filter Events by Aggregator/Import Record. [EA-130]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add background color css overrides. [TEC-3651]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add Event Title color css overrides. [TEC-3334]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add Event Date &amp; Time color css overrides. [TEC-3675]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Background Color to general and single-event sections. [TEC-3683]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Event Title Color to general section. [TEC-3684]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Event Date &amp; Time Color to general section. [TEC-3685]</li>\n<li>Tweak &#8211; Add opaque backgrounds for selected bordered elements. [TEC-3673]</li>\n<li>Tweak &#8211; Change Title/Date &amp; Time font color defaults on the Event Single page. [TEC-3682]</li>\n<li>Fix &#8211; Fix an issue in csv venue imports where the address would not import.  [TEC-3637]</li>\n<li>Fix &#8211; Compatibility for some theme menus that no longer displayed when an event is password protected. [TEC-2968]</li>\n<li>Language &#8211; 8 new strings added, 63 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.3.0] 2020-12-02</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator &#8211; Search Box for Scheduled Imports. [TEC-3570]</li>\n<li>Feature &#8211; Event Aggregator Batch Pushing for Cron Imports [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_aggregator_import_queue_cleaner_time_to_live</code> to customize the time in seconds to consider an EA record alive. [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_aggregator_import_queue_cleaner_stall_limit</code> to customize the number of seconds for an EA record to be considered stalled. [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_events_aggregator_build_url</code> [EA-297]</li>\n<li>Tweak &#8211; Adjust Event Aggregator Client Progress Bar using the Heart Beat API for polling state instead [TEC-3534]</li>\n<li>Tweak &#8211; Event Aggregator &#8211; Make default limit by number of events instead of by date range. [TEC-3635]</li>\n<li>Tweak &#8211; Event Aggregator/Eventbrite Tickets &#8211; Remove verbiage regarding 50 event limit on Eventbrite imports.</li>\n<li>Tweak &#8211; Add the <code>tribe_get_organizer_object</code> function. [TEC-3645]</li>\n<li>Tweak &#8211; Change the return value of the <code>tribe_get_event( $event_id )-&gt;organizers</code> from a collection of Organizer names to a collection of Organizer post objects. [TEC-3645s]</li>\n<li>Tweak &#8211; Add the <code>tribe_get_event( $event_id )-&gt;organizer_names</code> method to return a collection of the Event Organizer names. [TEC-3645]</li>\n<li>Tweak &#8211; Ensure widgets don&#8217;t get Filter Bar classes on their containers. [FBAR-202]</li>\n<li>Tweak &#8211; Switch the List View previous/next URL methods to use the slug rather than a hard-coded «list» so the class is more easily extendable. [TEC-3648]</li>\n<li>Tweak &#8211; Add an option to trash events after 1 month (thanks @StefanSchroeder).</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_datepicker_no_conflict</code> filter (default <code>false</code>) to allow loading the Views v2 datepicker in no-conflict mode, when set to <code>true</code>, and avoid issues with other plugins that are loading the built-in WordPress <code>jquery-ui-datepicker</code> script. [TEC-3581]</li>\n<li>Tweak &#8211; Improve WPML integration and URL localization of Views v2. [TEC-3608]</li>\n<li>Fix &#8211; Event Aggregator &#8211; Fix Eventbrite status filter to not return &#8216;do_not_override&#8217; and handle Eventbrite&#8217;s additional statuses. [TEC-3569]</li>\n<li>Fix &#8211; Ensure ECP shortcode today button handles categories gracefully. [ECP-492]</li>\n<li>Fix &#8211; Prevent creation of duplicate venues for default address while adding or editing events. [ECP-482]</li>\n<li>Fix &#8211; Make sure Month View «View More» link to Day View will preserve the current search criteria. [TEC-3230]</li>\n<li>Fix &#8211; Ensure Event Aggregator Cron schedules always have array format and avoid errors on fresh WordPress installations (thanks @mmcachran).</li>\n<li>Fix &#8211; Regular expression to sanitize name of columns on the EA client make sure all invalid characters are removed.</li>\n<li>Fix &#8211; Use more robust code in the <code>tribe_is_past_event</code> template tag to avoid Warnings.</li>\n<li>Fix &#8211; Review and improve the Rewrite component to correctly parse and handle localized URLs and accented characters. [TEC-3608]</li>\n<li>Language &#8211; 25 new strings added, 775 updated, 1 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.2.1] 2020-10-22</h4>\n<ul>\n<li>Tweak &#8211; Change Views v2 AJAX request method from GET to POST to avoid issues with too long URLs. [TEC-3283]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_endpoint_method</code> filter to allow controlling the HTTP method Views should use to fetch their content from the back-end endpoint. [TEC-3283]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_endpoint_url</code> filter to allow controlling the URL Views should use to fetch their content from the back-end endpoint. [TEC-3283]</li>\n<li>Fix &#8211; Prevent Event Aggregator 15 minute Cron Schedule from being created when not required (props @jetxpert) [EA-317]</li>\n<li>Fix &#8211; Add filter to toggle off the event templates hijack. [TEC-3521]</li>\n<li>Fix &#8211; Correct url for current month iCal export link. [TEC-3575]</li>\n<li>Fix &#8211; Avoid loading the same CSS file twice on the back-end. [TEC-3623]</li>\n<li>Fix &#8211; Ensure ECP shortcode prev/next urls handle categories gracefully. [ECP-492]</li>\n<li>Language &#8211; 3 new strings added, 200 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.2.0] 2020-09-28</h4>\n<ul>\n<li>Fix &#8211; Fix the order of the List View when the PRO is set to show only the first instance of a Recurring Event. [ECP-467]</li>\n<li>Fix &#8211; Fix a PHP error that would arise when during the translation, by the WPML plugin, of some strings. [TEC-3454, TEC-3578]</li>\n<li>Fix &#8211; Fix a compatibility issue with the WPML plugin that would prevent some options from being translated correctly. [TEC-3454]</li>\n<li>Fix &#8211; Generation and usage of translated strings that would cause issues with the WPML plugin. [TEC-3454]</li>\n<li>Tweak &#8211; Use the <code>border-small</code> class for the today button, add new border button styles to customizer. [FBAR-143]</li>\n<li>Tweak &#8211; Add missing CSS classes to the Event Categories label on the single event page. [TEC-3478]</li>\n<li>Tweak &#8211; Adjust accordion trigger selector to allow multiple space-separated <code>data-js</code> attributes. [FBAR-125]</li>\n<li>Tweak &#8211; Adjust spacing on header to prevent screen overflow. [FBAR-132]</li>\n<li>Tweak &#8211; Adjust aria attributes and add loader text to make ajax loading more accessible. [FBAR-147]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_latest_past_view_display_template</code> filter to allow controlling the display of templates  in the context of the Latest Past Events View. [FBAR-148]</li>\n<li>Tweak &#8211; Allow passing of additional data to the AJAX request by use of container data. [FBAR-162]</li>\n<li>Language &#8211; 2 new strings added, 20 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.1.6] 2020-08-24</h4>\n<ul>\n<li>Tweak &#8211; Move the iCal output coding out of the loop and into its own method.  [VE-150]</li>\n<li>Fix &#8211; Fix SQL errors that would show up when creating custom Event queries in theme builders. [TEC-3530]</li>\n<li>Fix &#8211; Fix SQL errors that would show up when running custom Event queries in plugins . [TEC-3528]</li>\n<li>Fix &#8211; Fix SQL errors that would prevent customers from being able to select tickets assigned to Events in some instances. [TEC-3500]</li>\n<li>Fix &#8211; On re-import of the excerpt and event description field enable changes to the existing values. [TEC-3080]</li>\n<li>Fix &#8211; On re-import enable excerpt and description to be cleared of their values. [TEC-3080]</li>\n<li>Fix &#8211; On re-import only overwrite items that have been mapped. [TEC-2962]</li>\n<li>Tweak &#8211; Add filters for venue and organizer import data. [TEC-2962]</li>\n<li>Tweak &#8211; Add ability to use default values from settings for venue imports via the <code>tribe_events_importer_set_default_venue_import_values</code> filter. [TEC-2962]</li>\n<li>Tweak &#8211; Replace placeholders in template docblocks with appropriate links. [TEC-3399]</li>\n<li>Language &#8211; 32 new strings added, 75 updated, 0 fuzzied, and 28 obsoleted</li>\n</ul>\n<h4>[5.1.5] 2020-07-27</h4>\n<ul>\n<li>Tweak &#8211; Add filters to link generation for events, venues, and organizers. [EXT-151]</li>\n<li>Tweak &#8211; Remove disabled admin notice for Virtual Events and Gutenberg. [TEC-3546]</li>\n<li>Tweak &#8211; Modify parameters on <code>register_rest_route</code> to include <code>permission_callback</code> to prevent notices on WordPress 5.5.</li>\n<li>Fix &#8211; Prevent the wrong dates in mobile month view date marker when on leading UTC timezones. [TEC-3549]</li>\n<li>Fix &#8211; Fix the display order of Events starting on the same date and time to ensure it&#8217;s consistent. [TEC-3548]</li>\n<li>Fix &#8211; Fix the handling of URL fragments translations in Views to ensure fully localized View URLs work. [TEC-3479]</li>\n<li>Fix &#8211; Display promo at the bottom of views when «Show The Events Calender link» is checked. [TEC-3321]</li>\n<li>Fix &#8211; Set proper timezone on block editor when creating a new event. [TEC-3543]</li>\n<li>Fix &#8211; Prevent PHP error when using V2, the site home page at <code>Main Events page</code>, including events in the blog loop, and Pro is active.  [ECP-361]</li>\n<li>Fix &#8211; Resolve WordPress REST API authentication errors related to <code>null</code> returns. Props to @ahaurat [TEC-3539]</li>\n<li>Language &#8211; 0 new strings added, 55 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.1.4] 2020-06-24</h4>\n<ul>\n<li>Tweak &#8211; Improve fresh install experience by setting the default template to the Events one [TEC-3453]</li>\n<li>Tweak &#8211; Create a new method to request an update back to EA imports to mark imports as completed on EA server [TEC-3476]</li>\n<li>Tweak &#8211; Add a new filter <code>tribe_aggregator_service_put_pue_licenses</code> to enable external sources the option to add additional PUE attached to the request. [TEC-3476]</li>\n<li>Tweak &#8211; Prevent latest-past from showing in the front end view selector in new installs [TEC-3450]</li>\n<li>Tweak &#8211; On a fresh install set the enabled views to list, month, and day and set the default view to list to stop erroneous error entries [TEC-3451]</li>\n<li>Tweak &#8211; Add a new «scheduled» status for the activity reporter of imports from EA [TEC-3475]</li>\n<li>Tweak &#8211; Add admin notice for Virtual Events. [TEC-3620]</li>\n<li>Language &#8211; 3 new strings added, 246 updated, 1 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.3] 2020-06-22</h4>\n<ul>\n<li>Tweak &#8211; Add new filter <code>tribe_events_filter_views_v2_plural_events_label</code> to customize the label in V2 views. [VE-9]</li>\n<li>Fix &#8211; Prevent «too few arguments» on the settings page when a url contains percentage signs. [VE-111]</li>\n<li>Fix &#8211; Correctly store Event Organizer meta when using the ORM.</li>\n<li>Fix &#8211; Linked posts (Organizers and Venues) correctly check if the item selected is brand new or existing when edit link is empty. [TEC-3481]</li>\n<li>Language &#8211; 1 new strings added, 112 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.2.1] 2020-06-09</h4>\n<ul>\n<li>Security &#8211; Remove deprecated usage of escapeMarkup in Select2 (props to miha.jirov for reporting this).</li>\n</ul>\n<h4>[5.1.2] 2020-05-27</h4>\n<ul>\n<li>Tweak &#8211; Prevent undefined errors when using tribe_get_events and forcing a cache refresh.</li>\n<li>Fix &#8211; Prevent <code>E_ERROR</code> for <code>Tribe__Events__Meta__Save</code> construct when dealing with revisions, which some WP Engine customers were seeing.</li>\n<li>Language &#8211; 0 new strings added, 49 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.1.1] 2020-05-11</h4>\n<ul>\n<li>Feature &#8211; Move all the featured event icons to templates. [TEC-3441]</li>\n<li>Feature &#8211; Added a helper method <code>Tribe__Plugins::is_active( \'slug\' )</code> to check if a given plugin is active.</li>\n<li>Feature &#8211; Add entry points through filters to be able to add content after the opening html tag or before the closing html tag. [TCMN-65]</li>\n<li>Tweak &#8211; Deprecated the <code>Tribe__Events__Main::get_i18n_strings_for_domains()</code> and <code>Tribe__Events__Main::get_i18n_strings()</code> methods; use the methods with the same name and signature provided by the <code>tribe( \'tec.18n\' )</code> object [TEC-3404]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_manage_record_column_source_html</code> to customize the source column content HTML used on the Event Aggregator Import «History» tab.</li>\n<li>Tweak &#8211; Modify language variables to improve translations readability on Updated Views navigation previous and next buttons. [props @justlevine]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_manage_record_column_source_html</code> to customize the source column content HTML used on the Event Aggregator Import «History» tab.</li>\n<li>Fix &#8211; Enqueue Customizer stylesheets properly via <code>tribe_customizer_inline_stylesheets</code> in Common. [TEC-3401]</li>\n<li>Fix &#8211; Not being able to create events because capabilities were not set on activation or update of the plugin. [TEC-3350]</li>\n<li>Fix &#8211; Adjust templates to show time zone in event details when «Show time zone» is checked. [TEC-2979]</li>\n<li>Fix &#8211; Correct bad defaults from <code>Template-&gt;attr()</code> and ensure that the timezone info is correctly hydrated in the case of an unchanged block. [TEC-2964]</li>\n<li>Fix &#8211; Show the correct counts on the Event Aggregator Import «History» tab for non-Event content types being imported.</li>\n<li>Fix &#8211; Prevent creation of empty venue when removing a Venue inside of the Events using the Classic editor that had a US state selected. [TEC-3416]</li>\n<li>Fix &#8211; Event Aggregator imported events when using default status or categories from the Settings Page will now be imported correctly. [TEC-3445]</li>\n<li>Fix &#8211; A localization support that would mangle Views URLs when WPML plugin is active alongside Views v2 [TEC-3404]</li>\n<li>Fix &#8211; Prevent problems with <code>func_get_args()</code> usage around template inclusion for legacy template files [TEC-3104]</li>\n<li>Tweak &#8211; Extended support for namespaced classes in the Autoloader.</li>\n<li>Tweak &#8211; Make Customizer stylesheet enqueue filterable via <code>tribe_customizer_inline_stylesheets</code>. [TEC-3401]</li>\n<li>Tweak &#8211; Normalize namespaced prefixes with trailing backslash when registering them in the Autoloader. [VE-14]</li>\n<li>Language &#8211; 2 new strings added, 243 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.0] 2020-04-23</h4>\n<ul>\n<li>Feature &#8211; Add a «fast forward» link to Month and Day views when there are no events to show. [TEC-3400]</li>\n<li>Feature &#8211; Add <code>tribe_events_views_v2_use_ff_link</code> and <code>tribe_events_views_v2_{$this-&gt;slug}_use_ff_link</code> filters to allow control of the link. [TEC-3400]</li>\n<li>Feature &#8211; Add Recent Past Events Views. [TEC-3385]</li>\n<li>Tweak &#8211; Improved on meta data handling of for Blocks editor.</li>\n<li>Tweak &#8211; Deprecate Select2 3.5.4 in favor of SelectWoo</li>\n<li>Tweak &#8211; Load plugin text domain on the new <code>tribe_load_text_domains</code> action hook, which fires on <code>init</code> instead of on the <code>plugins_loaded</code> hook. [TEC-3406]</li>\n<li>Tweak &#8211; Add a constant <code>TRIBE_CACHE_VIEWS</code> to turn off views HTML caching.</li>\n<li>Fix &#8211; Theme navigation warning around <code>post_date = \'0\'</code> no longer happens when using Page template for Updated Views [TEC-3434]</li>\n<li>Fix &#8211; Selecting other Page templates from Settings &gt; Display now loads the correct template properly, to display events.</li>\n<li>Fix &#8211; Preventing redirects from updated Views V2 to be too broad and end up catching requests from other Plugins, reported by GravityView team on Gravity Forms bug with imports.</li>\n<li>Fix &#8211; Prevent PHP errors from happening during bulk activation or deactivation of the plugin [TCMN-53]</li>\n<li>Fix &#8211; Correct iCal link on month view for months other than the current one [TEC-3267]</li>\n<li>Fix &#8211; Correct a few incorrect and/or typoed text domains [TEC-3390]</li>\n<li>Fix &#8211; Ensure we pass search keywords when changing views and in the top-bar nav [TEC-3282]</li>\n<li>Fix &#8211; Prevent Blocks editor from throwing browser alert when leaving the page without any changes applied to the edited post.</li>\n<li>Fix &#8211; Several strings have been adjusted for consistency and better translatability [BTRIA-307]</li>\n<li>Hook &#8211; Add the <code>tribe_events_blocks_editor_is_on</code> filter; returning a falsy value from this filter will prevent the Blocks Editor to ever be active on Events; else the settings from Events &gt; Settings will apply [TEC-3349]</li>\n<li>Tweak &#8211; Add some filters for better control of link targets, standardize the way we create those links [TEC-3402]</li>\n<li>Language &#8211; 4 new strings added, 286 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[5.0.3.1] 2020-03-23</h4>\n<ul>\n<li>Fix &#8211; Assets class modification to prevent JavaScript and CSS failing to load when <code>SCRIPT_DEBUG=true</code> [TCMN-52]</li>\n</ul>\n<h4>[5.0.3] 2020-03-23</h4>\n<ul>\n<li>Feature &#8211; Allow users to set a custom name for new Event Aggregator Imports. [TEC-3286]</li>\n<li>Tweak &#8211; Add back missing JSON-LD to Single Events. [TEC-3262]</li>\n<li>Tweak &#8211; Minify the Freemius svg assets. [TEC-3215]</li>\n<li>Tweak &#8211; Remove «(beta)» label from URL source type of import. [TEC-3289]</li>\n<li>Tweak &#8211; Reword the Filter Activation setting&#8217;s labels for better clarity.  [FBAR-79]</li>\n<li>Fix &#8211; Ensure that any values for <code>liveFilterUpdate</code> that are not <code>automatic</code> or <code>manual</code> get converted. [FBAR-83]</li>\n<li>Fix &#8211; Breakpoint code compatibility with the latest version of jQuery 3.4.1 [BTRIA-154]</li>\n<li>Fix &#8211; Remove numbers from listed events in event list widget for Genesis theme. [TEC-2957]</li>\n<li>Fix &#8211; Customizer accent color affects featured line and text. [TEC-3277]</li>\n<li>Fix &#8211; Resolve conflict between datepicker holding consistent size when navigating and flexibility on small screen sizes. [TEC-3322]</li>\n<li>Fix &#8211; Respect EA <code>post_status</code> from settings when an event does not have a defined value. [TEC-3255]</li>\n<li>Fix &#8211; Save the <code>post_status</code> for a scheduled import when using a different value other than <code>publish</code>. [TEC-3296]</li>\n<li>Fix &#8211; Update events, venues, and organizers to use dynamic labels. [TEC-3280]</li>\n<li>Fix &#8211; Resolve an issue in Views v2 that would break URLs when the event single and archive slugs have the same value due to the «Events URL slug» and «Single event URL slug» settings or due to their translations [TEC-3254]</li>\n<li>Fix &#8211; Restore correct handling of events RSS feeds; events will show in the RSS feed in ascending start date, starting from the current day and the event publish date will be set to the event start date [TEC-3252]</li>\n<li>Hook &#8211; Add filters <code>tribe_events_liveupdate_automatic_label_text</code> and <code>tribe_events_liveupdate_manual_label_text</code> to allow Filter Bar to include itself in those labels. [TEC-3322]</li>\n<li>Hook &#8211; Add the <code>tribe_views_v2_events_query_controller_active</code> filter; returning a falsy value from this filter will prevent Views v2 from altering the WordPress query. This filter allows handling situations where Views v2 might interfere with third party plugins (e.g. custom RSS feed implementations) [TEC-3252]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_option_convert_live_filters</code>, <code>tribe_events_views_v2_messages_need_events_label_keys</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_ical_export_text</code></li>\n<li>Tweak &#8211; Changed views: <code>v2/components/events-bar/search/keyword</code>, <code>v2/month/calendar-body/day</code></li>\n<li>Language &#8211; 11 new strings added, 81 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.0.2.1] 2020-02-25</h4>\n<ul>\n<li>Fix &#8211; Plugin dependency registration with <code>Plugin_Register</code> will not prevent loading of all plugins in list if the last item loaded fails. [TCMN-41]</li>\n</ul>\n<h4>[5.0.2] 2020-02-19</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.0.2 is only compatible with Filter Bar 4.9.2 and higher</li>\n<li>Version &#8211; The Events Calendar 5.0.2 is only compatible with Events Calendar PRO 5.0.2 and higher</li>\n<li>Tweak &#8211; Modify Link Color Customizer option for single event links in description, the venue, the organizer, and the website link in classic editor.  [TEC-3219]</li>\n<li>Tweak &#8211; Move link color option to General tab in Customizer and remove Text tab.  [TEC-3244]</li>\n<li>Tweak &#8211; Freemius Opt-out workflow now present on all occasions [TEC-3171]</li>\n<li>Tweak &#8211; Freemius updated to the latest version 2.3.2 [TEC-3171]</li>\n<li>Tweak &#8211; Remove the «Default stylesheet &#8211; full» option from display settings, for the new views. [TEC-3125]</li>\n<li>Tweak &#8211; Change the live refresh option to a radio, adjust conditional checks to accommodate. [TEC-3072]</li>\n<li>Fix &#8211; Freemius activation URL send via email works as expected [TEC-3218]</li>\n<li>Fix &#8211; Improve compatibility from Updated Views V2 with Beaver Builder plugins [TEC-3248]</li>\n<li>Fix &#8211; More robust handling of <code>hide_from_listings</code> in REST API v2, thanks @maxm123</li>\n<li>Fix &#8211; Make sure the new Views (v2) will correctly print JSON-LD schema information [TEC-3241]</li>\n<li>Language &#8211; 4 new strings added, 248 updated, 1 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[5.0.1] 2020-02-12</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.0.1 is only compatible with Filter Bar 4.9.1 and higher</li>\n<li>Version &#8211; The Events Calendar 5.0.1 is only compatible with Events Calendar PRO 5.0.1 and higher</li>\n<li>Feature &#8211; Add the «Accent Color» option in the customizer, for the new views. [TEC-3067]</li>\n<li>Fix &#8211; Fix venue block title from being indented in Twenty Twenty theme. [TEC-3140]</li>\n<li>Fix &#8211; Fix website block label from disappearing when adding event details classic block. [TEC-2971]</li>\n<li>Fix &#8211; Fix style overrides for new view shortcodes for Enfold theme. [ECP-315]</li>\n<li>Fix &#8211; Fix events bar input class recognition for JS handling in new views. [TEC-3091]</li>\n<li>Fix &#8211; Ensure datepicker does not get cut off in small width screens for new views. [TEC-2983]</li>\n<li>Fix &#8211; Venue and organizer blocks link to venue and organizer pages if Events Calendar Pro is activated. [ECP-14]</li>\n<li>Fix &#8211; Use proper check for map on venue block to apply proper class. [TEC-3020]</li>\n<li>Fix &#8211; Remove font family applied to organizer block to allow theme styles to be applied. [TEC-2974]</li>\n<li>Fix &#8211; Fix numbers breaking into two lines in datepicker in Twenty Twenty theme. [TEC-2999]</li>\n<li>Fix &#8211; Fix tooltips being cut off and hidden in month view. [TEC-3000]</li>\n<li>Fix &#8211; Fix event sharing block cutting off text in block editor admin when editing event. [TEC-2972]</li>\n<li>Fix &#8211; Fix disappearing price description in block editor admin when editing event. [TEC-2992]</li>\n<li>Fix &#8211; Allow venues to be properly removed by clicking the remove venue button in the venue block. [TEC-2965]</li>\n<li>Fix &#8211; Ensure map does not display if enable map setting is disabled. [TEC-3013]</li>\n<li>Fix &#8211; Fix the datepicker width problem in Google Chrome, for the new views. [TEC-2995]</li>\n<li>Fix &#8211; Fix an issue where Venue provinces would be incorrectly populated in iCal exports [TEC-3223]</li>\n<li>Fix &#8211; Deleting events after X feature no longer will delete posts with <code>_EventEndDate</code> meta [TEC-3233]</li>\n<li>Tweak &#8211; Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]</li>\n<li>Tweak &#8211; Remove find events button and related data when events bar is disabled. [TEC-3074]</li>\n<li>Tweak &#8211; Ensure datepicker always updates view via live refresh. [TEC-3073]</li>\n<li>Tweak &#8211; Adjust customizer labels for sites using the new views [TEC-3066]</li>\n<li>Tweak &#8211; Allow start datetime and end datetime to be the same to hide end datetime in frontend when using block editor. [TEC-3009]</li>\n<li>Tweak &#8211; Move the «Link Color» option in the customizer, for the new views. [TEC-3067]</li>\n<li>Language &#8211; 14 new strings added, 256 updated, 0 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.0.0.2] 2020-02-06</h4>\n<ul>\n<li>Fix &#8211; Datepicker format now properly defaults to the correct value when Display Settings have not been saved. [TEC-3229]</li>\n<li>Fix &#8211; New views mobile breakpoints interactions with Caching plugins resolved. [TEC-3221]</li>\n</ul>\n<h4>[5.0.0.1] 2020-01-31</h4>\n<ul>\n<li>Fix &#8211; Events with timezones that differ from the site timezone now display on the correct date. [TEC-3208]</li>\n<li>Fix &#8211; Multi-day events now display on all days that they are supposed to. [TEC-3212]</li>\n<li>Fix &#8211; End of day cutoff is now being observed appropriately when creating the day grid stack. [TEC-3210]</li>\n<li>Fix &#8211; Fix number of parameters when doing <code>the_post</code> action, for the single event view in the new views. [TEC-3214]</li>\n<li>Fix &#8211; 404s on permalinks have been resolved by moving the flush permalink action to a later moment of time on activation after all rules have been declared. [TEC-3211]</li>\n</ul>\n<h4>[5.0.0] 2020-01-27</h4>\n<ul>\n<li>Feature &#8211; Created new Month, Day, and List views with all new HTML, CSS, and JavaScript.</li>\n<li>Feature &#8211; Add upgrade path for new Month, Day, and List views making it opt-in for any existing users.</li>\n<li>Feature &#8211; New templating engine to power the new Views. <a href=\"https://evnt.is/1aid\" rel=\"nofollow ugc\">See More</a></li>\n<li>Feature &#8211; Views initialization and instance includes more filters and actions to allow improved extensibility and customization. (See all filters below)</li>\n<li>Feature &#8211; Views manager and bootstrapping classes were created to allow more control over where and when views will be initialized. (See filters related to those below)</li>\n<li>Feature &#8211; Reduced maintenance burden of customizations by leveraging atomic templates for the new views. (See list of files now available below)</li>\n<li>Feature &#8211; CSS uses a Block Element Modifier (BEM) methodology to improve reusability of components. <a href=\"https://evnt.is/1aib\" rel=\"nofollow ugc\">See More</a></li>\n<li>Feature &#8211; New Views share one JavaScript Manager, which contains multiple jQuery actions and customization points.</li>\n<li>Feature &#8211; View navigation relies on the WP Rest API, improving reliability and caching opportunities.</li>\n<li>Feature &#8211; Event permalinks are now more consistent across navigation using <code>WP_Rewrite</code> to map params to their matching URL, which improves SEO.</li>\n<li>Feature &#8211; Event data filtering used across all new views: <code>tribe_get_event_before</code>, <code>tribe_get_event</code>, <code>tribe_get_event_after</code>, <code>tribe_events_organizers_fetch_callback</code>, <code>tribe_events_venues_fetch_callback</code></li>\n<li>Feature &#8211; Venue data filtering used across all new views: <code>tribe_get_venue_object_before</code>, <code>tribe_get_venue_object</code></li>\n<li>Tweak &#8211; Custom Before and After HTML on the Events &gt; Settings page will now prefer event view styling over the Theme&#8217;s CSS.</li>\n<li>Tweak &#8211; Lowered the reliance on the global <code>$wp_query</code> to create more consistent output and faster maintenance. <a href=\"https://evnt.is/1aic\" rel=\"nofollow ugc\">See More</a></li>\n<li>Tweak &#8211; View overrides for the new views will look within a new folder in your theme to avoid conflicting with old The Events Calendar theme customizations <a href=\"https://evnt.is/1aia\" rel=\"nofollow ugc\">See More</a></li>\n<li>Tweak &#8211; Switch to a compact date while on day and month view in mobile [136789]</li>\n<li>Tweak &#8211; Remove <code>tribe_events_getLink</code> in favor of <code>tribe_events_get_link</code> which was a deprecated filter since version 4.3</li>\n<li>Hooks &#8211; View template include and render filters and actions: <code>tribe_template_before_include</code>, <code>tribe_template_before_include:{$template_path}</code>, <code>tribe_template_after_include</code>, <code>tribe_template_after_include:{$template_path}</code>, <code>tribe_template_html</code>, <code>tribe_template_html:{$template_path}</code></li>\n<li>Hooks &#8211; View instance filters and actions: <code>tribe_events_views_v2_view_template</code>, <code>tribe_events_views_v2_{$view_slug}_view_template</code>, <code>tribe_events_views_v2_view_context</code>, <code>tribe_events_views_v2_{$view_slug}_view_context</code>, <code>tribe_events_views_v2_view_repository</code>, <code>tribe_events_views_v2_{$view_slug}_view_repository</code>, <code>tribe_events_views_v2_view_url_query_args</code>, <code>tribe_events_views_v2_{$view_slug}_view_url_query_args</code>, <code>tribe_events_views_v2_view_html_classes</code>, <code>tribe_events_views_v2_{$view_slug}_view_html_classes</code>, <code>tribe_events_views_v2_url_query_args</code>, <code>tribe_events_views_v2_view_template_vars</code>, <code>tribe_events_views_v2_view_{$view_slug}_template_vars</code>, <code>tribe_events_views_v2_view_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_url</code>, <code>tribe_events_views_v2_view_prev_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_prev_url</code>, <code>tribe_events_views_v2_view_next_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_next_url</code>, <code>tribe_events_views_v2_view_repository_args</code>, <code>tribe_events_views_v2_view_link_label_format</code>, <code>tribe_events_views_v2_view_{$view_slug}_link_label_format</code>, <code>tribe_events_views_v2_view_title</code>, <code>tribe_events_views_v2_view_{$view_slug}_title</code>, <code>tribe_events_views_v2_view_messages</code>, <code>tribe_events_views_v2_view_{$view_slug}_messages</code>, <code>tribe_events_views_v2_view_breadcrumbs</code>, <code>tribe_events_views_v2_view_{$view_slug}_breadcrumbs</code>, <code>tribe_events_views_v2_view_display_events_bar</code>, <code>tribe_events_views_v2_view_{$view_slug}_display_events_bar</code>, <code>tribe_events_views_v2_view_ical_data</code>, <code>tribe_events_views_v2_view_{$view_slug}_ical_data</code>, <code>tribe_events_views_v2_view_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_{$view_slug}_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_public_views</code>, <code>tribe_events_views_v2_view_{$view_slug}_public_views</code>, <code>tribe_events_views_v2_view_data</code>, <code>tribe_events_views_v2_{$view_slug}_view_data</code>, <code>tribe_events_views_v2_{$view_slug}_events_per_day</code>, <code>tribe_events_views_v2_month_events_per_day</code>, <code>tribe_events_views_v2_month_nav_skip_empty</code>, <code>tribe_events_views_v2_view_breakpoints</code>, <code>tribe_events_views_v2_view_{$view_slug}_breakpoints</code>, <code>tribe_events_views_v2_before_make_view</code>, <code>tribe_events_views_v2_after_make_view</code>, <code>tribe_events_views_v2_messages_map</code>, <code>tribe_events_views_v2_view_messages_before_render</code></li>\n<li>Hooks &#8211; View REST API HTML request actions and filters: <code>tribe_events_views_v2_request_arguments</code>, <code>tribe_events_views_v2_rest_endpoint_available</code>, <code>tribe_events_views_v2_rest_params</code>, <code>tribe_events_views_v2_{$view_slug}_rest_params</code></li>\n<li>Hooks &#8211; Views Bootstrap filters and actions: <code>tribe_events_views_v2_bootstrap_pre_get_view_html</code>, <code>tribe_events_views_v2_bootstrap_should_display_single</code>, <code>tribe_events_views_v2_bootstrap_view_slug</code>, <code>tribe_events_views_v2_bootstrap_pre_should_load</code>, <code>tribe_events_views_v2_should_hijack_page_template</code></li>\n<li>Hooks &#8211; Views Manager filters and actions: <code>tribe_events_views</code>, <code>tribe_events_views_v2_manager_default_view</code>, <code>tribe_events_views_v2_manager_view_label_domain</code>, <code>tribe_events_views_v2_manager_{$view_slug}_view_label_domain</code>, <code>tribe_events_views_v2_manager_view_label</code>, <code>tribe_events_views_v2_manager_{$view_slug}_view_label</code></li>\n<li>Hooks &#8211; Other views filters and actions: <code>tribe_events_views_v2_is_enabled</code>, <code>tribe_events_views_v2_assets_should_enqueue_frontend</code>, <code>tribe_events_views_v2_assets_should_enqueue_full_styles</code>, <code>tribe_events_v2_view_title</code>, <code>tribe_events_views_v2_should_replace_excerpt_more_link</code>, <code>tribe_events_views_v2_view_before_events_html</code>, <code>tribe_events_views_v2_view_after_events_html</code>, <code>tribe_events_views_v2_month_title</code>, <code>tribe_events_views_v2_day_title</code>, <code>tribe_events_views_v2_category_title</code>, <code>tribe_events_views_v2_theme_compatibility_registered</code>, <code>tribe_events_views_v2_stack_spacer</code>, <code>tribe_events_views_v2_stack_recycle_spaces</code>, <code>tribe_events_views_v2_stack_events</code>, <code>tribe_events_views_v2_stack_filter_event</code>, <code>tribe_events_views_v2_stack_normalize</code></li>\n<li>Templates &#8211; Views refactored template files: <code>v2/base</code>, <code>v2/components/after</code>, <code>v2/components/before</code>, <code>v2/components/breadcrumbs</code>, <code>v2/components/breadcrumbs/breadcrumb</code>, <code>v2/components/breadcrumbs/linked-breadcrumb</code>, <code>v2/components/breakpoints</code>, <code>v2/components/data</code>, <code>v2/components/events-bar</code>, <code>v2/components/events-bar/filters</code>, <code>v2/components/events-bar/search-button</code>, <code>v2/components/events-bar/search-button/icon</code>, <code>v2/components/events-bar/search</code>, <code>v2/components/events-bar/search/keyword</code>, <code>v2/components/events-bar/search/submit</code>, <code>v2/components/events-bar/tabs</code>, <code>v2/components/events-bar/views</code>, <code>v2/components/events-bar/views/list</code>, <code>v2/components/events-bar/views/list/item</code>, <code>v2/components/filter-bar</code>, <code>v2/components/ical-link</code>, <code>v2/components/loader</code>, <code>v2/components/messages</code>, <code>v2/components/read-more</code>, <code>v2/components/top-bar/actions</code>, <code>v2/components/top-bar/actions/content</code>, <code>v2/components/top-bar/datepicker/submit</code>, <code>v2/components/top-bar/nav</code>, <code>v2/components/top-bar/nav/next-disabled</code>, <code>v2/components/top-bar/nav/next</code>, <code>v2/components/top-bar/nav/prev-disabled</code>, <code>v2/components/top-bar/nav/prev</code>, <code>v2/components/top-bar/today</code>, <code>v2/day</code>, <code>v2/day/event</code>, <code>v2/day/event/cost</code>, <code>v2/day/event/date</code>, <code>v2/day/event/date/meta</code>, <code>v2/day/event/description</code>, <code>v2/day/event/featured-image</code>, <code>v2/day/event/title</code>, <code>v2/day/event/venue</code>, <code>v2/day/nav</code>, <code>v2/day/nav/next-disabled</code>, <code>v2/day/nav/next</code>, <code>v2/day/nav/prev-disabled</code>, <code>v2/day/nav/prev</code>, <code>v2/day/time-separator</code>, <code>v2/day/top-bar</code>, <code>v2/day/top-bar/datepicker</code>, <code>v2/day/type-separator</code>, <code>v2/index</code>, <code>v2/list</code>, <code>v2/list/event</code>, <code>v2/list/event/cost</code>, <code>v2/list/event/date-tag</code>, <code>v2/list/event/date</code>, <code>v2/list/event/date/meta</code>, <code>v2/list/event/description</code>, <code>v2/list/event/featured-image</code>, <code>v2/list/event/title</code>, <code>v2/list/event/venue</code>, <code>v2/list/month-separator</code>, <code>v2/list/nav</code>, <code>v2/list/nav/next-disabled</code>, <code>v2/list/nav/next</code>, <code>v2/list/nav/prev-disabled</code>, <code>v2/list/nav/prev</code>, <code>v2/list/nav/today</code>, <code>v2/list/top-bar</code>, <code>v2/list/top-bar/datepicker</code>, <code>v2/month</code>, <code>v2/month/calendar-body</code>, <code>v2/month/calendar-body/day</code>, <code>v2/month/calendar-body/day/calendar-events</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/date</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/date/meta</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/title</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/cost</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date/meta</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/description</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title</code>, <code>v2/month/calendar-body/day/more-events</code>, <code>v2/month/calendar-body/day/multiday-events</code>, <code>v2/month/calendar-body/day/multiday-events/multiday-event-spacer</code>, <code>v2/month/calendar-body/day/multiday-events/multiday-event</code>, <code>v2/month/calendar-header</code>, <code>v2/month/mobile-events</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code>, <code>v2/month/mobile-events/mobile-day/mobile-event</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/cost</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/date</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/date/meta</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/featured-image</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/title</code>, <code>v2/month/mobile-events/mobile-day/more-events</code>, <code>v2/month/mobile-events/nav</code>, <code>v2/month/mobile-events/nav/next-disabled</code>, <code>v2/month/mobile-events/nav/next</code>, <code>v2/month/mobile-events/nav/prev-disabled</code>, <code>v2/month/mobile-events/nav/prev</code>, <code>v2/month/mobile-events/nav/today</code>, <code>v2/month/top-bar</code>, <code>v2/month/top-bar/datepicker</code>, <code>v2/not-found</code></li>\n<li>Language &#8211; 2 new strings added, 169 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.14] 2020-01-15</h4>\n<ul>\n<li>Feature &#8211; Add Repository filter <code>where_meta_related_by_meta</code> for getting a post by the meta value an associated post. [133333]</li>\n<li>Tweak &#8211; Modifications to the Freemius code initialization to allow better data around plugin uninstalls.</li>\n<li>Tweak &#8211; Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]</li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-venue</code></li>\n<li>Fix &#8211; Cost field description no longer disappears when editing the block. [TEC-2992]</li>\n<li>Fix &#8211; Organizer theme no longer getting overwritten by Blocks editor styles. [TEC-2974]</li>\n<li>Fix &#8211; Venue block properly receives the correct HTML class. [TEC-3020]</li>\n<li>Fix &#8211; Correct missing block when switching from blocks to classic editor. [131493]</li>\n</ul>\n<h4>[4.9.13] 2019-12-10</h4>\n<ul>\n<li>Tweak &#8211; Allow Event Aggregator date refinements for Eventbrite source.</li>\n<li>Language &#8211; 29 new strings added, 201 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.12] 2019-11-20</h4>\n<ul>\n<li>Fix &#8211; Blocks Editor date time saving correctly for WordPress 5.3 compatibility. [137421]</li>\n<li>Tweak &#8211; Add the <code>tribe_get_query_var</code> function [137262]</li>\n<li>Tweak &#8211; Add <code>tribe_get_the_content()</code> and <code>tribe_the_content()</code> for PHP 7.2 compatibility with WordPress 5.2</li>\n<li>Language &#8211; 21 new strings added, 162 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.11] 2019-11-12</h4>\n<ul>\n<li>Feature &#8211; Opt-in to the newly redesigned views</li>\n<li>Fix &#8211; Fixed issue where DD/MM/YYYY style dates were not supported during Event Aggregator imports [117691]</li>\n<li>Fix &#8211; Resolved issue where non YYYY-MM-DD datepicker formats resulted in unpredictable behavior while navigating views [116086, 126472, 117909]</li>\n<li>Fix &#8211; Fixed date issue where the event date was defaulting to current date when editing an event with the block editor [132735]</li>\n<li>Tweak &#8211; Added additional datepicker formats for simpler selection [116086, 126472, 117909]</li>\n<li>Tweak &#8211; Updated the Repository implementation to handle more complex <code>orderby</code> constructs [133303]</li>\n<li>Tweak &#8211; Added the <code>Tribe__Date_Utils::get_week_start_end</code> method [133303]</li>\n<li>Tweak &#8211; added the <code>tribe_events_suppress_query_filters</code> filter to allow suppressing <code>Tribe__Events__Query</code> filters [134827]</li>\n<li>Language &#8211; 5 new strings added, 23 updated, 2 fuzzied, and 13 obsoleted</li>\n</ul>\n<h4>[4.9.10] 2019-10-16</h4>\n<ul>\n<li>Tweak &#8211; added the <code>tribe_sanitize_deep</code> function to sanitize and validate input values [134427]</li>\n<li>Tweak &#8211; use the <code>tribe_sanitize_deep</code> function to sanitize the values returned by the <code>tribe_get_request_var</code> function [134427]</li>\n<li>Tweak &#8211; Rename «Datepicker Date Format» to «Compact Date Format» [134526]</li>\n<li>Tweak &#8211; Adjust Promoter loading order to increase compatibility with plugins that use authentication early in the process [134862]</li>\n<li>Tweak &#8211; Add support for Authentication using a Header when using Promoter [133922]</li>\n<li>Language &#8211; 2 new strings added, 25 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.9.9] 2019-09-25</h4>\n<ul>\n<li>Fix &#8211; Set the start date with the current day for the «All» events page for recurring events. Thanks Andy, leapness and others for flagging this! [130350]</li>\n<li>Tweak &#8211; Updated Freemius integration code [133148]</li>\n<li>Tweak &#8211; Conform iCalendar feed to specifications by not putting quotes around the timezone ID. This fixes some custom parsers [133626]</li>\n<li>Language &#8211; 0 new strings added, 16 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.9.8] 2019-09-04</h4>\n<ul>\n<li>Tweak &#8211; Added the Monolog logging library as alternative logging backend [120785]</li>\n<li>Tweak &#8211; Hook Monolog logger on <code>tribe_log</code> action [120785]</li>\n<li>Tweak &#8211; Add redirection of <code>tribe( \'logger\' )-&gt;log()</code> calls to the Monolog logger using the <code>tribe_log_use_action_logger</code> filter [120785]</li>\n<li>Fix &#8211; Conform iCalendar feed to specifications by not putting quotes around the timezone. This fixes Outlook compatibility [131791]</li>\n<li>Fix &#8211; Additional fields with multiple values using pipes <code>|</code> as separators are working properly on importing again. [131510]</li>\n<li>Fix &#8211; Fix default view redirection loop on mobile devices. Thanks Ricardo, cittaslow and others for flagging this! [125567]</li>\n<li>Fix &#8211; Handling of featured image setting during Event Aggregator CSV imports [127132]</li>\n<li>Language &#8211; 1 new strings added, 10 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.7] 2019-08-19</h4>\n<ul>\n<li>Tweak &#8211; Update Lodash version on Block editor to prevent any possibility of a security issue with the package. From v4.17.11 to v4.17.15 [131421]</li>\n<li>Tweak &#8211; Add filter &#8216;tribe_events_js_config&#8217; to allow filtering the contents of the Javascript configuration [132567]</li>\n<li>Tweak &#8211; Updates to the shortcode Javascript code to allow disabling the URL manipulation behavior [132567]</li>\n<li>Fix &#8211; Prevent mascot image to get blown up out of proportions to a larger size on buggy CSS loading. [131910]</li>\n<li>Language &#8211; 3 new strings added, 191 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.6] 2019-08-07</h4>\n<ul>\n<li>Tweak &#8211; Update Event Aggregator to include compatibility with new Meetup API requirements &#8211; <a href=\"https://evnt.is/1afb\" rel=\"nofollow ugc\">See more</a> [125635]</li>\n<li>Language &#8211; 5 new strings added, 120 updated, 5 fuzzied, and 10 obsoleted</li>\n</ul>\n<h4>[4.9.5] 2019-07-25</h4>\n<ul>\n<li>Tweak &#8211; Update redirection URLs for Freemius actions [130281]</li>\n<li>Fix &#8211; Location filtering for Context class moved out of construct, resolving lots of navigation problems across The Events Calendar [130754]</li>\n<li>Fix &#8211; Featured event AJAX and browser navigation working as expected for all use cases. [127272]</li>\n<li>Fix &#8211; Shortcode properly handling featured param on AJAX requests. [114002]</li>\n<li>Fix &#8211; Remove removing wpautop for gutenberg blocks to fix spacing when content comes from classic editor. [122801]</li>\n<li>Language &#8211; 4 new strings added, 16 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.4] 2019-07-03</h4>\n<ul>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_insert_args</code> the arguments in prior to inserting the event and meta fields. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_update_args</code> the arguments prior the update of an event and meta fields. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_prevent_update</code> to disable the update for an event via the Tribe API [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_archive_get_args</code> to filter the arguments used to get the events on the archive page via REST API. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_validator_is_event_id</code> to define if is a valid event_id [129517]</li>\n<li>Tweak &#8211; Add action <code>tribe_rest_before_event_data</code> executed before the Event data is pulled before deliver the Event via REST API. [129517]</li>\n<li>Tweak &#8211; Add <code>Tribe__Events__Query::last_found_events()</code> to access the last results via the <code>Query</code> object [129517]</li>\n<li>Tweak &#8211; Wrap <code>register_rest_route</code> calls with <code>tribe_register_rest_route</code> to enable filtering on REST registration</li>\n<li>Tweak &#8211; Add filter <code>tribe_ical_feed_vtimezone</code> to filter the <code>VTIMEZONE</code> group [89999]</li>\n<li>Tweak &#8211; Include proper documentation of why the plugin has been deactivated and a knowledgebase article about how to downgrade [129726]</li>\n<li>Tweak &#8211; When trying to update The Events Calendar with an incompatible version of an Addon that is expired, it will stop the upgrade [129727]</li>\n<li>Tweak &#8211; Add filter <code>tribe_is_classic_editor_plugin_active</code> to change the output if the classic editor is active or not [121267]</li>\n<li>Tweak &#8211; Create a new key if <code>AUTH_KEY</code> is not defined or is empty and add a new filter <code>tribe_promoter_secret_key</code> to filter the result [127183]</li>\n<li>Tweak &#8211; Divide the <code>tribe-common.js</code> file to prevent that file from being bloated with external dependencies. [129526]</li>\n<li>Tweak &#8211; Make sure <code>UTC-0</code> is converted back to <code>UTC</code> instead of <code>UTC-01</code> [129240]</li>\n<li>Tweak &#8211; Add new function <code>tribe_register_rest_route</code> Wrapper around <code>register_rest_route</code> to filter the arguments when a new REST endpoint is created [129517]</li>\n<li>Tweak &#8211; Add new method <code>Tribe__Cost_Utils::parse_separators</code> to infer decimal and thousands separators from a value that might have been formatted in a local different from the current one [98061]</li>\n<li>Fix &#8211; Save of event meta data when Classic editor plugin and gutenberg blocks for events are enabled [121267]</li>\n<li>Fix &#8211; Moved The Events Calendar specific code from common Context class into The Events Calendar [129241]</li>\n<li>Fix &#8211; Fixed issue where multiday events were not returning correct end date in block editor [128033]</li>\n<li>Fix &#8211; Resolved issue where deactivation feedback was not hooked properly [128341]</li>\n<li>Fix &#8211; Added escaping to the event website URL target attribute [129565]</li>\n<li>Fix &#8211; Fix Timezone definitions for <code>*.ics</code> file on events [89999]</li>\n<li>Fix &#8211; Resolved an issue where non-English decimal and thousands event cost separators could lead to wrong cost values in REST API responses [98061]</li>\n<li>Fix &#8211; Prevent Clipboard Javascript from loading all over the place on <code>/wp-admin/</code> [129526]</li>\n<li>Fix &#8211; PHP 5.6 compatibility for <code>trait Cache_User</code> by using WP action <code>shutdown</code> instead of <code>__destruct</code> on our <code>WP_Rewrite</code> [129860]</li>\n<li>Language &#8211; 14 new strings added, 222 updated, 1 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[4.9.3.2] 2019-06-20</h4>\n<ul>\n<li>Fix &#8211; Prevent issue where older versions of the tribe-common libraries could be bootstrapped [129478]</li>\n<li>Fix &#8211; Add Promoter PCSS file so that the proper CSS will be generated on package build [129584]</li>\n</ul>\n<h4>[4.9.3.1] 2019-06-07</h4>\n<ul>\n<li>Fix &#8211; Remove caching of rewrite base slugs which make third-party, Photo and Week work as expected [129035]</li>\n<li>Tweak &#8211; Adjust newsletter signup submission destination [129034]</li>\n</ul>\n<h4>[4.9.3] 2019-06-06</h4>\n<ul>\n<li>Fix &#8211; Fixed issue where the previous events link was not present on initial page load of the List View [127477]</li>\n<li>Language &#8211; 10 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.2] 2019-05-16</h4>\n<ul>\n<li>Tweak &#8211; In the Event Repository class: filter the event creation meta before checking it for coherency</li>\n<li>Tweak &#8211; Reduced file size by removing .po files and directing anyone creating or editing local translations to translate.wordpress.org</li>\n<li>Fix &#8211; Fix event bar issue where it was required to pick the date in order to search events via keyword or location [126158]</li>\n<li>Fix &#8211; Make back-compatibility handling more robust when dealing with classes non-existing in the older plugin versions [127173]</li>\n</ul>\n<h4>[4.9.1.1] 2019-05-06</h4>\n<ul>\n<li>Fix &#8211; Prevent Composer autoloader from throwing Fatal due to nonexistent <code>setClassMapAuthoritative()</code> method [126590]</li>\n</ul>\n<h4>[4.9.1] 2019-05-02</h4>\n<ul>\n<li>Fix &#8211; Prevent recurring events all page to throw 404 when events are in the past [126790]</li>\n<li>Fix &#8211; Backwards compatibility for <code>eventDisplay</code> usage around <code>list</code> and <code>day</code> only showing upcoming events [126686]</li>\n<li>Fix &#8211; List events Widget will display events until their end date has passed [126837]</li>\n<li>Tweak &#8211; Add values for the JSON-LD object to avoid Google console errors. Fields added: <code>offers.availability</code>, <code>offers.category</code>, <code>offers.priceCurrency</code>, <code>offers.validFrom</code> and <code>performer</code> [120193]</li>\n<li>Tweak &#8211; Add <code>tribe_events_cost_unformatted</code> filter to allow WPML support for WooCommerce Multilingual</li>\n<li>Language &#8211; 0 new strings added, 168 updated, 0 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[4.9.0.3] 2019-04-26</h4>\n<ul>\n<li>Fix &#8211; Prevent Composer autoloader from throwing Fatal due to nonexistent <code>setClassMapAuthoritative()</code> method [126590]</li>\n</ul>\n<h4>[4.9.0.2] 2019-04-25</h4>\n<ul>\n<li>Fix &#8211; Avoid fatals due to Query method not been present by bumping version of Event Tickets required to 4.10.4.2</li>\n</ul>\n<h4>[4.9.0.1] 2019-04-25</h4>\n<ul>\n<li>Fix &#8211; Modifications to <code>tribe_get_events()</code> to resolve problems introduced by latest release <code>4.9.0</code></li>\n<li>Fix &#8211; Backwards compatibility for <code>\'eventDisplay\' =&gt; \'upcoming\'</code> on <code>tribe_get_events()</code>. Thanks @softwebteam, @mrwweb and @karks88 [126124]</li>\n<li>Fix &#8211; Single navigation to next and previous events using the Object Relational Mapping classes [126144]</li>\n<li>Fix &#8211; Events displayed correctly on all views, using End date instead of Start Date. Making sure events that are not over still show on upcoming [126259]</li>\n</ul>\n<h4>[4.9.0] 2019-04-17</h4>\n<ul>\n<li>Feature &#8211; Refactor the Database Connection to start using an Object Relational Mapping tool for a better tested codebase</li>\n<li>Feature &#8211; Add the <code>tribe_events()</code> function as entry-point to the Events ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add the <code>tribe_venues()</code> function as entry-point to the Venues ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add the <code>tribe_organizers()</code> function as entry-point to the Organizers ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add additional caching to The Events Calendar REST API archives and the Post Repository event/venue/organizer responses [117159]</li>\n<li>Feature &#8211; Include Freemius integration on to allow opt-in information collection for 10% of new users</li>\n<li>Tweak &#8211; Setting the site of Timezones will trigger queries using UTC to equalize event dates on Views</li>\n<li>Tweak &#8211; Add filter to allow deactivating Freemius <code>tribe_events_integrations_should_load_freemius</code></li>\n<li>Tweak &#8211; Include a way for third-party to handle Known Range rebuilding of events <code>tribe_events_rebuild_known_range</code></li>\n<li>Tweak &#8211; All new granular handling for UTC and Timezone saving on the Classic editor</li>\n<li>Tweak &#8211; Add support for the <code>tribe_suppress_query_filters</code> query variable to prevent the plugin&#8217;s own query filters from applying [116356, 115579]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_has_next_args</code> and <code>tribe_events_has_previous_args</code> filters to allow filtering the arguments that check if next/previous archive pages or events are available [123950]</li>\n<li>Fix &#8211; Include second param for the <code>the_title</code> for Events, Venue and Organizer Rest API endpoints amd prevent warnings. Props to Alex [123317]</li>\n<li>Language &#8211; 5 new strings added, 167 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.8.2] 2019-03-04</h4>\n<ul>\n<li>Fix &#8211; Resolve console warnings around React key usage for Blocks Editor [121198]</li>\n<li>Fix &#8211; Improve our <code>tribe_paged</code> URL parameter sanitization, preventing themes from printing the variable and causing XSS security issues [123616]</li>\n<li>Fix &#8211; Change ordering for Eventbrite Tickets on Event Aggregator, Ascending order by date is now the default [121979]</li>\n<li>Tweak &#8211; Day light savings notice will now reset 4 times per year when using any UTC Timezone [123221]</li>\n<li>Tweak &#8211; Start date for Event Aggregator is now required on Eventbrite Tickets [121979]</li>\n<li>Language &#8211; 3 new strings added, 172 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.8.1] 2019-02-14</h4>\n<ul>\n<li>Feature &#8211; Introduced new «(do not override)» default post status for Eventbrite imports in Event Aggregator. This preserves events&#8217; original statuses from Eventbrite.com upon import (e.g., «draft» events will not be automatically set to «publish» upon import) [112346]</li>\n<li>Fix &#8211; Make sure the setting for «Default mobile view» is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]</li>\n<li>Fix &#8211; Apply block closer to price block [120108]</li>\n<li>Tweak &#8211; Added new filter <code>tribe_aggregator_new_event_post_status_before_import</code> to allow for custom handling of an event&#8217;s post status before EA an import is completed [112648]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_admin_js_ajax_url_data</code></li>\n<li>Tweak &#8211; Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar</li>\n<li>Language &#8211; 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.8] 2019-02-04</h4>\n<ul>\n<li>Feature &#8211; Introduced new «(do not override)» default post status for Eventbrite imports in Event Aggregator. This preserves events&#8217; original statuses from Eventbrite.com upon import (e.g., «draft» events will not be automatically set to «publish» upon import) [112346]</li>\n<li>Fix &#8211; Make sure the setting for «Default mobile view» is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]</li>\n<li>Fix &#8211; Apply block closer to price block [120108]</li>\n<li>Tweak &#8211; Added new filter <code>tribe_aggregator_new_event_post_status_before_import</code> to allow for custom handling of an event&#8217;s post status before EA an import is completed [112648]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_admin_js_ajax_url_data</code></li>\n<li>Tweak &#8211; Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar</li>\n<li>Language &#8211; 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.8.0.1] 2019-02-07</h4>\n<ul>\n<li>Fix &#8211; Modify extension dependency checking with new system to determine if it can load [122368]</li>\n<li>Tweak &#8211; Prevent most extensions from loading if Event Tickets is on an older version to prevent conflicts [122368]</li>\n</ul>\n<h4>[4.8] 2019-02-05</h4>\n<ul>\n<li>Feature &#8211; Add check and enforce PHP 5.6 as the minimum version [116282]</li>\n<li>Feature &#8211; Add system to check plugin versions to inform you to update and prevent site breaking errors [116841]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_not_php_version_names</code></li>\n<li>Deprecated &#8211; Constants MIN_ET_VERSION and MIN_COMMON_VERSION in Tribe__Events__Main, use $min_et_version property and no replacement for MIN_COMMON_VERSION</li>\n<li>Deprecated &#8211; The <code>is_delayed_activation()</code>, <code>maybe_delay_activation_if_outdated_common()</code>, and <code>checkAddOnCompatibility()</code> method has been deprecated in <code>Tribe__Events__Main</code> in favor of new Dependency Checking System</li>\n<li>Language &#8211; 7 new strings added, 139 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.7.4] 2019-01-21</h4>\n<ul>\n<li>Fix &#8211; Display the tags block delimiter in the editor [119393]</li>\n<li>Fix &#8211; Fixed a number of small layout bugs with the new Twenty Nineteen core theme [119689]</li>\n<li>Fix &#8211; Save the «Event Options» when using the block editor [120168]</li>\n<li>Fix &#8211; Filter correctly when in Classic Editor page [120137]</li>\n<li>Fix &#8211; Give the ability to switch back from all day events in date time block [120266]</li>\n<li>Fix &#8211; Properly align the search or create results [120460]</li>\n<li>Fix &#8211; iCal export content for events created with the block editor [118679]</li>\n<li>Fix &#8211; Moved the «Remove venue» button for a better user experience when removing venues from an event [120267]</li>\n<li>Fix &#8211; Date/time block conflicts when clicking to open the block options [119413]</li>\n<li>Fix &#8211; Layout bugs with the new Twenty Nineteen core theme [119689]</li>\n<li>Fix &#8211; Include UTC dates meta on the event creation from the block editor [120399]</li>\n<li>Tweak &#8211; Ensure we don&#8217;t re-apply <code>wpautop()</code> to content that has had it removed [120562]</li>\n<li>Tweak &#8211; Added <code>tribe_events_admin_js_ajax_url_data</code> filter to make filtering the JS vars of TEC&#8217;s admin JS easier [116973]</li>\n<li>Tweak &#8211; Adjusted content in the admin welcome page that users are brought to upon newly activating The Events Calendar [117795]</li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-tags</code></li>\n<li>Language &#8211; 3 new strings added, 21 updated, 1 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[4.7.3] 2018-12-19</h4>\n<ul>\n<li>Tweak &#8211; Tweak the registration of the Event, Venue, and Organizer post types so they use some new post type labels introduced in WordPress 5.0 like <code>item_updated</code>, <code>item_scheduled</code>, etc. [119451]</li>\n<li>Fix &#8211; Password protected events breaking the month view. Thanks to Lindsay, Simon and others for flagging this out! [117385]</li>\n<li>Fix &#8211; Add proper capitalization for Event Price for Blocks Editor [119140]</li>\n<li>Fix &#8211; Make sure Datetime Format for Datepickers are respected on the Blocks Editor [117428]</li>\n<li>Fix &#8211; Correct text domain and remove old <code>events-gutenberg</code> [118656]</li>\n<li>Fix &#8211; Properly display recurrence description on Blocks Editor view [119354]</li>\n<li>Fix &#8211; Point support links to the correct places [117795]</li>\n<li>Language &#8211; 27 new strings added, 106 updated, 0 fuzzied, and 13 obsoleted</li>\n</ul>\n<h4>[4.7.2] 2018-12-13</h4>\n<ul>\n<li>Feature &#8211; Added new action <code>tribe_events_before_event_template_data_date_display</code> and <code>tribe_events_after_event_template_data_date_display</code></li>\n<li>Tweak &#8211; Corrected font on time picker components in Event Date Time block [116907]</li>\n<li>Tweak &#8211; Adjusted padding on the Event Date Time block [118697]</li>\n<li>Tweak &#8211; Set default start time to 8:00am and default end time to 5:00pm in Event Date Time block [118112]</li>\n<li>Fix &#8211; Corrected an issue where feature detection of async-process support would fire too many requests [118876]</li>\n<li>Fix &#8211; Removed tribe_events_template_data()&#8217;s dependency on Events Calendar PRO, which could lead to a fatal error under some conditions [119263]</li>\n<li>Fix &#8211; Made the Event Date Time block respect the timezone settings [118682]</li>\n<li>Fix &#8211; Removed Price block dashboard gap [118683]</li>\n<li>Fix &#8211; Made sure all block editor code for Meta saving is PHP 5.2 compatible</li>\n<li>Fix &#8211; Prevented <code>undefined</code> from been displayed at the Event Date Time separator fields [119337]</li>\n<li>Fix &#8211; Solved 500 error when trying to update an event [118058]s</li>\n</ul>\n<h4>[4.7.1] 2018-12-05</h4>\n<ul>\n<li>Feature &#8211; Added additional caching to TEC REST API archives and the Post Repository event/venue/organizer responses [117159]</li>\n<li>Feature &#8211; Added new <code>tribe_events_set_month_view_events_from_cache</code> action to make it easier to listen for when Month View events are retrieved from the Month View cache [116124]</li>\n<li>Fix &#8211; Importing CSV files with whitespace at the beginning of the rows won&#8217;t remove headers and skip columns on Preview [117236]</li>\n<li>Fix &#8211; Prevent JavaScript error in Month View when the Date filter is removed from the Tribe Bar (thank you to @tyrann0us on GitHub for submitting this fix!) [116995]</li>\n<li>Fix &#8211; Facilitate automated updates for Events Calendar PRO even if it&#8217;s requirements have not been met</li>\n</ul>\n<h4>[4.7.0.1] 2018-11-30</h4>\n<ul>\n<li>Fix &#8211; Update common library to maximize compatibility with earlier PHP versions (our thanks to @megabit81 for highlighting this problem) [119073]</li>\n<li>Fix &#8211; Update common library to ensure better compatibility with addons running inside multisite networks [119044]</li>\n<li>Language &#8211; 0 new strings added, 141 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.7] 2018-11-29</h4>\n<ul>\n<li>Feature &#8211; added new setting to activate the block editor on events for users running the WordPress 5.0 beta.</li>\n<li>Feature &#8211; added an Event Date Time block to add and display the event date and time</li>\n<li>Feature &#8211; added an Event Price block to add and display the event price and optional event description</li>\n<li>Feature &#8211; added an Event Organizer block to add and display an organizer on an event single</li>\n<li>Feature &#8211; added an Event Venue block to add and display the event venue information including optional link or map</li>\n<li>Feature &#8211; added an Event Website block to add and display an external website link as a button with custom label</li>\n<li>Feature &#8211; added an Event Sharing block to display event export options and allow for more customization</li>\n<li>Feature &#8211; added an Event Details Classic block to maintain a combined content display as in the classic editor</li>\n<li>Feature &#8211; added a Featured Image block to display an event’s featured image in the editor content</li>\n<li>Feature &#8211; added a Tags block to display an event’s tags in the editor content</li>\n<li>Feature &#8211; added an Event Categories block to display an event’s categories in the editor content</li>\n<li>Feature &#8211; added a new Events Blocks section to the block inserter</li>\n<li>Tweak &#8211; Added filters: <code>tribe_blocks_editor_update_classic_content_params</code>, <code>tribe_blocks_editor_update_classic_content</code>, <code>tribe_events_editor_default_classic_template</code>, <code>tribe_events_editor_default_template</code>, <code>tribe_events_google_maps_api</code>, <code>tribe_events_editor_assets_should_enqueue_frontend</code>, <code>tribe_events_single_map_zoom_level</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code>, <code>tribe_events_event_block_datetime_use_yearless_format</code>, <code>tribe_get_event_website_link_target</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_blocks_editor_flag_post_classic_editor</code>, <code>tribe_events_editor_register_blocks</code>, <code>tribe_events_single_event_meta_primary_section_start</code>, <code>tribe_events_single_event_meta_primary_section_end</code>, <code>tribe_events_single_event_meta_secondary_section_start</code>, <code>tribe_events_single_event_meta_secondary_section_end</code>, <code>tribe_events_single_meta_details_section_start</code>, <code>tribe_events_single_meta_details_section_end</code>, <code>tribe_events_single_meta_map_section_start</code>, <code>tribe_events_single_meta_map_section_end</code>, <code>tribe_events_single_meta_organizer_section_start</code>, <code>tribe_events_single_meta_organizer_section_end</code>, <code>tribe_events_single_meta_venue_section_start</code>, <code>tribe_events_single_meta_venue_section_end</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/event-category</code>, <code>blocks/event-datetime</code>, <code>blocks/event-links</code>, <code>blocks/event-organizer</code>, <code>blocks/event-price</code>, <code>blocks/event-tags</code>, <code>blocks/event-venue</code>, <code>blocks/event-website</code>, <code>blocks/featured-image</code>, <code>blocks/parts/details</code>, <code>blocks/parts/map</code>, <code>blocks/parts/organizer</code>, <code>blocks/parts/venue</code>, <code>silence</code>, <code>single-event-blocks</code>, <code>single-event</code>, <code>single-event/back-link</code>, <code>single-event/comments</code>, <code>single-event/content</code>, <code>single-event/footer</code>, <code>single-event/notices</code>, <code>single-event/title</code></li>\n<li>Language &#8211; 11 new strings added, 0 updated, 0 fuzzied, and 30 obsoleted</li>\n</ul>\n<h4>[4.6.26.1] 2018-11-21</h4>\n<ul>\n<li>Fix &#8211; Resolved a compatibility issue with WordPress version 4.7.11 and earlier (our thanks to @placer69 and @earthnutvt for flagging this) [118627]</li>\n</ul>\n<h4>[4.6.26] 2018-11-13</h4>\n<ul>\n<li>Fix &#8211; Fixed the setting-up of strings in the Tribe Bar datepicker to ensure they&#8217;re translatable into languages other than English [115286]</li>\n<li>Tweak &#8211; Improved the legibility of text in Featured Events that are in the Event List widget [116702]</li>\n<li>Tweak &#8211; Clarified a number of maps-related settings strings [114865]</li>\n</ul>\n<h4>[4.6.25] 2018-10-22</h4>\n<ul>\n<li>Fix &#8211; List only enabled views on the «Default View» option. Thanks to wescole, John Meuse and others for reporting! [114807]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Fix &#8211; Fixed event navigation when the mini calendar widget was on the event page. Props to Matt and wescole for flagging this [114359]</li>\n<li>Fix &#8211; Ensure columns without headers are handled in CSV imports [114199]</li>\n<li>Tweak &#8211; Added notice for the Events Gutenberg extension and eBook download [115543]</li>\n<li>Tweak &#8211; Avoid unnecessary HTTP calls in the Settings screens [114013]</li>\n<li>Tweak &#8211; Show only applicable refinements for the Eventbrite source types in Event Aggregator imports [107009]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_resolve_geolocation</code> filter to allow for disabling of Geocoding using the EA service [114171]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_clean_unsupported</code> filter to specify whether unsupported origin records should be removed or not</li>\n</ul>\n<h4>[4.6.24.1] 2018-10-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_setting_origins</code> filter to the origins available for default import settings [115704]</li>\n</ul>\n<h4>[4.6.24] 2018-10-03</h4>\n<ul>\n<li>Fix &#8211; Prevent broken and low-resolution Google Maps if user has not provided a Google Maps API key of their own by providing our own fallback API key [114442]</li>\n<li>Fix &#8211; Only load widget assets when widget is active on the page [113141]</li>\n<li>Fix &#8211; Ensure that venue, organizer, and meta information doesn&#8217;t show on password-protected events [102643]</li>\n<li>Fix &#8211; Correct the Google Maps API link in the Settings help text to point to the correct API page [112322]</li>\n<li>Fix &#8211; Restores the event categories and tags creation summary in CSV imports [105888]</li>\n<li>Fix &#8211; Updated the Events Gutenberg extension install check to show only when the extension is not active [114577]</li>\n<li>Fix &#8211; Stop potential fatal errors from debug logging when running EA import actions from command line [114555]</li>\n<li>Fix &#8211; Fixed a bug where it was often not possible to un-check the «Enable JSON-LD» option in the Events List Widget (thanks to @myrunningresource and @craigwilcox for reporting this!) [113541]</li>\n<li>Fix &#8211; Ensure that the <code>tribe-events-bar-should-show</code> filter functions as aspected; if <code>__return_false</code> is passed, the Tribe Bar will be totally hidden (thanks @debranettles for reporting this!) [112260]</li>\n<li>Fix &#8211; Added checks to prevent JS Type Error in mobile view. Thanks szenenight, agrilife and others for flagging this! [113524]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Fix &#8211; handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added new filters for customizing the fallback Google Maps embeds: <code>tribe_is_using_basic_gmaps_api</code>, <code>tribe_get_basic_gmap_embed_url</code>, and <code>tribe_get_basic_gmap_embed_url_args</code> [114442]</li>\n<li>Tweak &#8211; Fixed the handling of the global $post variable in some Month View templates to make it easier for themers to customize those templates [113283]</li>\n<li>Tweak &#8211; Ensure linked posts are listed alphabetically in metabox dropdowns, as they are in all other admin locations [108120]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_service_post_import_args</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_validate_meta_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_keyword_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_location_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_venue_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_organizer_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_status_third_party</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_import_form</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added <code>$origin_show_map_options</code> parameter to the <code>tribe_aggregator_fields</code> filter to allow new EA origins to make use of them [114652]</li>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n</ul>\n<h4>[4.6.23] 2018-09-12</h4>\n<ul>\n<li>Fix &#8211; Fixed the «Full Styles» mobile view. Thanks Matthew, Laura and others for flagging this! [112301]</li>\n<li>Fix &#8211; Modify resource url function to work in mu-plugin directory, thanks to Doug for reporting it  [86104]</li>\n<li>Fix &#8211; Remove references to and settings for Facebook importing in Event Aggregator [112432]</li>\n<li>Fix &#8211; Ensure Event Aggregator allows for importing events from Eventbrite sites other than eventbrite.com, including but not limited to eventbrite.ca, .co.uk, and .co.nz [107821]</li>\n<li>Fix &#8211; Allow venue location fields to be intentionally empty on Venue Singular REST API calls [108834]</li>\n<li>Tweak &#8211; Add the WordPress Custom Fields Metabox show|hide settings from the Events Calendar Pro [109815]</li>\n<li>Tweak &#8211; Allow changing Event Aggregator import process system between the asynchronous and the cron-based one; previously only available as a filter [113418, 113475]</li>\n<li>Tweak &#8211; Allow stopping and clearing asynchronous queue processes from the admin UI [113418, 113475]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Aggregator__Record__Facebook</code></li>\n</ul>\n<h4>[4.6.22.1] 2018-08-27</h4>\n<ul>\n<li>Fix &#8211; Allow user to choose venues not created by them. Props to @integrity, @nomadadmin, and many others for reporting this! [113147]</li>\n</ul>\n<h4>[4.6.22] 2018-08-22</h4>\n<ul>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; The «Import events but preserve local changes to event fields» Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Multiple fixes regarding linked post types (e.g. Organizers and custom post types) &#8211; props to @natureslens and others for reporting these [105116]:\n<ul>\n<li>Now correctly saves in their drag-and-drop order</li>\n<li>Deprecated the functions added in version 4.6.13 that previously attempted to fix ordering logic but was not done in a backwards-compatible way: <code>get_order_meta_key()</code> and <code>tribe_sanitize_organizers()</code></li>\n<li>We no longer rely on a separate postmeta value dedicated to ordering linked posts (e.g. <code>_EventOrganizerID_Order</code>), and you may want to remove all such values from your database after re-saving any events that have linked posts and their ordering is important</li>\n<li><code>tribe_get_linked_posts_by_post_type()</code> now works as expected, no longer returning zero results in error, nor returning all of the post type&#8217;s posts if there are none linked. The <code>tribe_events_return_all_linked_posts_if_none</code> filter was added, as it is necessary for this fix.</li>\n<li>Editing an existing event no longer loses the linked posts just because they were not part of the submission. Example of the bug in prior versions: If organizers are editable in the wp-admin event edit screen but not on the Community Events «event edit» form (via template override or other custom code), all pre-existing organizers were removed in error.</li>\n</ul>\n</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Only show admin notice when it is a top-level page with the event slug, thanks to MikeNGarrett for the code fix! [111186]</li>\n<li>Fix &#8211; Change template_redirect to an action for some legacy view redirects, thanks barryceelen! [110463]</li>\n<li>Fix &#8211; Correctly import and set Organizers for iCal and ICS files Event Aggregator imports [96059]</li>\n<li>Fix &#8211; Retain category title in month view and month view shortcode, thanks corthoover for the first report [108258]</li>\n<li>Fix &#8211; The «Import events but preserve local changes to event fields» Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; Fix the classic header option not working. Thanks @hanemac, David Luyendyk and others for flagging this! [111672]</li>\n<li>Tweak &#8211; Namespace javascript debug function to prevent conflicts causing a function found, thanks to Tom-Mulvey for the fix [110462]</li>\n<li>Tweak &#8211; Add venue name to address string for iCal and gCal export, thanks for the coding from sylviavanos [110464]</li>\n<li>Tweak &#8211;  Drop the order from the query WPML linked query as it is set later in the method, thanks to dgwatkins for the PR [110459]</li>\n<li>Tweak &#8211; Display JS debug messages only if setting is set or through the <code>tribe_events_js_debug</code> filter. Thanks to Rob, @aand and others for flagging this! [82781]</li>\n</ul>\n<h4>[4.6.21] 2018-08-01</h4>\n<ul>\n<li>Add &#8211; Make global $post obj available to tribe_events_get_the_excerpt() with setup_postdata($post) [108043]</li>\n<li>Add &#8211; Added WPML metadata improvements for Organizers and Venue. Thanks to David Garcia Watkins and the entire WPML team for their contribution [106798]</li>\n<li>Fix &#8211; Ensure no console errors are being displayed if there&#8217;s no Google Maps API key present. Thanks Greg for flagging this [95312]</li>\n<li>Fix &#8211; Fixed an issue where saving Event Aggregator scheduled imports with an empty preview would generate PHP notices [110311]</li>\n<li>Fix &#8211; Escape each closing html element in month view tooltip to prevent PHP parser from exposing html, thanks to Karen for a solution [64834]</li>\n<li>Fix &#8211; Sending empty &#8216;categories&#8217; and &#8216;tags&#8217; for the REST API event endpoints when inserting and updating events [109627]</li>\n<li>Fix &#8211; Prevent selection of past dates when setting up Scheduled Other URL Imports in Event Aggregator [111227]</li>\n<li>Tweak &#8211; Manage plugin assets via <code>tribe_assets()</code> [40267]</li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Asset in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Menu in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Ui in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Calendar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Dayview in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_List in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Bootstrap_Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Calendar_Script in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Chosen in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dialog in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dynamic in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ecp_Plugins in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Default in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Full in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Skeleton in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Factory in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Placeholder in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Resize in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__PHP_Date_Formatter in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Settings in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Smoothness in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Events_Bar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Select2 in favor of using <code>tribe_asset</code></li>\n</ul>\n<h4>[4.6.20.1] 2018-07-10</h4>\n<ul>\n<li>Fix &#8211; Fix an issue where Event Aggregator imports might get blocked at 1% progress [110258]</li>\n<li>Fix &#8211; Fix the error displayed when navigating the month view via shortcode. Thanks Lam, @ltcalendar, Disk and others for flagging this! [109589]</li>\n</ul>\n<h4>[4.6.20] 2018-07-09</h4>\n<ul>\n<li>Feature &#8211; Add featured event column support for CLI imports [108027]</li>\n<li>Fix &#8211; Display the exact search term in the «no results» notice on the events page [106991]</li>\n<li>Fix &#8211; Allow venue and organizer fields to be intentionally empty on Event Singular REST API calls [109482]</li>\n<li>Fix &#8211; Added basic checks to prevent saving obviously-invalid event meta values, such as sending <code>EventStartMinute</code> of <code>60</code> (since it should be 0-59) to <code>tribe_create_event()</code>. This prevents falling back to «zero» values (e.g. Unix Epoch) when another value was intended. Thanks to @compton-bob for flagging this via our Help Desk. [109722]</li>\n<li>Fix &#8211; Add Privacy Policy guide for The Events Calendar [108454]</li>\n<li>Tweak &#8211; Added event ID parameter to <code>tribe_events_event_classes</code> filter to make it more useful [64807]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_finalized</code> action to allow developers to act before Event Aggregator imports start [109938]</li>\n</ul>\n<h4>[4.6.19] 2018-06-20</h4>\n<ul>\n<li>Feature &#8211; CSV importer now supports a featured event column [72376]</li>\n<li>Add &#8211; Add Eventbrite Icon to Third Party Accounts on the help page [105388]</li>\n<li>Add &#8211; Accessibility repair: new title-bar template for loop views included above the filter bar and content containing the page title in a <code>h1</code> tag.</li>\n<li>Fix &#8211; Accessibility repair: adjust main content container element from <code>div</code> to <code>main</code>.</li>\n<li>Fix &#8211; More robust handling of errors and exceptions during Event Aggregator imports [107929]</li>\n<li>Fix &#8211; Ensure that the «Export Events» button is properly displayed in month view when paginating. Thanks to @linpleva, Steven, Will and others for flagging this! [104751]</li>\n<li>Fix &#8211; Month view pagination for datepicker formats: YYYY.MM.DD, MM.DD.YYYY, and DD.MM.YYYY. Thanks @netzwerk, @wdburgdorf, @oliverwick and others for notifying us! [105443]</li>\n<li>Fix &#8211; Resolved customizer inconsistencies with month/week views and full styles [69758]</li>\n<li>Fix &#8211; Check the Events Aggregator license each time the page is accessed [67864]</li>\n<li>Fix &#8211; Improve Event Import message responses from Event Aggregator for certain cases where «Unknown service message» would be returned [107606]</li>\n<li>Fix &#8211; Make the date picker respect the «Start of the week» Setting. Thanks to @websource, @dsb and others for flagging this! [76320]</li>\n<li>Fix &#8211; Correct the «View All» link when using the events month view and plain permalinks. props to Kay and Robert for notifying us [72544]</li>\n<li>Fix &#8211; Keep filter bar date when changing from month to list view, with all datepicker formats. Thanks to Caio for reporting this! [83018]</li>\n<li>Fix &#8211; Correct the pagination in list view when a keyword is being searched. Thanks to @versi, @akr and Mary for reporting this! [94613]</li>\n<li>Fix &#8211; Split linked posts (Organizers and Venues) by ownership, for all users [71349]</li>\n<li>Fix &#8211; The connected status for Eventbrite under Third Party Accounts on the Help page [106868]</li>\n<li>Fix &#8211; Fixed two PHP 5.2 errors on the Events &gt; Help page [108338]</li>\n<li>Fix &#8211; Display the correct Import Settings when Eventbrite Tickets is enabled [106947]</li>\n<li>Tweak &#8211; Modify the default values for the CSV settings if there&#8217;s no EA license [94426]</li>\n<li>Tweak &#8211; Added classes to meta output in Single Event meta templates to facilitate customization [62704]</li>\n<li>Tweak &#8211; Add the <code>tribe_aggregator_async_insert_event</code> filter to allow overriding the Event Aggregator asynchronous event insertion [107929]</li>\n<li>Tweak &#8211; Add the <code>\'tribe_aggregator_async_import_event_task</code> filter to allow overriding the Event Aggregator asynchronous import task [107929]</li>\n<li>Tweak &#8211; Added venue google map link to events in Day view [91610]</li>\n<li>Tweak &#8211; Renamed the Time zone mode option «Use the local time zones for each event» to «Use manual timezones for each event» (thanks @hikeitbaby for the suggestion) [67148]</li>\n<li>Tweak &#8211; Accessibility repair: heading hierarchy improvements throughout.</li>\n<li>Tweak &#8211; Accessibility repair: make sure all elements have unique <code>id</code> attributes.</li>\n<li>Tweak &#8211; Accessibility repair: remove redundant tab stops on feature image links.</li>\n<li>Tweak &#8211; Accessibility repair: filter bar view selector adjustments.</li>\n<li>Tweak &#8211; Accessibility repair: provide meaningful aria labels for filter bar inputs.</li>\n<li>Tweak &#8211; Accessibility repair: hide Google Map embeds from screen readers.</li>\n<li>Tweak &#8211; Enable only url imports for Eventbrite when that plugin is not active [107415]</li>\n<li>Tweak &#8211; The EB 4.5 migration process to better detect events for migration and insure all fields are migrated [106623]</li>\n<li>Tweak &#8211; Add <code>tribe_events_month_has_events_filtered</code> function and filter to see if there are events on a certain month, with filters (categories, search) [67607]</li>\n<li>Language &#8211; 68 new strings added, 406 updated, 3 fuzzied, and 37 obsoleted</li>\n</ul>\n<h4>[4.6.18] 2018-06-04</h4>\n<ul>\n<li>Add &#8211; Eventbrite to Event Aggregator import origins [61172]</li>\n<li>Add &#8211; Priority attribute to Import Setting fields to be able to customize order of fields [61173]</li>\n<li>Add &#8211; Default category and change authority for Eventbrite Imports [61173]</li>\n<li>Add &#8211; Ability to schedule Eventbrite imports through Event Aggregator [35454]</li>\n<li>Add &#8211; Preview for Eventbrite events in the import screen ordered from farthest future event to closest [70130]</li>\n<li>Add &#8211; Import Eventbrite events using the Other URL import origin [81825]</li>\n<li>Add &#8211; Ability to preview and import multiple Eventbrite events using the Organizer URL [94284]</li>\n<li>Add &#8211; Import from Eventbrite Location Search URL, i.e. https://www.eventbrite.com/d/or&#8211;portland/events/ [94588]</li>\n<li>Tweak &#8211; Move Eventbrite settings from Legacy Import to Settings Import Tab [94388]</li>\n<li>Tweak &#8211; Add Eventbrite imports to the Import History Tab [81826]</li>\n<li>Tweak &#8211; Remove Legacy Imports UI [81829]</li>\n</ul>\n<h4>[4.6.17] 2018-05-29</h4>\n<ul>\n<li>Tweak &#8211; Add tribe_redirected parameter to enable a visitor to select another view after default mobile redirect, thanks to Marcella for notifying us [102743]</li>\n<li>Fix &#8211; Hide any errors generated by servers that don&#8217;t support <code>set_time_limit()</code> (props to @jsww for flagging this!) [64183]</li>\n<li>Fix &#8211; Add a warning when the site Timezone is set to UTC [105217]</li>\n<li>Fix &#8211; An issue with organizers and venues not being attached to events on Eventbrite import  [106869]</li>\n<li>Language &#8211; 4 new strings added, 170 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.16] 2018-05-16</h4>\n<ul>\n<li>Tweak &#8211; Replaced the Aggregator queue processing system to run independently of WP Cron (not for CSV) [105650]</li>\n<li>Fix &#8211; Prevents notices for Events Community when handling State and Province fields [106415]</li>\n</ul>\n<h4>[4.6.15] 2018-05-09</h4>\n<ul>\n<li>Feature &#8211; Added wp-cli command to import events from a source with Event Aggregator. See <code>wp event-aggregator import-from --help</code> to know more [104426]</li>\n<li>Feature &#8211; Added wp-cli command to run scheduled imports with Event Aggregator. See <code>wp event-aggregator run-import --help</code> to know more [104426]</li>\n<li>Fix &#8211; Ensure that organizers can be deleted when an event has multiple organizers [103715]</li>\n<li>Fix &#8211; Fixed a bug where the <code>[tribe_events]</code> Month View pagination would fail when no Tribe Bar was visible and plain permalinks were being used [95720]</li>\n<li>Fix &#8211; Prevent <code>url_to_postid</code> from running when on the main events page to avoid query conflicts [94328]</li>\n<li>Fix &#8211; Prevent 404s and malformed URLs that would sometimes arise when navigating to a past-events view from the «All»-events view on a single recurring event [43925]</li>\n<li>Fix &#8211; Make the <code>[tribe_events]</code> shortcode&#8217;s output scroll to top when using the List View to match the non-shortcode List View  [81509]</li>\n<li>Fix &#8211; Ensure that default venue and address values are used throughout various venue-creation forms [63915]</li>\n<li>Tweak &#8211; Honor the return types for <code>tribe_has_next_event</code> and <code>tribe_has_previous_event</code> when the global query is null</li>\n<li>Idiomas &#8211; añadidas 28 nuevas cadeans, actualizadas 290, 29 controvertidas y 7 obsoletas</li>\n</ul>\n<h4>[4.6.14.1] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Fixed fatal error that would sometimes arise when The Events Calendar was set to display on the front page</li>\n</ul>\n<h4>[4.6.14] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Updated the «front page» logic to store the value in the DB instead of «mocking» the view via JS [100832]</li>\n<li>Fix &#8211; Fixed the generation of PHP warnings on retrieval of posts if the «Include events in main blog loop» option is checked (thanks to Colin Carmichael for reporting this problem) [97667]</li>\n<li>Fix &#8211; Made the <code>tribe-ea-record</code> custom post type (used to store Event Aggregator record information) private [99106]</li>\n<li>Fix &#8211; Expanded the size of the time zone input in the admin to allow for better visibility for long names [100363]</li>\n<li>Fix &#8211; If the main events page is set to be the site&#8217;s front page, ensure it shows as «selected» in the Customizer&#8217;s front page option [100832]</li>\n<li>Fix &#8211; Fixed an issue where failed Event Aggregator scheduled imports would re-attempt the import too soon [102489]</li>\n<li>Fix &#8211; Ensure the Tribe Bar displays all the available ranges of dates and times [100646]</li>\n<li>Fix &#8211; Hid the filters in the Tribe Bar if a unique view is enabled [75114]</li>\n<li>Fix &#8211; Fixed some imported-event handling so that events with no time and that aren&#8217;t all-day events do not display on the front-end [93979]</li>\n<li>Fix &#8211; Changed the HTTP status codes of empty event, venue, organizer, category, and tag archives from 404 to 200 and return empty arrays to stick with WP REST API standard [102283]</li>\n<li>Fix &#8211; Better «guessing» on column mapping during the import of CSV file (thanks to April in our Help Desk for flagging this problem!) [96162]</li>\n<li>Fix &#8211; Add new <code>tribe_events_linked_post_type_meta_key</code> filter, required to be set for each custom linked post type, to output custom linked post types in their drag-and-drop order (thanks @natureslens for highlighting the issue) [100733]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_find_matching_organizer</code> and <code>tribe_aggregator_find_matching_venue</code> filters in Events Aggregator to allow the definition of custom Venue and Organizer match criteria [97292]</li>\n<li>Tweak &#8211; Display the retry time for a failed Event Aggregator scheduled import in the Scheduled tab [102489]</li>\n<li>Tweak &#8211; Add new filter, <code>tribe_events_import_event_duplicate_matches</code>, to determine if an event is part of the duplicates matches [77956]</li>\n<li>Tweak &#8211; Ensure «secondary» maps, e.g. in the sidebar, have the same full-width behavior as «main» maps [74052]</li>\n<li>Tweak &#8211; Restore some missing header navigation elements [99742]</li>\n<li>Tweak &#8211; Add notice if an import is missing required columns [67886]</li>\n<li>Tweak &#8211; Save time zone and time zone abbreviation fields (if provided) even if date was not changed when saving event through API [102705]</li>\n</ul>\n<h4>[4.6.13] 2018-03-28</h4>\n<ul>\n<li>Feature &#8211; Added facilities allowing users to trash or permanently delete expired events [98826]</li>\n<li>Fix &#8211; Corrected the behavior of the previous/next event links rendered on single event pages (props to @jeremyfelt for fixing this) [101757]</li>\n<li>Arreglado &#8211; Guardas el orden de los organizadores como se muestra en la administración (gracias a Jobinfo y otros por el aviso) [79126]</li>\n<li>Tweak &#8211; Added Gutenberg compatibility for the Gutenberg Extension plugin</li>\n<li>Tweak &#8211; Added new filter <code>tribe_tickets_venue_action_links_edit_url</code> to modify the venue edit link for the sales and attendee reports [93923]</li>\n<li>Tweak &#8211; Altered day view to start at 00:00:00 and not 00:00:01 [99641]</li>\n</ul>\n<h4>[4.6.12] 2018-03-08</h4>\n<ul>\n<li>Fix &#8211; Resolved an oversight resulting in notice-level errors when the <code>tribe_event_is_on_date()</code> function was called incorrectly (props to @sharewisdom for pointing this out) [99117]</li>\n<li>Fix &#8211; Resolved errors within the admin environment when the «ticketed» view of events is generated [99266]</li>\n<li>Fix &#8211; Improved compatibility with WordPress SEO in relation to the default mobile events view [68716]</li>\n<li>Fix &#8211; Resolved Javascript errors in month view which were triggered under some conditions by the presence of password-protected events [99089]</li>\n<li>Fix &#8211; Improved logic responsible for identifying which events are expired (in the past) by using timezone-aware comparisons [91168]</li>\n<li>Fix &#8211; Corrected the export of upcoming events from single organizer pages (added to support changes in Events Calendar PRO) [70727]</li>\n<li>Tweak &#8211; Added safety checks around our use of the global $wp_query object (thanks @archetypalsxe for highlighting this issue!) [100199]</li>\n<li>Tweak &#8211; Renamed &#8216;Use Javascript to control date filtering&#8217; option to &#8216;Enable live refresh&#8217; and improved the associated helper text [98022]</li>\n<li>Tweak &#8211; Added caching to reduce the number of HTTP requests being made in relation to Event Aggregator within the admin environment [99486]</li>\n<li>Tweak &#8211; Improved performance by reducing the number of queries that run in single event pages (in relation to <code>tribe_get_prev_event_link()</code> and <code>tribe_get_next_event_link()</code> specifically) [94587]</li>\n<li>Tweak &#8211; Added pagination to single organizer and venue pages [97772]</li>\n<li>Tweak &#8211; Improved compatibility with the Twenty Seventeen theme (ensuring the calendar is full-width if set to be the site&#8217;s homepage) [97977]</li>\n<li>Language &#8211; 3 new strings added, 161 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.11.1] 2018-02-16</h4>\n<ul>\n<li>Fix &#8211; The render of the venue and organizer templates (thanks to Antonio and others for reporting this in our forums) [99550]</li>\n<li>Fix &#8211; Make sure events on calendar are not affected by DST changes [99537]</li>\n</ul>\n<h4>[4.6.11] 2018-02-14</h4>\n<ul>\n<li>Fix &#8211; Ensure parity of CSS styles between the default Month View and the embedded Month Views generated by Events Calendar PRO&#8217;s [tribe_events] shortcode (thanks @copoloff for reporting this bug!) [92329]</li>\n<li>Fix &#8211; If <code>tribe_ical_feed_calname</code>  is empty the property <code>X-WR-CALNAME</code> is not added to the .ics file [46620]</li>\n<li>Fix &#8211; Stopped modifications of the main query if is in a single post to allow custom variables don&#8217;t affect the page loading when using shortcode (our thanks to Joseph Reckley and others for highlighting this problem) [91787]</li>\n<li>Tweak &#8211; Fixed a handful of small CSS bugs in the mobile views of the Twenty Sixteen, Twenty Fifteen, and Twenty Fourteen themes [95693]</li>\n<li>Tweak &#8211; Added new hooks (<code>tribe_events_ical_before</code>, <code>tribe_events_ical_events_list_args</code> and <code>tribe_events_ical_events_list_query</code>) to allow further customization of the iCal feed [86227]</li>\n<li>Tweak &#8211; Added safeguards to reduce conflicts when lodash and underscore are used on the same site [92205]</li>\n<li>Language &#8211; 0 new strings added, 41 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.10.1] 2018-01-26</h4>\n<ul>\n<li>Fix &#8211; Make sure rewrite rule for <code>/events</code> is not hardcoded and is based on dynamic option field (thanks to @earnjam and others for flagging this problem) [98463]</li>\n</ul>\n<h4>[4.6.10] 2018-01-23</h4>\n<ul>\n<li>Fix &#8211; Allow The Events Calendar REST API to be disabled using the <code>tribe_events_rest_api_enabled</code> filter [97209]</li>\n<li>Fix &#8211; Remove the errant <code>div.tribe-events-single-section</code> on the single event view when there is no venue [97615]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Fix &#8211; Use <code>featured_color_scheme_custom</code> if present as mechanism to overwrite the default color scheme for highlight color [96821]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Tweak &#8211; Trigger an event <code>map-created.tribe</code> when a map is created to allow flexibility on customization [91984]</li>\n<li>Tweak &#8211; Add a link to the knowledge base about &#8216;Setting Up Your Google Maps API Key&#8217; [89761]</li>\n<li>Tweak &#8211; Add <code>the_title</code> filter to events called by <code>tribe_events_template_data</code> [38237]</li>\n<li>Tweak &#8211; Made the «events» and «event» slugs translatable by WPML and other multilingual plugins [95026]</li>\n<li>Tweak &#8211; Introduced the <code>tribe_events_query_force_local_tz</code> filter to allow for forcing non-UTC event start and end times in Tribe__Events__Query [92948]</li>\n<li>Tweak &#8211; Prevent empty or otherwise-invalid values for various date-format options in the Display settings [94725]</li>\n<li>Tweak &#8211; Brought day number headers in the Month View into compliance with WCAG 2.0 accessibility standards when using the «Tribe Events» stylesheet [68411]</li>\n<li>Tweak &#8211; Improved the alignment of the event cost on the single-event view (props to @canberraclimbersassociation for reporting this bug) [97208]</li>\n<li>Tweak &#8211; Added some more context to the labeling of the «Number of events per page» option (thanks to Todd H. for highlighting this label) [73659]</li>\n<li>Tweak &#8211; Improve performance on Event Admin List Count by removing JOIN and use cached results [63567]</li>\n<li>Tweak &#8211; Made the «/page/» component of some views&#8217; URL string translatable [40976]</li>\n<li>Tweak &#8211; Button «Merge Duplicates» is always visible from now on [75208]</li>\n<li>Tweak &#8211; Allow queries to explicitly include or exclude events that are nominally hidden from event listings [91254]</li>\n</ul>\n<h4>[4.6.9] 2018-01-10</h4>\n<ul>\n<li>Feature &#8211; Add new utility functions tribe_is_events_home and tribe_is_events_front_page similar to native WP is_home and is_front_page [42195]</li>\n<li>Fix &#8211; Avoid issues when importing multiple organizers that specify images [96354]</li>\n<li>Fix &#8211; Make sure latitude and longitude information from iCal feeds is used if available [96363]</li>\n<li>Fix &#8211; Fixed an issue that prevented EA from importing images attached to Facebook events [96393]</li>\n<li>Fix &#8211; Remove the duplicate filter call that was running twice for <code>tribe_rest_venue_data</code> [96090]</li>\n<li>Tweak &#8211; Added new <code>tribe_aggregator_import_event_image</code>, <code>tribe_aggregator_import_venue_image</code> and <code>tribe_aggregator_import_organizer_image</code> filter so that users can control whether, during EA imports, images should be attached to post or not [96393]</li>\n<li>Tweak &#8211; Made it possible to translate the iCal feed&#8217;s description field (props @gafderks) [96677]</li>\n<li>Tweak &#8211; Improved escaping of map IDs (props LucaPipolo) [96772]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up organizers by slug instead of ID at the path <code>organizers/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>organizers/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up venues by slug instead of ID at the path <code>venues/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>venues/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for organizer and venue data [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an organizer or event [96088]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_venue_save</code> [96069]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_save</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_venue_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_organizer_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Old <code>tribe_rest_venue_data</code> filter was passing the venue and the event two the second parameter because of the duplication. Now it has the second parameter as $venue, third parameter as $event if event ID was provided [96090]</li>\n<li>Language &#8211; 5 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.8] 2017-12-18</h4>\n<ul>\n<li>Fix &#8211; Preserve filter bar checkbox selections when changing views [66749]</li>\n<li>Fix &#8211; Fix radio filters so they are only included as values when switching views when checked [72954]</li>\n<li>Fix &#8211; Ensure the correct properties are set for list widget queries, to avoid problems when running alongside Events Calendar PRO (props @KZeni) [94105]</li>\n<li>Fix &#8211; Fixed some layout issues with the «Buy Now» button and stock labels on mobile list views [81115]</li>\n<li>Fix &#8211; Fixed issue where left- or right-aligned images at the bottom of event descriptions would overlap event meta on single-event pages [71134]</li>\n<li>Fix &#8211; Fixed issue where Google Maps Link would display in some situations even when there is no address information for which to generate a link. [94909]</li>\n<li>Fix &#8211; Corrected reference to a Select2 asset (our thanks to @pyxis630 for flagging this problem and props to @andrasguseo for the fix) [95348]</li>\n<li>Fix &#8211; Ensure that when start and end dates are passed to the REST API, all events within the date range are correctly retrieved (thanks @braffenberg and others for highlighting this issue!) [90005]</li>\n<li>Tweak &#8211; Added Google Maps API key to all Google Maps URLs when the key is available, allowing maps to load more reliably on some hosting environments (props to @sfdfortnight, @thor, and many others for reporting this!) [62910]</li>\n<li>Tweak &#8211; Adjusted CSS to improve the display of venue URLs/phone numbers (especially when Events Calendar PRO is also active) (our thanks to Mathew on the forums for flagging this issue) [69127]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up events by slug instead of ID at the path <code>events/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>events/{ID}</code> [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for event data [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an event [92825]</li>\n<li>Tweak &#8211; Added new <code>tribe_events_rest_use_inclusive_start_end_dates</code> filter so that users can make the REST API return events from a more literal date range [90005]</li>\n<li>Language &#8211; 3 new strings added, 68 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.7] 2017-12-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where EA imports might not correctly create venues for iCalendar imports (thanks @starweb and others for highlighting this issue) [94323]</li>\n<li>Fix &#8211; Fixed an issue where Month View wouldn&#8217;t render correctly in X Theme with the «Events template» option set to «Default Page Template» [92554]</li>\n<li>Fix &#8211; Fixed a WPML incompatibility issue where language could be switched to the wrong one (thanks @dgwatkins) [94732]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_x_theme_force_full_content()</code> filter to let users disable X Theme compatibility code [92554]</li>\n<li>Language &#8211; 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.6] 2017-11-21</h4>\n<ul>\n<li>Feature &#8211; Added Template class which adds a few layers of filtering to any template file included</li>\n<li>Tweak &#8211; Added clear warnings and errors to prevent and limit the import of iCalendar sources missing required fields [93600]</li>\n<li>Tweak &#8211; Included <code>tribe_callback_return</code> for static returns for Hooks</li>\n<li>Tweak &#8211; Improved Aggregator notices including error data on the responses [87326]</li>\n<li>Language &#8211; 4 new strings added, 79 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.5] 2017-11-16</h4>\n<ul>\n<li>Fix &#8211; Improved legacy URL redirect logic to prevent unwanted redirects (our thanks to wesleyanhq and Adam Schwartz for highlighting this issue) [86942]</li>\n<li>Fix &#8211; Modified tribe_get_template_part() to remove potential for multiple templates to be rendered in a single call [46630]</li>\n<li>Fix &#8211; Fixed an issue where Event Aggregator scheduled imports might remain stuck in pending status [90501, 92614, 91754]</li>\n<li>Fix &#8211; Removed code which was automatically populating various address fields with default values when creating a new venue from within the event editor [44732]</li>\n<li>Fix &#8211; Resolved some issues with the «Show Map» and «Show Map Link» options in CSV files not being reliably respected on import (props @joappf and many others for highlighting this issue) [82784]</li>\n<li>Fix &#8211; Added opportunities to override edit linked post links [89015]</li>\n<li>Fix &#8211; Fixed a bug where only some parts of event featured images were clickable in List Views (thanks @mattemkadia for highlighting this issue) [81392]</li>\n<li>Fix &#8211; Fixed the broken &#8216;Learn more&#8217; URL received after an unsuccessful «Other URL» import preview [92890]</li>\n<li>Fix &#8211; Fixed issue in list view navigation with backwards previous/next classes (thanks @secondtoughest) [36230]</li>\n<li>Fix &#8211; Fixed an issue where venues and organizers would not be correctly assigned to events in CSV imports with import statuses other than «Publish» [79680]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on demand imports [79079]</li>\n<li>Tweak &#8211; Allow for non-Latin characters to be used as the Events URL slug and the Single Event URL slug (thanks @daviddweb for originally reporting this) [61880]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on demand imports [79079]</li>\n<li>Tweak &#8211; Fixed some layout issues that would emerge with «Events URL Slug» option when «Plain» permalinks were enabled [92314]</li>\n<li>Tweak &#8211; Tweaked some language in Event Aggregator&#8217;s metabox on individual edit-event screens to reduce confusion around the impact of the Update Authority on CSV imports [77957]</li>\n<li>Tweak &#8211; Fix PHP 7.1 compatibility with Event Aggregator (props @BJP NEALE) [90002]</li>\n<li>Tweak &#8211; Added new filter: <code>tribe_events_force_filtered_ical_link</code>. This makes the «Export Events» URL more easily modifiable (thanks to @tdudley07 for highlighting this issue) [43908]</li>\n<li>Tweak &#8211; Made the «End of Day Cutoff» option better accommodate 24-hour and other time formats (thanks @festivalgeneral for bringing this issue to our attention!) [78621]</li>\n<li>Tweak &#8211; Made the options presented by the timezone selector filterable (via the newly added <code>tribe_events_timezone_choice</code> hook &#8211; our thanks to National University&#8217;s Marketing Department for this idea) [92909]</li>\n<li>Tweak &#8211; Improved integration with Twenty Seventeen &#8211; main events page now uses full height header when set to front page (thanks @uncovery for pointing this out) [89767]</li>\n<li>Tweak &#8211; Ensured REST API taxonomy endpoints are only registered in WordPress versions 4.7 and higher (thanks @dnaber-de for reporting this) [93227]</li>\n<li>Language &#8211; 1 new strings added, 132 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.6.4] 2017-11-09</h4>\n<ul>\n<li>Tweak &#8211; Timepicker is now part of Tribe Common, it was removed from The Events Calendar</li>\n<li>Tweak &#8211; Required changes to make the plugin compatible with version 4.6 of Event Tickets</li>\n<li>Language &#8211; 10 new strings added, 167 updated, 0 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.3] 2017-11-02</h4>\n<ul>\n<li>Fix &#8211; Prevent JS error when adding a Pro widget in the WP Customizer screen [72127]</li>\n<li>Fix &#8211; Fixed issue where the value of an event&#8217;s «Show Google Maps Link» option would not properly affect the displaying of the link on List View (props: @etechnologie) [75547]</li>\n<li>Fix &#8211; Added some more specification to our jquery-ui-datepicker CSS to limit conflicts with other plugins and themes [90577]</li>\n<li>Fix &#8211; Improve shortcode pagination/view change url so it is reusable (props: @der.chef and others) [70021]</li>\n<li>Fix &#8211; Ensure the <code>tribe_json_ld_{type}_object</code> filter is available to make modifications of event, venue and organizer JSON LD data possible (thanks to Mathew for flagging this problem) [89801]</li>\n<li>Fix &#8211; Improved JSON LD output for events by outputting the correct UTC offset where required (our thanks to Nina and many others for flagging this issue) [78233]</li>\n<li>Tweak &#8211; Fixed some display issues for the event schedule details (props @mia-caro)</li>\n<li>Tweak &#8211; Improved the clarity of and amount of context for some linked post labels to make translation of those labels a little easier and more nuanced (props @hnacc and others) [88589]</li>\n<li>Tweak &#8211; Changed the order in which the list view «next events» link is assembled for better translatability (with thanks to @alelouya for highlighting this problem) [72097]</li>\n<li>Tweak &#8211; Adjusted linked posts selector HTML to improve compatibility with Batcache [92049]</li>\n<li>Tweak &#8211; Improved datepicker handling so an end date on or later than the start date can always be selected [89825]</li>\n<li>Language &#8211; 0 new strings added, 7 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.2] 2017-10-18</h4>\n<ul>\n<li>Fix &#8211; Restored functionality to the «currency position» options in Events Settings, and in the per-event cost settings (props @schola and many others!) [89918]</li>\n<li>Fix &#8211; Fixed issue in Month view with multi-month events not appearing on subsequent months (thanks @shinno.kei &amp; @schittly for helping isolate this) [89747]</li>\n<li>Fix &#8211; Made some changes to prevent Month View caching from breaking WPML support when in Month View (props: @mpike and many others!) [82286]</li>\n<li>Fix &#8211; Fixed start/end times being displayed in incorrect timezone in structured data (thanks @mtncreative &amp; @esosa) [42125]</li>\n<li>Fix &#8211; Fixed an issue that would cause a 404 error if the selected default view was not enabled (thanks @pruneau) [45612]</li>\n<li>Fix &#8211; Improved translatability by adding missing textdomains for a number of strings (props @pedro-mendonca) [91071]</li>\n<li>Fix &#8211; Removed unneeded escaping to ensure the organizer link displays as expected (pros @f4w-pwharton) [91074]</li>\n<li>Tweak &#8211; Improvements to the readme.txt file surrounding plugin requirements (thanks @ramiy) [90285]</li>\n<li>Tweak &#8211; Improve site identification in multisite installations using Event Aggregator to avoid throttling issues [90489]</li>\n<li>Tweak &#8211; Avoid notice level errors when a non-existent category archive is requested (our thanks to Charles Simmons for highlighting this) [90697]</li>\n<li>Tweak &#8211; Added a new filter <code>tribe_events_ical_single_event_links</code> to make customizing the iCal and gCal export links on single-event views easier [90705]</li>\n</ul>\n<h4>[4.6.1] 2017-10-04</h4>\n<ul>\n<li>Fix &#8211; Fixed «Next Events» and «Previous Events» navigation links in list views, which would sometimes make a category-filtered list view lose its category filter as a user navigated through pages of future or past events (props @forumhelpdesk and @atomicdust for reporting this!) [72013]</li>\n<li>Fix &#8211; Fixed some layout issues with the Tribe Bar datepicker that would arise when using a Twenty Sixteen or Twenty Fifteen child them (thanks to @stefanrueegger for reporting this) [46471]</li>\n<li>Fix &#8211; Prevented modification of event titles within the loop when using TRIBE_MODIFY_GLOBAL_TITLE [89273]</li>\n<li>Fix &#8211; Fixed issue when exporting all-day multi-day events via iCal where the end date was one day early (Thank you @fairmont for reporting this!) [87775]</li>\n<li>Fix &#8211; Fixed issues with the jQuery Timepicker vendor script conflicting with other plugins&#8217; similar scripts (props: @hcny et al.) [74644]</li>\n<li>Fix &#8211; Fixed an issue that would prevent Event Aggregator scheduled imports from running [88395]</li>\n<li>Fix &#8211; Fixed the «Start Time» and «End Time» timepicker fields in the event-creation screen to make it impossible to have an end date/time that comes before the start date/time [72686]</li>\n<li>Tweak &#8211; Remove unnecessary parameters from some remove_action calls in the plugin (thanks to @JPry on GitHub for submitting this fix!) [88867]</li>\n<li>Tweak &#8211; Adjusted the EA cron start time so that it never gets created in the past [88965]</li>\n<li>Tweak &#8211; Improved options format in the Event Aggregator settings [88970]</li>\n<li>Tweak &#8211; Added a filter to CSV importer for altering the delimiter, escaping, and enclosing characters [70570]</li>\n<li>Tweak &#8211; Adjusted the <code>tribe_update_venue()</code> template tag so it no longer creates some unnecessary meta fields involving post_title, post_content, etc. (thanks @oheinrich for bringing this to our attention) [66968]</li>\n<li>Tweak &#8211; Improved the performance of The Events Calendar REST API tweaking some queries [89743]</li>\n<li>Tweak &#8211; Add support for a <code>found_posts</code> argument in <code>tribe_get_events</code>, <code>tribe_get_venues</code> and <code>tribe_get_organizers</code> functions to return the number of posts found matching the current query arguments [89743]</li>\n<li>Deprecated &#8211; Deprecated the <code>tribe-events-bar-date-search-default-value</code> filter; use <code>tribe_events_bar_date_search_default_value</code> instead [67482]</li>\n<li>Language &#8211; Improvements to aid translatability of text throughout plugin (props: @ramiy) [88982]</li>\n<li>Language &#8211; 7 new strings added, 180 updated, 4 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[4.6] 2017-09-25</h4>\n<ul>\n<li>Feature &#8211; Added full CRUD REST support for Events, Organizers, Venues, Event Categories, and Tags</li>\n<li>Tweak &#8211; Updated Bootstrap Datepicker to v1.7.0</li>\n<li>Tweak &#8211; Added latitude/longitude to REST responses when available on venues</li>\n<li>Tweak &#8211; Added JSON-LD data to REST responses when available</li>\n<li>Tweak &#8211; Replaced deprecated first parameter of <code>tribe_get_organizers()</code> with a parameter that, when specified with a truthy value, returns only organizers with upcoming events attached to them</li>\n<li>Tweak &#8211; Added linked post filters: <code>tribe_{$this-&gt;post_type}_has_events_excluded_post_stati</code>, <code>tribe_events_tribe_organizer_create</code>, <code>tribe_events_tribe_organizer_update</code>, <code>tribe_event_venue_duplicate_post_fields</code>, <code>tribe_event_organizer_duplicate_custom_fields</code></li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_created</code></li>\n<li>Tweak &#8211; Added REST filters: <code>tribe_rest_organizer_default_only_with_upcoming</code>, <code>tribe_rest_venue_default_only_with_upcoming</code>, <code>tribe_events_rest_term_allow_delete</code></li>\n<li>Tweak &#8211; Added duplicate-detection filters: <code>tribe_duplicate_post_strategies</code>, <code>tribe_duplicate_post_strategy</code>, <code>tribe_duplicate_post_{$strategy}_strategy</code></li>\n<li>Language &#8211; 152 new strings added, 217 updated, 6 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.13] 2017-09-20</h4>\n<ul>\n<li>Feature &#8211; Add link to the featured image in the Events List widget. New filter introduced to control this: <code>tribe_events_list_widget_featured_image_link</code> (props to @cabadaj007 for the feature request) [84807]</li>\n<li>Feature &#8211; Remove &#8216;France, Metropolitan&#8217; option from country list to prevent issues with Google Maps API (thanks @varesanodotfr for pointing this out) [78023]</li>\n<li>Feature &#8211; Ignored Events will restore previous status instead of setting to &#8216;publish&#8217; [82213]</li>\n<li>Fix &#8211; Patched jQuery Resize vendor library to avoid JavaScript conflicts (props to @britner for the original report) [71994]</li>\n<li>Fix &#8211; Fixed a typo in the Event List widget options [71081]</li>\n<li>Fix &#8211; Addressed some PHP notices that would sometimes emerge in tag-filtered post lists in the wp-admin (thanks to @wfsec28 and others in the forums for reporting this!) [45274]</li>\n<li>Fix &#8211; When «Full Styles» or «Tribe Events Styles» are used, prevent duplicate featured images from showing up in the Twenty Seventeen theme (props to @want2what and others in the forums for reporting this) [80955]</li>\n<li>Fix &#8211; Fixed the issue that would prevent the start date and date range parameters from being taken into account when using &#8216;Other URL&#8217; source in Event Aggregator</li>\n<li>Fix &#8211; Aggregator will no longer update comments while inactive [78890]</li>\n<li>Fix &#8211; Avoid issues when REST API archive request parameters are not in the original order (thanks @Nslaver for reporting this and providing a fix) [88748]</li>\n<li>Tweak &#8211; Aggregator prevents duplicated records with the same params from being created [68833]</li>\n<li>Tweak &#8211; Aggregator will now allow for some minor shifts in schedule execution time to help distribute requests to EA Service [86628]</li>\n<li>Tweak &#8211; Improve text in the Event Aggregator settings [77452]</li>\n<li>Tweak &#8211; Add actions before and after posts are inserted or updated by Event Aggregator to allow custom functions to kick in (<code>tribe_aggregator_before_insert_posts</code> and <code>tribe_aggregator_after_insert_posts</code>) [87530]</li>\n<li>Tweak &#8211; Allow users to import CSV with numerically-named categories by using a flag (currently <code>%n</code>) (thanks @Shamsi for reporting) [78340]</li>\n<li>Tweak &#8211; Allow date range and events count limits to be set on each type of import (except for &#8216;Other URL&#8217;) in Event Aggregator [79975]</li>\n</ul>\n<h4>[4.5.12.3] 2017-09-19</h4>\n<ul>\n<li>Fix &#8211; Display events on Month View correctly for WordPress version 4.8.2 and up (props @realcrozetva for reporting this) [88952]</li>\n</ul>\n<h4>[4.5.12.2] 2017-09-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where manually running Scheduled Imports would always result in a failed import [87321]</li>\n</ul>\n<h4>[4.5.12.1] 2017-09-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where events imported via Event Aggregator from an iCal-like source would be duplicated in place of being updated [87654]</li>\n</ul>\n<h4>[4.5.12] 2017-09-06</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where, with certain date formats chosen in the Events display settings, the «Next Month» link navigation wasn&#8217;t working (props to @tttammi and others for reporting this issue!) [86937]</li>\n<li>Fix &#8211; Fixed a typo in REST API Swagger documentation that mentioned «organizer» when it should have stated «venue».</li>\n<li>Fix &#8211; Fixed issues with Event Aggregator queueing system where events might be duplicated or incorrectly updated [79975]</li>\n<li>Fix &#8211; Prevent notice when the Aggregator Record title is an array [82149]</li>\n<li>Fix &#8211; Allows Aggregator Google Map settings to extend the Global Setting by default (props to queerio for reporting this!) [67639]</li>\n<li>Fix &#8211; Prevent Warnings when throwing WordPress admin notices from Aggregator daily usage limit (props to cigarplanner for reporting this!) [83187]</li>\n<li>Fix &#8211; Resolved problem where Aggregator wouldn&#8217;t allow you to remove filtering terms for Records [76949]</li>\n<li>Fix &#8211; Allow any datepicker format to be used on Aggregator filtering Events (props to matthewseymour for reporting this!) [77819]</li>\n<li>Fix &#8211; Added check to see if log directory is readable before listing logs within it (thank you @rodrigochallengeday-org and @richmondmom for reporting this) [86091]</li>\n<li>Tweak &#8211; Datatables Head and Foot checkboxes will not select all items, only the current page [77395]</li>\n<li>Tweak &#8211; Included tooltip for Aggregator «Hide &amp; Ignore» button for events [67890]</li>\n<li>Tweak &#8211; Added all the Aggregator Origins to the Admin Bar [68693]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_get_state_options</code></li>\n<li>Tweak &#8211; Added template tags: <code>maybe_format_from_datepicker()</code></li>\n<li>Tweak &#8211; Added the <code>tribe_rest_single_event_data</code> filter to the single event REST API endpoint to allow filtering the returned data (thanks @mwender) [88748]</li>\n<li>Language &#8211; 2 new strings added, 90 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.11] 2017-08-24</h4>\n<ul>\n<li>Fix &#8211; Avoid Event Aggregator previews or scheduled imports being marked as failures [84259]</li>\n<li>Fix &#8211; Fixed start and end date limit parsing for events archive in the REST API code [78375]</li>\n<li>Fix &#8211; Fixed issue with <code>tribe_events_get_the_excerpt()</code> returning a read more link that sometimes pointed to the current page [70473]</li>\n<li>Fix &#8211; Fixed Post ID not being sent to the_title filter for Organizers and Venues (props Anna L.) [85206]</li>\n<li>Fix &#8211; Fixed issue where Month View tooltips would often go off-screen in some smaller viewport sizes [65136]</li>\n<li>Fix &#8211; Fixed an issue that would sometimes render Event Aggregator options invalid even with a valid license [78469]</li>\n<li>Fix &#8211; Fixed an issue where the mobile.php template file would often fail to include an event&#8217;s featured image [74291]</li>\n<li>Fix &#8211; Resolved issue where invalid linked post IDs prevent proper updates on linked posts (props to Mathew L. and a few others for highlighting this issue) [71802]</li>\n<li>Fix &#8211; Do not hijack the blog when the main events page is configured to appear on the site&#8217;s homepage (our thanks to Jason and others for flagging this problem) [72094]</li>\n<li>Fix &#8211; Remove extra trailing double-quotes at the end of the timepicker data-format attributes [85603]</li>\n<li>Fix &#8211; Fixed an issues where Event Aggregator scheduled imports could not run other than manually [81639]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the List View [72289]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the Day View [85429]</li>\n<li>Tweak &#8211; Modify certain event queries to widen the window of opportunity for query caching (props @garretjohnson) [84841]</li>\n<li>Tweak &#8211; Improve Event Aggregator message regarding Facebook token expiration [70376]</li>\n<li>Tweak &#8211; Support importing from URLs (Event Aggregator) where the protocol hasn&#8217;t been specified by defaulting to HTTP [76466]</li>\n<li>Tweak &#8211; Removed WP API adjustments [85996]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_aggregator_meta_source</code> to filter the Event Aggregator import source</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_linked_post_meta_values_{$current_linked_post_meta_key}</code> for filtering the array of values retrieved for a specific linked post meta field</li>\n<li>Tweak &#8211; Updated views: <code>src/views/day/single-event.php</code> and <code>src/views/list/single-event.php</code></li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.5</li>\n<li>Language &#8211; Improvements to various strings to improve ease of translation (props to @ramiy)</li>\n<li>Language &#8211; 5 new strings added, 56 updated, 1 fuzzied, and 3 obsoleted [the-events-calendar]</li>\n</ul>\n<h4>[4.5.10.1] 2017-08-16</h4>\n<ul>\n<li>Fix &#8211; Updates common library to resolve a range of issues preventing frontend assets from loading and breaking parts of our user interface [85017]</li>\n</ul>\n<h4>[4.5.10] 2017-08-09</h4>\n<ul>\n<li>Fix &#8211; Avoid duplicate events when importing from some iCal, Google Calendar and Facebook feeds in Event Aggregator (our thanks to Jason Sears, controlyours and many other users for highlighting these issues) [67038]</li>\n<li>Fix &#8211; Fixed bug that caused scheduled imports to get stuck in a perpetual state of failure when receiving error messages from the Event Aggregator service (our thanks to Antonio Jose and others for flagging this problem) [83767]</li>\n<li>Fix &#8211; Resolved issue where errors from the Event Aggregator service were not properly logging/visible on the History tab [83767]</li>\n<li>Tweak &#8211; Made linked post fields&#8217; auto-save features more stringently check for empty values to prevent the plugin from trying to «save» empty values (our thanks to Jean-Marie for highlighting this problem) [80282]</li>\n<li>Tweak &#8211; Moved the organizer e-mail address field label a bit to better accommodate Community Events [80426]</li>\n<li>Tweak &#8211; Added filter to tribe_get_display_end_date()&#8217;s return value [77730]</li>\n<li>Tweak &#8211; Avoid notice-level errors while processing queues within Event Aggregator (our thanks to David Sharpe and others for reporting this) [84020]</li>\n<li>Tweak &#8211; Improve compatibility and avoid Javascript errors when running alongside Twenty Seventeen [70853]</li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.4</li>\n<li>Language &#8211; 1 new strings added, 119 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.5.9] 2017-07-26</h4>\n<ul>\n<li>Fix &#8211; Send Aggregator callback URL with correct Scheme [83364]</li>\n<li>Fix &#8211; Scheduled Aggregator cron for inserting will re-enqueue to complete scheduled imports [83382]</li>\n<li>Fix &#8211; Avoid overwriting Venues and Organizers when importing FB events with similarly named Venues and Organizers [75370]</li>\n<li>Fix &#8211; Improve handling of large and/or slow Google Calendar and iCal feeds [79975]</li>\n<li>Tweak &#8211; Added period «.» separator to datepicker formats. [65282]</li>\n<li>Tweak &#8211; Added tribe_events_month_get_events_in_month filter to allow overriding of events used in month templates. [83317]</li>\n</ul>\n<h4>[4.5.8.1] 2017-07-21</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where failed EA Imports would hang for a long time before failing [83344]</li>\n</ul>\n<h4>[4.5.8] 2017-07-13</h4>\n<ul>\n<li>Fix &#8211; Remove permalink logic for recurring events (Events Calendar PRO will implement instead) [74153]</li>\n<li>Fix &#8211; Avoid type error when setting up one-time imports for Facebook URLs (our thanks to @J for flagging this!) [78664]</li>\n<li>Fix &#8211; Add a safety check in isOrganizer() function (our thanks to Kevin for flagging this!) [81645]</li>\n<li>Fix &#8211; Avoid EA Client hanging when no events are found while attempting an import from a Facebook source [82713]</li>\n<li>Fix &#8211; Improve compatibility of The Events Calendar when operating with WPML from within a subdirectory (props: @dgwatkins) [81998]</li>\n</ul>\n<h4>[4.5.7] 2017-06-28</h4>\n<ul>\n<li>Fix &#8211; Restore support for translated events category slugs when WPML is active [73478]</li>\n<li>Fix &#8211; Improve handling of shortcodes within event view excerpts (props: @awbauer) [81226]</li>\n<li>Fix &#8211; Improve compatibility with WPML in relation to event permalinks specifically (props: @dgwatkins) [81224]</li>\n<li>Fix &#8211; Improved handling of Venue fields that allows for better form validation in Community Events [76297]</li>\n<li>Tweak &#8211; Better detection and reporting of communication failures with the Event Aggregator server</li>\n<li>Tweak &#8211; Textual corrections (with thanks to @garrett-eclipse for highlighting many of these) [77196]</li>\n<li>Tweak &#8211; New filter added («tribe_events_linked_posts_dropdown_enable_creation») to facilitate more control over linked posts [80487]</li>\n<li>Tweak &#8211; Improve performance of theme compatibility code [71974]</li>\n<li>Tweak &#8211; Don&#8217;t show Event Aggregator system status in Help tab if there&#8217;s no Event Aggregator license in place [68506]</li>\n</ul>\n<h4>[4.5.6] 2017-06-22</h4>\n<ul>\n<li>Tweak &#8211; Improved how Cost field looks and it&#8217;s consistency across views [71092 &amp; 71094]</li>\n<li>Fix &#8211; Resolved issue where the Meta Chunker attempted to inappropriately chunk meta for post post_types [80857]</li>\n<li>Tweak &#8211; Added actions: <code>tribe_events_inside_cost</code></li>\n<li>Tweak &#8211; Changed views: <code>day/single-event</code>, <code>day/single-featured</code>, <code>list/single-event</code>, <code>list/single-featured</code></li>\n<li>Language &#8211; 1 new strings added, 15 updated, 1 fuzzied, and 1 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 0 new strings added, 0 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.5] 2017-06-14</h4>\n<ul>\n<li>Fix &#8211; Removed extra double quotes in organizer link output [71133]</li>\n<li>Fix &#8211; Make the list and day view styles match more closely [63599]</li>\n<li>Fix &#8211; Better sanitization on CSV imports (thanks to Valentinos Chouris from NCC Group for reporting this) [80311]</li>\n<li>Fix &#8211; Prevent tabs from being incorrectly escaped in iCal output (props: KZeni) [80452]</li>\n<li>Fix &#8211; Fixed inconsistent font styling of Tribe Bar form labels. [27252]</li>\n<li>Tweak &#8211; Removed unused Javascript (jQuery UI Dialog) to help avoid warnings (our thanks to @gama6889 for flagging this) [80766]</li>\n<li>Tweak &#8211; Added new filter hooks &#8216;tribe_events_register_event_type_args&#8217; and &#8216;tribe_events_register_event_cat_type_args&#8217; [80658]</li>\n</ul>\n<h4>[4.5.4] 2017-06-06</h4>\n<ul>\n<li>Tweak &#8211; Minor tweaks to the CSS for linked post types (Organizer/Venues)</li>\n<li>Fix &#8211; Prevent drag and drop icon showing when singular linked post type is been displayed</li>\n<li>Fix &#8211; Resolved issue where scheduled imports sometimes failed to execute [79587]</li>\n<li>Fix &#8211; Better sanitization of data (Props to Valentinos Chouris for reporting this) [80310]</li>\n<li>Language &#8211; 2 new strings added, 156 updated, 0 fuzzied, and 4 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 4 new strings added, 20 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.3] 2017-06-01</h4>\n<ul>\n<li>Fix &#8211; Made it easier to translate the update confirmation message (our thanks to safu9 for highlighting this) [79729]</li>\n<li>Fix &#8211; Fixed compatibility issue with WPML which caused organizers and venues to disappear on translated events [67581]</li>\n<li>Fix — Fixed bug where venues and organizers would be duplicated when their associated event is previewed. [64088]</li>\n<li>Tweak &#8211; Other fixes to the plugin verbiage (with thanks to @garrett-eclipse and others)</li>\n</ul>\n<h4>[4.5.2.1] 2017-05-19</h4>\n<ul>\n<li>Fix &#8211; Prevent fatal errors occuring in PHP 5.5 and earlier [79208]</li>\n</ul>\n<h4>[4.5.2] 2017-05-17</h4>\n<ul>\n<li>Fix &#8211; Correct REST API reference URL (our thanks to Lindsey for flagging this) [78658]</li>\n<li>Fix &#8211; Improve Event Aggregator integration to avoid situations where imports continually restart but do not complete [77988]</li>\n<li>Tweak &#8211; Make the inclusion or exclusion of the year (within the event schedule string) filterable [78070]</li>\n<li>Tweak &#8211; Adjustments to help avoid false positive security alerts being generated in relation to our customizer integration [78355]</li>\n</ul>\n<h4>[4.5.1] 2017-05-04</h4>\n<ul>\n<li>Fix &#8211; Prevented errors on EA import screen that happened in exotic circumstance. Thanks @kathryn for reporting this! [75787]</li>\n<li>Fix &#8211; Made EA preserve custom dates after reimporting a Facebook Event when option is set. [75787]</li>\n<li>Fix &#8211; Enhance month view caching to minimize impact of JSON-LD generation [74656]</li>\n<li>Tweak &#8211; Styling/layout improvements within the Event Aggregator screen [77895]</li>\n</ul>\n<h4>[4.5.0.2] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Ensure compatibility with WordPress version 4.4 and earlier</li>\n</ul>\n<h4>[4.5.0.1] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Resolving issue where some premium plugins were falsely claiming they were out of date</li>\n</ul>\n<h4>[4.5] 2017-05-01</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator now allows users to import from other sites with The Events Calendar [68139]</li>\n<li>Feature &#8211; Include a Events REST API endpoint for read operations [70711]</li>\n<li>Feature &#8211; Include granular Scheduling for Events Aggregator</li>\n<li>Tweak &#8211; Update Authority for modified fields now will include Organizer, Venues and Taxonomy changes [71152]</li>\n<li>Tweak &#8211; Clean up direct calls to get events and use wrapper <code>tribe_get_events()</code> which has a hook for customizing</li>\n<li>Tweak &#8211; Remove including Event Tickets for backwards compatibility as a vendor library [71908]</li>\n<li>Tweak &#8211; Create a global ID to increase consistency on all of the imported items with Event Aggregator [75218]</li>\n<li>Fix &#8211; Prevent Aggregator to run on Empty Queues thus generating fatals (props to @Donald for the report here) [75377]</li>\n<li>Fix &#8211; Categories and Tags are no longer cleared when importing with Event Aggregator (thank you @Nicolas for the report) [74264]</li>\n<li>Fix &#8211; Increase consistency on Column Mapping for CSV imports [76476]</li>\n<li>Tweak &#8211; Added filters for REST API: <code>tribe_events_rest_url_prefix</code>, <code>tribe_rest_url</code>, <code>tribe_events_rest_use_builtin</code>, <code>tribe_rest_events_archive_data</code>, <code>tribe_rest_event_max_per_page</code>, <code>tribe_rest_event_data</code>, <code>tribe_rest_venue_data</code>, <code>tribe_rest_organizer_data</code>, <code>tribe_rest_event_categories_data</code>, <code>tribe_rest_event_tags_data</code>, <code>tribe_rest_event_taxonomy_term_data</code>, <code>tribe_rest_event_featured_image</code>, <code>tribe_events_rest_api_enabled</code></li>\n<li>Tweak &#8211; Added filters for REST API Documentation: <code>tribe_rest_swagger_cost_details_documentation</code>, <code>tribe_rest_swagger_date_details_documentation</code>, <code>tribe_rest_swagger_image_details_documentation</code>, <code>tribe_rest_swagger_image_size_documentation</code>, <code>tribe_rest_swagger_term_documentation</code>, <code>tribe_rest_swagger_event_documentation</code>, <code>tribe_rest_swagger_organizer_documentation</code>, <code>tribe_rest_swagger_venue_documentation</code>, <code>tribe_rest_swagger_documentation</code></li>\n<li>Tweak &#8211; Added filters for Modified fields tracking: <code>tribe_tracker_post_types</code>, <code>tribe_tracker_excluded_meta_keys</code>, <code>tribe_tracker_enabled</code>, <code>tribe_tracker_enabled_for_terms</code>, <code>tribe_tracker_taxonomies</code></li>\n<li>Tweak &#8211; Added filters for Event Aggregator: <code>tribe_aggregator_localized_data</code>, <code>tribe_aggregator_service_messages</code>, <code>tribe_aggregator_url_import_range_options</code>, <code>tribe_aggregator_url_import_range_cap</code>, <code>tribe_aggregator_url_import_range_start</code>, <code>tribe_aggregator_url_import_range_end</code></li>\n<li>Tweak &#8211; Removed filters for Event Aggregator: <code>tribe_aggregator_track_modified_fields</code></li>\n<li>Tweak &#8211; Added actions for Initialization: <code>tribe_events_bound_implementations</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Main</code>: <code>track_event_post_field_changes</code>, <code>maybe_load_tickets_framework</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Aggregator__Service</code>: <code>has_service_message</code></li>\n</ul>\n<h4>[4.4.5] 2017-03-23</h4>\n<ul>\n<li>Fix &#8211; Local changes to events should be preserved in accordance with the Event Import Authority setting (thanks to @bryan for reporting this one) [72876]</li>\n<li>Fix &#8211; Correct the value for days of the week abbreviation (thanks @mmmmartin03 for the report) [75379]</li>\n<li>Tweak &#8211; Enable the month view cache by default on new installations [74867]</li>\n<li>Tweak &#8211; External links to Google maps changed from http to https (nice find by @bjf2000 &#8211; reported via the .org support page) [74930]</li>\n<li>Tweak &#8211; Links to WordPress.org changed from http to https (ultimately this is also credited to @bjf2000&#8217;s find. Thanks!) [72273]</li>\n</ul>\n<h4>[4.4.4] 2017-03-08</h4>\n<ul>\n<li>Fix &#8211; Avoid unnecessarily removing a callback from an action while inside the same action (improves PolyLang compatibility &#8211; props @Chouby) [73122]</li>\n<li>Fix &#8211; Resolving issue where sites that overrode the wp-admin path would fail to successfully perform a Facebook OAuth with Event Aggregator [74687]</li>\n<li>Tweak &#8211; Improve template loading for easier customization by developers and better support of the template hierarchy (props @QWp6t) [72842]</li>\n</ul>\n<h4>[4.4.3] 2017-02-22</h4>\n<ul>\n<li>Fix &#8211; Resolved issue where iCal exports on month view were exporting more events than intended (thanks to @s2ldesign for reporting in our forums) [72133]</li>\n<li>Fix &#8211; Resolved meta width issue for maps when Pro is active (gracias a @ANTONIO JOSE por el reporte del error)  [69844, 72272]</li>\n<li>Fix &#8211; Resolved issue where featured images were not being imported via Event Aggregator Facebook imports (cheers to @Cody for the initial bug report) [72764]</li>\n<li>Fix &#8211; Resolved issue where translated &#8216;all&#8217; slugs were not respected (thank you @Marianne for your report in the forums) [71996]</li>\n<li>Tweak &#8211; Translation improvements and fixes (@Katja &#8211; thanks! ) [70068]</li>\n<li>Tweak &#8211; Allow «-1» when specifying the «Month view events per day» setting [70497]</li>\n</ul>\n<h4>[4.4.2] 2017-02-09</h4>\n<ul>\n<li>Fix &#8211; Ensure the global and source-specific Google Map settings for imports are respected [67228]</li>\n<li>Fix &#8211; Prevent PHP 5.2 Strict mode from throwing notices due to usage of <code>is_a</code> [72812]</li>\n<li>Fix &#8211; Ensure the events list widget&#8217;s show/hide if there are upcoming events setting is respected [72965]</li>\n<li>Tweak &#8211; Add filters for template tag functions related to dates: <code>tribe_get_start_time</code>, <code>tribe_get_end_time</code>, <code>tribe_get_start_date</code> and <code>tribe_get_end_date</code> [67759]</li>\n</ul>\n<h4>[4.4.1.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolved fatal caused when rendering themes that override tribe styles</li>\n</ul>\n<h4>[4.4.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolve the Fatals related to undefined methods and Memory exhaustion [71958, 71912]</li>\n<li>Fix &#8211; iCal export for Single events working again [71916]</li>\n<li>Tweak &#8211; Changes the Search label to prevent duplicate words (props @oheinrich) [72149]</li>\n<li>Tweak &#8211; Add theme version to <code>tribe-event.css</code> (props @berler) [71973]</li>\n<li>Fix &#8211; Resolve JavaScript error when jQuery was been de-registered [71369]</li>\n<li>Fix &#8211; Prevent Fatals when Importing Images on Event Aggregator [70576]</li>\n<li>Fix &#8211; Prevent Third Party notes to be escaped, anchor link working again [71872]</li>\n<li>Fix &#8211; Google Maps now are using HTTPS instead of HTTP (props @cliffordp)</li>\n<li>Fix &#8211; Prevent Fatals on Event Aggregator Cron, due to Activity logging failure [71904]</li>\n<li>Fix &#8211; Elminate some cases of problem with Facebook manual import on Event Aggregator [69137]</li>\n<li>Fix &#8211; WPML integration smaller incompatibilities [70520, 70522]</li>\n</ul>\n<h4>[4.4.0.1] 2017-01-09</h4>\n<ul>\n<li>Fix &#8211; Adds safety check to ensure a smooth activation process when earlier versions of Tribe Common are active</li>\n</ul>\n<h4>[4.4] 2017-01-09</h4>\n<ul>\n<li>Feature &#8211; Add dynamic helper text to single event editor to display the events date and time [66484]</li>\n<li>Feature &#8211; Add support for featured events [65898]</li>\n<li>Feature &#8211; Add support for placing the main events archive on the site homepage [38757]</li>\n<li>Feature &#8211; Add support for the theme customizer [67489]</li>\n<li>Feature &#8211; Make it possible to adjust map pins via the theme customizer [65889]</li>\n<li>Feature &#8211; Support for Event Aggregator in a multisite network context added [61427]</li>\n<li>Fix &#8211; Add a link to The Events Calendar Help page in the Network Administration screen of multisite installations [68665]</li>\n<li>Fix &#8211; Multisite license editing and displaying consistency [68662]</li>\n<li>Tweak &#8211; Adjusted styles and added actions for featured events in the List Widget [65923]</li>\n<li>Tweak &#8211; Organizers and Venues are now with a better and cleaner interface [68430]</li>\n<li>Tweak &#8211; Eliminate duplicate meta data for organizer posts [25084]</li>\n<li>Tweak &#8211; Improved the start/end date user interface [66486, 66487, 66550]</li>\n<li>Tweak &#8211; iCal export now includes all events &#8211; up to a reasonable limit &#8211; rather than just those in the current view [65037]</li>\n<li>Tweak &#8211; Adjustments made to the default week view color scheme [69756]</li>\n<li>Tweak &#8211; Add AJAX and improve consistency of the venue and organizer UI [38129]</li>\n</ul>\n<h4>[4.3.5] 2016-12-20</h4>\n<ul>\n<li>Tweak &#8211; Updated the template override instructions in a number of templates [68229]</li>\n<li>Tweak &#8211; Improve behavior of tribe_get_events_title() in respect of single events [46313]</li>\n<li>Tweak &#8211; Event Aggregator will only load on the Administration, prevent bigger loads for Front-End users [70812]</li>\n<li>Tweak &#8211; Allow better filtering for Organizers and Venue Meta fields (Props: @Chouby from Polylang) [70894]</li>\n<li>Fix &#8211; Prevent JavaScript Notices related to Bumpdown [69886]</li>\n<li>Fix &#8211; Assets URL on Windows Servers are fully operational again [68377]</li>\n<li>Fix &#8211; JavaScript and CSS files will respect HTTPS on all pages [69561]</li>\n<li>Fix &#8211; Fixed comment count and visibility issues due to Event Aggregator records [68297]</li>\n<li>Fix &#8211; Fixed PHP notices and warnings raised when importing .ics files [69960]</li>\n<li>Fix &#8211; Only show link to Venues if Pro is active in List View [69887]</li>\n<li>Fix &#8211; Fixed and issue that would make Event Aggregator importing notices remain stuck in the Import screen [70614]</li>\n<li>Fix &#8211; Avoid error screen when saving licenses on multisite installations [68599]</li>\n<li>Fix &#8211; Fix calendar view links in WPML language switcher [67134]</li>\n</ul>\n<h4>[4.3.4.2] 2016-12-13</h4>\n<ul>\n<li>Fix &#8211; Correct an oversight leading to breakages of the /all/ events archive for Events Calendar PRO users [70662]</li>\n</ul>\n<h4>[4.3.4.1] 2016-12-09</h4>\n<ul>\n<li>Fix &#8211; Updates Tribe Common to remove some stray characters that were impacting page layouts (props: @Aetles) [70536]</li>\n</ul>\n<h4>[4.3.4] 2016-12-08</h4>\n<ul>\n<li>Tweak &#8211; Tribe Common now is loaded only once across our plugin suite, improves performance in some cases [65755]</li>\n<li>Fix &#8211; Featured Images for Event Aggregator imports are working as expected again. [69465]</li>\n<li>Fix &#8211; Google Calendar and iCalendar files are now updating their respective events [68684]</li>\n<li>Fix &#8211; On demand Event Aggregator records will update events correctly [69542]</li>\n</ul>\n<h4>[4.3.3] 2016-11-16</h4>\n<ul>\n<li>Feature &#8211; Added Tribe Extension class and loader, to make small addons easier to build [68188]</li>\n<li>Fix &#8211; Ordering on Month view is working as expected again [69123]</li>\n<li>Fix &#8211; Enable ampersand character in mobile month view titles (thanks @kate for the report of this) [45409]</li>\n<li>Fix &#8211; Prevent notices for Event Aggregator License checking [67981]</li>\n<li>Fix &#8211; Mismatched text domains are resolved, important for translations (props to @Hans) [68462]</li>\n<li>Fix &#8211; Sticky on Month View is working as expected again [68902]</li>\n<li>Fix &#8211; Prevent HTTPS websites from pointing to Assets in HTTP [68372]</li>\n<li>Fix &#8211; On <code>WP_Query</code> we will no-longer overwrite custom <code>post__not_in</code> params [42143]</li>\n</ul>\n<h4>[4.3.2] 2016-11-02</h4>\n<ul>\n<li>Fix &#8211; Fixes an issue where the text in the Location search field was URL encoded when using the back or forward button for navigation. [61742]</li>\n<li>Fix &#8211; Aggregator Errors will not show more than once daily as comments (Thanks @Jacob for your report on the forums) [68094]</li>\n<li>Fix &#8211; Event Aggregator ICS default configuration now are been Selected Correctly [67885]</li>\n<li>Fix &#8211; Shortcode Month view now will display tooltips correctly [68094]</li>\n<li>Fix &#8211; Avoid loading the select2 JavaScript library twice when Advanced Custom Fields is activated (props to @ryan for the initial report [43605]</li>\n<li>Fix &#8211; Avoid errors and notices on calendar page when X theme and WPML plugins are active (thanks @ingrid for reporting this one) [64400]</li>\n</ul>\n<h4>[4.3.1.1] 2016-10-20</h4>\n<ul>\n<li>Fix &#8211; Corrected a packaging issue from the 4.3.1 release [67936]</li>\n</ul>\n<h4>[4.3.1] 2016-10-20</h4>\n<ul>\n<li>Tweak &#8211; Implement the pruning of Event Aggregator history records after 7 days, filterable by tribe_aggregator_record_retention [68283]</li>\n<li>Tweak &#8211; Event Aggregator will now verify that the license key has uses remaining before creating a history record [68286]</li>\n<li>Tweak &#8211; Improve <code>tribe_create_event</code> documentation (Props to Keith) [44871]</li>\n<li>Fix &#8211; Resolved an issue where scheduled Event Aggregator imports marked as «On Demand» were being run by cron [68284]</li>\n<li>Fix &#8211; Resolved a bug where empty meta fields were being inserted into Event Aggregator record post meta [68290]</li>\n<li>Fix &#8211; Resolved a bug where Venue and Organizers urls were been generated incorrectly (Thanks @Matt) [68168]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n<li>Fix &#8211; Resolved the support for translated event category archive slug that could lead to broken links on the front-end while using WPML (Props to Wilco in the support Forums) [62018]</li>\n<li>Fix &#8211; Resolved a bug where searching for past events in the List view would always yield no results (Thanks for the report @Davide) [61863]</li>\n<li>Fix &#8211; Resolved an issue where long file names would break plugin updates on some Windows installations (pros to @Alan [62552]</li>\n<li>Fix &#8211; Resolved an issue where the <code>/all</code> link on recurring events on non English websites could be broken (reported by @lumiest &#8211; thanks!) [68062]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n</ul>\n<h4>[4.3.0.1] 2016-10-14</h4>\n<ul>\n<li>Fix &#8211; Preventing legacy Facebook events from being duplicated</li>\n</ul>\n<h4>[4.3] 2016-10-13</h4>\n<ul>\n<li>Feature &#8211; Added Event Aggregator to enable service-based event imports from iCal feeds, Facebook, and Meetup</li>\n<li>Feature &#8211; Revamped the CSV import screens to work within the new Event Aggregator pages</li>\n<li>Tweak &#8211; Adjusted some view logic to support the new Event Views shortcode in Pro [44800]</li>\n<li>Tweak &#8211; Added a button to copy the system infomation on the help tab [43709]</li>\n<li>Tweak &#8211; Added an option for users to opt into automatic system infomation so our support system can grab the system information found on the help tab automatically [31645]</li>\n<li>Tweak &#8211; Use an earlier hook for iCal feed generation (props @jlambe) [64141]</li>\n<li>Tweak &#8211; Revise and simplify integration with Event Tickets attendee screen [61992]</li>\n<li>Tweak &#8211; Added context to a set of strings to make translation easier (props @pedro-mendonca) [64586]</li>\n<li>Tweak &#8211; Deprecated various disused functions and classes relating to the Meta Factory [39905]</li>\n<li>Fix &#8211; Cease using GLOB_BRACE for including deprecated files due to limited server support [63172]</li>\n<li>Fix &#8211; Avoid problems that can occur when hooking and unhooking actions (props @Chouby) [63474]</li>\n<li>Fix &#8211; Resolves an issue where we were duplicating a core WordPress hook but with a different set of parameters (props @Chouby) [66455]</li>\n<li>Fix &#8211; Correct the datetime formatting issues within the iCal feed (props @henryk) [65968]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::initOptions()</code> has been deprecated with no replacement</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::set_meta_factory_global()</code> has been deprecated in favor of using the <code>Tribe__Events__Meta_Factory</code> class</li>\n<li>Deprecated &#8211; The <code>setup_meta()</code> method in both the <code>Tribe__Events__Template__Single_Event</code> and <code>Tribe__Events__Template_Factory</code> classes has been deprecated</li>\n<li>Deprecated &#8211; The <code>the_title()</code>, <code>event_date()</code>, <code>event_category()</code>, <code>event_tag()</code>, <code>event_website()</code>, <code>event_origin()</code>, <code>organizer_name()</code>, <code>organizer_email()</code>, <code>venue_name()</code>, <code>venue_address()</code>, and <code>venue_map()</code> methods have been deprecated in the <code>Tribe__Events__Advanced_Functions__Register_Meta</code> class</li>\n<li>Deprecated &#8211; The <code>register()</code>, <code>check_exists()</code>, and <code>get_args()</code> methods have been deprecated in the <code>Tribe__Events__Meta_Factory</code> class</li>\n</ul>\n<h4>[4.2.7] 2016-09-15</h4>\n<ul>\n<li>Tweak &#8211; Additional support for plugin extensions</li>\n</ul>\n<h4>[4.2.6] 2016-08-31</h4>\n<ul>\n<li>Add &#8211; tribe_is_event_past() conditional to detect if event end time is past current time (Reported by @Jonathan in our support forums &#8211; thanks Jonathan.)</li>\n</ul>\n<h4>[4.2.5] 2016-08-17</h4>\n<ul>\n<li>Fix &#8211; Fixed inconsistent template filtering logic for single event template [62525]</li>\n<li>Tweak &#8211; Restored preview for published events [64874]</li>\n</ul>\n<h4>[4.2.4] 2016-08-03</h4>\n<ul>\n<li>Tweak &#8211; Changed «Event Add-Ons» to load faster [64286]</li>\n<li>Fix &#8211; Fixed default venue setting [64628]</li>\n<li>Fix &#8211; Fixed default venue state and province settings [64629]</li>\n</ul>\n<h4>[4.2.3] 2016-07-20</h4>\n<ul>\n<li>Fix &#8211; In month view, be sure to unhook JSON-LD output when calling unhook function</li>\n<li>Fix &#8211; Incorrect JSON-LD event start and end times (thank you @jjbte for reporting on .org forums)</li>\n<li>Fix &#8211; Show Google Map and Link checkbox so they show when editing an event (Reported originally by Michael of @NailedIT in the .org forum)</li>\n<li>Fix &#8211; Use Community Events Venue Edit Link when on Community Events Forms instead of Admin (also as a result of the report abve from @NailedIT. Thanks again.)</li>\n</ul>\n<h4>[4.2.2] 2016-07-06</h4>\n<ul>\n<li>Fix &#8211; Small CSS Issue on Welcome Page</li>\n<li>Fix &#8211; Month view on mobile device width doesn&#8217;t have links to prev/next months</li>\n<li>Fix &#8211; Reimport of updated CSV removes featured image (Bug #46149)</li>\n<li>Fix &#8211; Fixed the issue that would make multiple organizers details disappear when trying to submit invalid event data using Community</li>\n<li>Fix &#8211; Add a check to avoid being unable to switch view when Filter Bar plugin is active and at least one field is set to auto-complete mode</li>\n<li>Fix &#8211; Only add the events custom post type to the tag archive queries and not custom queries with tags [45635]</li>\n<li>Fix &#8211; When using the filter tribe_events_excerpt_allow_shortcode shortcodes will be maybe be processed in event excerpts in the list views [42289]</li>\n</ul>\n<h4>[4.2.1.1] 2016-06-28</h4>\n<ul>\n<li>Fix &#8211; Ensure translations load as expected with all supported versions of WordPress (thanks to @JacobALund for originally reporting this on .org forums)</li>\n</ul>\n<h4>[4.2.1] 2016-06-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust the caching rules for Month View for faster loading</li>\n<li>Fix &#8211; Replace a bad return type to avoid unnecessary notices in the error log</li>\n<li>Fix &#8211; Add missing styles for correctly hide screen reader text</li>\n<li>Fix &#8211; Fixes <code>tribe_get_event_link()</code> which wasn&#8217;t working when passing second parameter as `true&#8217;</li>\n<li>Tweak &#8211; Reduce the ginormous font size of Month View titles in skeleton styles</li>\n<li>Fix &#8211; Add styling to adjust List View description to full width</li>\n<li>Fix &#8211; Miscellaneous tweaks to improve the Month and Day views</li>\n<li>Fix &#8211; Fix a shorthand array that was causing errors in PHP 5.2 and 5.3 when importing events</li>\n</ul>\n<h4>[4.2] 2016-06-08</h4>\n<ul>\n<li>Feature &#8211; Added Google Maps API key field in the Settings tab to avoid map timeouts and errors on larger sites (Thanks to Yan for reporting this!)</li>\n<li>Feature &#8211; Added support for featured image, multiple organizers, excerpt and more custom fields in the .csv file import function for events (Thank you to Graphic Designer for posting on UserVoice!)</li>\n<li>Feature &#8211; Added support for featured image, description, map details and more custom fields in the .csv file import function for venues</li>\n<li>Feature &#8211; Added support for featured image and description in the .csv file import function for organizers (Thank you to Rebecca for posting on UserVoice!)</li>\n<li>Feature &#8211; Added an oEmbed template for events</li>\n<li>Feature &#8211; Improve performance of a query used to determine if there are free/uncosted events (Thank you @fabianmarz for the pull request!)</li>\n<li>Feature &#8211; Added support for attaching custom post types to events</li>\n<li>Tweak &#8211; Improved filtering of the <code>tribe_event_featured_image()</code> function (Cheers to @fabianmarz!)</li>\n<li>Tweak &#8211; Add an encoding class for the CSV importer to prevent non utf8 characters from preventing imports (Thanks to screenrage for the report!)</li>\n<li>Tweak &#8211; Improved our JSON-LD output to ensure consistency (Props to @garrettjohnson and Lars!)</li>\n<li>Tweak &#8211; Language files in the <code>wp-content/languages/plugins</code> path will be loaded before attempting to load internal language files (Thank you to user aafhhl for bringing this to our attention!)</li>\n<li>Tweak &#8211; Switch to HTTPS for the «Powered by The Events Calendar» link (Thank you Cynthia for reporting this!)</li>\n<li>Tweak &#8211; Switch to using HTTPS by default for interactions with Google Maps API</li>\n<li>Tweak &#8211; Improved filterability of calendar excerpts by introducing the new <code>tribe_events_get_the_excerpt</code> filter hook</li>\n<li>Tweak &#8211; Improved filtering of organizer details when importing by CSV (Props to @Geir for bringing this up!)</li>\n<li>Tweak &#8211; Adjustments for single event view in Twenty Fifteen theme</li>\n<li>Tweak &#8211; Improved performance of query used to test for events without any cost</li>\n<li>Tweak &#8211; Added missing semicolon to a laquo (Props to mwender on GitHub for the fix!)</li>\n<li>Tweak &#8211; Improve the «stickiness» of CSV import column mappings (Thank you @jamesgol!)</li>\n<li>Tweak &#8211; Consistency of JSON-LD markup improved (Cheers to @garrettjohnson for the help!)</li>\n<li>Tweak &#8211; Avoid notice-level errors when working with WP CLI on a site where The Events Calendar is also active (Thanks to @sun)</li>\n<li>Tweak &#8211; Corrected the spelling of timezone in the CSV Importer&#8217;s event field</li>\n<li>Tweak &#8211; Updated venue and organizer templates to use the new architecture for attaching custom post types to events</li>\n<li>Tweak &#8211; Move plugin CSS to PostCSS</li>\n<li>Tweak &#8211; Category default view is now set to <code>default</code> in place of hardcoding the current default view in the category base rewrite rule [31907]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__PUE__Checker</code>, <code>Tribe__Events__PUE__Plugin_Info</code>, and <code>Tribe__Events__PUE__Utility</code> classes are deprecated and are replaced by <code>Tribe__PUE__Checker</code>, <code>Tribe__PUE__Plugin_Info</code>, and <code>Tribe__PUE__Utility</code> classes</li>\n<li>Fixed &#8211; Changed the use of <code>have_posts()</code> in the maybe iCal links for the main views that could cause an infinite loop</li>\n<li>Accessibility &#8211; Focus styles added for search fields</li>\n<li>Accessibility &#8211; Add ARIA labels for Month/Day/List sub nav</li>\n<li>Accessibility &#8211; Add ARIA label for events footer sub nav heading</li>\n</ul>\n<h4>[4.1.4] 2016-05-19</h4>\n<ul>\n<li>Fix &#8211; Improve accuracy of list view pagination after switching from month view</li>\n<li>Tweak &#8211; Give the multi-organizer form &#8216;sticky&#8217; properties so values persist even if the submission is initially rejected</li>\n<li>Tweak &#8211; Resolved minor CSS issues in the welcome page</li>\n</ul>\n<h4>[4.1.3] 2016-04-28</h4>\n<ul>\n<li>Fix &#8211; Month View single days are now ordered as follows: sticky events, ongoing multi-day events, all day events, then start time. In other words, all events should be ordered as you&#8217;d expect when viewing events in Month View.</li>\n<li>Fix &#8211; Updated the compatibility of CSV importer with WordPress 4.5 due to a change in the <code>post_status</code> filter. This will help prevent some of the errors you may have seen when importing events using a CSV file.</li>\n<li>Tweak &#8211; Added new event names for AJAX success to the List, Month, and Day views to help The Events Calendar&#8217;s compatibility with our other premium plugins.</li>\n</ul>\n<h4>[4.1.2] 2016-04-11</h4>\n<ul>\n<li>Tweak &#8211; Removed an unneeded hook that attempted to add a query argument to event tag links</li>\n<li>Fix &#8211; Resolved an issue where events marked as «sticky» would not display as such in Month View</li>\n<li>Fix &#8211; Dashes, hyphens, or whatever you like to call them in the events archive slug no longer breaks the URL</li>\n<li>Fix &#8211; The notice that pops up when a conflicting «events» page exists can now be dismissed</li>\n</ul>\n<h4>[4.1.1.1] 2016-04-07</h4>\n<ul>\n<li>Security &#8211; Tightened up security with post type link filtering (props to Nadal Soler for reporting this issue!)</li>\n<li>Security &#8211; Tightened up security around tribe bar submissions (props to Paul Mynarsky for reporting this issue!)</li>\n</ul>\n<h4>[4.1.1] 2016-03-30</h4>\n<ul>\n<li>Fix &#8211; Resolved bug where array notices were output on single event pages when venues were not set (props to zaxiscreative for reporting this issue!)</li>\n<li>Fix &#8211; Resolved issue where the Month View in mobile sizes retained the long day-of-week names when the abbreviations should have been used (props to Lucy for the bug report!)</li>\n<li>Fix &#8211; Fixed bug where a «0» was added to the default Venue name when creating a new event</li>\n<li>Fix &#8211; Fixed notice that caused Ajax requests to fail (props to cgrymala on WP.org for reporting this!)</li>\n<li>Fix &#8211; Removed quotes from around TZID-specified timezones in iCal feeds which causes problems with some parsers (props to factory44 for reporting the issue that lead to this fix)</li>\n<li>Fix &#8211; Resolved various capitalization issues with German translations (props to oheinrich in our forums for pointing out this issue!)</li>\n</ul>\n<h4>[4.1.0.1] 2016-03-17</h4>\n<ul>\n<li>Fix &#8211; Resolved multiple issues with the German <code>de_DE</code> language file that caused a number of site-breaking issues</li>\n</ul>\n<h4>[4.1] 2016-03-15</h4>\n<ul>\n<li>Feature &#8211; Added a tribe_get_venue_website_url() function for fetching Venue website URLs (props to fervorcreative in our forums for this request!)</li>\n<li>Performance &#8211; Lazy-load venue and organizer selector data</li>\n<li>Tweak &#8211; Allow iCal filenames to be filtered via a new filter: tribe_events_ical_feed_filename</li>\n<li>Tweak &#8211; Added a hook to allow single day queries in month view to be filtered: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Improved the logic around rebuilding known date ranges</li>\n<li>Tweak &#8211; Always show the «Merge Duplicates» button for venues and organizers in the Events General Settings page</li>\n<li>Tweak &#8211; Allow the «same slug» notice to be dismissed and fix some text in that message</li>\n<li>Tweak &#8211; Ignore alpha/beta/rc suffixes on version numbers when checking template versions</li>\n<li>Tweak &#8211; Add a filter for month view daily events query: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Added a more flexible cost range parsing function</li>\n<li>Tweak &#8211; Obfuscate license keys Events &gt; Help &gt; System Information</li>\n<li>Fix &#8211; Fixed a fatal that sometimes occurred when refreshing the import CSV page</li>\n<li>Fix &#8211; Fixed issue where some characters were not escaped appropriately for month and year formats</li>\n<li>Fix &#8211; Added missing tribe-loading@2x.gif</li>\n<li>Fix &#8211; Fixed a warning produced by passing a DateTime() object into start_date or end_date args of tribe_get_events (props to iamhexcoder for the pull request!)</li>\n<li>Fix &#8211; Fixed bug where events in month view were not always sorted in chronological order</li>\n<li>Fix &#8211; Fixed the System Info URL in Events &gt; Help</li>\n<li>Fix &#8211; Resolved issue where the default country would be «Array» if no default country is set</li>\n<li>Fix &#8211; Fixed bug where ajaxurl was sometimes undefined</li>\n</ul>\n<h4>[4.0.7] 2016-03-02</h4>\n<ul>\n<li>Fix &#8211; Resolve display issues on templates with Jetpack and a few themes</li>\n<li>Fix &#8211; Mobile breakpoints on month view working with custom breakpoints</li>\n<li>Fix &#8211; Reordering Venue and Organizer metadata no longer breaks titles</li>\n<li>Fix &#8211; Prevented notices from happening when using <code>the_title</code> filter</li>\n<li>Fix &#8211; iCal links now will respect categories on the first page</li>\n<li>Fix &#8211; Prevent third-party bugs with SEO plugins when inserting events programmatically</li>\n<li>Fix &#8211; Organizer information is showing up again correctly</li>\n<li>Fix &#8211; Modified the add-on license validation method to better explain what is happening</li>\n<li>Fix &#8211; Description on mobile views now have the correct class attribute on HTML</li>\n<li>Fix &#8211; Added missing semicolon on the list navigation for «&amp;laquo»</li>\n</ul>\n<h4>[4.0.6] 2016-02-17</h4>\n<ul>\n<li>Tweak &#8211; Adjust injection of event data into the_content from priority 10 to 9 for better 3rd-party plugin compatibility</li>\n<li>Tweak &#8211; Change mobile month view selector to load event details below the calendar for better theme compatibility</li>\n<li>Tweak &#8211; Better handling of edge cases on the post_excerpt for List View</li>\n<li>Tweak &#8211; Removal of generic CSS classes like <code>.updated</code> and <code>.published</code></li>\n<li>Fix &#8211; Prevent Notices from appearing when using <code>tribe_get_organizer()</code></li>\n<li>Fix &#8211; Make HTML Single Event Pages valid</li>\n<li>Fix &#8211; Numeric named categories URLs are now fully working</li>\n<li>Fix &#8211; Event Title now Accepts HTML on Tooltips</li>\n<li>Fix &#8211; Licenses Tab now will work with <code>DISALLOW_FILE_MODS</code> (Props to Sun for spotting and fixing this)</li>\n</ul>\n<h4>[4.0.5] 2016-01-15</h4>\n<ul>\n<li>Security &#8211; Security fix with Venues and Organizers (props to grantdayjames for reporting this!)</li>\n</ul>\n<h4>[4.0.4] 2015-12-23</h4>\n<ul>\n<li>Tweak &#8211; Including the latest embedded Event Tickets release for backward compatibility</li>\n</ul>\n<h4>[4.0.3] 2015-12-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust single-event.php template to allow the «Time» title and content to be filterable (Props to Sitecrafting for highlighting this issue!)</li>\n<li>Fix &#8211; Resolved issue with an overly escaped Event Category edit URL that prevented editing categories (Thanks to Ian for the first report of this issue!)</li>\n<li>Fix &#8211; Fixed issue where clicking on columns on the Events listed in the Admin Dashboard were ALWAYS sorted by Event start/end date before sorting by the column selected (Cheers to Corrado for bringing this to our attention!)</li>\n</ul>\n<h4>[4.0.2] 2015-12-16</h4>\n<ul>\n<li>Tweak &#8211; Adding better support for non-numeric cost values on events (Props to Mirja for highlighting this!)</li>\n<li>Tweak &#8211; Avoid notice level errors when advanced events list widget settings are saved (Thank you Johan for reporting the issue!)</li>\n<li>Tweak &#8211; Improve messaging in the same-slug warning message (Thanks to Simon for bringing this to our attention!)</li>\n<li>Tweak &#8211; Hook to Event Tickets to inject event dates into ticket emails</li>\n<li>Tweak &#8211; Adding better support for default venues (Props to Karly for noting this!)</li>\n<li>Tweak &#8211; Improve handling of internationalized slugs (Cheers to Oliver for the help!)</li>\n<li>Fix &#8211; Ensure the past events list displays the correct events when accessed via ajax (Thank you Jesse for highlighting this!)</li>\n<li>Fix &#8211; Support ordering by venue/organizer within event queries (Thank you Doug for bringing this to our attention!)</li>\n<li>Fix &#8211; Fixed issue where events with the same date/time would sometimes be excluded from single-event navigation (Cheers to JeremyEnglert for the tip!)</li>\n<li>Fix &#8211; Resolved issue where events set with the explicit cost of 0 were not showing as «Free» (Thank you terrizsolo for reporting this!)</li>\n<li>Fix &#8211; Fixed bug where the datepicker in Twenty Sixteen was really ugly</li>\n<li>Fix &#8211; Fixed bug where using Quick Edit on events caused the table columns in the event list to become jumbled on save (Props to A K for the report!)</li>\n<li>Fix &#8211; Resolved bug where category links sometimes included event category 1 (Thank you Anthony for the original report of this problem!)</li>\n<li>Fix &#8211; Fixed a settings page URL (Props to Kristy for the heads up!)</li>\n</ul>\n<h4>[4.0.1] 2015-12-10</h4>\n<ul>\n<li>Tweak &#8211; Add a warning message for major updates</li>\n<li>Tweak &#8211; For SEO reasons, use an h1 for the title rather than an h2 (props to wpexplorer for this fix)</li>\n<li>Tweak &#8211; Target the calendar view grid in JS using a simpler selector</li>\n<li>Fix &#8211; Resolved WP 4.4 related fatal on the Nav Menu page that prevented the admin footer from rendering/enqueuing JS</li>\n<li>Fix &#8211; Resolved bug where visiting /events/upcoming could sometimes result in an infinite redirect loop</li>\n<li>Fix &#8211; Removed <code>wp_trim_excerpt</code> and use only it&#8217;s powers, fixing the excerpt problem</li>\n<li>Fix &#8211; Fixed bug where the mobile calendar view did not display the date for the date being viewed</li>\n<li>Fix &#8211; Fixed bug where the admin toolbar&#8217;s Events &gt; Import &gt; CSV did not link to the CSV importer page</li>\n<li>Fix &#8211; Fixed issue where the events list in the admin dashboard were not ordered in an intuitive manner</li>\n<li>Fix &#8211; Resolved bug where sorting by event category or tag resulted in an error</li>\n<li>Fix &#8211; Fixed bug where full event content text was displayed where excerpts should have been displayed</li>\n<li>Fix &#8211; Resolved issue where events imported via CSV were excluded from single event navigation</li>\n<li>Fix &#8211; Fixed bug where /events/list would sometimes 404 on a new install</li>\n<li>Fix &#8211; Resolved bug where multiday all-day events displayed the end date as one day later than it should be when the End of Day Cut-off was set to something other than 12am</li>\n<li>Fix &#8211; Timezone handling fixed within generated iCal feeds</li>\n</ul>\n<h4>[4.0] 2015-12-02</h4>\n<ul>\n<li>Security &#8211; A TON of escaping was added to our codebase thanks to the efforts of the always-helpful Andy Fragen (@afragen)</li>\n<li>Feature &#8211; Moved the Ticket framework code into its own plugin (event-tickets)</li>\n<li>Feature &#8211; The event cost now supports more international formats with the addition of the tribe_events_cost_separators filter (Thank you remokrol for bringing this to our attention!)</li>\n<li>Feature &#8211; Added support for the twentysixteen theme</li>\n<li>Feature &#8211; Created a new Add-Ons tab in Settings so that TEC add-ons can have a consolidated settings tab</li>\n<li>Feature &#8211; Improve the date formats UI by providing example output for each selected format</li>\n<li>Tweak &#8211; Restructured TEC&#8217;s core settings code for reusability with other standalone plugins like Event Tickets</li>\n<li>Tweak &#8211; Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe</li>\n<li>Tweak &#8211; Consolidated import pages for TEC and add-ons</li>\n<li>Tweak &#8211; When suggesting a UTF-8 compatibility CSV formatting tool, point to one that still exists</li>\n<li>Tweak &#8211; Added the ability to filter attendees CSV items via tribe_events_tickets_attendees_csv_items (Props to @bostondv on GitHub for this patch!)</li>\n<li>Tweak &#8211; Updated all excerpt output to use tribe_events_get_the_excerpt() to ensure a consistent display of excerpt content (Cheers to Joseph to pointing this out!)</li>\n<li>Tweak &#8211; Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title</li>\n<li>Tweak &#8211; Check post creation permissions before letting users create venues and organizers from the event meta box</li>\n<li>Tweak &#8211; Only display data separators between fields that have data when rendering organizers (Thank you Bud for highlighting this issue!)</li>\n<li>Tweak &#8211; When a user cannot create organizers, prevent the auto-selection of organizers when editing an event</li>\n<li>Tweak &#8211; Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes</li>\n<li>Tweak &#8211; Changed the «updated» CSS class to «tribe-updated» so that it is properly namespaced (Thank you vijayrajesh!)</li>\n<li>Tweak &#8211; The Plugin Update Checker will now auto-save valid plugin keys (Thanks to Denon for originally bringing this up!)</li>\n<li>Tweak &#8211; Cleaned up the output of JSON-LD data. Filterable via the new tribe_google_data_markup_json filter</li>\n<li>Tweak &#8211; Drop the use of the generic CSS class «placeholder» in favor of «tribe-event-placeholder» (Thanks to Marc on the forums!)</li>\n<li>Tweak &#8211; Adjusted the CSS padding on Admin Menu items for Events</li>\n<li>Tweak &#8211; Various codesniffer fixes</li>\n<li>Tweak &#8211; tribe_get_venue_link() no longer echoes if you ask it to return an <a> element</a></li>\n<li>Tweak &#8211; Error messages for empty Venue names</li>\n<li>Tweak &#8211; Improve our responsiveness for the widget mini calendar, allowing smaller sidebars.</li>\n<li>Tweak &#8211; No longer retrieve empty costs when fetching all costs for all events</li>\n<li>Tweak &#8211; Change the priority of bootstrapping the-events-calendar to ensure it occurs before any of the TEC addons in the event some addons are upgraded to v4.0 later than TEC</li>\n<li>Tweak &#8211; Adjust the logic used for adding a noindex/follow tag to event views</li>\n<li>Tweak &#8211; No longer hiding default address fields when default venues are selected when Pro is active</li>\n<li>Fix &#8211; Resolved issue where the iCal feed did not provide an appropriately formatted timezone in some cases (Cheers to Matt for the report!)</li>\n<li>Fix &#8211; Added support for translating some previously untranslatable strings (Props to tititou36, media325, and Stef!)</li>\n<li>Fix &#8211; Prevented duplicate CSS IDs on the mini calendars (Cheers to Corrado for the help!)</li>\n<li>Fix &#8211; Fixed bug causing tribe_get_single_ical_link() and tribe_get_ical_link() to use the same URL when it shouldn&#8217;t (Props to Ben Byrne @drywall on Twitter for the heads up!)</li>\n<li>Fix &#8211; Fixed issue where the «Add another organizer» text wasn&#8217;t using the correct singular label (Thank you MIKE for the report!)</li>\n<li>Fix &#8211; Various CSS fixes for twenty(ten-fifteen)</li>\n<li>Fix &#8211; Improved our handling of <code>get_current_screen()</code> across the plugin, avoiding notices and warnings (Thank you Mike for the help!)</li>\n<li>Fix &#8211; Fixed bug where accessing object properties on a non object errored out when saving event meta (props to @dalethedeveloper on GitHub for this fix!)</li>\n<li>Fix &#8211; Fixed bug where organizer ID meta attached sometimes included a blank record. That blank record is no longer returned in tribe_get_organizer_ids()</li>\n<li>Fix &#8211; Fixed error message returned when tabbing away from a blank event name meta box so that it properly indicates that an event name is required (Our thanks to @tapan29bd for this fix!)</li>\n<li>Fix &#8211; Resolved issue where Timezone event start/end date property name strings were malformed which guaranteed a a call to get_post_meta for Timezone date strings</li>\n<li>Fix &#8211; Fixed CSS issue where the month view calendar could sometimes extend beyond the edge of the page when Skeleton Styles were enabled</li>\n<li>Fix &#8211; Fixed a problem where iCal data was generated with incorrect dates in the case of some all days events (thanks to Matt for highlighting this)</li>\n<li>Fix &#8211; Resolved a problem causing the previous month view to appear when it should not</li>\n<li>Fix &#8211; Fixed issue in mobile month view where date was missing from heading</li>\n<li>Fix &#8211; Resolved issue that caused /events/ to 404 if it was visited on a new install before hitting «Save» on the Events &gt; Settings &gt; Display page</li>\n<li>Deprecated &#8211; The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option(&#8216;defaultValueReplace&#8217;). Schedules for removal in v4.5</li>\n<li>Deprecated &#8211; The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation</li>\n<li>Deprecated &#8211; Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__App_Shop in favor of Tribe__App_Shop</li>\n<li>Deprecated &#8211; Tribe__Events__Autoloader in favor of Tribe__Autoloader</li>\n<li>Deprecated &#8211; Tribe__Events__Cache in favor of Tribe__Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener</li>\n<li>Deprecated &#8211; Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader</li>\n<li>Deprecated &#8211; Tribe__Events__Credits in favor of Tribe__Credits</li>\n<li>Deprecated &#8211; Tribe__Events__Date_Utils in favor of Tribe__Date_Utils</li>\n<li>Deprecated &#8211; Tribe__Events__Field in favor of Tribe__Field</li>\n<li>Deprecated &#8211; Tribe__Events__Settings in favor of Tribe__Settings</li>\n<li>Deprecated &#8211; Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab</li>\n<li>Deprecated &#8211; Tribe__Events__Support in favor of Tribe__Support</li>\n<li>Deprecated &#8211; Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Validate in favor of Tribe__Validate</li>\n<li>Deprecated &#8211; Tribe__Events__View_Helpers in favor of Tribe__View_Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( &#8216;defaultValueReplace&#8217; )</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url</li>\n<li>Deprecated &#8211; Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()</li>\n<li>Deprecated &#8211; tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()</li>\n<li>Deprecated &#8211; tribe_event_end_of_day() in favor of tribe_end_of_day()</li>\n<li>Deprecated &#8211; tribe_event_format_date() in favor of tribe_format_date()</li>\n<li>Deprecated &#8211; tribe_events_the_notices() in favor of tribe_the_notices()</li>\n</ul>\n<h4>3.x and previous</h4>\n<p>For release notes from the 3.x and older lifecycles, see our <a href=\"https://theeventscalendar.com/category/products/release-notes/\" rel=\"nofollow ugc\">full historical release notes</a>.</p>\n\";s:11:\"screenshots\";s:2035:\"<ol><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2234716\" alt=\"Month View with hover\"></a><p>Month View with hover</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2234716\" alt=\"Mobile Views\"></a><p>Mobile Views</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2234716\" alt=\"Single event\"></a><p>Single event</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2234716\" alt=\"Ver Lista\"></a><p>Ver Lista</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2234716\" alt=\"Event Editor\"></a><p>Event Editor</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2234716\" alt=\"Events admin listing\"></a><p>Events admin listing</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2234716\" alt=\"Ajustes generales\"></a><p>Ajustes generales</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2234716\" alt=\"Ajustes de visualización\"></a><p>Ajustes de visualización</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2234716\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2234716\" alt=\"CSV Importer\"></a><p>CSV Importer</p></li></ol>\";s:7:\"reviews\";s:15844:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">A great WP plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/vlrrml\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/909717216b4dc89a2289527c0ec939fb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/909717216b4dc89a2289527c0ec939fb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/vlrrml\" class=\"reviewer-name\">vlrrml</a> el <span class=\"review-date\">noviembre 6, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">it is a simple, effective plugin with a great outlook!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/myad92\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0a444cc9b041202b4a4e9853bc02714f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0a444cc9b041202b4a4e9853bc02714f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/myad92\" class=\"reviewer-name\">myad92</a> el <span class=\"review-date\">noviembre 2, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Merci</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">working great</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/jaredreed2\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a6116d58c6c42355f42e326338ce21a1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a6116d58c6c42355f42e326338ce21a1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/jaredreed2\" class=\"reviewer-name\">jaredreed2</a> el <span class=\"review-date\">octubre 22, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Support was helpful and solved the problem (of my own making).</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent plugin! Thank you!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/madetobeunique\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c71add3a6ce8a3b3673d19ed4f68deb9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c71add3a6ce8a3b3673d19ed4f68deb9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/madetobeunique\" class=\"reviewer-name\">madetobeunique</a> el <span class=\"review-date\">octubre 21, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Thank you for making this free with the option to upgrade.  It\'s pretty awesome and works well for several of my clients!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent Support - URL Links problem fixed</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/rickiru34\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ed52c980c06c353e87ab223684bef02f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ed52c980c06c353e87ab223684bef02f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/rickiru34\" class=\"reviewer-name\">rickiru34</a> el <span class=\"review-date\">octubre 4, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Thank you for your help in solving the problem I had with the URL links.\nI find that you always have a quick response to my problems.\nThank you.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Worst support ever seen on pro plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/adage\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0b2729f14ef2a179f546ef709f37e117?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0b2729f14ef2a179f546ef709f37e117?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/adage\" class=\"reviewer-name\">adage</a> el <span class=\"review-date\">septiembre 28, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><strong>Worst support I ever seen</strong> in 100+ sites made with tons of premium plugins. \n\nThey don\'t even know their own plugin and documentation !\n\nThey\'re slow and totally inaccurate. Currently having a ticket where they answer a 4th time with totally erroneous answers... </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">HORRIBLE support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/pblshrtom4\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d21ddf1b9c394097aad7d501effd37c1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d21ddf1b9c394097aad7d501effd37c1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/pblshrtom4\" class=\"reviewer-name\">pblshrtom4</a> el <span class=\"review-date\">septiembre 9, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">We are a 501(c)3 nonprofit with a mission of social equity. \n\nWe wanted to use The Events Calendar on our aggregating website (200K page views annually). \n\nOur tech team found out the Pro edition wouldn\'t work on our template. TEC tech folks said, \"Yeah, we knew that.\" Asked for a possible work-around our team got crickets.\n\nAt that point I told our credit card company to dispute the charge. After months of dithering we got the response that we hadn\'t requested a refund, so they didn\'t have to give our money back. I requested a refund, and was told, \"Sorry, it\'s after 30 days.\"\n\nThere are far better ways to manage events. We do very large events and we would NEVER use these folks, even if we had a different template.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">no support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/judyreidster\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/31eae2acf9346a50ffd37a65088267e3?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/31eae2acf9346a50ffd37a65088267e3?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/judyreidster\" class=\"reviewer-name\">judyreidster</a> el <span class=\"review-date\">septiembre 5, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I am not a coder or professional website builder.  I made a lovely calendar in 2020 and we know what happened then.\nI deleted all the 2020 entries, recurrent events and colors and categories.  It displayed in monthly view beautifully after embedding into WP site.\n\nI submitted 2 help requests with no reply.  I can\'t find the new event entry page that I used before.  It was a table format that you could enter start dates and times, enter exceptions for holidays. Consequently I have had to put google calendar on the site this year.  Yuck!\n\nI will not be renewing our subscription this year.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/bobfox47\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/080a1d3c8b95fb2ac470d505f1b29728?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/080a1d3c8b95fb2ac470d505f1b29728?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/bobfox47\" class=\"reviewer-name\">bobfox47</a> el <span class=\"review-date\">agosto 31, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Excellent support\n\nI put in two tickets in the last two days. Both tickets were answered within 24 hours and answered very intelligently with workable solutions\n\nThe last response included a custom video to demonstrate the source of the problem that was in my theme and a possible code solution that I could inject into the theme CSS. I’m very impressed with that kind of thoroughness.\n\nThe Functionality of the community calendar is extremely valuable for what I do in trying to connect parts of my region for collaboration purposes</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">THE WORST CALENDAR PLUGIN!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/butterflyherder\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8894bfef0228c8e6a6da83b08b33cfb3?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8894bfef0228c8e6a6da83b08b33cfb3?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/butterflyherder\" class=\"reviewer-name\">ButterflyHerder</a> el <span class=\"review-date\">agosto 31, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">OH.MY.GOSH. Never in all my years of working with WordPress have I experienced such a horrible plugin! This thing is SO buggy and SO frustrating. The tech support people are very helpful -- BUT only if you can actually submit a support ticket. Their stupid support process is a mess. Today, for example, I\'ve been trying for over an hour -- in 3 different browsers -- to simply LOG IN to their support site! The SUPPORT SITE is giving me a 522 error! (If they can\'t manage their own site, how can they be expected to support a plugin?!) We just launched a very big membership site and all was working perfectly until -- yet again -- they updated one of the plugins in their suite. Then it all went to hell again. We\'re paying a lot of money for this calendar, and it won\'t even work correctly &amp; consistently. DO NOT BUY IT.</div>\n</div>\n\";}s:13:\"download_link\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.1.zip\";s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2234716\";s:7:\"caption\";s:21:\"Month View with hover\";}i:2;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2234716\";s:7:\"caption\";s:12:\"Mobile Views\";}i:3;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2234716\";s:7:\"caption\";s:12:\"Single event\";}i:4;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2234716\";s:7:\"caption\";s:9:\"Ver Lista\";}i:5;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2234716\";s:7:\"caption\";s:12:\"Event Editor\";}i:6;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2234716\";s:7:\"caption\";s:20:\"Events admin listing\";}i:7;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2234716\";s:7:\"caption\";s:17:\"Ajustes generales\";}i:8;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2234716\";s:7:\"caption\";s:25:\"Ajustes de visualización\";}i:9;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2234716\";s:7:\"caption\";s:12:\"CSV Importer\";}}s:4:\"tags\";a:5:{s:8:\"calendar\";s:8:\"calendar\";s:5:\"event\";s:5:\"Event\";s:6:\"events\";s:6:\"events\";s:9:\"organizer\";s:9:\"organizer\";s:8:\"schedule\";s:8:\"schedule\";}s:8:\"versions\";a:242:{s:3:\"1.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.zip\";s:5:\"1.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.1.zip\";s:5:\"1.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.2.zip\";s:5:\"1.5.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.3.zip\";s:5:\"1.5.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.4.zip\";s:5:\"1.5.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.5.zip\";s:5:\"1.5.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.6.zip\";s:3:\"1.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.zip\";s:5:\"1.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.1.zip\";s:5:\"1.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.2.zip\";s:5:\"1.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.3.zip\";s:5:\"1.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.4.zip\";s:5:\"1.6.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.5.zip\";s:3:\"2.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.zip\";s:5:\"2.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.1.zip\";s:6:\"2.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.10.zip\";s:6:\"2.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.11.zip\";s:5:\"2.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.2.zip\";s:5:\"2.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.3.zip\";s:5:\"2.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.4.zip\";s:5:\"2.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.5.zip\";s:5:\"2.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.6.zip\";s:5:\"2.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.7.zip\";s:5:\"2.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.8.zip\";s:5:\"2.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.9.zip\";s:3:\"3.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.zip\";s:5:\"3.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.1.zip\";s:5:\"3.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.2.zip\";s:5:\"3.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.3.zip\";s:3:\"3.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.1.zip\";s:4:\"3.10\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.zip\";s:6:\"3.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.1.zip\";s:4:\"3.11\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.zip\";s:6:\"3.11.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.1.zip\";s:6:\"3.11.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.2.zip\";s:4:\"3.12\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.zip\";s:6:\"3.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.1.zip\";s:6:\"3.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.2.zip\";s:6:\"3.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.3.zip\";s:6:\"3.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.4.zip\";s:6:\"3.12.5\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.5.zip\";s:6:\"3.12.6\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.6.zip\";s:3:\"3.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.2.zip\";s:3:\"3.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.zip\";s:5:\"3.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.1.zip\";s:3:\"3.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.zip\";s:5:\"3.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.1.zip\";s:3:\"3.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.zip\";s:5:\"3.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.1.zip\";s:3:\"3.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.zip\";s:5:\"3.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.1.zip\";s:3:\"3.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.7.zip\";s:3:\"3.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.zip\";s:5:\"3.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.1.zip\";s:3:\"3.9\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.zip\";s:5:\"3.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.1.zip\";s:5:\"3.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.2.zip\";s:5:\"3.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.3.zip\";s:3:\"4.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.zip\";s:5:\"4.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.1.zip\";s:5:\"4.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.2.zip\";s:5:\"4.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.3.zip\";s:5:\"4.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.4.zip\";s:5:\"4.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.5.zip\";s:5:\"4.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.6.zip\";s:5:\"4.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.7.zip\";s:3:\"4.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.zip\";s:7:\"4.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.0.1.zip\";s:5:\"4.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.zip\";s:7:\"4.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.1.zip\";s:5:\"4.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.2.zip\";s:5:\"4.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.3.zip\";s:5:\"4.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.4.zip\";s:3:\"4.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.zip\";s:5:\"4.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.zip\";s:7:\"4.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.1.zip\";s:5:\"4.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.2.zip\";s:5:\"4.2.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.3.zip\";s:5:\"4.2.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.4.zip\";s:5:\"4.2.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.5.zip\";s:5:\"4.2.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.6.zip\";s:5:\"4.2.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.7.zip\";s:3:\"4.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.zip\";s:7:\"4.3.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.0.2.zip\";s:5:\"4.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.zip\";s:7:\"4.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.2.zip\";s:7:\"4.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.2.1.zip\";s:7:\"4.3.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.3.1.zip\";s:7:\"4.3.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.1.zip\";s:7:\"4.3.4.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.3.zip\";s:7:\"4.3.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.5.1.zip\";s:3:\"4.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.zip\";s:7:\"4.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.0.2.zip\";s:5:\"4.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.zip\";s:7:\"4.4.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.2.zip\";s:7:\"4.4.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.2.1.zip\";s:7:\"4.4.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.3.1.zip\";s:7:\"4.4.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.4.1.zip\";s:7:\"4.4.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.5.1.zip\";s:3:\"4.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.zip\";s:7:\"4.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.1.zip\";s:7:\"4.5.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.3.zip\";s:7:\"4.5.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.1.1.zip\";s:6:\"4.5.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.zip\";s:8:\"4.5.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.2.zip\";s:8:\"4.5.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.11.1.zip\";s:6:\"4.5.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.zip\";s:8:\"4.5.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.1.zip\";s:8:\"4.5.12.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.2.zip\";s:8:\"4.5.12.4\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.4.zip\";s:8:\"4.5.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.13.1.zip\";s:5:\"4.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.zip\";s:7:\"4.5.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.2.zip\";s:7:\"4.5.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.3.1.zip\";s:7:\"4.5.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.4.1.zip\";s:7:\"4.5.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.5.1.zip\";s:7:\"4.5.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.6.1.zip\";s:7:\"4.5.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.7.1.zip\";s:5:\"4.5.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.zip\";s:7:\"4.5.8.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.2.zip\";s:7:\"4.5.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.9.1.zip\";s:7:\"4.6.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.0.1.zip\";s:7:\"4.6.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.1.1.zip\";s:6:\"4.6.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.zip\";s:8:\"4.6.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.2.zip\";s:6:\"4.6.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.zip\";s:8:\"4.6.11.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.2.zip\";s:8:\"4.6.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.12.1.zip\";s:8:\"4.6.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.13.1.zip\";s:6:\"4.6.14\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.zip\";s:8:\"4.6.14.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.2.zip\";s:8:\"4.6.15.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.15.1.zip\";s:8:\"4.6.16.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.16.1.zip\";s:8:\"4.6.17.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.17.1.zip\";s:8:\"4.6.18.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.18.1.zip\";s:8:\"4.6.19.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.19.1.zip\";s:7:\"4.6.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.2.1.zip\";s:6:\"4.6.20\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.zip\";s:8:\"4.6.20.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.2.zip\";s:8:\"4.6.21.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.21.1.zip\";s:6:\"4.6.22\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.zip\";s:8:\"4.6.22.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.2.zip\";s:8:\"4.6.23.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.23.1.zip\";s:6:\"4.6.24\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.zip\";s:8:\"4.6.24.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.2.zip\";s:8:\"4.6.25.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.25.1.zip\";s:6:\"4.6.26\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.zip\";s:8:\"4.6.26.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.2.zip\";s:7:\"4.6.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.3.1.zip\";s:7:\"4.6.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.4.1.zip\";s:7:\"4.6.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.5.1.zip\";s:7:\"4.6.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.6.1.zip\";s:7:\"4.6.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.1.zip\";s:7:\"4.6.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.8.1.zip\";s:7:\"4.6.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.9.1.zip\";s:3:\"4.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.zip\";s:7:\"4.7.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.0.2.zip\";s:7:\"4.7.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.1.1.zip\";s:7:\"4.7.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.2.1.zip\";s:7:\"4.7.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.3.1.zip\";s:7:\"4.7.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.4.1.zip\";s:3:\"4.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.zip\";s:7:\"4.8.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.0.2.zip\";s:7:\"4.8.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.1.1.zip\";s:7:\"4.8.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.2.1.zip\";s:7:\"4.9.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.1.zip\";s:7:\"4.9.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.2.zip\";s:7:\"4.9.0.4\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.4.zip\";s:5:\"4.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.zip\";s:7:\"4.9.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.2.zip\";s:8:\"4.9.10.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.10.1.zip\";s:8:\"4.9.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.11.1.zip\";s:8:\"4.9.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.12.1.zip\";s:8:\"4.9.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.13.1.zip\";s:8:\"4.9.14.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.14.1.zip\";s:7:\"4.9.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.2.1.zip\";s:5:\"4.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.zip\";s:7:\"4.9.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.1.zip\";s:7:\"4.9.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.3.zip\";s:7:\"4.9.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.4.1.zip\";s:7:\"4.9.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.5.1.zip\";s:7:\"4.9.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.6.1.zip\";s:7:\"4.9.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.7.1.zip\";s:7:\"4.9.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.8.1.zip\";s:7:\"4.9.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.9.1.zip\";s:5:\"5.0.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.zip\";s:7:\"5.0.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.1.zip\";s:7:\"5.0.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.3.zip\";s:7:\"5.0.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.1.zip\";s:7:\"5.0.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.2.zip\";s:5:\"5.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.zip\";s:7:\"5.0.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.2.zip\";s:7:\"5.0.2.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.3.zip\";s:5:\"5.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.zip\";s:7:\"5.0.3.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.2.zip\";s:7:\"5.0.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.3.zip\";s:7:\"5.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.1.zip\";s:7:\"5.1.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.2.zip\";s:7:\"5.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.1.zip\";s:7:\"5.1.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.2.zip\";s:7:\"5.1.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.1.zip\";s:7:\"5.1.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.2.zip\";s:5:\"5.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.zip\";s:7:\"5.1.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.1.zip\";s:5:\"5.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.zip\";s:7:\"5.1.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.1.zip\";s:5:\"5.1.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.zip\";s:7:\"5.1.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.1.zip\";s:5:\"5.1.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.zip\";s:7:\"5.1.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.1.zip\";s:6:\"5.10.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.0.zip\";s:6:\"5.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.1.zip\";s:5:\"5.2.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.zip\";s:7:\"5.2.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.1.zip\";s:5:\"5.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.zip\";s:7:\"5.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.1.zip\";s:7:\"5.2.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.2.zip\";s:5:\"5.3.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.zip\";s:7:\"5.3.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.1.zip\";s:5:\"5.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.zip\";s:7:\"5.3.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.1.zip\";s:7:\"5.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.2.zip\";s:5:\"5.3.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.zip\";s:7:\"5.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.1.zip\";s:7:\"5.3.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.2.zip\";s:5:\"5.4.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.zip\";s:7:\"5.4.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.1.zip\";s:7:\"5.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.2.zip\";s:7:\"5.4.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.3.zip\";s:5:\"5.5.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.zip\";s:7:\"5.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.1.zip\";s:7:\"5.5.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.2.zip\";s:5:\"5.6.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.6.0.zip\";s:5:\"5.7.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.0.zip\";s:5:\"5.7.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.1.zip\";s:5:\"5.8.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.0.zip\";s:5:\"5.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.1.zip\";s:5:\"5.8.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.2.zip\";s:5:\"5.9.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.0.zip\";s:5:\"5.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.1.zip\";s:5:\"5.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.2.zip\";s:5:\"trunk\";s:62:\"https://downloads.wordpress.org/plugin/the-events-calendar.zip\";}s:11:\"donate_link\";s:18:\"https://evnt.is/29\";s:7:\"banners\";a:2:{s:3:\"low\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=2257622\";s:4:\"high\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=2257622\";}}s:13:\"wordpress-seo\";a:25:{s:4:\"name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"17.5\";s:6:\"author\";s:43:\"<a href=\"https://yoa.st/1uk\">Team Yoast</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/joostdevalk\";s:12:\"contributors\";a:3:{s:5:\"yoast\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/yoast\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/2d6543ef6d3e1336c47d008809b87816?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Yoast\";}s:11:\"joostdevalk\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/joostdevalk\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/f08c3c3253bf14b5616b4db53cea6b78?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Joost de Valk\";}s:9:\"omarreiss\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/omarreiss\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/86aaa606a1904e7e0cf9857a663c376e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Omar Reiss\";}}s:8:\"requires\";s:3:\"5.6\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:6:\"5.6.20\";s:6:\"rating\";i:96;s:7:\"ratings\";a:5:{i:5;i:25765;i:4;i:620;i:3;i:175;i:2;i:125;i:1;i:722;}s:11:\"num_ratings\";i:27407;s:15:\"support_threads\";i:507;s:24:\"support_threads_resolved\";i:442;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2021-11-02 9:10am GMT\";s:5:\"added\";s:10:\"2010-10-11\";s:8:\"homepage\";s:18:\"https://yoa.st/1uj\";s:8:\"sections\";a:6:{s:11:\"description\";s:12841:\"<h3>Yoast SEO: el plugin SEO para WordPress #1</h3>\n<p>Desde 2008, Yoast SEO ha ayudado a millones de webs de todo el mundo a <strong>posicionarse más alto en los motores de búsqueda</strong>.</p>\n<p>La misión de Yoast es <strong>SEO para todo el mundo</strong>. Los usuarios de nuestro plugin van desde la panadería de la esquina hasta algunos de los sitios más populares del planeta.</p>\n<p>Yoast SEO Free contiene todo lo que necesitas para gestionar tu SEO, y el plugin <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a> y sus extensiones desbloquean incluso más herramientas y funcionalidad.</p>\n<h4>ADELÁNTATE A TU COMPETENCIA</h4>\n<p>Para estar arriba en el posicionamiento de los motores de búsqueda, tienes que ganar a la competencia. Necesitas tener una web mejor, más rápida y más sólida que las de las personas que venden o hacen el mismo tipo de cosas que tú.</p>\n<p>Yoast  SEO es el plugin SEO para WordPress más utilizado y ha ayudado a millones de personas como tú a avanzar y a estar en cabeza.</p>\n<h4>CUIDANDO TU SEO EN WORDPRESS</h4>\n<p>Yoast SEO está repleto de características, diseñadas para ayudar a los visitantes y motores de búsqueda para conseguir la mejor de tu web. Algunas de nuestras favoritas son:</p>\n<ul>\n<li>Mejoras técnicas de SEO automáticas, como las <strong>URLs canónicas</strong> y <strong>meta tags</strong>.</li>\n<li><strong>Mapas del sitio XML</strong> avanzados; que hacen más fácil que Google comprenda la estructura de tu sitio.</li>\n<li>Plantillas de título y descripción meta para <strong>mejorar tu marca</strong> y tener snippets consistentes en los resultados de búsqueda.</li>\n<li>Una integración en profundidad con Schema.org que <strong>aumentará tus oportunidades de conseguir resultados enriquecidos</strong> ayudando a los motores de búsqueda a comprender tu contenido.</li>\n<li>Control total sobre las <strong>migas de pan del sitio</strong>, para que los usuarios y los motores de búsqueda siempre sepan dónde están.</li>\n<li><strong>Tiempos de carga más rápidos</strong> para toda tu web, debido a un modo innovador de gestionar datos en WordPress.</li>\n<li><strong>[Premium]</strong> soporte por correo electrónico para nuestros usuarios de <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a>.</li>\n<li><strong>[Premium]</strong> la capacidad de ampliar Yoast SEO con las extensiones <a href=\"https://yoa.st/1uv\" rel=\"nofollow ugc\">News SEO</a>, <a href=\"https://yoa.st/1uw\" rel=\"nofollow ugc\">Video SEO</a>, <a href=\"https://yoa.st/1uu\" rel=\"nofollow ugc\">Local SEO</a> y <a href=\"https://yoa.st/3rh\" rel=\"nofollow ugc\">WooCommerce SEO</a>.</li>\n</ul>\n<h4>ESCRIBE CONTENIDO ROMPEDOR CON YOAST SEO</h4>\n<p>Sabemos que el contenido es el rey, es por eso que Yoast SEO es famoso por su <strong>análisis de legibilidad y su análisis SEO de primera calidad</strong>. Yoast SEO te da:</p>\n<ul>\n<li><strong>Análisis SEO</strong>: una herramienta de incalculable valor mientras escribes contenido para SEO con las frases clave correctas (objetivo) en mente.</li>\n<li><strong>Análisis de legibilidad</strong>: asegura que humanos y motores de búsqueda puedan leer y comprender tu contenido.</li>\n<li><strong>Compatibilidad total de idioma</strong> para: inglés, alemán, francés, neerlandés, español, italiano, ruso, indonesio, polaco, portugués, árabe, sueco, hebreo, húngaro, turco, checo, noruego, eslovaco y griego.</li>\n<li><strong>Una vista previa en Google</strong>, que muestra cómo se verán tus contenidos en los resultados de búsqueda. ¡Incluso en dispositivos móviles!</li>\n<li><strong>Innovadores bloques de Schema</strong> para el editor de bloques de WordPress, para que tu contenido de FAQ y guías prácticas pueda ser mostrado directamente en los resultados de búsqueda. Además de un bloque de migas de pan para guiar a tus usuarios.</li>\n<li><strong>[Premium] Bloques de enlazado interno</strong> para mejorar fácilmente la estructura de tu contenido. Añade fácilmente un <strong>bloque de tabla de contenidos</strong>, un <strong>bloque de enlaces relacionados</strong>, un bloque de  <strong>subpáginas</strong> o ¡el <strong>bloque de hermanos</strong>! Además, seguiremos añadiendo estos bloques fáciles de añadir para mejorar la estructura de tu sitio.</li>\n<li><strong>[Premium]</strong> Las vistas previas sociales para mostrar cómo se verá tu contenido en Twitter y Facebook. Plus: Plantillas de apariencia social para garantizar un aspecto consistente.</li>\n<li><strong>[Premium]</strong> La herramienta Insights que te muestra en lo que se enfoca tu texto. De esta forma, puedes mantener tu artículo en consonancia con tus frases clave.</li>\n<li><strong>[Premium]</strong> Optimiza tu contenido para sinónimos y frases clave relacionadas.</li>\n<li><strong>[Premium]</strong> Optimiza tu artículo para diferentes formas de palabras a partir de tus frases clave, como por ejemplo entre singular y plural. Pero también diferentes formas verbables, sinónimos y frases claves relacionadas. ¡Esto ayuda a tener contenido más natural!</li>\n<li><strong>[Premium]</strong> sugerencias automáticas de enlazado interno: escribe tu artículo y ¡obtén automáticamente sugerencias de entradas a las que enlazar!</li>\n<li><strong>[Premium]</strong> Un filtro de contenido huérfano para ¡detectar entradas que no tengan enlaces que apuntan hacia ellas.</li>\n<li><strong>[Premium]</strong> Ejercicios SEO para que trabajar en tu sitio sea tan fácil como ABC. ¡Estos flujos de trabajo de SEO pondrán tu sitio en forma en poco tiempo!</li>\n</ul>\n<h4>MANTÉN TU SITIO EN PERFECTAS CONDICIONES</h4>\n<p>Ya seas un emprendedor online, bloguero o creador de contenidos, un desarrollador, un experto en SEO (WordPress) o propietario de un negocio, Yoast SEO te ayuda a mantener tu web en perfecta forma:</p>\n<ul>\n<li>Ajusta el motor de tu web para que puedas trabajar en la creación de ¡gran contenido!</li>\n<li>Te ofrece las características de <strong>contenido esencial</strong> y <strong>enlazado interno</strong> para ayudarte a optimizar la estructura de tu sitio fácilmente.</li>\n<li>Traduce tu contenido a <strong>datos estructurados</strong> siempre que sea posible para ayudar a los motores de búsqueda a entender tu web.</li>\n<li>Te ayuda a gestionar tu equipo: con nuestros <strong>perfiles SEO</strong> puedes dar a los colegas acceso a secciones específicas del plugin Yoast SEO.</li>\n<li><strong>[Premium] Creación automática de redirecciones</strong> cuando cambian las URLs o cuando se borran páginas, y que ofrece herramientas para gestionar o crear redirecciones.</li>\n<li><strong>[Premium]</strong> mostrándote <strong>vistas previas sociales</strong> para gestionar la forma en la que tu página es compartida en redes sociales, como Facebook y Twitter.</li>\n</ul>\n<h4>CONFÍA EN LOS EXPERTOS</h4>\n<p>Yoast funciona gracias a un equipo de expertos desarrolladores, probadores, arquitectos de software y consultores SEO. Trabajan constantemente para estar a la última en SEO para WordPress, y para mejorar el plugin en cada versión.</p>\n<p>Yoast SEO es el <strong>único plugin SEO para WordPress creado por expertos SEO conocidos mundialmente</strong>.</p>\n<h3>CONSIGUE SOPORTE PREMIUM</h3>\n<p>El equipo de Yoast ofrece soporte normal en los foros de WordPress.org. Pero esperamos que comprendas que priorizamos a los clientes premium. Este soporte por correo electrónico persona a persona está disponible para quienes haya comprado Yoast SEO Premium.</p>\n<p>¿Sabías que <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a> contiene un montón de características adicionales?:</p>\n<ul>\n<li>Un <strong>gestor de redirecciones</strong> que evita errores de  «404: página no encontrada»</li>\n<li>Optimiza sin preocuparte sobre la sobre optimización con el <strong>reconocimiento inteligente de palabras</strong> disponible en varios idiomas.</li>\n<li><strong>Bloques de enlazado interno</strong> para estructurar fácilmente tu sitio.</li>\n<li><strong>Sugerencias de enlazado interno</strong> mientras escribes.</li>\n<li>Previsualiza tu contenido para ver cómo se verá en los resultados de búsqueda y cuando se comparta en los medios sociales usando la <strong>vista previa en Google</strong> y la  <strong>vista previa social</strong>.</li>\n<li><strong>Comprobaciones fundamentales del contenido</strong> para dirigir a los motores de búsqueda a tus páginas más importantes.</li>\n<li>Conecta Yoast SEO a Zapier para <strong>crear fácilmente zaps que compartan instantáneamente tus entradas publicadas</strong> con más de 2.000 destinos como Twitter, Facebook y muchos más.</li>\n</ul>\n<p>¡Si eres concienzudo con el SEO de tu WordPress, instala el <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">plugin Yoast SEO Premium</a>! <strong>¡Cuesta muy poco, ahorra un montón de tiempo!</strong></p>\n<h4>NUESTRAS EXTENSIONES PARA MEJORAR AÚN  MÁS TU SEO EN WORDPRESS</h4>\n<p>Echa un vistazo a estas extensiones SEO de Yoast:</p>\n<ul>\n<li><strong><a href=\"https://yoa.st/1uu\" rel=\"nofollow ugc\">Yoast Local SEO</a></strong> optimiza tu web para una audiencia local.</li>\n<li><strong><a href=\"https://yoa.st/1uw\" rel=\"nofollow ugc\">Yoast Video SEO</a></strong> para asegurar que Google entiende de qué va tu vídeo, aumentando las posibilidades de posicionamiento en los resultados.</li>\n<li><strong><a href=\"https://yoa.st/1uv\" rel=\"nofollow ugc\">Yoast News SEO</a></strong> para noticias de webs que quieran mejorar su visibilidad y rendimiento en Google News.</li>\n<li><strong><a href=\"https://yoa.st/3rh\" rel=\"nofollow ugc\">WooCommerce SEO</a></strong> para todas las tiendas online que quieran tener un mejor rendimiento en los resultados de búsqueda y en los medios sociales.</li>\n</ul>\n<p>Estas extensiones funcionan genial con la versión gratuita de Yoast SEO. Por supuesto, las extensiones premium también incluyen soporte 24/7.</p>\n<p>Ah, y no lo olvides: nuestra <strong><a href=\"https://yoa.st/3ri\" rel=\"nofollow ugc\">Yoast Academy</a></strong> es para todos los emprendedores, blogueros y cualquier otro que quiera aprender más sobre la optimización de webs, la mejora de su SEO WordPress y ¡llevar a otro nivel su contenido online!</p>\n<h3>INTEGRACIONES</h3>\n<p>Yoast SEO se integra fácilmente con montones de temas y plugins. Funcionamos particularmente bien con:</p>\n<ul>\n<li>El <a href=\"https://wordpress.org/support/article/wordpress-editor/\">editor de bloques de WordPress</a> (o editor ‘Gutenberg’).</li>\n<li>El plugin oficial de <a href=\"https://wordpress.org/plugins/amp/\">AMP</a>, que cambia tus plantillas para usar el formato ‘AMP’ HTML.</li>\n<li>El plugin de Google <a href=\"https://es.wordpress.org/plugins/web-stories/\" rel=\"nofollow ugc\">Web Stories</a> que te ayuda a crear «<a href=\"https://amp.dev/about/stories/\" rel=\"nofollow ugc\">historias web</a>».</li>\n<li>El plugin <a href=\"https://es.wordpress.org/plugins/advanced-custom-fields/\" rel=\"nofollow ugc\">Advanced Custom Fields</a>, cuando también activas el plugin <a href=\"https://es.wordpress.org/plugins/acf-content-analysis-for-yoast-seo/\" rel=\"nofollow ugc\">ACF Content Analysis for Yoast SEO</a>.</li>\n<li>El maquetador web <a href=\"https://wordpress.org/plugins/elementor/\">Elementor</a>.</li>\n<li><a href=\"https://zapier.com/apps/yoast-seo/integrations\" rel=\"nofollow ugc\">Zapier</a>, que te ayuda a automatizar tu flujo de publicación.</li>\n<li><a href=\"https://es.wordpress.org/plugins/wp-search-with-algolia/\" rel=\"nofollow ugc\">Algolia</a>, integración para mejorar la calidad de la búsqueda de tu sitio.</li>\n</ul>\n<h3>INFORMES DE FALLOS</h3>\n<p>¿Quieres informar de un fallo en Yoast SEO? Mejor hacerlo en el <a href=\"https://github.com/Yoast/wordpress-seo\" rel=\"nofollow ugc\">repositorio en GitHub</a> de WordPress SEO. Por favor, tén en cuenta que GitHub no es un foro de soporte y los problemas se cerrarán si no reúnen los requisitos de información de fallos.</p>\n<h3>LEER MÁS</h3>\n<p>¿Quieres más informaicón sobre optimización en motores de búsqueda y Yoast SEO? Echa un vistazo a:</p>\n<ul>\n<li>La página oficial del <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">plugin Yoast SEO</a>.</li>\n<li>El <a href=\"https://yoa.st/1va\" rel=\"nofollow ugc\">centro de ayuda de Yoast SEO</a>.</li>\n<li><a href=\"https://yoa.st/1v6\" rel=\"nofollow ugc\">WordPress SEO &#8211; La guía definitiva de Yoast</a>.</li>\n<li>Otros <a href=\"https://yoa.st/1v9\" rel=\"nofollow ugc\">plugins WordPress</a> del equipo de Yoast.</li>\n<li>También, sigue a Yoast en <a href=\"https://facebook.com/yoast\" rel=\"nofollow ugc\">Facebook</a>, <a href=\"https://www.instagram.com/yoast/\" rel=\"nofollow ugc\">Instagram</a> y <a href=\"https://twitter.com/yoast\" rel=\"nofollow ugc\">Twitter</a>.</li>\n</ul>\n\";s:12:\"installation\";s:1129:\"<p>Empezar con Yoast SEO consiste en solo dos pasos: instalación y configuración del plugin. Toast SEO está diseñado para funcionar con las necesidades específicas de tu sitio, por lo que no olvides ir al asistente de configuración de Yoast SEO, ¡como se explica en el paso «después de la activación»!</p>\n<h3>INSTALAR YOAST SEO DESDE WORDPRESS</h3>\n<ol>\n<li>Visita la página de plugins en tu escritorio y selecciona «Añadir nuevo»;</li>\n<li>Busca «Yoast SEO»;</li>\n<li>Activa Yoast SEO desde tu página de plugins;</li>\n<li>Ve a «después de la activación», a continuación.</li>\n</ol>\n<h3>INSTALAR YOAST SEO MANUALMENTE</h3>\n<ol>\n<li>Sube la carpeta «wordpress-seo» al directorio «/wp-content/plugins/»;</li>\n<li>Activa el plugin Yoast SEO desde el menú «Plugins» en WordPress;</li>\n<li>Ve a «después de la activación», a continuación.</li>\n</ol>\n<h3>DESPUÉS DE LA ACTIVACIÓN</h3>\n<ol>\n<li>Deberías ver el asistente de configuración de Yoast SEO (un aviso para empezar).</li>\n<li>Ve al asistente de configuración y configura el plugin para tu sitio;</li>\n<li>¡Ya has terminado!</li>\n</ol>\n\";s:3:\"faq\";s:6384:\"\n<dt id=\'how%20do%20the%20xml%20sitemaps%20in%20the%20yoast%20seo%20plugin%20work%3F\'>\n¿Cómo funcionan los mapas del sitio XML en el plugin Yoast SEO?\n</h4>\n<p>\n<p>Tener un mapa del sitio XML puede ser beneficioso para SEO, ya que Google puede recuperar muy rápidamente páginas esenciales de una web, incluso si los enlaces internos de un sitio no son perfectos.<br />\nEl índice del mapa del sitio y los mapas del sitio individuales son actualizados automáticamente cuando añades o eliminas contenidos e incluirán los tipos de contenido que quieras que el motor de búsqueda indexe. Los tipos de contenido marcados como «noindex» no aparecerán en el mapa del sitio. <a href=\"https://yoa.st/3qt\" rel=\"nofollow ugc\">Aprende más sobre los mapas del sitio XML</a>.</p>\n</p>\n<dt id=\'how%20can%20i%20add%20my%20website%20to%20google%20search%20console%3F\'>\n¿Cómo puedo añadir mi web a la consola de búsqueda de Google?\n</h4>\n<p>\n<p>Es muy sencillo añadir tu web a Google Search Console.<br />\n1. Crea una cuenta en Google Search Console y accede a tu cuenta.<br />\n2. Haz clic en «Añadir una propiedad» en el desplegable de búsqueda.<br />\n3. Introduce la URL de tu web en la casilla y haz clic en «Continuar».<br />\n4. Haz clic en la flecha junto a «Etiqueta HTML» para ampliar la opción.<br />\n5. Copia la etiqueta meta.<br />\n6. Accede a tu web WordPress.<br />\n7. Haz clic en «SEO» en el escritorio.<br />\n8. Haz clic en «General».<br />\n9. Haz clic en la pestaña «Herramientas del webmaster».<br />\n10. Pega el código en el campo de Google y haz clic en «Guardar los cambios».<br />\n11. Vuelve a Google Search Console y haz clic en «Verificar».</p>\n<p>Si quieres más detalles de los pasos, por favor, visita <a href=\"https://yoa.st/3qu\" rel=\"nofollow ugc\">nuestro artículo en yoast.com/help/</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20implement%20yoast%20seo%20breadcrumbs%3F\'>\n¿Cómo implemento migas de pan de Yoast SEO?\n</h4>\n<p>\n<p>Lo siguientes pasos son una solución temporar, ya que las ediciones manuales hechas en los archivos del tema podrán sobrescribirse con futuras actualizaciones del tema. Por favor, contacta con el desarrollador del tema para una solución permanente. Hemos escrito un artículo sobre la <a href=\"https://yoa.st/3qv\" rel=\"nofollow ugc\">importancia de las migas de pan para SEO</a>.</p>\n<p>Para implementar la función «<a href=\"https://yoa.st/3qw\" rel=\"nofollow ugc\">[breadcrumbs]</a>» en Yoast SEO, tendrás que editar tu tema. Recomendamos que, antes de cualquier edición de los archivos del tema, se haga una copia de seguridad. Tu proveedor de alojamiento puede ayudarte a hacer una copia de seguridad.<br />\nCopia el siguiente código en tu tema, donde quieras que estén las migas de pan. Si no estás seguro, tendrás que experimentar con la colocación:</p>\n<pre><code>&lt;?php\nif ( function_exists( \'yoast_breadcrumb\' ) ) {\n    yoast_breadcrumb( \'&lt;p id=\"breadcrumbs\"&gt;\',\'&lt;/p&gt;\' );\n}\n?&gt;\n</code></pre>\n<p>Los lugares comunes donde podrías colocar tus migas de pan están dentro de tu archivo <code>single.php</code> y/o <code>page.php</code>, justo encima del título de la página. Otra opción que lo hace realmente fácil en algunos temas es simplemente pegando el código al final del archivo <code>header.php</code>.</p>\n<p>En la mayoría de los temas que no son de WooTheme, este snippet de código no debería ser añadido a tu archivo <code>functions.php</code>.<br />\nComo alternativa, puedes añadir manualmente el shortcode de las migas de pan a las entradas o páginas individuales: <code>[wpseo_breadcrumb]</code></p>\n<p>Si necesitas más detalles o una guía paso a paso, lee nuestra <a href=\"https://yoa.st/3qx\" rel=\"nofollow ugc\">guía de implementación de las migas de pan de Yoast SEO</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20noindex%20urls%3F\'>\n¿Cómo hago las URLs «noindex»?\n</h4>\n<p>\n<p>Yoast SEO proporciona múltiples opciones para configurar una URL o un grupo de URLs para «noindex». <a href=\"https://yoa.st/3qy/\" rel=\"nofollow ugc\">Lee más sobre cómo hacer esto en esta guía</a>.</p>\n</p>\n<dt id=\'google%20shows%20the%20wrong%20description%2C%20how%20do%20i%20fix%20this%3F\'>\nGoogle muestra la descripción errónea, ¿cómo puedo corregirlo?\n</h4>\n<p>\n<p>Si has creado buenas meta description para tus entradas del blog, nada es más molesto que Google muestre para tu sitio una descripción completamente distinta en el snippet de resultados de búsqueda.</p>\n<p>Las posibles causas podrían ser:<br />\n1. descripción errónea en el código<br />\n2. la caché de Google es obsoleta<br />\n3. manupilación del término de búsqueda<br />\n4. Google ha ignorado la meta description</p>\n<p>Aquí puedes <a href=\"https://yoa.st/3qz\" rel=\"nofollow ugc\">leer más sobre cómo resolver el problema con la descripción errónea</a>.</p>\n</p>\n<dt id=\'how%20often%20is%20yoast%20seo%20updated%3F\'>\n¿Con qué frecuencia se actualiza Yoast SEO?\n</h4>\n<p>\n<p>Yoast SEO es actualizado cada dos semanas. Si quieres saber porqué, por favor, lee <a href=\"https://yoa.st/3q-\" rel=\"nofollow ugc\">esta entrada sobre ¡porqué actualizamos cada dos semanas!</a></p>\n</p>\n<dt id=\'how%20do%20i%20get%20support%3F\'>\n¿Cómo obtengo soporte?\n</h4>\n<p>\n<p>Como nuestro plugin gratuito es usado por millones de personas en todo el mundo, no podemos ofrecerte soporte individual. Si tienes problemas con el plugin Yoast SEO para WordPress, puedes obtener ayuda en el foro de soporte de <a href=\"https://wordpress.org/support/plugin/wordpress-seo/\">wordpress.org</a> o revisando nuestro centro de ayuda en <a href=\"https://yoa.st/3r1\" rel=\"nofollow ugc\">yoast.com/help/</a>.</p>\n<p>Los plugins que compras en Yoast son denominados «plugins premium» (incluso si su nombre no es «premium») e incluyen un año completo de actualizaciones y soporte premium. Esto significa que puedes contactar con nuestro equipo de soporte si tienes cualquier pregunta respecto a ese plugin.</p>\n<p><a href=\"https://yoa.st/3r2\" rel=\"nofollow ugc\">Lee más sobre cómo obtener soporte</a></p>\n</p>\n<dt id=\'i%20have%20a%20different%20question%20than%20listed%20here\'>\nTengo una pregunta diferente de las que aparecen aquí\n</h4>\n<p>\n<p>Los más probable es que tu pregunta haya sido respondida en nuestro centro de ayuda: <a href=\"https://yoa.st/1va\" rel=\"nofollow ugc\">yoast.com/help/</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:3370:\"<h4>17.5</h4>\n<p>Fecha de lanzamiento: 2 de noviembre de 2021</p>\n<p>¡Saluda a Yoast SEO 17.5! O quizá «γεια» encaje mejor, ya que esta versión introduce la compatibilidad de legibilidad en griego. Además: también podrás encontrar de nuevo los separadores de título « | » y « ~ ». ¡Feliz actualización! ¡Lee más sobre las novedades de Yoast SEO 17.5 en <a href=\"https://yoa.st/release-17-5\" rel=\"nofollow ugc\">nuestra entrada de la versión en inglés</a> o <a href=\"https://yoa.st/release-17-5-spanish\" rel=\"nofollow ugc\">nuestra entrada de la versión en español</a>!</p>\n<p>Mejoras:</p>\n<ul>\n<li>Completa el análisis de legibilidad para el griego añadiendo las palabras de transición, los inicios de frase y las evaluaciones de las voces pasivas.</li>\n<li>Mejora la detección de palabras clave para el griego añadiendo una lista de palabras de función.</li>\n<li>Reduce el relleno derecho de los botones contraíbles la barra lateral para coincidir con el nuevo estilo del editor de bloques.</li>\n<li>Restaura los separadores <code>|</code> y <code>~</code>.</li>\n<li>Reduce el relleno derecho de los botones contraíbles la barra lateral para coincidir con el nuevo estilo de Gutenberg.</li>\n</ul>\n<p>Soluciones a fallos:</p>\n<ul>\n<li>Corrige un fallo por el que el botón de resaltado de análisis era visible en las etiquetas, las categorías y las taxonomías personalizadas, a pesar de que no admitimos el resaltado para esos tipos.</li>\n<li>Corrige un fallo por el que los enlaces a elementos de la misma página se identificaban incorrectamente como enlaces a otras páginas, llevando a un resultado incorrecto en la evaluación de la frase clave de los enlaces.</li>\n</ul>\n<h4>17.4</h4>\n<p>Fecha de lanzamiento: 19 de octubre de 2021</p>\n<p>¡Yoast SEO 17.4 está disponible hoy! Esta versión viene con varias correcciones y mejoras para ayudar al rendimiento de la base de datos en sitios grandes mediante la limpieza de los datos y la optimización de la recuperación. ¡Feliz actualización! ¡Lee más sobre las novedades de Yoast SEO 17.4 en <a href=\"https://yoast.com/es/yoast-seo-17-4/\" rel=\"nofollow ugc\">nuestra entrada de la versión</a>!</p>\n<p>Mejoras:</p>\n<ul>\n<li>Mejora dos consultas usadas para determinar si un sitio ha sido procesado completamente o no, usando nuestra optimización de datos SEO. Esto debería evitar posibles ralentizaciones en sitios extremadamente grandes.</li>\n</ul>\n<p>Soluciones a fallos:</p>\n<ul>\n<li>Corrige un fallo por el que la propiedad <code>url</code> en el schema de la página de búsqueda podría estar vacío.</li>\n<li>Corrige un fallo por el que se mostraba una etiqueta canonical duplicada en las historias web creadas con el plugin Web Stories. Gracias a <a href=\"https://github.com/swissspidy\" rel=\"nofollow ugc\">swissspidey</a>.</li>\n<li>Corrige un fallo por el que podía producirse una condición de carrera que causaba que las reglas de reescritura se purgaran en cada solicitud de página cuando se usaba una caché persistente como Redis. Esto puede acelerar los tiempos de carga de tu sitio si está usando la caché persistente.</li>\n</ul>\n<h4>Earlier versions</h4>\n<p>Para ver el registro de cambios de versiones anteriores, por favor, revisa el <a href=\"https://yoa.st/yoast-seo-changelog\" rel=\"nofollow ugc\">registro de cambios de Yoast SEO en yoast.com</a></p>\n\";s:11:\"screenshots\";s:1959:\"<ol><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2363699\" alt=\"La caja meta general del plugin Yoast SEO. Verás esto en la edición de páginas, entradas y tipos de contenido personalizado.\"></a><p>La caja meta general del plugin Yoast SEO. Verás esto en la edición de páginas, entradas y tipos de contenido personalizado.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2363699\" alt=\"Ejemplo de la funcionalidad de análisis SEO.\"></a><p>Ejemplo de la funcionalidad de análisis SEO.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2363699\" alt=\"Ejemplo de la funcionalidad de análisis de legibilidad.\"></a><p>Ejemplo de la funcionalidad de análisis de legibilidad.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2363699\" alt=\"Revisión de problemas SEO globales y posibles mejoras\"></a><p>Revisión de problemas SEO globales y posibles mejoras</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2363699\" alt=\"Controla qué características quieres usar.\"></a><p>Controla qué características quieres usar.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2363699\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2363699\" alt=\"Importa fácilmente datos SEO de otros plugins SEO como All in One SEO pack, HeadSpace2 SEO y wpSEO.de.\"></a><p>Importa fácilmente datos SEO de otros plugins SEO como All in One SEO pack, HeadSpace2 SEO y wpSEO.de.</p></li></ol>\";s:7:\"reviews\";s:14737:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very useful</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/davizpixel\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/95e721c164702dcf1a3fb931f1f70e47?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/95e721c164702dcf1a3fb931f1f70e47?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/davizpixel\" class=\"reviewer-name\">davizpixel</a> el <span class=\"review-date\">noviembre 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This plugin is very usefu and easy to confgure. Recommened 100%</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">An absolute nightmare.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/ingevdb\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ffa2c2da57185d2e6d3cca5a66f03a53?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ffa2c2da57185d2e6d3cca5a66f03a53?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/ingevdb\" class=\"reviewer-name\">ingevdb</a> el <span class=\"review-date\">noviembre 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This is a FREE but DANGEROUS plugin! I would not recommend to use it, as it might unintenionally stop google indexing your website.\n\nYoast came with wordpress install. After I got my website up and running, uploaded the sitemap to google, it was waiting for months for google to index my site.\n\nI got 32 errors and 70 noindex. That\'s strange I thought, I have everything set to be indexed on yoast. So I asked google to crawl my site again. And waited. But still the results were the same.\n\nLooking in the source code, it shows that the Yoast plugin, somehow puts a noindex in regions and listings of my page. \n\nIf I switch yoast off, the noindex disapears. I did contact support and they asked me to clone the site, switch off all plugins and change the theme. But still Yoast keeps putting a noindex in. Have not heared back from them yet.\n\nYoast is heavily advertising as being the best SEO plugin on wordpress. But I would not touch it. I switched it off and will deinstall it.\n\n</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very Useful!!!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/juppalsingh\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/10b4bab64495431f15f84957c632c89c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/10b4bab64495431f15f84957c632c89c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/juppalsingh\" class=\"reviewer-name\">juppalsingh</a> el <span class=\"review-date\">octubre 29, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I\'ve used this tool for my several clients websites and it always helps managing the important aspects of SEO parts. I usually prefer to focus on the meta tags using this tool but they also have another options to make your site SEO friendly which is a good part. So, this tool is good if you want to make your site SEO friendly.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">love this plugin for many years</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/solokkhz\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/248b7d29277e924798536d513dbcbc36?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/248b7d29277e924798536d513dbcbc36?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/solokkhz\" class=\"reviewer-name\">Shlomo Man <small>(solokkhz)</small></a> el <span class=\"review-date\">octubre 24, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I work with the Yoast SEO plugin for as long as I build websites. love the fact that they fixed it so it works with elementor and other page builders. </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good Plugin Option for SEO</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/wyattsarmasagdesign\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/bec8cdd11c54b02a15edad15a621f1a3?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/bec8cdd11c54b02a15edad15a621f1a3?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/wyattsarmasagdesign\" class=\"reviewer-name\">wyattsarmasagdesign</a> el <span class=\"review-date\">octubre 21, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I\'m new to Yoast, but really like this SEO Plugin. Easy to use and great results.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Muy buen Complemento</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/sirtech237\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f4c81de3696416271084283a8ccbc1ca?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f4c81de3696416271084283a8ccbc1ca?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/sirtech237\" class=\"reviewer-name\">sirtech237</a> el <span class=\"review-date\">octubre 21, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Un excelente apoyo para mejorar la visibilidad y el posicionamiento</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Amazing Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/abramo\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/443ec0583e7d0a4219ee4039a822d2e0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/443ec0583e7d0a4219ee4039a822d2e0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/abramo\" class=\"reviewer-name\">abramo</a> el <span class=\"review-date\">octubre 20, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I use this plugin in several websites, very useful</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/galroz\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d9758859e39d2980af40d86dc5035c2a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d9758859e39d2980af40d86dc5035c2a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/galroz\" class=\"reviewer-name\">galroz</a> el <span class=\"review-date\">octubre 18, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">It’s a good plugin for website SEO. The free plan is enough for my needs. Thanks!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">xml problem</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/zla520\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/35784cc498f670732d04752380112097?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/35784cc498f670732d04752380112097?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/zla520\" class=\"reviewer-name\">zla520</a> el <span class=\"review-date\">octubre 14, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I encountered a problem. When accessing the site map, it takes about 10 seconds for yoast to generate the xml file in real time. If there are several different xml files, it will slow down several times, so it is very slow, causing the search engine to fail to include it. I suggest to generate xml directly in the website directory and save it, so that the search engine will open very quickly next time.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good seo plugin with reports</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/danielle7719\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6993cd3a409e39af44ce7eb7756e2197?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6993cd3a409e39af44ce7eb7756e2197?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/danielle7719\" class=\"reviewer-name\">danielle7719</a> el <span class=\"review-date\">octubre 12, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Good seo plugin with reports.</div>\n</div>\n\";}s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.5.zip\";s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2363699\";s:7:\"caption\";s:127:\"La caja meta general del plugin Yoast SEO. Verás esto en la edición de páginas, entradas y tipos de contenido personalizado.\";}i:2;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2363699\";s:7:\"caption\";s:45:\"Ejemplo de la funcionalidad de análisis SEO.\";}i:3;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2363699\";s:7:\"caption\";s:56:\"Ejemplo de la funcionalidad de análisis de legibilidad.\";}i:4;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2363699\";s:7:\"caption\";s:54:\"Revisión de problemas SEO globales y posibles mejoras\";}i:5;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2363699\";s:7:\"caption\";s:44:\"Controla qué características quieres usar.\";}i:6;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2363699\";s:7:\"caption\";s:103:\"Importa fácilmente datos SEO de otros plugins SEO como All in One SEO pack, HeadSpace2 SEO y wpSEO.de.\";}}s:4:\"tags\";a:5:{s:16:\"content-analysis\";s:16:\"Content analysis\";s:11:\"readability\";s:11:\"Readability\";s:6:\"schema\";s:6:\"schema\";s:3:\"seo\";s:3:\"seo\";s:11:\"xml-sitemap\";s:11:\"xml sitemap\";}s:8:\"versions\";a:78:{s:4:\"12.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.0.zip\";s:4:\"12.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.1.zip\";s:4:\"12.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.2.zip\";s:4:\"12.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.3.zip\";s:4:\"12.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.4.zip\";s:4:\"12.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.5.zip\";s:6:\"12.5.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.5.1.zip\";s:4:\"12.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.6.zip\";s:6:\"12.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.6.1.zip\";s:6:\"12.6.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.6.2.zip\";s:4:\"12.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.7.zip\";s:6:\"12.7.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.7.1.zip\";s:4:\"12.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.8.zip\";s:6:\"12.8.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.8.1.zip\";s:4:\"12.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.9.zip\";s:6:\"12.9.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.12.9.1.zip\";s:4:\"13.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.0.zip\";s:4:\"13.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.1.zip\";s:4:\"13.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.2.zip\";s:4:\"13.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.3.zip\";s:4:\"13.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.4.zip\";s:6:\"13.4.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.4.1.zip\";s:4:\"13.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.13.5.zip\";s:4:\"14.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.0.zip\";s:6:\"14.0.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.0.1.zip\";s:6:\"14.0.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.0.2.zip\";s:6:\"14.0.3\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.0.3.zip\";s:6:\"14.0.4\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.0.4.zip\";s:4:\"14.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.1.zip\";s:4:\"14.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.2.zip\";s:4:\"14.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.3.zip\";s:4:\"14.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.4.zip\";s:6:\"14.4.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.4.1.zip\";s:4:\"14.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.5.zip\";s:4:\"14.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.6.zip\";s:6:\"14.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.6.1.zip\";s:4:\"14.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.7.zip\";s:4:\"14.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.8.zip\";s:6:\"14.8.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.8.1.zip\";s:4:\"14.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.14.9.zip\";s:4:\"15.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.0.zip\";s:4:\"15.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.1.zip\";s:6:\"15.1.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.1.1.zip\";s:4:\"15.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.2.zip\";s:6:\"15.2.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.2.1.zip\";s:4:\"15.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.3.zip\";s:4:\"15.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.4.zip\";s:4:\"15.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.5.zip\";s:4:\"15.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.6.zip\";s:6:\"15.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.6.1.zip\";s:6:\"15.6.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.6.2.zip\";s:4:\"15.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.7.zip\";s:4:\"15.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.8.zip\";s:4:\"15.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.9.zip\";s:6:\"15.9.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.9.1.zip\";s:6:\"15.9.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.15.9.2.zip\";s:4:\"16.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.0.zip\";s:6:\"16.0.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.0.1.zip\";s:6:\"16.0.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.0.2.zip\";s:4:\"16.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.1.zip\";s:6:\"16.1.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.1.1.zip\";s:4:\"16.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.2.zip\";s:4:\"16.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.3.zip\";s:4:\"16.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.4.zip\";s:4:\"16.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.5.zip\";s:4:\"16.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.6.zip\";s:6:\"16.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.6.1.zip\";s:4:\"16.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.7.zip\";s:4:\"16.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.8.zip\";s:4:\"16.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.16.9.zip\";s:4:\"17.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.0.zip\";s:4:\"17.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.1.zip\";s:4:\"17.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.2.zip\";s:6:\"17.2.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.2.1.zip\";s:4:\"17.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.3.zip\";s:4:\"17.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.4.zip\";s:4:\"17.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.17.5.zip\";s:5:\"trunk\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";}s:11:\"donate_link\";s:18:\"https://yoa.st/1up\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";s:4:\"high\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";}}s:6:\"leadin\";a:25:{s:4:\"name\";s:70:\"HubSpot &#8211; CRM, Email Marketing, Live Chat, Forms &amp; Analytics\";s:4:\"slug\";s:6:\"leadin\";s:7:\"version\";s:7:\"8.4.329\";s:6:\"author\";s:59:\"<a href=\"http://hubspot.com/products/wordpress\">HubSpot</a>\";s:14:\"author_profile\";s:41:\"https://profiles.wordpress.org/hubspotdev\";s:12:\"contributors\";a:2:{s:10:\"hubspotdev\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/hubspotdev\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b0fc5d064b5de562cd2c4da8f2949488?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"HubSpot\";}s:6:\"leadin\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/leadin\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e01bb710319d405b425ca83629d9df92?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Leadin\";}}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:3:\"5.6\";s:6:\"rating\";i:88;s:7:\"ratings\";a:5:{i:5;i:118;i:4;i:12;i:3;i:3;i:2;i:5;i:1;i:13;}s:11:\"num_ratings\";i:151;s:15:\"support_threads\";i:4;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:200000;s:12:\"last_updated\";s:21:\"2021-10-26 2:55pm GMT\";s:5:\"added\";s:10:\"2014-03-12\";s:8:\"homepage\";s:45:\"http://www.hubspot.com/integrations/wordpress\";s:8:\"sections\";a:6:{s:11:\"description\";s:8485:\"<p>THE MOST POWERFUL &amp; EASY TO USE CONTACT MANAGEMENT (CRM), EMAIL MARKETING, LIVE CHAT, FORMS &amp; ANALYTICS PLUGIN</p>\n<p><a href=\"https://www.hubspot.com/products/wordpress?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot</a> enables you to grow your business better. It helps turn visitors into leads, nurture them into customers, and measure your business growth.</p>\n<p>With HubSpot’s free plugin you can easily:</p>\n<ul>\n<li>Engage visitors with <a href=\"https://www.hubspot.com/products/crm/live-chat?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">live chat and chatbots</a>, and convert leads with forms &amp; popups.</li>\n<li>Build beautiful, responsive <a href=\"https://www.hubspot.com/products/marketing/email?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">email newsletters</a> inside WordPress, and nurture your leads with marketing automation campaigns.</li>\n<li>Manage your entire contact database with HubSpot’s free <a href=\"https://www.hubspot.com/products/crm?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">CRM</a>, and group contacts together with the built-in list builder.</li>\n<li>Measure your business growth in real-time with easy-to-understand analytics dashboards.</li>\n</ul>\n<p>What’s included in HubSpot’s free WordPress plugin:</p>\n<p><strong>CRM &amp; CONTACT MANAGEMENT PLATFORM</strong></p>\n<p>Your website forms will automatically sync with your HubSpot CRM so you can easily manage your contacts, segment them into lists, and see every interaction they&#8217;ve had with your website. This plugin creates &amp; updates each contact record with a unified timeline of the contact’s page views, live chat conversations, form submissions, and more.</p>\n<p><strong>EMAIL NEWSLETTER &amp; MARKETING AUTOMATION</strong></p>\n<p>Build beautiful, responsive newsletters to send to your contact database with HubSpot’s easy-to-use, <a href=\"https://www.hubspot.com/products/marketing/email?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">drag and drop email builder</a>. Send an email automation anytime someone fills out a form or engages with your live chat &amp; chatbots.</p>\n<p>Don’t want to have to design emails yourself? HubSpot comes with 20+ pre-designed email templates so all you have to do is add your content and press send.</p>\n<p>With HubSpot&#8217;s email marketing software, you’re able to personalize your messaging and start tailoring content for each of your subscribers. Plus, with A/B testing and email tracking, you can go a step further and improve the open rate and click rate of each campaign.</p>\n<p>All emails are automatically logged in your customer relationship management (CRM) software and include reporting for opens and clicks so you can measure each email&#8217;s engagement.</p>\n<p><strong>FORMS &amp; POPUPS</strong></p>\n<p>Create beautiful <a href=\"https://www.hubspot.com/products/marketing/forms?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">forms and popups</a> on your website in minutes using the intuitive drag and drop builder. Choose which pages you want your popups displayed on with HubSpot’s advanced filtering based on your visitors’ behaviors.</p>\n<p>Rather stick with your existing forms and popup plugin? That’s fine too! HubSpot integrates with most WordPress form builders, form creators, and popup builders out-of-the-box so you don’t have to worry about a thing.</p>\n<p>HubSpot is a dynamic form builder and can be used to create nearly any type of form — such as an announcement popup, banner bar, conditional logic form, contact form, custom form, donation form, email form, exit intent popup form, event form, feedback form, mobile popup, newsletter form, order form, payment form, popup form, quiz form, quote form, signature form, signup form, star rating form, sticky bar, survey popup, web form, and more!</p>\n<p><strong>LIVE CHAT &amp; CHATBOTS</strong></p>\n<p>Add free <a href=\"https://www.hubspot.com/products/crm/live-chat?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">live chat</a> to your website and easily engage &amp; help your site visitors. Add 24/7 <a href=\"https://www.hubspot.com/products/crm/live-chat?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">chatbots</a> to your website to help automate lead capture, lead generation, lead management and provide live support. Now you can help your visitors while you sleep — the power of WordPress live chat!!</p>\n<p><strong>BUILT-IN ANALYTICS &amp; DASHBOARDS</strong></p>\n<p>Built-in marketing analytics (email analytics, traffic analytics, and website analytics) make it easy to understand which sales and marketing actions are driving the most success… and which ones you need to fix. Quickly see how your forms, popups, live chat &amp; chatbots, email marketing, and sales follow-ups are helping grow your business.</p>\n<p>Why install analytics from another app when you can get built-in WordPress analytics? With HubSpot, you can view a unified view of your site&#8217;s performance in an easy-to-understand analytics dashboard — all without leaving WordPress. Dashboards are customizable, so you can surface the most relevant information to make data-driven decisions for your unique business.</p>\n<p><strong>SEAMLESS INTEGRATIONS</strong></p>\n<p>Happy with the tools you’re using? Now you can easily integrate HubSpot with over <a href=\"https://ecosystem.hubspot.com/marketplace/apps?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">400 native integrations</a> including:<br />\n&#8211; Analytics / Advertising / Social Media Software: Adroll, Facebook Ads, Facebook Messenger, Google Ads, Google Analytics, Hotjar, Instagram Ads, Linkedin Ads, Twitter, WhatsApp, YouTube<br />\n&#8211; Communications / Design / Integrations: Canva, Gutenberg Blocks, HelloSign, Integromat, Slack, Twilio, Vidyard, Zoom<br />\n&#8211; CRM / Email Marketing / Marketing Automation Software: Active Campaign, Aweber, Campaign Monitor, Constant Contact, Drip, Gmail, Hustle, Mailchimp, Ontraport, Outlook, Salesforce, Sendinblue, WP Fusion, Zoho<br />\n&#8211; E-commerce / Online Store / Recurring Payment / Payment Processing: BigCommerce, Shopify, Stripe, WooCommerce, YITH<br />\n&#8211; Events / Meeting Scheduling Software: Calendly, Eventbrite, The Events Calendar<br />\n&#8211; Forms / Landing Page Builders / CRO: Caldera Forms, Contact Form 7, Elementor, Formidable Forms, Forminator, Gravity Forms, Instapage, JotForm, Kali Forms, MailOptIn, Ninja Forms, OptInMonster, Sumo, Survey Monkey, Typeform, Unbounce, WPForms<br />\n&#8211; Live Chat / Customer Support Software: Drift, Front, Help Scout, Intercom, LiveChat, Pure Chat, Zendesk<br />\n&#8211; Productivity / Project Management Software: Asana, Jira</p>\n<p>HubSpot also works great with Zapier and PieSync, so you can easily connect nearly any tool together.</p>\n<p><strong>WHAT PEOPLE ARE SAYING ABOUT HUBSPOT &#8211; CRM, EMAIL MARKETING, LIVE CHAT, FORMS &amp; ANALYTICS?</strong></p>\n<p>“HubSpot was a big factor in helping us scale WP Buffs to $1M in revenue. Their plugin and sales CRM made our sales process so much more professional and kept us fully organized as we grew from 1 salesperson to 4. Plus, the reporting dashboards allow me to know where our sales game is strong and where we can still improve with just a few clicks. Needless to say, I&#8217;m all in on HubSpot.” – <strong>Joe Howard, Founder &amp; CEO, WP Buffs</strong></p>\n<p>“HubSpot educates marketers beyond just the anonymous web analytics they get from Google Analytics. Instead, it digs down to individual users.” – <strong>Michael Shoup, Founder / CEO, 12South Marketing</strong></p>\n<p>“HubSpot dramatically cuts down the time I spend on marketing. We used to spend tons of time generating very few inbound leads, but those numbers have gone through the roof with minimal effort.” – <strong>Brian Ruhlmann, Director of Sales &amp; Marketing, AdmitHub</strong></p>\n\";s:12:\"installation\";s:1139:\"<h4>Search</h4>\n<p>The easiest way to install this plugin is to use the WordPress Admin interface.</p>\n<ul>\n<li>Go to your admin dashboard</li>\n<li>Find the «Plugins» menu</li>\n<li>Click on «Add New»</li>\n<li>Search for «HubSpot»</li>\n<li>Click «Install Now»</li>\n<li>Go to your «Plugins» menu</li>\n<li>Click «Activate» on the HubSpot All-In-One Marketing &#8211; Forms, Popups, Live Chat plugin</li>\n<li>Log in or sign up for a HubSpot account</li>\n</ul>\n<p>Your WordPress site and HubSpot account will be connected and you&#8217;re ready to get started with HubSpot All-In-One Marketing &#8211; Forms, Popups, Live Chat.</p>\n<h4>Upload</h4>\n<ol>\n<li>Upload the &#8216;leadin&#8217; folder to the &#8216;/wp-content/plugins/&#8217; directory</li>\n<li>Activa el plugin a través del menú «Plugins» en WordPress</li>\n</ol>\n<p>Having trouble? Check out our <a href=\"https://knowledge.hubspot.com/articles/kcs_article/integrations/how-can-i-install-the-hubspot-tracking-code-for-wordpress?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">help documentation</a></p>\n\";s:3:\"faq\";s:6276:\"\n<dt id=\'requirements\'>\nRequirements\n</h4>\n<p>\n<ul>\n<li>Your website or blog must be using WordPress.org version 3.7 or higher on your server. We recommend the latest version.</li>\n<li>The plugin cannot be installed on WordPress.com sites, as they do not allow you to add plugins or Javascript.</li>\n<li>The wp_footer function must be included in your WordPress theme’s footer file (footer.php).</li>\n<li>This function is required for our Javascript snippet to be installed on every page of your site.</li>\n<li>You must be a WordPress admin to be able to install plugins for your site. If you are not the admin, you can forward these instructions to the person who manages your WordPress install.</li>\n</ul>\n</p>\n<dt id=\'what%20does%20the%20plugin%20do%3F\'>\nWhat does the plugin do?\n</h4>\n<p>\n<p>HubSpot&#8217;s WordPress plugin allows you to use HubSpot email marketing, CRM, forms, popups, and live chat on your WordPress website. This plugin gives you all the tools you need to grow your business and delight your contacts and customers.</p>\n</p>\n<dt id=\'what%20is%20hubspot%3F\'>\nWhat is HubSpot?\n</h4>\n<p>\n<p><a href=\"https://hubspot.com/?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot</a> is an all-in-one growth platform that provides a free CRM, marketing, sales, and customer service products to help you grow your business.</p>\n</p>\n<dt id=\'who%20should%20use%20hubspot%3F\'>\nWho should use HubSpot?\n</h4>\n<p>\n<p>HubSpot is perfect for agencies, business owners (including small businesses and ecommerce companies), bloggers, designers, or anyone with a WordPress website that wants to use a seamless CRM plugin with built-in marketing tools. 100,000+ websites in 100+ countries already use HubSpot to grow their businesses.</p>\n</p>\n<dt id=\'are%20coding%20skills%20needed%20to%20use%20the%20hubspot%20wordpress%20plugin%3F\'>\nAre coding skills needed to use the HubSpot WordPress plugin?\n</h4>\n<p>\n<p>Not at all! HubSpot’s WordPress plugin is easy to download and starts working seamlessly with your WordPress site right away. You can take advantage of our CRM, live chat, email marketing, forms, and much more without the need to code.</p>\n</p>\n<dt id=\'what%20is%20available%20for%20free%20with%20hubspot%3F\'>\nWhat is available for free with HubSpot?\n</h4>\n<p>\n<p>HubSpot’s WordPress plugin is free to use with forms, contact management, email marketing, and more.</p>\n<p>HubSpot also has paid tiers available for those who want more advanced functionality like blogging, landing pages, search engine optimization (SEO), team email, retargeting, lead scoring, bots, email scheduling, NPS surveys, calls-to-action (CTAs), knowledge base, and more. If you&#8217;d like a complete view of the features offered in HubSpot&#8217;s free and paid tiers, view our <a href=\"https://hubspot.com/pricing?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">pricing page</a>.</p>\n<p>Our CRM for WordPress is powered by HubSpot’s <a href=\"https://www.hubspot.com/products/crm\" rel=\"nofollow ugc\">free forever CRM</a>.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20install%20a%20wordpress%20smtp%20plugin%20to%20use%20hubspot%27s%20email%20feature%3F\'>\nDo I need to install a WordPress SMTP plugin to use HubSpot&#8217;s email feature?\n</h4>\n<p>\n<p>No, there’s no need to install an additional mail SMTP plugin.</p>\n<p>Unlike other WordPress form plugins and email plugins that send messages using a PHP mail function, HubSpot is a stand-alone email marketing software. You can <a href=\"https://knowledge.hubspot.com/email-notifications/how-can-i-find-my-email-servers-imap-and-smtp-information\" rel=\"nofollow ugc\">define your IMAP and SMTP</a> from your existing mail service (Gmail, Outlook, Yahoo) and stop worrying about email deliverability from within WordPress.</p>\n</p>\n<dt id=\'what%20types%20of%20forms%20and%20popups%20can%20i%20build%20with%20hubspot%3F\'>\nWhat types of forms and popups can I build with HubSpot?\n</h4>\n<p>\n<p>Here are some examples of the types of forms and popups you can create with HubSpot:</p>\n<p>-advanced forms<br />\n-announcement popup<br />\n-appointment form<br />\n-banner bar<br />\n-calculator form<br />\n-conditional form<br />\n-conditional logic form<br />\n-contact button form<br />\n-contact form popup<br />\n-contact forms<br />\n-coupon popup<br />\n-custom form<br />\n-custom forms<br />\n-custom popup<br />\n-donation form<br />\n-email form<br />\n-email forms<br />\n-email submit form<br />\n-event form<br />\n-exit intent popup forms<br />\n-exit popup<br />\n-feedback form<br />\n-file upload form<br />\n-floating bar popup<br />\n-inline signup form<br />\n-lightbox popup<br />\n-mobile popup<br />\n-multi page form<br />\n-newsletter form<br />\n-newsletter popup<br />\n-order form<br />\n-payment form<br />\n-pdf form<br />\n-popup form<br />\n-quiz form<br />\n-quote form<br />\n-quote request form<br />\n-registration popup<br />\n-scroll trigger popup<br />\n-signature form<br />\n-signup form<br />\n-slide-in popup<br />\n-slide-in scroll popup<br />\n-star rating form<br />\n-sticky bar<br />\n-sticky popup<br />\n-subscription form<br />\n-survey popup<br />\n-targeted popup<br />\n-time on site popup<br />\n-upload form<br />\n-user registration form<br />\n-web contact form<br />\n-web form<br />\n-welcome mat popup<br />\n-woocommerce popup</p>\n<p>Rather use your existing form tool? HubSpot integrates with most WordPress form builders and popup builders.</p>\n</p>\n<dt id=\'does%20hubspot%20support%20ecommerce%20stores%3F\'>\nDoes HubSpot support ecommerce stores?\n</h4>\n<p>\n<p>The HubSpot WordPress plugin is great for many types of businesses including e-commerce. For WooCommerce shop owners, consider the <a href=\"https://wordpress.org/plugins/makewebbetter-hubspot-for-woocommerce/\">HubSpot for WooCommerce plugin</a> for even added functionality in your shop.</p>\n</p>\n<dt id=\'my%20question%20is%20not%20listed.\'>\nMy question is not listed.\n</h4>\n<p>\n<p>Please visit the <a href=\"https://community.hubspot.com/?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot Community</a> for more detailed documentation and support. Thank you!</p>\n</p>\n\n\";s:9:\"changelog\";s:404:\"<p><a href=\"https://plugins.svn.wordpress.org/leadin/trunk/changelog.txt\" rel=\"nofollow ugc\">Full changelog here</a><br />\n&#8211; Current version: 8.4.329<br />\n&#8211; Version release date: 2021-10-26</p>\n<h4>8.4.302 (2021-10-21)</h4>\n<ul>\n<li>Fix for search function in HubSpot Gutenberg block</li>\n</ul>\n<h4>8.4.301 (2021-10-21)</h4>\n<ul>\n<li>Fix side navigation option highlight for list</li>\n</ul>\n\";s:11:\"screenshots\";s:2397:\"<ol><li><a href=\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2620236\" alt=\"Measure impact with reports.\"></a><p>Measure impact with reports.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2620236\" alt=\"Organize, track, and nurture your leads in your free HubSpot CRM.\"></a><p>Organize, track, and nurture your leads in your free HubSpot CRM.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2620236\" alt=\"Your website forms will automatically sync with your HubSpot CRM.\"></a><p>Your website forms will automatically sync with your HubSpot CRM.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2620236\" alt=\"Nurture and convert leads with lists and email.\"></a><p>Nurture and convert leads with lists and email.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2620236\" alt=\"Send contacts a beautiful, effective and personalized email.\"></a><p>Send contacts a beautiful, effective and personalized email.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2620236\" alt=\"Add live chat to your website and easily engage &amp; help your site visitors.\"></a><p>Add live chat to your website and easily engage &amp; help your site visitors.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2620236\" alt=\"Add 24/7 chatbots to your website to help automate lead capture and support.\"></a><p>Add 24/7 chatbots to your website to help automate lead capture and support.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2620236\"><img src=\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2620236\" alt=\"Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.\"></a><p>Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.</p></li></ol>\";s:7:\"reviews\";s:14667:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Too big, too slow, won&#039;t deactivate</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/xines\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/546056018a4d40f4c758755b3e42e399?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/546056018a4d40f4c758755b3e42e399?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/xines\" class=\"reviewer-name\">xines</a> el <span class=\"review-date\">agosto 18, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I think the title says it all, not worth it.\n\nTried to deactivate on my site, got a popup asking \"why?\" and no matter what option I chose, the page refreshed and nothing happened. Tried to contact support and they told me to clear my cookies, which of course made me leave the live chat, then they refused to reconnect me, I got a message saying \"no one is in the office now\" like 2 minutes later at 2 in the afternoon. \n\nI just want this plugin off my site already! </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Delivers a 320kb payload but you can&#039;t disable different features</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/blazenweb\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9513915bfef2fca399eeec6a3b783de2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9513915bfef2fca399eeec6a3b783de2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/blazenweb\" class=\"reviewer-name\">BlazenWeb</a> el <span class=\"review-date\">julio 12, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">the plugin delivers a chunky 320kb payload via this file\nMeetingsPublic/static-1.20692/bundles/project.js\nwhich is not impressing Google.\nIt would be very helpful to be able to disable features that we\'re not using to reduce the filesize, and also would be good if the filesize could be reduced by developers.\n\nIt\'s a great plugin, but I don\'t understand how it\'s so well reviewed when it delivers such a payload size. Hopefully they can improve over time.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Fresh Install: Unable to activate it.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/jsoifer\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/bed877aa85106b2ebb175f1a0af38854?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/bed877aa85106b2ebb175f1a0af38854?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/jsoifer\" class=\"reviewer-name\">jsoifer</a> el <span class=\"review-date\">julio 10, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This is a fresh wordpress install, updated to the current latest version.\r\n\r\nThe theme being used is a child theme from twentytwentyone - the simplest theme existing. And it has zero customizations, we\'re just getting started.\r\n\r\nYet, the plugin won\'t activate. The settings page shows up as blank.\r\n\r\nThis is frustrating.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can not get it to show after activating - Nothing</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/siouxsie\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/de4421e1aadfdde475825e2afe07f75d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/de4421e1aadfdde475825e2afe07f75d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/siouxsie\" class=\"reviewer-name\">Siouxsie</a> el <span class=\"review-date\">junio 17, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Is this a conflict? Is there a list of known conflicts somewhere?\nI have never gotten this plugin to work.\nThe menu icon and link appear after installing and activating the plugin but when I get to the page it is blank, nothing.\n\n</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Beginning of journey</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/dewajoker\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/00145fe32c882c510a23d59cb606e2bb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/00145fe32c882c510a23d59cb606e2bb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/dewajoker\" class=\"reviewer-name\">dewajoker</a> el <span class=\"review-date\">mayo 20, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">have been downloaded this plugin, all seems so well from registration in the official website till activation it on wordpress side. Hope it will be longterm use for me. </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good service, average pricing</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/mikhail12\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8eaf28a5f9fc7511aa97497d18e473a2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8eaf28a5f9fc7511aa97497d18e473a2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/mikhail12\" class=\"reviewer-name\">Mikhail <small>(mikhail12)</small></a> el <span class=\"review-date\">febrero 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Been using Hubspot for a few years now. In these years I noticed constant product improvement and great service. However, live chat feature could be better.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">clunky</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/shawfactor\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ee6cccae40a29f2fc886d06c55b48426?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ee6cccae40a29f2fc886d06c55b48426?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/shawfactor\" class=\"reviewer-name\">shawfactor</a> el <span class=\"review-date\">enero 7, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I tried it but it did not work well at all. Not integrated with wordpress</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">White Screen of Death</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/falcon13\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/19319adc70305b6f9125870291770bdf?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/19319adc70305b6f9125870291770bdf?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/falcon13\" class=\"reviewer-name\">Chris - On the Grid Web Design LLC <small>(falcon13)</small></a> el <span class=\"review-date\">noviembre 21, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">After activating I clicked on the plugin in the menu and got the white screen of death. Nothing in error logs.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very best and practice</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/laurencemadstt\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e172d052cce728cbb7ad99b7cb272d4c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e172d052cce728cbb7ad99b7cb272d4c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/laurencemadstt\" class=\"reviewer-name\">LaurenceMad <small>(laurencemadstt)</small></a> el <span class=\"review-date\">noviembre 13, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Very best and practice</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Best marketing plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/kosecom\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f928bac21de29eb42895083ee7f8a06b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f928bac21de29eb42895083ee7f8a06b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/kosecom\" class=\"reviewer-name\">kosecom</a> el <span class=\"review-date\">septiembre 10, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">best plugin</div>\n</div>\n\";}s:13:\"download_link\";s:49:\"https://downloads.wordpress.org/plugin/leadin.zip\";s:11:\"screenshots\";a:8:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2620236\";s:7:\"caption\";s:28:\"Measure impact with reports.\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2620236\";s:7:\"caption\";s:65:\"Organize, track, and nurture your leads in your free HubSpot CRM.\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2620236\";s:7:\"caption\";s:65:\"Your website forms will automatically sync with your HubSpot CRM.\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2620236\";s:7:\"caption\";s:47:\"Nurture and convert leads with lists and email.\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2620236\";s:7:\"caption\";s:60:\"Send contacts a beautiful, effective and personalized email.\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2620236\";s:7:\"caption\";s:78:\"Add live chat to your website and easily engage &amp; help your site visitors.\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2620236\";s:7:\"caption\";s:76:\"Add 24/7 chatbots to your website to help automate lead capture and support.\";}i:8;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2620236\";s:7:\"caption\";s:103:\"Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.\";}}s:4:\"tags\";a:5:{s:9:\"analytics\";s:9:\"analytics\";s:3:\"crm\";s:3:\"crm\";s:15:\"email-marketing\";s:15:\"Email Marketing\";s:5:\"forms\";s:5:\"forms\";s:9:\"live-chat\";s:9:\"live chat\";}s:8:\"versions\";a:0:{}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/leadin/assets/banner-772x250.png?rev=2620236\";s:4:\"high\";s:62:\"https://ps.w.org/leadin/assets/banner-1544x500.png?rev=2620236\";}}s:7:\"bbpress\";a:25:{s:4:\"name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:7:\"version\";s:5:\"2.6.6\";s:6:\"author\";s:58:\"<a href=\"https://bbpress.org\">The bbPress Contributors</a>\";s:14:\"author_profile\";s:46:\"https://profiles.wordpress.org/johnjamesjacoby\";s:12:\"contributors\";a:5:{s:4:\"matt\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/matt\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/767fc9c115a1b989744c755db47feb60?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Matt Mullenweg\";}s:15:\"johnjamesjacoby\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/johnjamesjacoby\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7a2644fb53ae2f7bfd7143b504af396c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"John James Jacoby\";}s:6:\"jmdodd\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/jmdodd\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6a7c997edea340616bcc6d0fe03f65dd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Jennifer M. Dodd\";}s:6:\"netweb\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/netweb\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/97e1620b501da675315ba7cfb740e80f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Stephen Edgar\";}s:14:\"sergeybiryukov\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/sergeybiryukov\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/750b7b0fcd855389264c2b1294d61bd6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Sergey Biryukov\";}}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:6:\"5.6.20\";s:6:\"rating\";i:80;s:7:\"ratings\";a:5:{i:5;i:190;i:4;i:40;i:3;i:24;i:2;i:20;i:1;i:44;}s:11:\"num_ratings\";i:318;s:15:\"support_threads\";i:1;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:200000;s:12:\"last_updated\";s:21:\"2021-08-03 5:56pm GMT\";s:5:\"added\";s:10:\"2010-01-13\";s:8:\"homepage\";s:19:\"https://bbpress.org\";s:8:\"sections\";a:5:{s:11:\"description\";s:326:\"<p>¿Estás buscando un foro de discusión atemporal, elegante y optimizado? bbPress es fácil de integrar, fácil de usar y está diseñado para adaptarse al crecimiento de tu comunidad.</p>\n<p>bbPress es un software de foros intencionadamente sencillo, pero infinitamente potente, creado por colaboradores de WordPress.</p>\n\";s:12:\"installation\";s:1955:\"<h4>Desde el escritorio de tu WordPress</h4>\n<ol>\n<li>Visita &#8216;Plugins &gt; Añadir nuevo&#8217;</li>\n<li>Buscar &#8216;bbPress&#8217;</li>\n<li>Activa bbPress desde tu página de plugins. (Verás un saludo en una página de bienvenida.)</li>\n</ol>\n<h4>Desde WordPress.org</h4>\n<ol>\n<li>Descargar bbPress.</li>\n<li>Sube el directorio &#8216;bbpress&#8217; a tu directorio &#8216;/wp-content/plugins/&#8217;, usando tu método favorito (ftp, sftp, scp, etc&#8230;)</li>\n<li>Activa bbPress desde tu página de plugins. (Verás un saludo en una página de bienvenida.)</li>\n</ol>\n<h4>Una vez activado</h4>\n<ol>\n<li>Visita &#8216;Foros &gt; Añadir nuevo&#8217; y crea algunos foros. (Siempre puedes borrarlos más tarde.)</li>\n<li>Si tienes activos los enlaces permanentes bonitos visita ejemplo.com/forums/, o si no tienes activos los enlaces permanentes bonitos visita ejemplo.com?post_type=forum</li>\n<li>Visita «Ajustes > Foros» y configura los ajustes para que se adapten mejor a las necesidades de tu comunidad.</li>\n<li>Visita &#8216;Herramientas &gt; Foros &gt; Importar foros&#8217; si tienes algún foro existente que convertir a bbPress.</li>\n</ol>\n<h4>Una vez configurado</h4>\n<ul>\n<li>bbPress tiene una API robusta de compatibilidad con temas que hace todo lo que puede para que el aspecto y uso de bbPress se adapte a cualquier tema WordPress. Puede que necesites ajustar algún estilo por tu cuenta para que todo se vea perfecto.</li>\n<li>Puede que quieras  personalizar los flujos de registro/activación/acceso/contraseña perdida para que se adapten a tu sitio. bbPress tiene un montón de shortcodes para hacerlo posible, listados aquí: https://codex.bbpress.org/shortcodes/</li>\n<li>bbPress también tiene compatibilidad nativa para Akismet y BuddyPress, dos plugins WordPress muy populares y potentes. Si usas alguno de ellos visita nuestra página de ajustes de foros y asegúrate de que la integración sea correcta.</li>\n</ul>\n\";s:9:\"changelog\";s:111:\"<p>Revisa la <a href=\"https://codex.bbpress.org/releases/\" rel=\"nofollow ugc\">página de las versiones</a></p>\n\";s:11:\"screenshots\";s:1673:\"<ol><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\" alt=\"Foros - Interface de administrador\"></a><p>Foros - Interface de administrador</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\" alt=\"Debates - Interfaz de administración\"></a><p>Debates - Interfaz de administración</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\" alt=\"Respuestas - Interface de administrador\"></a><p>Respuestas - Interface de administrador</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\" alt=\"Ajustes - Interfaz de administración\"></a><p>Ajustes - Interfaz de administración</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\" alt=\"Ajustes 2 - Interfaz de administración\"></a><p>Ajustes 2 - Interfaz de administración</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\" alt=\"Temas - Interfaz de administración\"></a><p>Temas - Interfaz de administración</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\" alt=\"Foro - Tema por defecto\"></a><p>Foro - Tema por defecto</p></li></ol>\";s:7:\"reviews\";s:16389:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Wrecks your roles; impossible to clean up after - AVOID THIS PLUGIN</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/ourroots\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9d9375220fce4a42e0252e5aa6988dd8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9d9375220fce4a42e0252e5aa6988dd8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/ourroots\" class=\"reviewer-name\">ourroots</a> el <span class=\"review-date\">agosto 24, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">We wanted to try BBPress but we discovered quickly that it caused way too many problems with roles &amp; permissions for the site. So we removed it. But it turns out that for at least 8 years bbPress has known the roles can\'t be removed cleanly and they just shrug and say \"not important.\" So, I recommend you NOT INSTALL THIS PLUGIN. It will leave ugly traces behind itself like a nasty WordPress slug and you\'ll waste hours googling it and trying to fix it to no avail. It\'s old, it\'s ugly, and it\'s a mess.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">It works, it&#039;s very basic, and clunky</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/llewen\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ee79e9411240a75f9349769770b52aa9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ee79e9411240a75f9349769770b52aa9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/llewen\" class=\"reviewer-name\">Llewen <small>(llewen)</small></a> el <span class=\"review-date\">agosto 6, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">If you\'ve ever used other forums software, or especially if you\'ve deployed other forums software, it becomes very clear after you install bbpress that this plugin is basic, and clunky.  An awful lot of what would be considered standard functionality in forums software simply isn\'t present, or if it is, is awkward and clunky to use.\n\nHaving said that, it is the best forums plugin I am aware of for WordPress, perhaps the only one, and it is FOSS, so hurrah for that, and it mostly does the job.  There are also plugins available for it that extend it\'s functionality and add features which almost put it on a par with other forums software, but even with those, not quite.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works well</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/lolafranklin0501\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3beeec41f11f35baea3dae398e16e559?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3beeec41f11f35baea3dae398e16e559?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/lolafranklin0501\" class=\"reviewer-name\">lolafranklin0501</a> el <span class=\"review-date\">abril 21, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Helpful plugin, good functionality.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">I love it!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/alinaalinuta\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/692d4a10a219a53baedb776dad69e629?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/692d4a10a219a53baedb776dad69e629?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/alinaalinuta\" class=\"reviewer-name\">alinaalinuta</a> el <span class=\"review-date\">enero 20, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">bbPress is powerfull and it integrates well with buddypress. I huge recommend it!\n </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very raw and has issues</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/rjrjrjrj\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/1e8155fdda0e0b75f488bea4fd130d8f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/1e8155fdda0e0b75f488bea4fd130d8f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/rjrjrjrj\" class=\"reviewer-name\">rjrjrjrj</a> el <span class=\"review-date\">diciembre 31, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">OOB the forum looks very raw and absolutely DOES NOT follow the active theme. It also produced some artifacts that the dev refused to even look into.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Dois-je rester en version 2.5 à vie ?</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/supermagicien\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a5a24531c14fc84cf105731125d52bc0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a5a24531c14fc84cf105731125d52bc0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/supermagicien\" class=\"reviewer-name\">supermagicien</a> el <span class=\"review-date\">diciembre 14, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Bonjour,\n\nBBpress est un chouette programme, le souci est que je suis obligé de revenir à la version 2.5.14 car dès que je passe à l\'une des versions récentes le forum rencontre de nombreux soucis, pb horodatage, sujets qui disparaissent, édition d\'un post impossible sans perdre le sujet complet, bref, compliqué !\n\nJe précise que j\'ai changé d\'hébergeur et de thème ces derniers mois... c\'est bien BBPRESS le souci...\n\nJ\'attends la version 2.6.7 avec espoir...</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Broke admin access. Goodbye</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/eaec\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d3d62c8b8631a8a1e96ee7a571d23b28?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d3d62c8b8631a8a1e96ee7a571d23b28?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/eaec\" class=\"reviewer-name\">eaec</a> el <span class=\"review-date\">octubre 28, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I had installed this to test it out and had deactivated it, and it broke admin access to my site, twice, overwriting permissions for my admin account.\n\nNEVER touching this plugin again, especially after reading that this has been an ongoing issue for years now. Cost me a lot of time and effort, not to mention IT fees in order to diagnose the issue so that I could access the admin tools to delete it.\n\nGoodbye! I will be sure to find your other plugins and avoid them as well.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">This is classic</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/gcarlsen\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3e41d6d7bf35ad17f0312cb210213900?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3e41d6d7bf35ad17f0312cb210213900?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/gcarlsen\" class=\"reviewer-name\">gcarlsen</a> el <span class=\"review-date\">octubre 5, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This is really helpful plugins with classic functionality. So helpful and powerful addon. Thank you!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Sub-forums</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/nesdam1981\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f50699db8a690b904215a0256ee6612b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f50699db8a690b904215a0256ee6612b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/nesdam1981\" class=\"reviewer-name\">Nesdam1981</a> el <span class=\"review-date\">octubre 4, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">It\'s great that it works natively with Wordpress but the lack of options and settings is a joke. I have a support forum with 50 sub-forums and counting, all of these sub-forums are shown on the main page and clutters the entire forum. Why there is no option yet as of 2020 to set a limit of sub-forums shown on main category is beyond me.\nSpontaneous feeling about bbPress is that it\'s a lazy take on trying to make a forum software that works with Wordpress. Sadly my theme requires bbPress to function properly, would exchange it in a heartbeat.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Total Lack of Communication</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/lruzza\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e6ea1440319737e40bd3369e6330d500?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e6ea1440319737e40bd3369e6330d500?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/lruzza\" class=\"reviewer-name\">laetee <small>(lruzza)</small></a> el <span class=\"review-date\">octubre 1, 2020</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">How do the developers expect users to continue using this plugin if none of them will answer troubleshooting questions? Not to mention there is no direct troubleshooting email to engage with.\n\nYour plugin comes with many issues, some that are years old, that need to be fixed. I’m thinking of changing to a completely new plugin because of the lack of communication from developers.\n\nIt\'s fine to have a support forum for users to help other users, but when your bugs are this abundant, clearly you need a better troubleshooting team that actually responds to inquiries.\n\nI’ve been developing websites with both paid AND free products and have never had any issues with receiving one to one responses with the free products. Ever. This plugin has been a first.\n\nDisappointed.</div>\n</div>\n\";}s:13:\"download_link\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.6.zip\";s:11:\"screenshots\";a:7:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\";s:7:\"caption\";s:34:\"Foros - Interface de administrador\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\";s:7:\"caption\";s:37:\"Debates - Interfaz de administración\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\";s:7:\"caption\";s:39:\"Respuestas - Interface de administrador\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\";s:7:\"caption\";s:37:\"Ajustes - Interfaz de administración\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\";s:7:\"caption\";s:39:\"Ajustes 2 - Interfaz de administración\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\";s:7:\"caption\";s:35:\"Temas - Interfaz de administración\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\";s:7:\"caption\";s:23:\"Foro - Tema por defecto\";}}s:4:\"tags\";a:4:{s:10:\"discussion\";s:10:\"discussion\";s:5:\"forum\";s:5:\"forum\";s:6:\"forums\";s:6:\"forums\";s:7:\"support\";s:7:\"support\";}s:8:\"versions\";a:62:{s:3:\"2.0\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.0.zip\";s:10:\"2.0-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-1.zip\";s:11:\"2.0-beta-2b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-2b.zip\";s:10:\"2.0-beta-3\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3.zip\";s:11:\"2.0-beta-3b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3b.zip\";s:8:\"2.0-rc-2\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-2.zip\";s:8:\"2.0-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-3.zip\";s:8:\"2.0-rc-4\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-4.zip\";s:8:\"2.0-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-5.zip\";s:5:\"2.0.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.1.zip\";s:5:\"2.0.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.2.zip\";s:5:\"2.0.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.3.zip\";s:3:\"2.1\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.1.zip\";s:10:\"2.1-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.1-beta-1.zip\";s:7:\"2.1-rc1\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc1.zip\";s:7:\"2.1-rc2\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc2.zip\";s:7:\"2.1-rc3\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc3.zip\";s:7:\"2.1-rc4\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc4.zip\";s:5:\"2.1.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.1.zip\";s:5:\"2.1.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.2.zip\";s:5:\"2.1.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.3.zip\";s:3:\"2.2\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.2.zip\";s:5:\"2.2.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.1.zip\";s:5:\"2.2.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.2.zip\";s:5:\"2.2.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.3.zip\";s:5:\"2.2.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.4.zip\";s:3:\"2.3\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.3.zip\";s:9:\"2.3-beta1\";s:60:\"https://downloads.wordpress.org/plugin/bbpress.2.3-beta1.zip\";s:5:\"2.3.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.1.zip\";s:5:\"2.3.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.2.zip\";s:3:\"2.4\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.4.zip\";s:5:\"2.4.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.4.1.zip\";s:3:\"2.5\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.5.zip\";s:5:\"2.5.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.1.zip\";s:6:\"2.5.10\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.10.zip\";s:6:\"2.5.11\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.11.zip\";s:6:\"2.5.12\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.12.zip\";s:6:\"2.5.13\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.13.zip\";s:6:\"2.5.14\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:5:\"2.5.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.2.zip\";s:5:\"2.5.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.3.zip\";s:5:\"2.5.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.4.zip\";s:5:\"2.5.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.5.zip\";s:5:\"2.5.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";s:5:\"2.5.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.7.zip\";s:5:\"2.5.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.8.zip\";s:5:\"2.5.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.9.zip\";s:10:\"2.6-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-1.zip\";s:10:\"2.6-beta-2\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-2.zip\";s:8:\"2.6-rc-1\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-1.zip\";s:8:\"2.6-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-3.zip\";s:8:\"2.6-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-5.zip\";s:8:\"2.6-rc-6\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-6.zip\";s:8:\"2.6-rc-7\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-7.zip\";s:5:\"2.6.0\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.0.zip\";s:5:\"2.6.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.1.zip\";s:5:\"2.6.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.2.zip\";s:5:\"2.6.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.3.zip\";s:5:\"2.6.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.4.zip\";s:5:\"2.6.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.5.zip\";s:5:\"2.6.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.6.zip\";s:5:\"trunk\";s:50:\"https://downloads.wordpress.org/plugin/bbpress.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/bbpress/assets/banner-772x250.png?rev=478663\";s:4:\"high\";s:62:\"https://ps.w.org/bbpress/assets/banner-1544x500.png?rev=567403\";}}s:14:\"contact-form-7\";a:25:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:7:\"version\";s:5:\"5.5.2\";s:6:\"author\";s:62:\"<a href=\"https://ideasilo.wordpress.com/\">Takayuki Miyoshi</a>\";s:14:\"author_profile\";s:43:\"https://profiles.wordpress.org/takayukister\";s:12:\"contributors\";a:1:{s:12:\"takayukister\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/takayukister\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/bb7bc21850c77e9eb16b44102f4a539d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Takayuki Miyoshi\";}}s:8:\"requires\";s:3:\"5.7\";s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";b:0;s:6:\"rating\";i:82;s:7:\"ratings\";a:5:{i:5;i:1334;i:4;i:134;i:3;i:60;i:2;i:50;i:1;i:344;}s:11:\"num_ratings\";i:1922;s:15:\"support_threads\";i:449;s:24:\"support_threads_resolved\";i:131;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2021-10-25 4:38am GMT\";s:5:\"added\";s:10:\"2007-08-02\";s:8:\"homepage\";s:25:\"https://contactform7.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:3337:\"<p>Contact Form 7 puede gestionar múltiples formularios de contacto, además, puedes personalizar el formulario y el contenido de los correos electrónicos de manera sencilla mediante un simple marcado. El formulario es compatible con envíos por Ajax, CAPTCHA, filtrado de spam de Akismet y mucho más.</p>\n<h4>Documentación y soporte</h4>\n<p>Puedes encontrar <a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">documentación</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a> e información más detallada sobre Contact Form 7 en <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">contactform7.com</a>. Si no eres capaz de encontrar la respuesta a tu pregunta en las FAQ o en la documentación, revisa el <a href=\"https://wordpress.org/support/plugin/contact-form-7/\">foro de soporte</a> en WordPress.org. Si no localizas ningún debate que ataña a tu problema en particular, abre un nuevo debate para él.</p>\n<h4>Contact Form 7 necesita de tu apoyo</h4>\n<p>Es difícil seguir con el desarrollo y el soporte para este plugin gratuito sin las contribuciones de usuarios como tú. Si disfrutas usando Contact Form 7 y lo encuentras útil, por favor, considera <a href=\"https://contactform7.com/donate/\" rel=\"nofollow ugc\">hacer una donación</a>. Tu donación nos ayudará a seguir adelante y apoyará el continuo desarrollo del plugin y un mejor soporte a los usuarios.</p>\n<h4>Avisos de privacidad</h4>\n<p>Con la configuración por defecto, este plugin, por su cuenta, no:</p>\n<ul>\n<li>hace seguimiento oculto de usuarios;</li>\n<li>guarda ningún dato personal de usuarios en la base de datos;</li>\n<li>envía ningún dato a servidores externos;</li>\n<li>usa cookies.</li>\n</ul>\n<p>Si activas ciertas características de este plugin los datos personales del remitente del formulario de contacto, incluida su dirección IP, pueden enviarse al proveedor del servicio. Por tanto, se recomienda confirmar la política de privacidad del proveedor. Estas características incluyen:</p>\n<ul>\n<li>reCAPTCHA (<a href=\"https://policies.google.com/?hl=en\" rel=\"nofollow ugc\">Google</a>)</li>\n<li>Akismet (<a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">Automattic</a>)</li>\n<li>Constant Contact (<a href=\"https://www.endurance.com/privacy\" rel=\"nofollow ugc\">Endurance International Group</a>)</li>\n<li><a href=\"https://www.sendinblue.com/legal/privacypolicy/\" rel=\"nofollow ugc\">Sendinblue</a></li>\n<li><a href=\"https://stripe.com/privacy\" rel=\"nofollow ugc\">Stripe</a></li>\n</ul>\n<h4>Plugins recomendados</h4>\n<p>Se recomiendan los siguientes plugins a los usuarios de Contact Form 7:</p>\n<ul>\n<li><a href=\"https://es.wordpress.org/plugins/flamingo/\" rel=\"nofollow ugc\">Flamingo</a> de Takayuki Miyoshi &#8211; Con Flamingo, puedes guardar los mensajes enviados vía formularios de contacto en la base de datos.</li>\n<li><a href=\"https://es.wordpress.org/plugins/bogo/\" rel=\"nofollow ugc\">Bogo</a> de Takayuki Miyoshi &#8211; Bogo es un plugin multilenguaje directo y claro que no provoca dolores de cabeza.</li>\n</ul>\n<h4>Traducciones</h4>\n<p>Puedes <a href=\"https://contactform7.com/translating-contact-form-7/\" rel=\"nofollow ugc\">traducir Contact Form 7</a> en <a href=\"https://translate.wordpress.org/projects/wp-plugins/contact-form-7\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n\";s:12:\"installation\";s:486:\"<ol>\n<li>Sube la carpeta completa <code>contact-form-7</code> al directorio <code>/wp-content/plugins/</code>.</li>\n<li>Activa el plugin a través de la pantalla de <strong>Plugins</strong> (<strong>Plugins > Plugins instalados</strong>).</li>\n</ol>\n<p>Encontrarás el menú <strong>Contacto</strong> en tu pantalla de administración de WordPress.</p>\n<p>Para un uso básico, puedes echar un vistazo en la <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">web del plugin</a>.</p>\n\";s:3:\"faq\";s:456:\"<p>¿Tienes preguntas o problemas con Contact Form 7? Utiliza estos canales de soporte apropiadamente.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">Documentación</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\">Foro de soporte</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow ugc\">Soporte</a></p>\n\";s:9:\"changelog\";s:1170:\"<p>Para más información revisa la página de  <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow ugc\">versiones</a>.</p>\n<h4>5.5.2</h4>\n<ul>\n<li>API REST: Eliminada la referencia al esquema de argumentos que causaba un error cuando el formulario tiene el campo `id`.</li>\n<li>Cambiados los nombres de los métodos que están reservados en PHP 5.6.</li>\n</ul>\n<h4>5.5.1</h4>\n<ul>\n<li>Corregido: Una palabra clave reservada se usaba en el nombre de la constante de la clase PHP.</li>\n<li>Corregido: Error tipográfico no detectado en la llamada <code>in_array()</code>.</li>\n</ul>\n<h4>5.5</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-55/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-55/</a></p>\n<h4>5.4.2</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-542/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-542/</a></p>\n<h4>5.4.1</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-541/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-541/</a></p>\n<h4>5.4</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-54/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-54/</a></p>\n\";s:11:\"screenshots\";s:225:\"<ol><li><a href=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\"><img src=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\" alt=\"screenshot-1.png\"></a><p>screenshot-1.png</p></li></ol>\";s:7:\"reviews\";s:14805:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/manhphucofficial\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a69dfc9ce00d25f3ba41b9550c301c64?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a69dfc9ce00d25f3ba41b9550c301c64?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/manhphucofficial\" class=\"reviewer-name\">Phuc Nguyen <small>(manhphucofficial)</small></a> el <span class=\"review-date\">noviembre 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This is very simple but very effective forms solution! I like it very much!</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The true classic, works perfectly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/rodoswebdesign\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/1a2571eb7d19fa232a4fd0bc390d5c8b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/1a2571eb7d19fa232a4fd0bc390d5c8b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/rodoswebdesign\" class=\"reviewer-name\">George X. <small>(rodoswebdesign)</small></a> el <span class=\"review-date\">noviembre 3, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I really don\'t understand why so many 1 star reviews. The form has so many features that have to be paid for in other forms. \n\nYes, it\'s not as easy to use as others, but it\'s still one of the lightest and always working forms for wordpress.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works Pretty well</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/seandmorris\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d1cc452a5b2cc2b49add93b8abd0e4a9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d1cc452a5b2cc2b49add93b8abd0e4a9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/seandmorris\" class=\"reviewer-name\">seandmorris</a> el <span class=\"review-date\">noviembre 1, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I had a bit of frustration in the beginning, mostly because of my newness in the field, but I was able to add my flair to the contact form. </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">It&#039;s good when it&#039;s working, but not if you need support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/sunlineenergy\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9b33b0f47d05d3875f9c7a4915c3fb69?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9b33b0f47d05d3875f9c7a4915c3fb69?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/sunlineenergy\" class=\"reviewer-name\">Sunline Energy <small>(sunlineenergy)</small></a> el <span class=\"review-date\">octubre 25, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Once the plugin was updated to 5.4.2 I started having issues with the recaptcha v3. All the forms are being flagged as spam. I\'ve already submitted a ticket but the author stopped responding. I jumped on a thread that had the same issue and the plugin author stopped responding as well. \nOther than that the plugin generally works well. Just make sure you don\'t have an issue because their support is very poor. </div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">it doesn&#039;t work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/alexg79\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/aeb8dfe5868aea7d738cc1bdc95d9cda?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/aeb8dfe5868aea7d738cc1bdc95d9cda?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/alexg79\" class=\"reviewer-name\">alexg79</a> el <span class=\"review-date\">octubre 25, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I have just downloaded and integrated it with my Mailchimp list but when I Have tested it by signing in as a user on my contact web page it keeps saying : \n\"There has been some error while submitting the form. Please verify all form fields again.\"\nPlease let me know if I can solve this issue.\nThanks in advance !\n</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">White page on 5.5</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/deegee65\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d417b15caebb449083cf33a19975e9da?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d417b15caebb449083cf33a19975e9da?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/deegee65\" class=\"reviewer-name\">deegee65</a> el <span class=\"review-date\">octubre 11, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I try to view the contact modules but i receive white page.\nPhp 8 - Latest WP</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Does not work on mobile devices</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/nathaniel45\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/bef6a799e702b20f1cc71ac1a2e313ef?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/bef6a799e702b20f1cc71ac1a2e313ef?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/nathaniel45\" class=\"reviewer-name\">nathaniel45</a> el <span class=\"review-date\">octubre 9, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Does not work on mobile devices.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">normal</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/worage\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d52a0a29e8a174aa8385d9e6fae4bb60?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d52a0a29e8a174aa8385d9e6fae4bb60?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/worage\" class=\"reviewer-name\">worage</a> el <span class=\"review-date\">octubre 6, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">基本的な機能は充実しているものの、それ以上のクオリティを期待できない部分は残念。</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good but More Scope of Improvement</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/srinivas08\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7ee226585d77b89eedaa470b8ae210db?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7ee226585d77b89eedaa470b8ae210db?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/srinivas08\" class=\"reviewer-name\">srinivas08</a> el <span class=\"review-date\">octubre 4, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">The form is too simple, it cant be added directly, mostly it needs some css to make it work. If we use WPForms, it has good frontend design, CF7 is just like a skeleton of form. And on most sites it throws 409 conflict error as the response code.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Pretty easy to use and it&#039;s free!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 de 5 estrellas\" data-title-template=\"%s de 5 estrellas\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				Por <a href=\"https://profiles.wordpress.org/westerngeomancy\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a70f64fe24b26e55f5d6846231053f7a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a70f64fe24b26e55f5d6846231053f7a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\'/></a><a href=\"https://profiles.wordpress.org/westerngeomancy\" class=\"reviewer-name\">westerngeomancy</a> el <span class=\"review-date\">octubre 25, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I was having trouble with Jetpack messing up anything more complicated than a basic contact form and looked at a few other plugins, all of which required subscription. I had thought CF7 seemed a bit complicated, but once  you get your head around the tags formatting, it\'s really very easy to use, and very versatile; which encouraged me to set up even more complicated forms than I\'d previously used. \nAn excellent and essential plugin, huge thanks to the developer.</div>\n</div>\n\";}s:13:\"download_link\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.2.zip\";s:11:\"screenshots\";a:1:{i:1;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\";s:7:\"caption\";s:16:\"screenshot-1.png\";}}s:4:\"tags\";a:5:{s:7:\"contact\";s:7:\"contact\";s:12:\"contact-form\";s:12:\"contact form\";s:5:\"email\";s:5:\"email\";s:8:\"feedback\";s:8:\"feedback\";s:4:\"form\";s:4:\"form\";}s:8:\"versions\";a:154:{s:3:\"1.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.1.zip\";s:4:\"1.10\";s:62:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.zip\";s:8:\"1.10.0.1\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.0.1.zip\";s:6:\"1.10.1\";s:64:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.1.zip\";s:3:\"1.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.2.zip\";s:3:\"1.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.zip\";s:5:\"1.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.1.zip\";s:5:\"1.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.2.zip\";s:3:\"1.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.zip\";s:5:\"1.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.1.zip\";s:5:\"1.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.2.zip\";s:5:\"1.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.3.zip\";s:5:\"1.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.4.zip\";s:3:\"1.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.5.zip\";s:3:\"1.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.zip\";s:5:\"1.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.1.zip\";s:3:\"1.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.zip\";s:5:\"1.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.1.zip\";s:5:\"1.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.2.zip\";s:5:\"1.7.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.4.zip\";s:5:\"1.7.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.5.zip\";s:5:\"1.7.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.zip\";s:7:\"1.7.6.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.1.zip\";s:5:\"1.7.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.zip\";s:7:\"1.7.7.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.1.zip\";s:5:\"1.7.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.8.zip\";s:3:\"1.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.zip\";s:7:\"1.8.0.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.1.zip\";s:7:\"1.8.0.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.2.zip\";s:7:\"1.8.0.3\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.3.zip\";s:7:\"1.8.0.4\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.4.zip\";s:5:\"1.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.zip\";s:7:\"1.8.1.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.1.zip\";s:3:\"1.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.zip\";s:5:\"1.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.1.zip\";s:5:\"1.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.zip\";s:7:\"1.9.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.1.zip\";s:7:\"1.9.2.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.2.zip\";s:5:\"1.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.3.zip\";s:5:\"1.9.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.4.zip\";s:5:\"1.9.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.zip\";s:7:\"1.9.5.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.1.zip\";s:3:\"2.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.zip\";s:8:\"2.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0-beta.zip\";s:5:\"2.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.1.zip\";s:5:\"2.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.2.zip\";s:5:\"2.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.3.zip\";s:5:\"2.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.4.zip\";s:5:\"2.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.5.zip\";s:5:\"2.0.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.6.zip\";s:5:\"2.0.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.7.zip\";s:3:\"2.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.zip\";s:5:\"2.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.1.zip\";s:5:\"2.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.2.zip\";s:3:\"2.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.zip\";s:5:\"2.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.1.zip\";s:3:\"2.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.zip\";s:5:\"2.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.1.zip\";s:3:\"2.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.zip\";s:5:\"2.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.1.zip\";s:5:\"2.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.2.zip\";s:5:\"2.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.3.zip\";s:5:\"2.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.4.zip\";s:5:\"2.4.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.5.zip\";s:5:\"2.4.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.6.zip\";s:3:\"3.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.zip\";s:8:\"3.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0-beta.zip\";s:5:\"3.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.1.zip\";s:5:\"3.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.zip\";s:7:\"3.0.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.1.zip\";s:3:\"3.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.zip\";s:5:\"3.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.1.zip\";s:5:\"3.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.2.zip\";s:3:\"3.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.zip\";s:5:\"3.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.1.zip\";s:3:\"3.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.zip\";s:5:\"3.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.1.zip\";s:5:\"3.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.2.zip\";s:5:\"3.3.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.3.zip\";s:3:\"3.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.zip\";s:5:\"3.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.1.zip\";s:5:\"3.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.2.zip\";s:3:\"3.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.zip\";s:5:\"3.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.1.zip\";s:5:\"3.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.2.zip\";s:5:\"3.5.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.3.zip\";s:5:\"3.5.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.4.zip\";s:3:\"3.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.6.zip\";s:3:\"3.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.zip\";s:5:\"3.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.1.zip\";s:5:\"3.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.2.zip\";s:3:\"3.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.zip\";s:5:\"3.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.1.zip\";s:3:\"3.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.zip\";s:8:\"3.9-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9-beta.zip\";s:5:\"3.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.1.zip\";s:5:\"3.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.2.zip\";s:5:\"3.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.3.zip\";s:3:\"4.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.zip\";s:5:\"4.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.1.zip\";s:5:\"4.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.2.zip\";s:5:\"4.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.3.zip\";s:3:\"4.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.zip\";s:8:\"4.1-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1-beta.zip\";s:5:\"4.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.1.zip\";s:5:\"4.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.2.zip\";s:3:\"4.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.zip\";s:8:\"4.2-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2-beta.zip\";s:5:\"4.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.1.zip\";s:5:\"4.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.2.zip\";s:3:\"4.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.zip\";s:5:\"4.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.1.zip\";s:3:\"4.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.zip\";s:5:\"4.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.1.zip\";s:5:\"4.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.2.zip\";s:3:\"4.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.zip\";s:5:\"4.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.1.zip\";s:3:\"4.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.zip\";s:5:\"4.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.1.zip\";s:3:\"4.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.7.zip\";s:3:\"4.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.zip\";s:5:\"4.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.1.zip\";s:3:\"4.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.zip\";s:5:\"4.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.1.zip\";s:5:\"4.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.2.zip\";s:3:\"5.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.zip\";s:5:\"5.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.1.zip\";s:5:\"5.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.2.zip\";s:5:\"5.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.3.zip\";s:5:\"5.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.4.zip\";s:5:\"5.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:3:\"5.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.zip\";s:5:\"5.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.1.zip\";s:5:\"5.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.2.zip\";s:5:\"5.1.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.3.zip\";s:5:\"5.1.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.4.zip\";s:5:\"5.1.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.5.zip\";s:5:\"5.1.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.6.zip\";s:5:\"5.1.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.7.zip\";s:5:\"5.1.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.8.zip\";s:5:\"5.1.9\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.9.zip\";s:3:\"5.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.zip\";s:5:\"5.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.1.zip\";s:5:\"5.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.2.zip\";s:3:\"5.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.zip\";s:5:\"5.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.1.zip\";s:5:\"5.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.2.zip\";s:3:\"5.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.zip\";s:5:\"5.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.1.zip\";s:5:\"5.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.2.zip\";s:3:\"5.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.zip\";s:5:\"5.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.1.zip\";s:5:\"5.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.2.zip\";s:5:\"trunk\";s:57:\"https://downloads.wordpress.org/plugin/contact-form-7.zip\";}s:11:\"donate_link\";s:32:\"https://contactform7.com/donate/\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";s:4:\"high\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";}}}','no');
INSERT INTO `wp_options` VALUES (225,'_site_transient_avada_addons_json','{\"418947\":{\"post_title\":\"Custom Search Element\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2021\\/04\\/custom_search_880_660.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2021\\/04\\/imgpsh_fullsize_anim.jpeg\",\"plugin_name\":\"Custom Search Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-search-element-for-avada-builder\\/31213422?ref=ThemeFusion\",\"new\":false,\"date\":1618918239},\"416560\":{\"post_title\":\"Custom Field Element\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/08\\/custom_fields_element.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/08\\/custom_fields_element.jpg\",\"plugin_name\":\"Custom Field Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-field-element-for-fusion-builder\\/22247344?ref=ThemeFusion\",\"new\":false,\"date\":1533635113},\"416071\":{\"post_title\":\"Elegant Elements\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/elegant_elements.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/elegant_elements.jpg\",\"plugin_name\":\"Elegant Elements\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/elegant-elements-for-fusion-builder\\/21113424?ref=ThemeFusion\",\"new\":false,\"date\":1513943064},\"416177\":{\"post_title\":\"Horizontal & Vertical Duo Button\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/03\\/duo_button.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/03\\/duo_button.jpg\",\"plugin_name\":\"Fusion Builder Horizontal & Vertical Duo Button\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/horizontal-vertical-duo-button-element-for-avada-v5-fusion\\/21602449?ref=ThemeFusion\",\"new\":false,\"date\":1522053820},\"415163\":{\"post_title\":\"Element Bundle\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/02\\/arcticlune_element_bundle.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/02\\/arcticlune_element_bundle.jpg\",\"plugin_name\":null,\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/element-bundle-addon-for-avada-v5-fusion-builder\\/19451303?ref=ThemeFusion\",\"new\":false,\"date\":1487277411},\"415144\":{\"post_title\":\"Notification & Pop-Up\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/02\\/arcticlune_notification.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/02\\/arcticlune_notification.jpg\",\"plugin_name\":\"Fusion Builder Notification & Pop-up Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/notification-popup-element-for-avada-v5-fusion-builder\\/19406447?ref=ThemeFusion\",\"new\":false,\"date\":1486391212},\"415084\":{\"post_title\":\"Reviews and Testimonials\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/12\\/arcticlune_reviews.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/12\\/arcticlune_reviews.jpg\",\"plugin_name\":\"Fusion Builder Reviews and Testimonials Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/reviews-and-testimonials-element-for-avada-v5-fusion-builder\\/19105069?ref=ThemeFusion\",\"new\":false,\"date\":1481829163},\"415029\":{\"post_title\":\"Custom Post Types and Taxonomies\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/35815191-ee7402b4-0a65-11e8-8c17-78079117d5b4.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/35815191-ee7402b4-0a65-11e8-8c17-78079117d5b4.jpg\",\"plugin_name\":\"Fusion Builder Custom Post Types and Taxonomies\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-post-types-and-taxonomies-for-fusion-builder\\/15572585?ref=ThemeFusion\",\"new\":false,\"date\":1479378733},\"415031\":{\"post_title\":\"Elegant Tabs\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/elegant_tabs.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/elegant_tabs.jpg\",\"plugin_name\":\"Elegant Tabs for Fusion Builder\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/elegant-tabs-for-fusion-builder\\/18795917?ref=ThemeFusion\",\"new\":false,\"date\":1479292408},\"415121\":{\"post_title\":\"Mobile Layout Creator\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/wpsqr_mobile_layout_creator.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/wpsqr_mobile_layout_creator.jpg\",\"plugin_name\":\"Fusion Builder Mobile Layout Creator\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/fusion-builder-mobile-layout-creator\\/19125174?ref=ThemeFusion\",\"new\":false,\"date\":1479235517},\"415444\":{\"post_title\":\"Membership\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/06\\/wpsqr_membership.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/06\\/wpsqr_membership.jpg\",\"plugin_name\":\"Fusion Builder Membership\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/fusion-builder-membership\\/20027621?ref=ThemeFusion\",\"new\":true,\"date\":1496726434},\"415041\":{\"post_title\":\"Coming Soon\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/10\\/coming_soon.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/10\\/coming_soon.jpg\",\"plugin_name\":null,\"description\":\"\",\"url\":\"https:\\/\\/themeforest.net\\/item\\/avada-responsive-multipurpose-theme\\/2833226?ref=ThemeFusion\",\"new\":false,\"date\":1475330672}}','no'),(230,'fusion_core_version','5.4.2','yes'),(231,'widget_ad_125_125-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(232,'widget_fusion_author-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(233,'widget_contact_info-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(234,'widget_pyre_tabs-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(235,'widget_recent_works-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(236,'widget_tweets-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(237,'widget_flickr-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(238,'widget_social_links-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(239,'widget_facebook-like-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(240,'widget_menu-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(241,'widget_avada-vertical-menu-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(242,'widget_form-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(275,'fusion_builder_version','3.4.2','yes'),(299,'fusion_form_cleanup_datetime','1647040845','yes'),(309,'revslider_servers','a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:16:\"themepunch.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}','yes'),(310,'revslider_server_refresh','1646056071','yes'),(311,'revslider-update-check-short','1646858026','yes'),(312,'revslider-connection','1','yes'),(313,'revslider-update-hash','96ce76b29a268614073808695215226e','yes'),(314,'revslider-latest-version','6.5.18','yes'),(315,'revslider-stable-version','4.2.0','yes'),(316,'revslider-notices','a:1:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}','yes'),(317,'revslider-additions','O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}','yes'),(318,'rs-addons-counter','32','yes'),(319,'revslider-addons','O:8:\"stdClass\":32:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.2.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2021-10-29\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2021-12-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2021-12-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2021-08-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"383\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2021-07-17\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.7\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2022-02-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2021-10-11\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:81:\"//updates.themepunch-ext-a.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2021-11-03\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2020-02-19\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2021-12-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2021-05-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2021-05-28\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}','yes'),(320,'revslider-library-check','1646927165','yes'),(321,'revslider-library-hash','dae3de1eb57eeeee008b70e9a23844b5','yes'),(322,'rs-library','a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}','no');
INSERT INTO `wp_options` VALUES (323,'revslider-templates-check','1646638270','yes'),(324,'revslider-templates-hash','faf9a8c06fb8b3eef6c56ea4859df99b','yes'),(325,'rs-templates-new','','no'),(326,'rs-templates','a:3:{s:4:\"hash\";s:32:\"2a291144014b682e6d56ed934a555cdc\";s:6:\"slider\";a:595:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;