<?php
/**
 * The template for displaying header search block
 *
 * @since   1.4.0
 * @version 1.0.3
 * last changes in 2.0.0
 */
?>

<?php

global $et_builder_globals;

$element_options = array();

$element_options['search_type'] = get_theme_mod( 'search_type_et-desktop', 'input' ); // icon, full form
$element_options['search_type'] = apply_filters('search_type', $element_options['search_type']);

$element_options['is_popup'] = $element_options['search_type'] == 'popup';
$element_options['is_popup'] = apply_filters('search_mode_is_popup', $element_options['is_popup']);

//    $element_options['search_mode'] = get_theme_mod( 'search_mode_et-desktop' );
//	$element_options['search_mode'] = apply_filters('search_mode', $element_options['search_mode']);

$element_options['icon_type_et-desktop'] = get_theme_mod( 'search_icon_et-desktop', 'type1' );
$element_options['icon_type_et-desktop'] = apply_filters('search_icon', $element_options['icon_type_et-desktop']);
$element_options['icon_custom'] = get_theme_mod('search_icon_custom_et-desktop', '');
$element_options['icon_custom'] = apply_filters('search_icon_custom', $element_options['icon_custom']);
$element_options['icon_custom'] = isset($element_options['icon_custom']['id']) ? $element_options['icon_custom']['id'] : '';

$element_options['search_type'] = $element_options['is_popup'] ? 'icon' : $element_options['search_type'];

$element_options['search_content'] = get_theme_mod( 'search_results_content_et-desktop',
	array(
		'products',
		'posts',
	)
);

$element_options['search_ajax'] = get_theme_mod( 'search_ajax_et-desktop', '1' );
$element_options['search_ajax_with_tabs'] = apply_filters('search_ajax_with_tabs', get_theme_mod('search_ajax_with_tabs_et-desktop', '0'));
if ( $element_options['is_popup'] ) {
	$element_options['search_ajax_with_tabs'] = false;
}

// to use desktop styles when use this element in mobile menu for example etc.
$element_options['etheme_use_desktop_style'] = false;
$element_options['etheme_use_desktop_style'] = apply_filters( 'etheme_use_desktop_style', $element_options['etheme_use_desktop_style'] );

if ( get_theme_mod('bold_icons', 0) ) {
	$element_options['search_icon_et-desktop'] = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.64 22.176l-5.736-5.712c1.44-1.8 2.232-4.032 2.232-6.336 0-5.544-4.512-10.032-10.032-10.032s-10.008 4.488-10.008 10.008c-0.024 5.568 4.488 10.056 10.032 10.056 2.328 0 4.512-0.792 6.336-2.256l5.712 5.712c0.192 0.192 0.456 0.312 0.72 0.312 0.24 0 0.504-0.096 0.672-0.288 0.192-0.168 0.312-0.384 0.336-0.672v-0.048c0.024-0.288-0.096-0.552-0.264-0.744zM18.12 10.152c0 4.392-3.6 7.992-8.016 7.992-4.392 0-7.992-3.6-7.992-8.016 0-4.392 3.6-7.992 8.016-7.992 4.392 0 7.992 3.6 7.992 8.016z"></path></svg>';
}
else {
	$element_options['search_icon_et-desktop'] ='<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor" viewBox="0 0 24 24"><path d="M23.784 22.8l-6.168-6.144c1.584-1.848 2.448-4.176 2.448-6.576 0-5.52-4.488-10.032-10.032-10.032-5.52 0-10.008 4.488-10.008 10.008s4.488 10.032 10.032 10.032c2.424 0 4.728-0.864 6.576-2.472l6.168 6.144c0.144 0.144 0.312 0.216 0.48 0.216s0.336-0.072 0.456-0.192c0.144-0.12 0.216-0.288 0.24-0.48 0-0.192-0.072-0.384-0.192-0.504zM18.696 10.080c0 4.752-3.888 8.64-8.664 8.64-4.752 0-8.64-3.888-8.64-8.664 0-4.752 3.888-8.64 8.664-8.64s8.64 3.888 8.64 8.664z"></path></svg>';
}

if ( $element_options['icon_type_et-desktop'] == 'custom' && $element_options['icon_custom'] != '' ) {
	$element_options['icon_custom_type']      = get_post_mime_type( $element_options['icon_custom'] );
	$element_options['icon_custom_mime_type'] = explode( '/', $element_options['icon_custom_type'] );
	if ( $element_options['icon_custom_mime_type']['1'] == 'svg+xml' ) {
		$element_options['rendered_svg'] = get_post_meta( $element_options['icon_custom'], '_xstore_inline_svg', true );
		
		if ( ! empty( $element_options['rendered_svg'] ) ) {
			$element_options['search_icon_et-desktop'] = $element_options['rendered_svg'];
		} else {
			
			$element_options['attachment_file'] = get_attached_file( $element_options['icon_custom'] );
			
			if ( $element_options['attachment_file'] ) {
				
				$element_options['rendered_svg'] = file_get_contents( $element_options['attachment_file'] );
				
				if ( ! empty( $element_options['rendered_svg'] ) ) {
					update_post_meta( $element_options['icon_custom'], '_xstore_inline_svg', $element_options['rendered_svg'] );
				}
				
				$element_options['search_icon_et-desktop'] = $element_options['rendered_svg'];
				
			}
			
		}
	}
    elseif ( function_exists('etheme_get_image') ) {
		$element_options['search_icon_et-desktop'] = etheme_get_image($element_options['icon_custom'], 'thumbnail' );
	}
}

$element_options['search_icon_et-desktop'] = apply_filters('et_b_search_icon', $element_options['search_icon_et-desktop']);

$element_options['search_category_et-desktop'] = get_theme_mod( 'search_category_et-desktop', '1' );
$element_options['search_category_et-desktop'] = apply_filters('search_category', $element_options['search_category_et-desktop']);
$element_options['search_posts_et-desktop'] = get_theme_mod( 'search_posts_et-desktop' );

$element_options['search_content_alignment'] = ' justify-content-' . get_theme_mod( 'search_content_alignment_et-desktop', 'center' );
$element_options['search_content_alignment'] .= ( !$element_options['etheme_use_desktop_style'] ) ? ' mob-justify-content-' . get_theme_mod( 'search_content_alignment_et-mobile' ) : '';

$element_options['search_content_position_et-desktop'] = get_theme_mod( 'search_content_position_et-desktop', 'right' );
$element_options['search_content_position_et-mobile'] = get_theme_mod( 'search_content_position_et-mobile' );

$element_options['search_content_position'] = ( $element_options['search_content_position_et-desktop'] != 'custom' ) ? ' et-content-' . $element_options['search_content_position_et-desktop'] : '';

$element_options['search_placeholder_et-desktop'] = get_theme_mod( 'search_placeholder_et-desktop', 'Search for...' );

$element_options['search_categories_et-desktop'] = '';

$element_options['etheme_search_results'] = true;
$element_options['etheme_search_results'] = apply_filters('etheme_search_results', $element_options['etheme_search_results']);

if ( $element_options['search_category_et-desktop'] && $element_options['etheme_search_results'] ) {
	
	$element_options['search_taxonomy_et-desktop'] = ( class_exists( 'WooCommerce' ) && in_array('products', $element_options['search_content']) ) ? 'product_cat' : 'category';
	
	$element_options['search_all_categories_text_et-desktop'] = get_theme_mod('search_all_categories_text_et-desktop', 'All categories');
	
	$element_options['search_categories_et-desktop'] = wp_dropdown_categories(
		array(
			'show_option_all' => ( $element_options['search_all_categories_text_et-desktop'] != '' ) ? $element_options['search_all_categories_text_et-desktop'] : false,
			'taxonomy'        => $element_options['search_taxonomy_et-desktop'],
			'hierarchical'    => true,
			'echo'            => 0,
			'id'              => $element_options['search_taxonomy_et-desktop'] . '-' . rand( 100, 999 ),
			'name'            => $element_options['search_taxonomy_et-desktop'],
			'orderby'         => 'name',
			'value_field'     => 'slug',
			'hide_if_empty'   => true
		)
	);
	
	$element_options['search_categories_et-desktop'] = str_replace( '<select', '<select style="max-width: calc(122px + 1.4em)"', $element_options['search_categories_et-desktop'] );
}

$element_options['class'] = ( $element_options['etheme_search_results'] && $element_options['search_ajax'] ) ? ' ajax-with-suggestions' : '';

$element_options['search_by_icon-click'] = ( ( $element_options['search_type'] == 'icon' || $element_options['is_popup'] ) && $element_options['etheme_search_results'] ) ? true : false;
$element_options['search_by_icon-click'] = apply_filters('search_by_icon', $element_options['search_by_icon-click']);

$element_options['min_symbols'] = get_theme_mod( 'search_ajax_min_symbols_et-desktop', 3 );

$element_options['icon_class'] = '';

$element_options['wrapper_class'] = ' ' . $element_options['search_content_position'];
$element_options['wrapper_class'] .= $element_options['search_content_alignment'];
$element_options['wrapper_class'] .= ( ( $element_options['search_type'] != 'icon' ) ? ' flex-basis-full' : '' );
$element_options['wrapper_class'] .= ( $et_builder_globals['in_mobile_menu'] ? '' : ' et_element-top-level' );
$element_options['wrapper_class'] .= ( $element_options['is_popup'] ) ? ' search-full-width' : '';

if ( $element_options['search_by_icon-click'] && !$et_builder_globals['in_mobile_menu'] && (wp_is_mobile() || $element_options['is_popup'])) {
	$element_options['wrapper_class'] .= ' et-content_toggle';
	$element_options['icon_class'] .= ' et-toggle';
	if ( $element_options['is_popup'])
		$element_options['icon_class'] .= ' pointer';
}

$element_options['class'] .= ' input-' . $element_options['search_type'].' ';

if ( $element_options['search_by_icon-click'] && ! $element_options['is_popup'] ) {
	$element_options['class'] .= ' et-mini-content';
}

if ( $element_options['is_popup'] ) {
	$element_options['class'] .= ' container search-full-width-form';
}
else {
	$element_options['wrapper_class'] .= ' et-content-dropdown';
}

$element_options['is_customize_preview'] = apply_filters('is_customize_preview', false);
$element_options['attributes'] = array();
if ( $element_options['is_customize_preview'] )
	$element_options['attributes'] = array(
		'data-title="' . esc_html__( 'Search', 'xstore-core' ) . '"',
		'data-element="search"'
	);

$element_options['search_query'] = get_search_query();
if ( $element_options['search_query'])
	$element_options['class'] .= ' ajax-results-shown';

$element_options['input_row_class'] = array();

if ($element_options['search_categories_et-desktop'] == '')
	$element_options['input_row_class'][] = 'et-overflow-hidden';

$element_options['input_id'] = 'et_b-header-search-input-'.rand(0,99);

?>

<div class="et_element et_b_header-search flex align-items-center <?php echo $element_options['wrapper_class']; ?>" <?php echo implode( ' ', $element_options['attributes'] ); ?>>
	<?php if ( $element_options['search_by_icon-click'] ) { ?>
        <span class="flex et_b_search-icon <?php echo esc_attr($element_options['icon_class']); ?>"><?php echo $element_options['search_icon_et-desktop']; ?></span>
	<?php } ?>
	<?php if ( $element_options['is_popup'] ) : ?>
    <div class="et-mini-content">
            <span class="et-toggle pos-absolute et-close right top">
				<svg xmlns="http://www.w3.org/2000/svg" width="1.4em" height="1.4em" viewBox="0 0 24 24"><path d="M13.056 12l10.728-10.704c0.144-0.144 0.216-0.336 0.216-0.552 0-0.192-0.072-0.384-0.216-0.528-0.144-0.12-0.336-0.216-0.528-0.216 0 0 0 0 0 0-0.192 0-0.408 0.072-0.528 0.216l-10.728 10.728-10.704-10.728c-0.288-0.288-0.768-0.288-1.056 0-0.168 0.144-0.24 0.336-0.24 0.528 0 0.216 0.072 0.408 0.216 0.552l10.728 10.704-10.728 10.704c-0.144 0.144-0.216 0.336-0.216 0.552s0.072 0.384 0.216 0.528c0.288 0.288 0.768 0.288 1.056 0l10.728-10.728 10.704 10.704c0.144 0.144 0.336 0.216 0.528 0.216s0.384-0.072 0.528-0.216c0.144-0.144 0.216-0.336 0.216-0.528s-0.072-0.384-0.216-0.528l-10.704-10.704z"></path>
				</svg>
			</span>
		<?php endif; ?>
        <form action="<?php echo esc_url( home_url( '/' ) ); ?>" role="searchform" data-min="<?php echo esc_attr($element_options['min_symbols']); ?>" data-tabs="<?php echo $element_options['search_ajax_with_tabs']; ?>" class="ajax-search-form <?php  esc_attr_e( $element_options['class'] ); ?>" method="get">
			<?php if ( $element_options['is_popup'] ) : ?>
            <div class="search-content-head">
                <h3 class="full-width align-center products-title"><?php echo esc_html__('What are you looking for?', 'xstore-core'); ?></h3>
				<?php endif; ?>

                <div class="input-row flex align-items-center <?php echo implode(' ', $element_options['input_row_class']); ?>" data-search-mode="<?php echo (get_theme_mod('search_category_select_color_scheme_et-desktop', 'dark')) ?>">
					<?php echo $element_options['search_categories_et-desktop']; ?>
                    <label class="screen-reader-text" for="<?php echo esc_attr($element_options['input_id']); ?>"><?php echo esc_html__('Search input', 'xstore-core'); ?></label>
                    <input type="text" value="<?php if($element_options['search_query']) echo esc_attr($element_options['search_query']); ?>"
                           placeholder="<?php echo $element_options['search_placeholder_et-desktop']; ?>" autocomplete="off" class="form-control" id="<?php echo esc_attr($element_options['input_id']); ?>" name="s">
					
					<?php if ( class_exists('WooCommerce') ): ?>
                        <input type="hidden" name="post_type" value="<?php echo ( class_exists('WooCommerce') ) ? 'product': 'post'; ?>">
					<?php endif ?>
					
					<?php if ( defined( 'ICL_LANGUAGE_CODE' ) && ! defined( 'LOCO_LANG_DIR' ) ) : ?>
                        <input type="hidden" name="lang" value="<?php echo ICL_LANGUAGE_CODE; ?>"/>
					<?php endif ?>
                    <span class="buttons-wrapper flex flex-nowrap">
                    <span class="clear flex-inline justify-content-center align-items-center pointer">
                        <span class="et_b-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width=".7em" height=".7em" viewBox="0 0 24 24"><path d="M13.056 12l10.728-10.704c0.144-0.144 0.216-0.336 0.216-0.552 0-0.192-0.072-0.384-0.216-0.528-0.144-0.12-0.336-0.216-0.528-0.216 0 0 0 0 0 0-0.192 0-0.408 0.072-0.528 0.216l-10.728 10.728-10.704-10.728c-0.288-0.288-0.768-0.288-1.056 0-0.168 0.144-0.24 0.336-0.24 0.528 0 0.216 0.072 0.408 0.216 0.552l10.728 10.704-10.728 10.704c-0.144 0.144-0.216 0.336-0.216 0.552s0.072 0.384 0.216 0.528c0.288 0.288 0.768 0.288 1.056 0l10.728-10.728 10.704 10.704c0.144 0.144 0.336 0.216 0.528 0.216s0.384-0.072 0.528-0.216c0.144-0.144 0.216-0.336 0.216-0.528s-0.072-0.384-0.216-0.528l-10.704-10.704z"></path></svg>
                    </span>
                    </span>
                    <button type="submit" class="search-button flex justify-content-center align-items-center pointer">
                        <span class="et_b-loader"></span>
                    <?php echo $element_options['search_icon_et-desktop']; ?></button>
                </span>
                </div>
				
				<?php if ( $element_options['is_popup'] ) :
				$element_options['search_tags'] = get_theme_mod('search_tags_et-desktop', 'Shirt, Shoes, Cap, Shoes, Skirt');
				if ($element_options['search_tags'] != '') {
					$element_options['search_tags'] = explode(',', $element_options['search_tags']);
				}
				if ( count($element_options['search_tags']) ) : ?>
                    <div class="ajax-search-tags full-width align-center">
						<?php echo get_theme_mod('search_trending_et-desktop', esc_html__('Trending Searches:', 'xstore-core') ); ?></span>
						<?php foreach ( $element_options['search_tags'] as $search_tag ) { ?>
                            <a><?php echo esc_html($search_tag); ?></a>
						<?php } ?>
                    </div>
				<?php endif; ?>
            </div>
		<?php endif;?>
			<?php if ( $element_options['etheme_search_results'] && $element_options['search_ajax'] ) : ?>
				<?php if ( $element_options['is_popup'] ) : ?>
                    <div class="ajax-extra-content">
                        <div class="ajax-search-categories">
                            <h3 class="full-width align-center products-title"><?php esc_html_e('Popular categories', 'xstore-core'); ?></h3>
							<?php
							global $woocommerce_loop;
							wc_set_loop_prop( 'is_shortcode', true );
							$element_options['old_woocommerce_columns'] = $woocommerce_loop['columns'];
							$element_options['old_woocommerce_cat_columns'] = $woocommerce_loop['categories_columns'];
							$woocommerce_loop['columns'] = 6;
							$woocommerce_loop['categories_columns'] = 6;
							$woocommerce_loop['content_position'] = 'under';
							echo do_shortcode('[product_categories columns="6" limit="6"]');
							$woocommerce_loop['columns'] = $element_options['old_woocommerce_columns'];
							$woocommerce_loop['categories_columns'] = $element_options['old_woocommerce_cat_columns'];
							unset($woocommerce_loop['content_position']);
							woocommerce_reset_loop();
							?>
                            <div class="full-width text-center"><a href="<?php echo esc_url( wc_get_page_permalink( 'shop' ) ); ?>" class="btn black"><?php esc_html_e('View all categories', 'xstore-core'); ?></a></div>
                        </div>
                    </div>
				<?php endif; ?>
                <div class="ajax-results-wrapper"></div>
			<?php endif; ?>
        </form>
		<?php if ( $element_options['is_popup'] ) : ?>
    </div>
<?php endif; ?>
</div>
