<?php
namespace ETC\App\Models\Widgets;

use ETC\App\Models\WC_Widget;

/**
 * Stock Status filter Widget.
 *
 * @since      3.0.3
 * @package    ETC
 * @subpackage ETC/Models/Widgets
 */
class Product_Status_Filter extends WC_Widget {
	function __construct() {
		$this->widget_cssclass    = 'sidebar-widget etheme-product-status-filter';
		$this->widget_description = esc_html__( 'Widget to filtering products by stock attribute', 'xstore-core' );
		$this->widget_id          = 'etheme_product_status_filter';
		$this->widget_name        = '8theme - ' . esc_html__( 'Product Status Filters', 'xstore-core' );
		$this->settings           = array(
			'title' => array(
				'type'  => 'text',
				'std'   => esc_html__( 'Product Status', 'xstore-core' ),
				'label' => esc_html__( 'Title', 'xstore-core' ),
			),
			'count' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' => esc_html__( 'Show numbers of products', 'xstore-core' )
			),
			'ajax' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' => esc_html__( 'Use ajax preload for this widget', 'xstore-core' )
			)
		);
		parent::__construct();
		add_action( 'woocommerce_product_query', array( $this, 'show_in_stock_products' ) );
		add_filter( 'loop_shop_post_in', array( $this, 'show_on_sale_products' ) );
	}
	
	function widget($args, $instance) {
		$ajax               = isset( $instance['ajax'] ) ? $instance['ajax'] : $this->settings['ajax']['std'];

		if (apply_filters('et_ajax_widgets', $ajax)){
			$instance['selector'] = '.etheme-product-status-filter';
			echo et_ajax_element_holder( 'Product_Status_Filter', $instance, '', '', 'widget_filter', $args );
			return;
		}
		$link  = $this->get_current_page_url();
		$class = $in_stock_class = $out_of_stock_class = '';
		$sale_link = $in_stock = $out_of_stock = $link;
		$count = isset( $instance['count'] ) ? $instance['count'] : $this->settings['count']['std'];
		
		if (! isset($_GET['stock_status'])){
			$out_of_stock = add_query_arg( 'stock_status', 'out_of_stock', $link );
		} else {
			if ($_GET['stock_status']=='in_stock'){
				$out_of_stock = add_query_arg( 'stock_status', 'out_of_stock,in_stock', $link );
			} elseif($_GET['stock_status']=='out_of_stock,in_stock'){
				$out_of_stock = add_query_arg( 'stock_status', 'in_stock', $link );
				$out_of_stock_class = 'chosen';
			} else {
				$out_of_stock = remove_query_arg( 'stock_status', $link );
				$out_of_stock_class = 'chosen';
			}
		}
		
		if (! isset($_GET['stock_status'])){
			$in_stock = add_query_arg( 'stock_status', 'in_stock', $link );
		} else {
			if ($_GET['stock_status']=='out_of_stock'){
				$in_stock = add_query_arg( 'stock_status', 'out_of_stock,in_stock', $link );
			}elseif($_GET['stock_status']=='out_of_stock,in_stock'){
				$in_stock = add_query_arg( 'stock_status', 'out_of_stock', $link );
				$in_stock_class = 'chosen';
			}else {
				$in_stock = remove_query_arg( 'stock_status', $link );
				$in_stock_class = 'chosen';
			}
		}
		
		if (! isset($_GET['sale_status'])){
			$sale_link = add_query_arg( 'sale_status', true, $link );
		} else {
			$sale_link = remove_query_arg( 'sale_status', $link );
			$class = 'chosen';
		}
		$this->widget_start( $args, $instance );
		
		?>
		<ul>
			<li class="<?php echo $in_stock_class; ?>">
				<a href="<?php echo $in_stock; ?>" class="etheme-ajax-filter etheme-stock-filter">
					<?php echo esc_html__( 'In stock', 'xstore-core' ); ?></a>
				<?php echo ($count) ? '(' . $this->get_status_count('instock') . ')' : ''?>
			</li>
			<li class="<?php echo $out_of_stock_class; ?>">
				<a href="<?php echo $out_of_stock; ?>" class="etheme-ajax-filter etheme-stock-filter">
					<?php echo esc_html__( 'Out of stock', 'xstore-core' ); ?>
					<?php echo ($count) ? '(' .$this->get_status_count('outofstock'). ')' : ''?>
				</a>
			</li>
			<li class="<?php echo $class; ?>">
				<a href="<?php echo $sale_link; ?>" class="etheme-ajax-filter etheme-sale-filter">
					<?php echo esc_html__( 'On sale', 'xstore-core' ) ?>
					<?php echo ($count) ? '(' .count(wc_get_product_ids_on_sale()). ')' : ''?>
				</a>
			</li>
		</ul>
		<?php
		$this->widget_end( $args, $instance );
	}
	
	public function get_status_count($type = 'outofstock'){
		global $wpdb;
		$outofstock = "SELECT COUNT(*) FROM $wpdb->posts as p
                INNER JOIN $wpdb->postmeta pm
                on p.ID = pm.post_id
                and  pm.meta_key='_stock_status'
                AND pm.meta_value = '$type'
                AND p.post_status = 'publish'
                AND p.post_type = 'product'
            ";

		if( defined('WPML_TM_VERSION') && defined('WPML_ST_VERSION') && defined( 'ICL_LANGUAGE_CODE' ) ){
			$outofstock .= "
					INNER JOIN {$wpdb->prefix}icl_translations pl
               		on p.ID = pl.element_id
            		and pl.language_code = '".ICL_LANGUAGE_CODE."'
				";
		}
		return $wpdb->get_var($outofstock);
	}
	
	public function show_on_sale_products( $ids ) {
		if ( isset( $_GET['sale_status'] ) && $_GET['sale_status'] ) {
			$ids = array_merge( $ids, wc_get_product_ids_on_sale() );
		}
		return $ids;
	}
	
	public function show_in_stock_products( $query ) {
		if ( isset( $_GET['stock_status'] ) && $_GET['stock_status'] ) {
			$meta_query = array();
			if ($_GET['stock_status'] == 'in_stock'){
				$meta_query = array(
					'relation' => 'AND',
					array(
						'key'     => '_stock_status',
						'value'   => 'instock',
						'compare' => '=',
					),
				);
			} elseif ($_GET['stock_status'] == 'out_of_stock'){
				$meta_query = array(
					'relation' => 'AND',
					array(
						'key'     => '_stock_status',
						'value'   => 'outofstock',
						'compare' => '=',
					),
				);
			}
			$query->set( 'meta_query', array_merge( WC()->query->get_meta_query(), $meta_query ) );
		}
	}
}
