<?php  
	/**
	 * The template created for displaying catalog mode options 
	 *
	 * @version 0.0.2
	 * @since 6.0.0
	 */
	
	// section catalog-mode
	Kirki::add_section( 'catalog-mode', array(
	    'title'          => esc_html__( 'Catalog Mode', 'xstore' ),
	    'panel' => 'shop',
	    'icon' => 'dashicons-hidden' // dashicons-tickets-alt
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'toggle',
			'settings'    => 'just_catalog',
			'label'       => esc_html__( 'Just Catalog', 'xstore' ),
			'description' => esc_html__( 'Turn on to disable ability to buy products via removing "Add to Cart" buttons.', 'xstore'),
			'section'     => 'catalog-mode',
			'default'     => 0,
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'toggle',
			'settings'    => 'just_catalog_price',
			'label'       => esc_html__( 'Hide price', 'xstore' ),
			'description' => esc_html__( 'Turn on to hide product price.', 'xstore'),
			'section'     => 'catalog-mode',
			'default'     => 0,
			'active_callback' => array(
				array(
					'setting'  => 'just_catalog',
					'operator' => '=',
					'value'    => 1,
				),
			)
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'select',
			'settings'    => 'just_catalog_type',
			'label'       => esc_html__( 'Permission restrictions just for:', 'xstore' ),
			'section'     => 'catalog-mode',
			'default'     => 'all',
			'choices'     => array(
				'all' => esc_html__( 'All', 'xstore' ),
				'unregistered' => esc_html__( 'Unregistered', 'xstore' ),
			),
			'active_callback' => array(
				array(
					'setting'  => 'just_catalog',
					'operator' => '=',
					'value'    => 1,
				),
			)
		) );
		
?>