<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Gateways;

use Objectiv\Plugins\Checkout\Compatibility\Base;

class PayPalPlusCw extends Base {
	public function is_available() {
		return class_exists( '\\PayPalPlusCw_Util' );
	}

	public function run_immediately() {
		// always update checkout gateways when active
		add_filter( 'cfw_get_payment_methods_html_fingerprint', function( $fingerprint ) {
			return microtime();
		} );
	}

	function typescript_class_and_params( $compatibility ) {
		$compatibility[] = [
			'class'  => 'PayPalPlusCw',
			'params' => [],
		];

		return $compatibility;
	}
}