<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Gateways;

use Objectiv\Plugins\Checkout\Compatibility\Base;

class Square extends Base {
	public function is_available() {
		return class_exists( '\\WooCommerce_Square_Loader' );
	}

	public function run() {
		if ( class_exists( '\\WooCommerce\\Square\\Plugin' ) && version_compare( \WooCommerce\Square\Plugin::VERSION, '2.1.3', '<' ) ) {
			$this->reorder_payment_tab();
		}
	}

	function reorder_payment_tab() {
		remove_action( 'cfw_checkout_payment_method_tab', 'cfw_payment_methods', 10 );
		remove_action( 'cfw_checkout_payment_method_tab', 'cfw_payment_tab_content_billing_address', 20 );

		add_action( 'cfw_checkout_payment_method_tab', 'cfw_payment_tab_content_billing_address', 10 );
		add_action( 'cfw_checkout_payment_method_tab', 'cfw_payment_methods', 20 );
	}

	function typescript_class_and_params( $compatibility ) {
		if ( class_exists( '\\WooCommerce\\Square\\Plugin' ) && version_compare( \WooCommerce\Square\Plugin::VERSION, '2.1.3', '<' ) ) {
			$compatibility[] = [
				'class'  => 'Square212',
				'params' => [],
			];
		} else {
			$compatibility[] = [
				'class'  => 'Square',
				'params' => [],
			];
		}

		return $compatibility;
	}
}