<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Plugins;

use Objectiv\Plugins\Checkout\Compatibility\Base;
use Objectiv\Plugins\Checkout\Core\Admin;
use Objectiv\Plugins\Checkout\Main;

class ElementorPro extends Base {
	function is_available() {
		return defined( 'ELEMENTOR_PRO_VERSION' );
	}

	public function pre_init() {
		add_action( 'elementor/theme/register_locations', array( $this, 'register_elementor_locations' ) );
		add_action( 'cfw_admin_integrations_settings', array( $this, 'admin_integration_setting' ) );
	}

	function run() {
		if ( Main::instance()->get_settings_manager()->get_setting( 'enable_elementor_pro_support' ) == 'yes' ) {
			// Workaround for copify theme
			$documents_by_conditions = \ElementorPro\Modules\ThemeBuilder\Module::instance()->get_conditions_manager()->get_documents_for_location( 'footer' );

			if ( ! empty( $documents_by_conditions ) ) {
				return wc_maybe_define_constant( 'CFW_HAS_ELEMENTOR_FOOTER', true );
			}
		}

		wc_maybe_define_constant( 'CFW_HAS_ELEMENTOR_FOOTER', false );
	}

	/**
	 * @param Admin $admin
	 */
	function admin_integration_setting( $admin ) {
		?>
		<tr>
			<th scope="row" valign="top">
				<label for="<?php echo $admin->plugin_instance->get_settings_manager()->get_field_name('enable_elementor_pro_support' ); ?>"><?php _e('Elementor Pro', 'checkout-wc'); ?></label>
			</th>
			<td>
				<input type="hidden" name="<?php echo $admin->plugin_instance->get_settings_manager()->get_field_name('enable_elementor_pro_support'); ?>" value="no" />
				<label><input type="checkbox" name="<?php echo $admin->plugin_instance->get_settings_manager()->get_field_name('enable_elementor_pro_support'); ?>" id="<?php echo $admin->plugin_instance->get_settings_manager()->get_field_name('enable_elementor_pro_support'); ?>" value="yes" <?php if ( $admin->plugin_instance->get_settings_manager()->get_setting('enable_elementor_pro_support') == "yes" ) echo "checked"; ?> /> <?php _e('Enable Elementor Pro support.', 'checkout-wc'); ?></label>
				<p><span class="description"><?php _e('Allow Elementor Pro to replace header and footer.', 'checkout-wc'); ?></span></p>
			</td>
		</tr>
		<?php
	}

	/**
	 * @param $elementor_theme_manager
	 */
	function register_elementor_locations( $elementor_theme_manager ) {
//		$elementor_theme_manager->register_location(
//			'cfw-header',
//			[
//				'label' => __( 'CheckoutWC Header', 'checkout-wc' ),
//				'multiple' => false,
//				'edit_in_content' => false,
//			]
//		);
//
//		$elementor_theme_manager->register_location(
//			'cfw-footer',
//			[
//				'label' => __( 'CheckoutWC Footer', 'checkout-wc' ),
//				'multiple' => false,
//				'edit_in_content' => false,
//			]
//		);
	}
}
