<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Plugins;

use Objectiv\Plugins\Checkout\Compatibility\Base;

class NIFPortugal extends Base {
	public function __construct() {
		parent::__construct();
	}

	public function is_available() {
		return function_exists( 'nif_active_nw_plugins' );
	}

	public function run() {
		add_filter( 'woocommerce_shipping_fields', array( $this, 'add_nif_field') );
	}

	function add_nif_field( $fields ) {
		remove_filter( 'woocommerce_shipping_fields', array( $this, 'add_nif_field') );

		$billing_fields = WC()->checkout()->get_checkout_fields( 'billing' );

		$fields['shipping_nif'] = $billing_fields['billing_nif'];

		add_filter( 'woocommerce_shipping_fields', array( $this, 'add_nif_field') );

		return $fields;
	}

	function typescript_class_and_params( $compatibility ) {
		$compatibility[] = [
			'class'  => 'NIFPortugal',
			'params' => [],
		];

		return $compatibility;
	}
}
