import 'ts-polyfill';
import { Main }                             from "./front/CFW/Main";
import { CompatibilityClasses }             from "./compatibility-classes";

declare var jQuery: any;
declare var cfwEventData: any;
(<any>window).CompatibilityClasses = CompatibilityClasses;
(<any>window).errorObserverIgnoreList = [];

/**
 * An error tolerant DOM ready replacement for jQuery(document).ready()
 * @param fn
 */
function cfw_dom_ready(fn) {
	// see if DOM is already available
	if (document.readyState === "complete" || document.readyState === "interactive") {
		// call on next available tick
		setTimeout(fn, 1);
	} else {
		document.addEventListener("DOMContentLoaded", fn);
	}
}

// Fired from compatibility-classes.ts
cfw_dom_ready( function() {
	let data = cfwEventData;
	let checkoutFormElement     = jQuery( data.elements.checkoutFormSelector );
	let breadCrumbElement       = jQuery( data.elements.breadCrumbElId );
	let alertContainerElement   = jQuery( data.elements.alertContainerId );
	let tabContainerElement     = jQuery( data.elements.tabContainerElId );

	// Allow users to add their own Typescript Compatibility classes
	jQuery( document.body ).trigger( 'cfw-checkout-before-load' );

	new Main( checkoutFormElement, alertContainerElement, tabContainerElement, breadCrumbElement, data.ajaxInfo, data.settings );
} );