import { Compatibility } from "./Compatibility";
import {Main} from "../Main";
import {Alert, AlertInfo} from "../Components/Alert";
import {ParsleyService} from "../Services/ParsleyService";

declare let OffAmazonPayments: any;
declare let amazon_payments_advanced_params: any;
declare let jQuery: any;
declare let cfwEventData: any;

export class AmazonPay extends Compatibility {
	/**
	 * @param {Main} main The Main object
	 * @param {any} params Params for the child class to run on load
	 */
	constructor( main: Main, params ) {
		super( main, params, 'AmazonPay' );
	}

	/**
	 * Run the compatibility
	 *
	 * @param main
	 */
	load( main: Main ): void {
		const errorKey = 'cfw_amazon_redirect_error';
		let easyTabsWrap: any = main.tabService.tabContainer;
		let getParams = this.getUrlParamsMap();

		if( getParams[errorKey] !== undefined ) {
			let alertInfo: AlertInfo = {
				type: "error",
				message: jQuery( '.woocommerce-error' ).html(),
				cssClass: "cfw-alert-error"
			};

			jQuery( '.woocommerce-error' ).remove();

			let alert: Alert = new Alert( Main.instance.alertContainer, alertInfo );
			alert.addAlert();

			// TODO: Is this overlay even working?
			jQuery( '#checkout' ).addClass( 'has-overlay' );
			jQuery( '#cfw-coupons' ).addClass( 'has-overlay' );
			jQuery( '#checkout' ).append( '<div class="amazon-pay-overlay"></div>' );
			jQuery( '#cfw-coupons' ).append( '<div class="amazon-pay-overlay"></div>' );

			if( amazon_payments_advanced_params !== undefined &&
				amazon_payments_advanced_params.declined_code !== undefined &&
				amazon_payments_advanced_params.declined_code === 'InvalidPaymentMethod' ) {

				(<any>window).setTimeout(() => {
					location.href = location.href = location.href.replace(`${errorKey}=1`, '' );
				}, 3000);
			}

			return;
		}

		/**
		 * If the OffAmazonPayments and amazon_payments_advanced_params exist we can then check to see if there is a reference
		 * id set. If not we are not logged in. If there is we are logged in.
		 */
		try {
			if ( OffAmazonPayments !== undefined &&
				amazon_payments_advanced_params !== undefined &&
				( amazon_payments_advanced_params.reference_id !== "" || amazon_payments_advanced_params.access_token !== "" )
			) {
				jQuery( window.document ).on( 'wc_amazon_pa_widget_ready', () => {
					(<any>window).cfw_suppress_js_field_validation = true;
				} );

				jQuery( window.document ).on( 'wc_amazon_pa_widget_ready cfw_updated_checkout', () => {
					jQuery( '.create-account .cfw-input-wrap' ).addClass( 'cfw-floating-label' );
				});

				jQuery( window.document ).on( 'wc_amazon_pa_widget_ready', () => {
					jQuery( '#billing_same_as_shipping_radio' ).remove();
				} );

				if ( cfwEventData.checkout_params.option_guest_checkout === 'yes' ) {
					jQuery( document.body ).on( 'change', 'input#createaccount', this.toggle_create_account );
				}

				jQuery( document.body ).on( 'cfw_updated_checkout', function() {
					jQuery( 'input#createaccount' ).change();
				} );

				jQuery( window ).on( 'load cfw_updated_checkout', () => {
                    this.cleanUpExtraStuff();
				});

				jQuery( document.body ).on( 'updated_checkout', ( event, clicked, target ) => this.amazonRefresh() );

				easyTabsWrap.bind( 'easytabs:after', ( event, clicked, target ) => this.amazonRefresh() );

				(<any>window).addEventListener( 'cfw-checkout-failed-before-error-message', ({detail}) => {
					let response = detail.response;

					if ( response.reload ) {
						let errorParam = `&${errorKey}=1`;

						location.href = amazon_payments_advanced_params.redirect + errorParam;
					}
				});
			}
		} catch( error ) {
			console.log( error );
		}
	}

	getUrlParamsMap() {
		let map = {};
		let urlGetParams = location.href.split( '&' ).splice(1).map( paramSet => {
			let keyValue = paramSet.split( '=' );
			let key = keyValue[0];
			let value = keyValue[1];

			map[key] = value;
		});

		return map;
	}

	toggle_create_account() {
		jQuery( 'div.create-account' ).hide();

		if ( jQuery( this ).is( ':checked' ) ) {
			// Ensure password is not pre-populated.
			jQuery( '#account_password' ).val( '' ).change();
			jQuery( 'div.create-account' ).slideDown();
		}
	}

	cleanUpExtraStuff() {
        jQuery( '#payment-info-separator-wrap' ).hide();
        jQuery( '#cfw-shipping-same-billing' ).hide();
        jQuery( '#cfw-billing-methods > h3' ).hide();
        jQuery( '#cfw-shipping-info > h3' ).hide();
        jQuery( '#cfw-payment-method > h3' ).hide();
	}

	/**
	 * Refreshes and loads the split amazon setup
	 */
	amazonRefresh() {
		OffAmazonPayments.Widgets.Utilities.setup();
        this.cleanUpExtraStuff();
	}
}