import { Compatibility } from "./Compatibility";
import { Main }          from "../Main";

declare let jQuery: any;

export class BraintreeForWooCommerce extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'BraintreeForWooCommerce' );
    }


    load( main: Main ): void {
        let easyTabsWrap: any = main.tabService.tabContainer;

        jQuery( document.body ).on( 'cfw-after-tab-change', ( event, clicked, target ) => this.refreshBraintree( main, event, clicked, target ) );

        jQuery( window ).on( 'payment_method_selected', () => {
            main.updateCheckoutService.force_updated_checkout = true;
            main.updateCheckoutService.triggerUpdateCheckout();
        } );
    }

    refreshBraintree( main: Main, event: any, clicked: any, target: any ): void {
        if( jQuery( target ).attr( 'id' ) === 'cfw-payment-method' ) {
            main.updateCheckoutService.force_updated_checkout = true;
            main.updateCheckoutService.triggerUpdateCheckout();
        }
    }
}