import { Compatibility } from "./Compatibility";
import { Main } from "../Main";

declare let jQuery: any;

export class NIFPortugal extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'NIF (Num. de Contribuinte Português) for WooCommerce' );
    }

    load( main: Main ): void {
        if ( jQuery( 'form.checkout' ).length === 0 ) {
            return;
        }

        var current_nif = '';

        //Address changed?
        var checkout_form = jQuery( 'form.checkout' );
        
        checkout_form.on( 'change', '#shipping_country', function() {
            var country = jQuery( '#shipping_country' ).val();
            if ( country == 'PT' ) {
                if ( jQuery( '#shipping_nif_field' ).is( ':hidden' ) ) {
                    jQuery( '#shipping_nif_field' ).show();
                    if ( current_nif != '' ) {
                        jQuery( '#shipping_nif' ).val( current_nif );
                    }
                    current_nif = '';
                }
            } else {
                if ( jQuery( '#shipping_nif_field' ).is( ':visible' ) ) {
                    current_nif = jQuery( '#shipping_nif' ).val();
                    jQuery( '#shipping_nif' ).val( '' );
                    jQuery( '#shipping_nif_field' ).hide();
                }
            }
        } );
    }
}