import { Compatibility } from "./Compatibility";
import { Main } from "../Main";

declare let jQuery: any;

export class PayPalForWooCommerce extends Compatibility {
	/**
	 * @param {Main} main The Main object
	 * @param {any} params Params for the child class to run on load
	 */
	constructor( main: Main, params ) {
		super( main, params, 'PayPalForWooCommerce' );
	}

	load( main: Main ): void {
		/**
		 * Fix for 2.1.10+
		 *
		 * PayPal for WooCommerce sets window.location.href to itself, which by default doesn't do anything because it treats this like a hash change.
		 * So, we use a variable to track the current hash on page load and then determine if the hash has changed or if it has been set to itself. If set to itself, we reload the page
		 * Otherwise, we update the currentHash variable. Yes it's hacky, but yes it works.
		 */
		let currentHash = window.location.hash;

		window.addEventListener('popstate', function( event ) {
			if ( window.location.hash == currentHash ) {
				window.location.reload();
			}

			currentHash = window.location.hash;
		} );

		let interval = 0;

		// Don't run the below if on express checkout review page
		let is_set_class = jQuery(`div`).is(`.express-provided-address`);

		if ( is_set_class ) {
			return;
		}

		jQuery( window ).on( 'payment_method_selected cfw_updated_checkout', () => {
			let max_iterations = 200;
			let iterations = 0;

			interval = (<any>window).setInterval(() => {
				let main: Main = Main.instance;

				if ( jQuery( 'input[name="payment_method"]:checked' ).is( '#payment_method_paypal_express' ) && jQuery( '.angelleye_smart_button_checkout_bottom' ).first().is( ':empty' ) ) {
					main.updateCheckoutService.triggerUpdatedCheckout();
				} else if( ! jQuery( 'input[name="payment_method"]:checked' ).is( '#payment_method_paypal_express' ) || ! jQuery( '.angelleye_smart_button_checkout_bottom' ).first().is( ':empty' ) ) {
					clearInterval( interval );
				} else if( iterations >= max_iterations ) {
					// Give up
					clearInterval( interval );
				} else {
					iterations++;
				}
			}, 50);
		} );

		jQuery( window ).on( 'cfw_updated_checkout', () => {
			let isPPEC = jQuery( 'input[name="payment_method"]:checked' ).is( '#payment_method_paypal_express' );
			jQuery( '#place_order' ).toggle( ! isPPEC );
			jQuery( '.angelleye_smart_button_checkout_bottom' ).toggle( isPPEC );
		} );
	}
}