import { Compatibility } from "./Compatibility";
import { Main } from "../Main";

declare let jQuery: any;

export class PayPalPlusCw extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'PayPalPlusCw' );
    }

    load( main: Main ): void {
        let easyTabsWrap: any = main.tabService.tabContainer;

        easyTabsWrap.bind( 'easytabs:after', ( event, clicked, target ) => {
            if ( jQuery( target ).attr( 'id' ) == 'cfw-payment-method' ) {
                main.updateCheckoutService.queueUpdateCheckout();
            }
        } );
    }
}