import { Compatibility } from "./Compatibility";
import { Main } from "../Main";

declare let jQuery: any;
declare let pvkw: any;

export class PortugalVaspKios extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'PortugalVaspKios' );
    }

    load( main: Main ): void {
        jQuery( document.body ).on( 'cfw_updated_checkout', function() {
            jQuery( function( $ ) {
                $( '#pvkw' ).hide();
                $( '#pvkw_point_active' ).val('0');
                //Country - we only do this for Portugal
                if ( $( '#ship-to-different-address' ).find( 'input' ).is( ':checked' ) ) {
                    var country = $( '#shipping_country' ).val();
                } else {
                    var country = $( '#billing_country' ).val();
                }
                if ( country == 'PT' ) {
                    //checkout.js : 271
                    var shipping_methods = {};
                    $( 'select.shipping_method, input[name^="shipping_method"][type="radio"]:checked, input[name^="shipping_method"][type="hidden"]' ).each( function() {
                        shipping_methods[ $( this ).data( 'index' ) ] = $( this ).val();
                    } );
                    //Only one shipping method chosen?
                    if ( Object.keys( shipping_methods ).length == 1 ) {
                        var shipping_method = $.trim( shipping_methods[0] );
                        if ( $.inArray( shipping_method, pvkw.shipping_methods ) >= 0 ) {
                            $( '#pvkw' ).show();
                            $( '#pvkw_point_active' ).val('1');
                            if ( $().select2 ) {
                                $( '#pvkw_point' ).select2();
                            }
                        }
                    }
                }
            } );
        } );
    }
}