import { Compatibility } from "./Compatibility";
import { Main } from "../Main";
import {FormField} from "../Components/FormField";

declare let jQuery: any;

export class PostNL extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'PostNL' );
    }

    load( main: Main ): void {
        jQuery( document.body ).on( 'cfw_updated_checkout', () => {
            // Shipping address
            let shipping_street_name = jQuery( '#shipping_street_name' );
            let shipping_house_number = jQuery( '#shipping_house_number' );
            let shipping_house_number_suffix = jQuery( '#shipping_house_number_suffix' );
            let shipping_city = jQuery( '#shipping_city' );
            let shipping_address_1 = '';

            // Fix float labels
            if ( shipping_street_name.val() ) {
                shipping_street_name.parent().addClass( FormField.float_class );
            }

            if ( shipping_city.val() ) {
                shipping_city.parent().addClass( FormField.float_class );
            }

            // Set address 1
            if ( shipping_street_name.val() && shipping_house_number.val() ) {
                shipping_address_1 = shipping_street_name.val() + ' ' + shipping_house_number.val();
            }

            if ( shipping_house_number_suffix.val() && shipping_address_1 ) {
                shipping_address_1 = shipping_address_1 + '-' + shipping_house_number_suffix.val();
            }

            if ( shipping_address_1 ) {
                jQuery( '#shipping_address_1' ).val( shipping_address_1 );
            }

            // Billing address
            let billing_street_name = jQuery( '#billing_street_name' );
            let billing_house_number = jQuery( '#billing_house_number' );
            let billing_house_number_suffix = jQuery( '#billing_house_number_suffix' );
            let billing_city = jQuery( '#billing_city' );
            let billing_address_1 = '';

            // Fix float labels
            if ( billing_street_name.val() ) {
                billing_street_name.parent().addClass( FormField.float_class );
            }

            if ( billing_city.val() ) {
                billing_city.parent().addClass( FormField.float_class );
            }

            // Set address 1
            if ( billing_street_name.val() && billing_house_number.val() ) {
                billing_address_1 = billing_street_name.val() + ' ' + billing_house_number.val();
            }

            if ( billing_house_number_suffix.val() && billing_address_1 ) {
                billing_address_1 = billing_address_1 + '-' + billing_house_number_suffix.val();
            }

            if ( billing_address_1 ) {
                jQuery( '#billing_address_1' ).val( billing_address_1 );
            }
        } );

        jQuery( window ).load( function() {
            // Hide empty containers from WC Postcode Checker NL moving fields around
            jQuery( '.row:not(:has(*))' ).hide();

            // Add spacing due to moving fields around
            jQuery( '.col-lg-12' ).filter( function() {
                return jQuery( this ).next( '.cfw-column-12' ).length;
            } ).css('margin-bottom', '12.5px');
        } );
    }
}