import { Compatibility } from "./Compatibility";
import { Main } from "../Main";

declare let jQuery: any;

export class SkyVergeCheckoutAddons extends Compatibility {
    /**
     * @param {Main} main The Main object
     * @param {any} params Params for the child class to run on load
     */
    constructor( main: Main, params ) {
        super( main, params, 'SkyVergeCheckoutAddons' );
    }

    load( main: Main ): void {
        jQuery( document.body ).on( 'cfw_updated_checkout', function() {
            // Force updated_checkout when this plugin is active
            main.updateCheckoutService.force_updated_checkout = true;
        } );
    }
}