export class Accordion {
    private readonly _target_selector;

    /**
     * Default selector is the class used for all radio reveal groups
     * SO, when using you have to remember that .cfw-radio-reveal-group matches
     * multiple parent containers for different accordions
     *
     * @param target_selector
     */
    constructor( target_selector: string = '.cfw-radio-reveal-group' ) {
        this._target_selector = target_selector;

        this.setListeners();
    }

    setListeners() {
        jQuery( document.body ).on( 'change', this._target_selector + ' .cfw-radio-reveal-title-wrap :radio', ( e ) => {
            this.showContent( e.target );
        } );

        jQuery( document.body ).on( 'cfw_updated_checkout', () => {
            jQuery( this._target_selector ).each( ( index, element ) => {
                this.showContent( jQuery( element ).find(' .cfw-radio-reveal-title-wrap :radio:checked' ).first() );
            } );
        } );
    }

    showContent( radio_button ) {
        radio_button     = jQuery( radio_button );
        let parent_row   = radio_button.parents( '.cfw-radio-reveal-li' ).first();

        if ( radio_button.is( ':checked') ) {
            parent_row.addClass( 'active' );
            parent_row.siblings('.cfw-radio-reveal-li').removeClass('active');
            parent_row.siblings( '.cfw-radio-reveal-li' ).find( '.cfw-radio-reveal-content:visible' ).slideUp(300);
            parent_row.find( '.cfw-radio-reveal-content:hidden' ).slideDown( 300 );
        }
    }
}