import {UpdateCartAction} from "../Actions/UpdateCartAction";
import {Main} from "../Main";

declare let jQuery: any;
declare let cfwEventData: any;

export class Cart {
    constructor() {
        this.setUpMobileCartDetailsReveal();
        this.setQuantityStepperTriggers();
    }

    setQuantityStepperTriggers(): void {
        jQuery( document.body ).on( 'click', '.cfw-quantity-stepper-btn-minus', function() {
            let quantity_value = jQuery( this ).parent( '.cfw-quantity-stepper' ).find( '.cfw-edit-item-quantity-value' ).first();
            let quantity_label = jQuery( this ).parents( '.cart-item-row' ).find( '.cfw-cart-item-quantity-bubble' ).first();
            let new_quantity   = Number( quantity_value.val() ) - 1;

            if ( new_quantity > 0 || window.confirm( cfwEventData.settings.delete_confirm_message ) ) {
                quantity_value.val( new_quantity );
                quantity_label.text( new_quantity );

                new UpdateCartAction( 'update_cart', Main.instance.ajaxInfo, Main.instance.getFormObject('update_cart') ).load();
            }
        } );

        jQuery( document.body ).on( 'click', '.cfw-quantity-stepper-btn-plus', function() {
            let quantity_value = jQuery( this ).parent( '.cfw-quantity-stepper' ).find( '.cfw-edit-item-quantity-value' ).first();
            let quantity_label = jQuery( this ).parents( '.cart-item-row' ).find( '.cfw-cart-item-quantity-bubble' ).first();
            let max_quantity   = Number( jQuery( quantity_value ).data( 'max-quantity' ) );
            let new_quantity   = Number( quantity_value.val() ) + 1;

            if ( new_quantity <= max_quantity ) {
                quantity_value.val( new_quantity );
                quantity_label.text( new_quantity );

                new UpdateCartAction( 'update_cart', Main.instance.ajaxInfo, Main.instance.getFormObject('update_cart') ).load();
            }
        } );
    }

    /**
     *
     */
    setUpMobileCartDetailsReveal(): void {
        let showCartDetails = jQuery( '#cfw-mobile-cart-header' );

        showCartDetails.on( 'click', function( e ) {
            e.preventDefault();
            jQuery( '#cfw-cart-summary-content' ).slideToggle( 300 ).parent().toggleClass( 'active' )
        });
    }
}