import { Main } from "../Main";
import { AccountExistsAction } from "../Actions/AccountExistsAction";
import { LoginAction } from "../Actions/LoginAction";
import { Utilities } from "../Modules/Utilities";

declare let cfwEventData: any;

export class LoginForm {
    constructor() {
        this.setListeners();
    }

    setListeners() {
        this.setAccountCheckListener();
        this.setLogInListener();
        this.setDefaultLoginFormListener();
        this.setAnimationListeners();
        this.setCreateAccountCheckboxListener();
    }

    /**
     *
     */
    setAccountCheckListener() {
        let email_input: any = jQuery( '#billing_email' );

        if ( email_input ) {
            // Add check to keyup event
            email_input.on( 'keyup change', Utilities.debounce( this.triggerAccountExistsCheck, 250 ) );

            // Handles page onload use case
            this.triggerAccountExistsCheck();
        }
    }

    /**
     *
     */
    setLogInListener() {
        let email_input: any = jQuery( '#billing_email' );

        if( email_input ) {
            let password_input: any = jQuery( '#cfw-password' );

            let login_btn: any = jQuery( '#cfw-login-btn' );

            // Fire the login action on click
            login_btn.on( 'click', () => new LoginAction( 'login', Main.instance.ajaxInfo, email_input.val(), password_input.val() ).load() );
        }
    }

    setDefaultLoginFormListener() {
        jQuery( document.body ).on( 'click', 'a.showlogin', function() {
            jQuery( 'form.login, form.woocommerce-form--login' ).slideToggle();

            return false;
        } );
    }

    /**
     * Sets up animation listeners
     */
    setAnimationListeners(): void {
        let create_account_checkbox = jQuery( '#createaccount' );

        jQuery( '#cfw-ci-login' ).on( 'click', function(){
            jQuery( '#cfw-login-slide' ).slideToggle( 300 ).toggleClass( 'stay-open' );

            if ( create_account_checkbox.is( ':checked:enabled' ) ) {
                create_account_checkbox.prop( 'checked', false ).trigger( 'change' );
            }
        });
    }

    setCreateAccountCheckboxListener(): void {
        if ( ! cfwEventData.settings.registration_generate_password ) {
            let create_account_checkbox = jQuery(`#createaccount`);
            let account_password_slide  = jQuery(`#cfw-account-password-slide`);
            let account_password        = jQuery(`#account_password`);

            create_account_checkbox.change( function() {
                if ( jQuery(this).is(':checked') ) {
                    account_password_slide.slideDown(300);
                    account_password.attr( 'data-parsley-required', 'true' );
                    account_password.prop( 'disabled', false );
                    jQuery( '#cfw-login-slide' ).slideUp( 300 );
                } else {
                    account_password_slide.slideUp(300);
                    account_password.attr( 'data-parsley-required', 'false' );
                    account_password.prop( 'disabled', true );
                }
            } ).trigger('change');
        }
    }

    triggerAccountExistsCheck() {
        let ajax_info = Main.instance.ajaxInfo;
        let email_input: any = jQuery( '#billing_email' );

        if ( email_input ) {
            new AccountExistsAction( 'account_exists', ajax_info, email_input.val(), ! cfwEventData.settings.enable_checkout_login_reminder ).load();
        }
    }
}