import { Alert, AlertInfo }    from "../Components/Alert";
import { CompleteOrderAction } from "../Actions/CompleteOrderAction";

export class AlertService {
    /**
     * @type {MutationObserver}
     * @private
     */
    private _errorObserver: MutationObserver;
    private _alertContainer: any;

    constructor( alertContainer: any ) {
        this.alertContainer = alertContainer;
        this.setMutationObserverWatcher();
    }

    setMutationObserverWatcher() {
        // Error observer messages to ignore
        jQuery( document.body ).trigger( 'cfw-before-alert-service-mutation-observer-init' );

        // Select the node that will be observed for mutations
        let targetNode = jQuery('form').get(0);

        // Options for the observer ( which mutations to observe )
        let config = { childList: true, characterData: true, subtree: true };

        if ( ! this.errorObserver ) {
            // Create an observer instance linked to the callback function
            let observer = new MutationObserver(( mutationsList ) => this.errorMutationListener( mutationsList ));

            // Start observing the target node for configured mutations
            observer.observe( targetNode, config );

            this.errorObserver = observer;
        }
    }

    /**
     * @param mutationsList
     */
    errorMutationListener( mutationsList ) {
        let ignoreList = (<any>window).errorObserverIgnoreList;

        if( jQuery( '#cfw-payment-method:visible' ).length || jQuery( '.context-order-pay' ).length ) {
            for ( let mutation of mutationsList ) {
                if ( mutation.type === 'childList' ) {
                    let addedNodes = mutation.addedNodes;
                    let $errorNode: any = null;

                    Array.from( addedNodes ).forEach( node => {
                        let $node: any = jQuery( node );
                        let hasClass: boolean = $node.hasClass( 'woocommerce-error' );
                        let hasGroupCheckoutClass: boolean = $node.hasClass( 'woocommerce-NoticeGroup-checkout' );

                        if ( hasClass || hasGroupCheckoutClass ) {
                            if( ignoreList.indexOf( $node.text() ) == -1 ) {
                                jQuery( document.body ).trigger( 'cfw-remove-overlay' );
                                $errorNode = $node;
                                $errorNode.attr( 'class','' );
                            }
                        }
                    });

                    if ( $errorNode ) {
                        if ( $errorNode.find( 'li' ).length > 0 ) {
                            jQuery.each( $errorNode.find( 'li' ), ( i, el ) => {
                                let alert: Alert = new Alert( this.alertContainer, <AlertInfo> {
                                    type: "error",
                                    message: jQuery.trim( jQuery( el ).text() ),
                                    cssClass: "cfw-alert-error"
                                } );
                                alert.addAlert();
                            } );
                        } else {
                            let alert: Alert = new Alert( this.alertContainer, <AlertInfo> {
                                type: "error",
                                message: jQuery.trim( $errorNode.text() ),
                                cssClass: "cfw-alert-error"
                            } );
                            alert.addAlert();
                        }

                        $errorNode.remove();

                        CompleteOrderAction.initCompleteOrder = false;
                    }
                }
            }
        }
    }

    /**
     * @returns {MutationObserver}
     */
    get errorObserver(): MutationObserver {
        return this._errorObserver;
    }

    /**
     * @param {MutationObserver} value
     */
    set errorObserver( value: MutationObserver ) {
        this._errorObserver = value;
    }

    get alertContainer(): any {
        return this._alertContainer;
    }

    set alertContainer(value: any) {
        this._alertContainer = value;
    }
}