import { Main }                from "../Main";
import { CompleteOrderAction } from "../Actions/CompleteOrderAction";
import { AjaxInfo }            from "../Types/Types";

declare let jQuery: any;

export class CompleteOrderService {
    /**
     * @type {any}
     * @private
     */
    private _checkoutDataAtSubmitClick: any;

    constructor() {
        this.setCompleteOrderListener();
    }

    /**
     *
     */
    setCompleteOrderListener(): void {
        let checkout_form: any = Main.instance.checkoutForm;

        checkout_form.on( 'submit', this.completeOrderSubmitHandler.bind( this ) );
    }

    /**
     *
     */
    completeOrderSubmitHandler( e ) {
        let main: Main = Main.instance;
        let checkout_form: any = main.checkoutForm;
        let lookFor: Array<string> = main.settings.default_address_fields;
        let preSwapData = this.checkoutDataAtSubmitClick = {};

        if ( checkout_form.is( '.processing' ) ) {
            return false;
        }

        CompleteOrderAction.initCompleteOrder = true;

        Main.addOverlay();

        checkout_form.find( '.woocommerce-error' ).remove();

        jQuery( document.body ).on( 'checkout_error', () => {
            checkout_form.removeClass( 'processing' ); // compatibility with gateways / plugins that expect this
            jQuery( document.body ).trigger( 'cfw-remove-overlay' );
            CompleteOrderAction.initCompleteOrder = false
        });

        if ( checkout_form.find( 'input[name="bill_to_different_address"]:checked' ).val() === "same_as_shipping" ) {
            lookFor.forEach( field => {
                let billing = jQuery(`#billing_${field}`);
                let shipping = jQuery(`#shipping_${field}`);

                if( billing.length > 0) {
                    preSwapData[field] = billing.val();

                    billing.val( shipping.val());
                    billing.trigger( 'keyup' );
                }
            });
        }

        // If all the payment stuff has finished any ajax calls, run the complete order.
        if ( checkout_form.triggerHandler( 'checkout_place_order' ) !== false && checkout_form.triggerHandler( 'checkout_place_order_' + checkout_form.find( 'input[name="payment_method"]:checked' ).val() ) !== false ) {
            checkout_form.addClass( 'processing' );

            // Reset data
            for ( let field in preSwapData ) {
                let billing = jQuery(`#billing_${field}`);

                billing.val( preSwapData[field]);
            }

            this.orderKickOff( main.ajaxInfo, Main.instance.getFormObject());
        } else {
            checkout_form.removeClass( 'processing' ).unblock();
        }

        /**
         * Throwing an error here seems to cause situations where the error briefly appears during a successful order
         */
        return false;
    }

    /**
     *
     * @param {AjaxInfo} ajaxInfo
     * @param data
     */
    orderKickOff( ajaxInfo: AjaxInfo, data ): void {
        new CompleteOrderAction( 'complete_order', ajaxInfo, data );
    }

    /**
     * @returns {any}
     */
    get checkoutDataAtSubmitClick(): any {
        return this._checkoutDataAtSubmitClick;
    }

    /**
     * @param value
     */
    set checkoutDataAtSubmitClick( value: any ) {
        this._checkoutDataAtSubmitClick = value;
    }
}