declare let jQuery: any;

/**
 * Field Persistence Service
 */
export class FieldPersistenceService {
    constructor( form: any ) {
        let excludes = [
            'input[type="file"]',
            'input[type="hidden"]',
            'input[type="submit"]',
            'input[type="reset"]',
            'input[name="payment_method"]',
            'input[name="paypal_pro-card-number"]',
            'input[name="paypal_pro-card-cvc"]',
            'input[name="wc-authorize-net-aim-account-number"]',
            'input[name="wc-authorize-net-aim-csc"]',
            'input[name="paypal_pro_payflow-card-number"]',
            'input[name="paypal_pro_payflow-card-cvc"]',
            'input[name="paytrace-card-number"]',
            'input[name="paytrace-card-cvc"]',
            'input[id="stripe-card-number"]',
            'input[id="stripe-card-cvc"]',
            'input[name="creditCard"]',
            'input[name="cvv"]',
            'input.wc-credit-card-form-card-number',
            'input[name="wc-authorize-net-cim-credit-card-account-number"]',
            'input[name="wc-authorize-net-cim-credit-card-csc"]',
            'input.wc-credit-card-form-card-cvc',
            'input.js-sv-wc-payment-gateway-credit-card-form-account-number',
            'input.js-sv-wc-payment-gateway-credit-card-form-csc',
            'input.shipping_method',
            'input[name^="tocheckoutcw"]',
            '#_sumo_pp_enable_order_payment_plan',
            '.cfw-cart-quantity-input',
            '.gift-certificate-show-form input'
        ];

        form.garlic({
            events: ['textInput', 'input', 'change', 'click', 'keypress', 'paste', 'focus'],
            destroy: false,
            excluded: excludes.join(', '),
            onRetrieve: this.onRetrieve
        });

        this.setListeners();
    }

    setListeners() {
        jQuery( document.body ).on( 'cfw-order-complete-before-redirect', ( event, form ) => {
            this.destroyForm( form );
        } );

        // After Parsley Service resets field
        jQuery( document.body ).on( 'cfw-after-field-country-to-state-changed', ( e ) => {
            jQuery( e.target ).garlic();
        } )
    }

    destroyForm( form: any ) {
        jQuery( form ).find( ':input' ).each( ( index, element ) => {
            jQuery( element ).garlic( 'destroy' );
        } );
    }

    onRetrieve( element, retrieved_value ) {
        jQuery( document.body ).trigger( 'cfw-field-persistence-after-retrieve-value', [ element, retrieved_value ] );
    }
}