import {CompleteOrderAction} from "../Actions/CompleteOrderAction";
import {Main} from "../Main";

declare var jQuery: any;
declare var window: any;
declare var cfwEventData: any;
declare var wc_address_i18n_params: any;

export class ParsleyService {

    /**
     * @type {any}
     * @private
     */
    private _parsley: any;

    private readonly _parsley_config: any;

    /**
     *
     */
    constructor() {
        // Attach errors to the outer parent so that select arrow styling isn't effected by dynamic height of cfw-input-wrap
        this._parsley_config = {
            errorsContainer: function( parsley_element ) {
                return parsley_element.$element.parent( '.cfw-input-wrap' ).parent( 'div' );
            }
        };

        this.setParsleyValidators();
    }

    /**
     *
     */
    setParsleyValidators(): void {
        // An instance of self that we can use without
        // worrying about scoping issues with functions
        const self = this;

        /**
         * Init Parsley
         */
        jQuery( window ).on( 'load', () => {
            this.parsley = window.Parsley;
            this.parsley.on( 'form:error', () => {
                jQuery( document.body ).trigger( 'cfw-remove-overlay' );
                CompleteOrderAction.initCompleteOrder = false;
            });

            try {
                // Parsley locale
                window.Parsley.setLocale( cfwEventData.settings.parsley_locale );
            } catch {
                console.log('CheckoutWC: Could not load Parsley translation domain (' + cfwEventData.settings.parsley_locale + ')' );
            }

            Main.instance.checkoutForm.parsley( this._parsley_config );

            // If we don't call this here, changing the state
            // field to 'Select an option' doesn't fire validation
            (<any>window).setTimeout( () => {
                self.refreshParsley();
            } );
        } );

        /**
         * There's a lot going on here, but here's essentially what we're doing.
         *
         * If the state field changes, we check to see what field type it is and do the following:
         * - Add correct classes to field parent wrap
         * - Make any changes to the Parsley validation
         * - Refresh Parsley
         *
         * The fields we are handling in this routine are state, city, and postcode for both address types.
         *
         * Lastly, we do this in a timer because we can't guarantee that WooCommerce will be done making their changes
         * before this runs. So by delaying 100ms, we ensure that they are completely done before we do our stuff.
         */
        jQuery( document.body ).bind( 'country_to_state_changed', function( event, country, wrapper ) {
            if ( typeof wrapper == 'undefined' ) {
                return;
            }

            (<any>window).setTimeout( () => {
                let locale_json = wc_address_i18n_params.locale.replace( /&quot;/g, '"' );
                let locale = jQuery.parseJSON( locale_json );

                let thislocale;

                if ( typeof locale[ country ] !== 'undefined' ) {
                    thislocale = locale[ country ];
                } else {
                    thislocale = locale['default'];
                }

                // Find the actual field wrapper
                wrapper = wrapper.find( '#billing_state, #shipping_state' ).parent( '.cfw-input-wrap' );
                let city_wrapper  = wrapper.find( '#billing_city, #shipping_city' ).parent( '.cfw-input-wrap' );
                let postcode_wrapper  = wrapper.find( '#billing_postcode, #shipping_postcode' ).parent( '.cfw-input-wrap' );

                wrapper.find( '#billing_state, #shipping_state' ).each( function() {
                    let fieldLocale = jQuery.extend( true, {}, locale['default'][ 'state' ], thislocale[ 'state' ] );

                    let group = jQuery( this ).attr( 'id' ).split( '_' )[0];

                    if ( jQuery( this ).is( 'select' ) ) {
                        // Setup data again
                        jQuery( this ).attr( 'field_key', 'state' )
                            .addClass( 'garlic-auto-save' )
                            .trigger( 'cfw-after-field-country-to-state-changed' );

                        wrapper.addClass( 'cfw-select-input' )
                            .removeClass( 'cfw-hidden-input' )
                            .removeClass( 'cfw-text-input' )
                            .addClass( 'cfw-floating-label' );
                    } else if( jQuery( this ).attr( 'type' ) === 'text' ) {
                        jQuery( this ).attr( 'field_key', 'state' )
                            .addClass( 'garlic-auto-save' )
                            .addClass( 'input-text' )
                            .trigger( 'cfw-after-field-country-to-state-changed' );

                        wrapper.addClass( 'cfw-text-input' )
                            .removeClass( 'cfw-hidden-input' )
                            .removeClass( 'cfw-select-input' )
                            .addClass( 'cfw-floating-label' );
                    } else {
                        jQuery( this ).addClass( 'hidden' );

                        wrapper.addClass( 'cfw-hidden-input' )
                            .removeClass( 'cfw-text-input' )
                            .removeClass( 'cfw-select-input' )
                            .removeClass( 'cfw-floating-label' );
                    }

                    // Handle required toggle
                    // We have to add the parsley attributes here because the field is
                    // recreated and thus loses anything that was previously there.
                    if ( fieldLocale.required ) {
                        jQuery( this )
                            .attr( 'data-parsley-trigger', 'keyup change focusout' )
                            .attr( 'data-parsley-group', group )
                            .attr( 'data-parsley-required', 'true' );
                    } else {
                        jQuery( this )
                            .removeAttr( 'data-parsley-trigger' )
                            .removeAttr( 'data-parsley-group' )
                            .attr( 'data-parsley-required', 'false' );
                    }

                } );

                city_wrapper.find( '#billing_city, #shipping_city' ).each( function() {
                    if ( ! jQuery( this ).is( ':visible' ) ) {
                        jQuery( this ).attr( 'data-parsley-required', 'false' );
                    } else if ( jQuery( this ).is( ':visible' ) ) {
                        jQuery( this ).attr( 'data-parsley-required', 'true' );
                    }
                });

                postcode_wrapper.find( '#billing_postcode, #shipping_postcode' ).each( function() {
                    if ( ! jQuery( this ).is( ':visible' ) || jQuery( this ).siblings( 'label' ).find( '.optional' ).length ) {
                        jQuery( this ).attr( 'data-parsley-required', 'false' );
                    } else if ( jQuery( this ).is( ':visible' ) ) {
                        jQuery( this ).attr( 'data-parsley-required', 'true' );
                    }
                });

                self.refreshParsley();
            } );
        } );
    }

    refreshParsley(): void {
        // Remove existing parsley errors.
        Main.instance.checkoutForm.find( '.parsley-errors-list' ).remove();

        // Re-register all the elements
        Main.instance.checkoutForm.parsley().refresh();
    }

    /**
     * @returns {any}
     */
    get parsley(): any {
        return this._parsley;
    }

    /**
     * @param value
     */
    set parsley( value: any ) {
        this._parsley = value;
    }
}