export class PaymentGatewaysService {
    constructor() {
        jQuery( window ).on( 'load', () => {
            this.initSelectedPaymentGateway();
        } );

        jQuery( document.body ).one( 'updated_checkout', () => {
            this.initSelectedPaymentGateway();
        } );
    }

    /**
     * Find the selected payment gateway and trigger a click
     *
     * Some gateways look for a click action to init themselves properly
     */
    initSelectedPaymentGateway() {
        let selected_payment_gateway = jQuery( 'input[name^="payment_method"][type="radio"]:checked' );

        // If there are none selected, select the first.
        if ( 0 === selected_payment_gateway.length ) {
            jQuery( `input[name^="payment_method"][type="radio"]` ).eq(0).prop( 'checked', true );
        }

        selected_payment_gateway.trigger( 'click' );
    }
}