import { Main }                             from "../Main";

declare let jQuery: any;

/**
 * EzTab Enum
 */
export enum EasyTab {
    CUSTOMER,
    SHIPPING,
    PAYMENT,
}

/**
 *
 */
export class TabService {
    /**
     * @type {any}
     * @private
     */
    private _tabContainer: any;

    /**
     * @type {any}
     * @private
     */
    private _tabBreadcrumbContainer: any;

    /**
     * @param tabContainer
     * @param tabBreadcrumbContainer
     */
    constructor( tabContainer: any, tabBreadcrumbContainer: any ) {
        this.tabContainer           = jQuery( tabContainer );
        this.tabBreadcrumbContainer = jQuery( tabBreadcrumbContainer );

        // Don't try to load tabs if tabs don't exist
        if ( ! this.tabBreadcrumbContainer.length || ! jQuery( 'li.tab#default-tab' ).length ) {
            return;
        }

        // Initialize tabs
        this.tabContainer.easytabs({
            defaultTab: 'li.tab#default-tab',
            tabs: 'ul > li.tab'
        });

        // Show the breadcrumbs
        this.tabBreadcrumbContainer.show();

        // After tab switch, scroll to the top of the active tab and set an active class
        this.tabContainer.on( 'easytabs:after', () => {
            // Remove temporary alerts on successful tab switch
            // TODO: Move to Alert service
            Main.instance.alertContainer.find( '.cfw-alert-temporary' ).remove();
        } );

        // Add tab active class on window load
        jQuery( window ).on( 'load cfw_updated_checkout', () => {
            this.setActiveTabClass();
        } );

        this.setTabChangeListeners();
        this.setTabButtonListeners();
    }

    /**
     * Returns the current and target tab indexes
     *
     * @returns any
     */
    getCurrentTab() {
        return this.tabContainer.find('.cfw-panel.active').first();
    }

    setTabButtonListeners() {
        jQuery( document.body ).on( 'click', '.cfw-tab-link, .cfw-next-tab, .cfw-prev-tab', ( event ) => {
            if ( jQuery( event.target ).data('tab') ) {
                this.tabContainer.easytabs('select', jQuery( event.target ).data('tab') );
            }
        } );
    }

    setTabChangeListeners() {
        this.tabContainer.bind( 'easytabs:before', ( event, clicked, target ) => {
            // Fire event that we can listen to around the world
            jQuery( document.body ).trigger( 'cfw-before-tab-change', [ event, clicked, target ] );
        } );

        this.tabContainer.bind( 'easytabs:after', ( event, clicked, target ) => {
            // Fire event that we can listen to around the world
            jQuery( document.body ).trigger( 'cfw-after-tab-change', [ event, clicked, target ] );

            // Scroll to top of tab container
            this.scrollToTop();

            // Set current tab active class on form
            this.setActiveTabClass();
        } );
    }

    scrollToTop() {
        // Scroll to the top of current tab on tab switch
        jQuery( 'html, body' ).animate( {
            scrollTop: this.tabContainer.offset().top
        }, 300 );
    }

    /**
     * Set active tab class on form
     */
    setActiveTabClass() {
        let main = Main.instance;
        let checkout_form = main.checkoutForm;

        // Add a class to checkout form to indicate payment tab is active tab
        // Doesn't work when tab is initialized by hash in URL
        let current_tab_id = this.getCurrentTab().attr('id');
        let active_class   = current_tab_id + '-active';

        checkout_form.removeClass( `cfw-customer-info-active` ).removeClass( `cfw-shipping-method-active` ).removeClass( `cfw-payment-method-active` ).addClass( active_class );
    }

    /**
     * @param {string} tab_id
     */
    static go( tab_id ): void {
        try {
            Main.instance.tabService.tabContainer.easytabs( 'select', tab_id );
        } catch (e) {
            console.log( 'Could not select tab: ' + e.message );
        }
    }

	/**
	 * @return {any}
	 */
	get tabContainer(): any {
        return this._tabContainer;
    }

	/**
	 * @param {any} value
	 */
	set tabContainer(value: any ) {
        this._tabContainer = value;
    }

    get tabBreadcrumbContainer(): any {
        return this._tabBreadcrumbContainer;
    }

    set tabBreadcrumbContainer(value: any) {
        this._tabBreadcrumbContainer = value;
    }
}