import { CompleteOrderAction }  from "../Actions/CompleteOrderAction";
import { UpdateCheckoutAction } from "../Actions/UpdateCheckoutAction";
import { Main }                 from "../Main";

declare let jQuery: any;

export class UpdateCheckoutService {
    /**
     * @type {boolean}
     * @private
     */
    private _force_updated_checkout: boolean;

    constructor() {
        this.setUpdateCheckoutHandler();
        this.setUpdateCheckoutTriggers();
    }

    /**
     *
     */
    setUpdateCheckoutHandler() {
        jQuery( document.body ).on( 'update_checkout', ( e, args ) => {
            this.queueUpdateCheckout( e, args );
        });
    }

    queueUpdateCheckout( e?, args? ) {
        let main: Main = Main.instance;

        let code = 0;

        if ( typeof e !== 'undefined' ) {
            code = e.keyCode || e.which || 0;
        }

        if ( code === 9 ) {
            return true;
        }

        this.resetUpdateCheckoutTimer();
        jQuery( document.body ).trigger( 'cfw_queue_update_checkout' );
        main.updateCheckoutTimer = (<any>window).setTimeout( this.maybeUpdateCheckout.bind( this ), 1000, args );
    }

    /**
     * All update_checkout triggers should happen here
     *
     * Exceptions would be edge cases involving TS compat classes
     */
    setUpdateCheckoutTriggers() {
        let main: Main = Main.instance;
        let checkout_form: any = main.checkoutForm;

        checkout_form.on( 'change', 'select.shipping_method, input[name^="shipping_method"], [name="bill_to_different_address"], .update_totals_on_change select, .update_totals_on_change input[type="radio"], .update_totals_on_change input[type="checkbox"]', this.queueUpdateCheckout.bind( this ) );
        checkout_form.on( 'change', '.address-field select', this.queueUpdateCheckout.bind( this ) );
        checkout_form.on( 'change', '.address-field input.input-text, .update_totals_on_change input.input-text', this.queueUpdateCheckout.bind( this ) );
        checkout_form.on( 'change', '#wc_checkout_add_ons :input', this.queueUpdateCheckout.bind( this ) );
        checkout_form.on( 'keydown', '.address-field input.input-text, .update_totals_on_change input.input-text', this.queueUpdateCheckout.bind( this ) );

        // Always force update checkout after tab change
        jQuery( document.body ).on( 'cfw-after-tab-change', () => {
            this.force_updated_checkout = true;
            this.queueUpdateCheckout();
        } );
    }

    resetUpdateCheckoutTimer() {
        let main: Main = Main.instance;

        clearTimeout( main.updateCheckoutTimer );
    }

    /**
     * Queue up an update_checkout
     */
    maybeUpdateCheckout( args ) {
        let main: Main = Main.instance;

        // Small timeout to prevent multiple requests when several fields update at the same time
        this.resetUpdateCheckoutTimer();
        main.updateCheckoutTimer = (<any>window).setTimeout( this.triggerUpdateCheckout.bind( this ), 5, args );
    }

    /**
     * Call update_checkout
     *
     * This should be the ONLY place we call this ourselves
     */
    triggerUpdateCheckout( args? ) {
        let main: Main = Main.instance;

        if ( main.settings.is_checkout_pay_page ) {
            return;
        }

        if( ! CompleteOrderAction.initCompleteOrder ) {
            if ( typeof args === 'undefined' ) {
                args = {
                    update_shipping_method: true
                };
            }

            new UpdateCheckoutAction( 'update_checkout', main.ajaxInfo, main.getFormObject('update_checkout'), args ).load();
        }
    }

    /**
     * Call updated_checkout
     *
     * This should be the ONLY place we call this ourselves
     */
    triggerUpdatedCheckout( data? ) {
        if ( typeof data === 'undefined' ) {
            // If this is running in the dark, we need
            // to shim in fragments because some plugins
            // ( like WooCommerce Smart Coupons ) expect it
            data = { fragments: {} };
        }
        jQuery( document.body ).trigger( 'updated_checkout', [ data ] );
    }

    /**
     * @returns {boolean}
     */
    get force_updated_checkout(): boolean {
        return this._force_updated_checkout;
    }

    /**
     * @param {boolean} value
     */
    set force_updated_checkout( value: boolean ) {
        this._force_updated_checkout = value;
    }
}