import 'ts-polyfill';
import { Accordion }              from "./front/CFW/Components/Accordion";
import { Cart }                   from "./front/CFW/Components/Cart";
import { PaymentGatewaysService } from "./front/CFW/Services/PaymentGatewaysService";
import { AlertService }           from "./front/CFW/Services/AlertService";

declare var cfwEventData: any;
(<any>window).errorObserverIgnoreList = [];

/**
 * An error tolerant DOM ready replacement for jQuery(document).ready()
 * @param fn
 */
function cfw_dom_ready(fn) {
    // see if DOM is already available
    if (document.readyState === "complete" || document.readyState === "interactive") {
        // call on next available tick
        setTimeout(fn, 1);
    } else {
        document.addEventListener("DOMContentLoaded", fn);
    }
}

export class OrderPay {
    constructor() {
        cfw_dom_ready( () => {
            let alertContainerElement   = jQuery( cfwEventData.elements.alertContainerId );
            
            /**
             * Services
             */
            new PaymentGatewaysService();

            /**
             * Components
             */
            // Accordion Component
            new Accordion();

            // Cart Component
            new Cart();

            // Alert Service
            new AlertService( alertContainerElement );

            // Init checkout ( WooCommerce native event )
            jQuery( document.body ).trigger( 'init_checkout' );
        } );
    }
}

new OrderPay();