import 'ts-polyfill';
import { MapEmbedService } from "./front/CFW/Services/MapEmbedService";
import { Cart }            from "./front/CFW/Components/Cart";

/**
 * An error tolerant DOM ready replacement for jQuery(document).ready()
 * @param fn
 */
function cfw_dom_ready(fn) {
    // see if DOM is already available
    if (document.readyState === "complete" || document.readyState === "interactive") {
        // call on next available tick
        setTimeout(fn, 1);
    } else {
        document.addEventListener("DOMContentLoaded", fn);
    }
}

export class ThankYou {
    constructor() {
        let map_embed_service = new MapEmbedService();

        cfw_dom_ready( () => {
            map_embed_service.setMapEmbedHandlers();

            jQuery(`.status-step-selected`).prevAll().addClass('status-step-selected');

            // Cart Service
            new Cart();
        } );
    }
}

new ThankYou();