jQuery(document).ready(function($) {

	// Adding Shipping Rate Table
	$( 'a#add_rate_table' ).on( 'click', function(){

		// Close modal box
		$('#wc-ss-table-shipping-type-dialog').dialog('close');

		var calculation_type = $( '#woocommerce_super_shipping_calculation_type' ).val();
		var size = $('tbody.special_rate_table .special_region').size();
		var region_table = '<tr valign="top" class="special_region" data-region_id="' + size + '" data-table_type="shipping_rate">\
			<th scope="row" class="titledesc"><input type="checkbox" name="select" /><span class="editable" style="font-size: 12pt; font-weight: bold; color: #0073aa; cursor: auto;">' + wcss_object.table_string +' '+ ( size + 1 ) + '</span><button type="button" class="handlediv button-link" data-region_id="' + size + '"><span class="toggle-indicator"></span></button></th>\
			<td class="forminp" data-region_id="' + size + '">\
				<table>\
					<tbody>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend><span>' + wcss_object.table_name_string + '</span>' + wcss_object.help_tip_smn_string + '</legend>\
									<input type="text" name="' + wcss_object.id + '_regions[' + size + '][table_name]" placeholder="' + wcss_object.table_name_default_string + '" size="20" /><br>\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend><span>' + wcss_object.shipping_zone_string + '</span></legend>\
									<select class="select" name="' + wcss_object.id + '_regions[' + size + '][shipping_zone]" id="woocommerce_special_region_delivery_codes">' + get_html_shipping_zones_options_list() + '\
									</select><br>\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend><span>' + wcss_object.calculation_type_string + '</span></legend>\
									<select class="select" name="' + wcss_object.id + '_regions[' + size + '][calculation_type]" id="woocommerce_region_' + wcss_object.id + '_calculation_type">\
										<option value="order" selected="selected">' + wcss_object.calculation_type_per_order_string + '</option>\
										<option value="item">' + wcss_object.calculation_type_per_item_string + '</option>\
										<option value="class">' + wcss_object.calculation_type_per_class_string + '</option>\
									</select><br>\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
                  				    <td class="forminp">\
                  				    	<fieldset>\
                  				    		<legend><span>' + wcss_object.apply_by_user_rol_string + '</span></legend>\
                  				        	<select multiple="multiple" name="' + wcss_object.id + '_regions[' + size + '][users_roles][]" style="width:450px;" data-placeholder="' + wcss_object.choose_users_roles + '" title="Users roles" class="chosen_select">\
                  				        	    <option value="all-users" selected="selected">' + wcss_object.all_users_option_string + '</option>\
                  				        	    <option value="guest-user">' + wcss_object.guest_user_option_string + '</option>' + get_html_users_roles_options_list( [] ) + '\
                  				        	</select><br>\
							</fieldset>\
                  				    </td>\
                  				</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend class="same-row">\
										<span>' + wcss_object.including_tax_string + '</span>' + wcss_object.help_tip_it_string + '\
									</legend>\
									<input type="checkbox" name="' + wcss_object.id + '_regions[' + size + '][including_tax]" id="woocommerce_region_' + size + '_including_tax" style="" value="1">\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend class="same-row">\
										<span>' + wcss_object.apply_percentage_cost_string + '</span>' + wcss_object.help_tip_apc_string + '\
									</legend>\
									<input type="checkbox" name="' + wcss_object.id + '_regions[' + size + '][apply_percentage]" id="woocommerce_region_' + size + '_apply_percentage" style="" value="1">\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend class="same-row">\
										<span>' + wcss_object.apply_shipping_class_priority_string + '</span>' + wcss_object.help_tip_ascp_string + '\
									</legend>\
									<input type="checkbox" name="' + wcss_object.id + '_regions[' + size + '][shipping_class_priority]" id="woocommerce_region_' + size + '_shipping_class_priority" style="" value="1">\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<table id="' + wcss_object.id + '_region_' + size + '" class="shippingrows widefat" cellspacing="0">\
									<thead>\
										<tr>\
											<td id="cb" class="manage-column column-cb check-column">\
												<label class="screen-reader-text" for="cb-select-all-' + size + '"><?php _e( "Select all", "wc-ss" ); ?></label>\
												<input id="cb-select-all-' + size + '" type="checkbox">\
											</td>\
											<th class="shipping_class">' + wcss_object.shipping_class_column_string + '</th>\
											<th class="shipping_class">' + wcss_object.condition_column_string + '</th>\
											<th class="shipping_class">' + wcss_object.range_column_string + '</th>\
											<th class="shipping_class">' + wcss_object.cost_column_string + '<a class="tips" data-tip="' + wcss_object.help_tip_cost_column_string + '"> [?]</a></th>\
											<th class="shipping_class">' + wcss_object.additional_cost_column_string + '</th>\
										</tr>\
									</thead>\
									<tfoot>\
										<tr>\
											<th colspan="8">\
											<a href="#" class="add button" id="' + wcss_object.id + '_region_' + size + '_add_button" data-region_id="'+ size +'">' + wcss_object.add_row_button_string + '</a>\
											<a href="#" class="duplicate button" id="' + wcss_object.id + '_region_' + size + '_duplicate_button" data-region_id="'+ size +'">' + wcss_object.duplicate_row_button_string + '</a>\
											<a href="#" class="delete button" id="' + wcss_object.id + '_region_' + size + '_delete_button" data-region_id="'+ size +'">' + wcss_object.delete_row_button_string + '</a>\
											</th>\
										</tr>\
									</tfoot>\
									<tbody class="flat_rates">\
									</tbody>\
								</table>\
							</td>\
						</tr>\
					</tbody>\
				</table>\
				<input type="hidden" name="' + wcss_object.id + '_regions[' + size + '][type_of_table]" value="shipping_rate">\
			</td>\
		</tr>';
		$( region_table ).appendTo('tbody.special_rate_table.regions_list');
		
		$( document.body ).trigger( 'wc-enhanced-select-init' );
		$( document.body ).trigger( 'init_tooltips' );
		$( 'tbody.special_rate_table #' + wcss_object.id + '_region_'+ size ).on( 'click', '.add.button', function( event ){
			var region_id = $( this ).attr( 'data-region_id' );
			add_new_cost_row( event, region_id );
		});
		$( 'tbody.special_rate_table #' + wcss_object.id + '_region_'+ size ).on( 'click', '.duplicate.button', function( event ){
			var region_id = $( this ).attr( 'data-region_id' );
			duplicate_cost_row( event, region_id );
		});
		$( 'tbody.special_rate_table #' + wcss_object.id + '_region_'+ size ).on( 'click', '.delete.button', function( event ){
			var region_id = $( this ).attr( 'data-region_id' );
			remove_cost_row( event, region_id );
		});
		$( '.button-link' ).filter( '[data-region_id=' + size + ']' ).on( 'click', function( event ){
			var region_id = $( this ).attr( 'data-region_id' );
			toggle_region( event, region_id );
		});

		// Adding editable property for every tables names
		add_editable_property_for_tables_names();

		return false;
	});

	// Adding Local Pickup Table
	$( 'a#add_local_pickup_table' ).on( 'click', function(){

		// Close modal box
		$('#wc-ss-table-shipping-type-dialog').dialog('close');
		
		var calculation_type = $( '#woocommerce_super_shipping_calculation_type' ).val();
		var size = $('tbody.special_rate_table .special_region').size();
		var region_table = '<tr valign="top" class="special_region" data-region_id="' + size + '" data-table_type="local_pickup">\
			<th scope="row" class="titledesc"><input type="checkbox" name="select" /><span class="editable" style="font-size: 12pt; font-weight: bold; color: #0073aa; cursor: auto;">' + wcss_object.table_string +' '+ ( size + 1 ) + '</span><button type="button" class="handlediv button-link" data-region_id="' + size + '"><span class="toggle-indicator"></span></button></th>\
			<td class="forminp" data-region_id="' + size + '">\
				<table>\
					<tbody>\
						<tr valign="top">\
							<td id="' + wcss_object.id + '_region_' + size + '" class="forminp">\
								<fieldset>\
									<legend><span>' + wcss_object.table_name_string + '</span>' + wcss_object.help_tip_smn_string + '</legend>\
									<input type="text" name="' + wcss_object.id + '_regions[' + size + '][table_name]" placeholder="' + wcss_object.local_pickup_table_name_default + '" size="20" /><br>\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
							<td class="forminp">\
								<fieldset>\
									<legend><span>' + wcss_object.local_pickup_zone_string + '</span></legend>\
									<select class="select" name="' + wcss_object.id + '_regions[' + size + '][shipping_zone]" id="woocommerce_special_region_delivery_codes">' + get_html_shipping_zones_options_list() + '\
									</select><br>\
								</fieldset>\
							</td>\
						</tr>\
						<tr valign="top">\
                  				    <td class="forminp">\
                  				    	<fieldset>\
                  				    		<legend><span>' + wcss_object.apply_by_user_rol_string + '</span></legend>\
                  				        	<select multiple="multiple" name="' + wcss_object.id + '_regions[' + size + '][users_roles][]" style="width:450px;" data-placeholder="' + wcss_object.choose_users_roles + '" title="Users roles" class="chosen_select">\
                  				        	    <option value="all-users" selected="selected">' + wcss_object.all_users_option_string + '</option>\
                  				        	    <option value="guest-user">' + wcss_object.guest_user_option_string + '</option>' + get_html_users_roles_options_list( [] ) + '\
                  				        	</select><br>\
							</fieldset>\
                  				    </td>\
                  				</tr>\
					</tbody>\
				</table>\
				<input type="hidden" name="' + wcss_object.id + '_regions[' + size + '][type_of_table]" value="local_pickup">\
			</td>\
		</tr>';
		$( region_table ).appendTo('tbody.special_rate_table.regions_list');

		$( document.body ).trigger( 'wc-enhanced-select-init' );
		$( document.body ).trigger( 'init_tooltips' );
		$( '.button-link' ).filter( '[data-region_id=' + size + ']' ).on( 'click', function( event ){
			var region_id = $( this ).attr( 'data-region_id' );
			toggle_region( event, region_id );
		});

		// Adding editable property for every tables names
		add_editable_property_for_tables_names();

		return false;
	});

	// Show modal box to select the type of shipping rate table
	$('#wc-ss-table-shipping-type-dialog').dialog({
		title: wcss_object.dialog_title,
		dialogClass: 'wp-dialog',
		autoOpen: false,
		draggable: false,
		width: '350px',
		modal: true,
		resizable: false,
		closeOnEscape: true,
		position: {
			my: "center",
			at: "center",
			of: window
		},

		open: function () {
  		    // close dialog by clicking the overlay behind it
  		    $('.ui-widget-overlay').bind('click', function(){
  		    	$('#wc-ss-table-shipping-type-dialog').dialog('close');
  		    })
  		},

  		create: function () {
  		    // style fix for WordPress admin
  		    $('.ui-dialog-titlebar-close').addClass('ui-button');
  		},
  	});

  	// Bind a button or a link to open the modal box
  	$('a#add_table_button').click(function(e) {
  		e.preventDefault();
  		$('#wc-ss-table-shipping-type-dialog').dialog('open');
  	});

  	// Wrap dialog to custom class
  	$( '.ui-dialog.wp-dialog' ).wrap( '<div class="wc-ss-modal-box"></div>' ); 

	// Return the HTML shipping zones options list
	function get_html_shipping_zones_options_list(){

		var select_option_list_html = '';
		json_shipping_zones = jQuery.parseJSON( wcss_object.shipping_zones );

		if ( $( json_shipping_zones ).length > 0 ) {

			select_option_list_html = '<option value="">' + wcss_object.select_shipping_zones_string + '&hellip;</option>';
			$.each( json_shipping_zones, function( key, value ){

				select_option_list_html += '<option value="' + value.zone_id + '">' + value.zone_title + '</option>';			
			});
		}else{
			select_option_list_html = '<option value=""><?php echo __( "Not shipping zones availables", "wc-ss" ); ?></option>';
		};

		return select_option_list_html;
	}

	// Return the HTML users roles options list
	function get_html_users_roles_options_list( selected_options ){

		var select_option_list_html = '';
		json_users_roles = jQuery.parseJSON( wcss_object.users_roles );

		if ( jQuery( 'all-users', selected_options ) >= 0 ) {
			select_option_list_html = '<option value="all-users" selected="selected">' + wcss_object.all_users_option_string + '</option>';
		}else{
			select_option_list_html = '<option value="all-users">' + wcss_object.all_users_option_string + '</option>';
		}

		if ( $( json_users_roles ).length > 0 ) {
			$.each( json_users_roles, function( key, value ){
				if ( jQuery.inArray( key, selected_options ) >= 0 ) {
					select_option_list_html += '<option value="' + key + '" selected="selected">' + value + '</option>';
				}else{
					select_option_list_html += '<option value="' + key + '">' + value + '</option>';
				};		
			});
		}

		return select_option_list_html;
	}
	
	// Remove Regions Row
	$('tfoot.special_rate_table').on( 'click', 'a#remove_table_button', function( event ){
		var answer = confirm( wcss_object.remove_region_table_confirm_string )
		if (answer) {
			$('tbody.special_rate_table.regions_list tr th input:checked').each(function(i, el){
				$(el).closest('tr').remove();
			});
		}
		return false;
	});

	// Duplicate selected regions
	$('tfoot.special_rate_table').on( 'click', 'a#duplicate_table_button', function( event ){
		if( $('tbody.special_rate_table.regions_list tr th input:checked').length > 0 ){

			var size = jQuery('tbody.special_rate_table tr.special_region').size();

			$('tbody.special_rate_table.regions_list tr th input:checked').each(function(i, el){

				if ( 'shipping_rate' == $(el).closest('tr').attr( 'data-table_type' ) ) {

					clone_shipping_rate_table( el, size );
				};

				if ( 'local_pickup' == $(el).closest('tr').attr( 'data-table_type' ) ) {

					clone_local_pickup_table( el, size );
				};

				size++;
			});

			$( document.body ).trigger( 'wc-enhanced-select-init' );
		}
		return false;
	});

	// Clone Shipping Rate Table
	function clone_shipping_rate_table( table, size ){
		var table_to_clone = $(table).closest('tr').clone( true );
		$( table_to_clone ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'th button' ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'td' ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'table:last' ).attr( 'id', wcss_object.id + '_region_' + size );

		// Update attribute "name" of the region general settings
		$( table_to_clone ).find( 'th input[type=text]' ).attr( 'name', wcss_object.id + '_regions[' + size + '][prices_table_name]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(0) input' ).attr( 'name', wcss_object.id + '_regions[' + size + '][table_name]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(1) select' ).attr( 'name', wcss_object.id + '_regions[' + size + '][shipping_zone]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(2) select' ).attr( 'name', wcss_object.id + '_regions[' + size + '][calculation_type]' );
		
		// Add new user roles selector
		var selected_options = $( table_to_clone ).find( 'table > tbody > tr:eq(3) select option:selected' );
		var selected_options_array = [];
		$( selected_options ).map(function(i,e){
			selected_options_array[i] = jQuery(e).val();
		});

		$( table_to_clone ).find( 'table > tbody > tr:eq(3)' ).remove();
		$( table_to_clone ).find( 'table > tbody > tr:eq(2)' ).after( '<tr valign="top">\
                  		    <td class="forminp">\
                  		    	<fieldset>\
                  		    		<legend><span>' + wcss_object.apply_by_user_rol_string + '</span></legend>\
                  		        	<select multiple="multiple" name="' + wcss_object.id + '_regions[' + size + '][users_roles][]" style="width:450px;" data-placeholder="' + wcss_object.choose_users_roles + '" title="Users roles" class="chosen_select">\
                  		        	    <option value="guest-user">' + wcss_object.guest_user_option_string + '</option>' + get_html_users_roles_options_list( selected_options_array ) + '\
                  		        	</select><br>\
					</fieldset>\
                  		    </td>\
                  		</tr>'
		);
		$( table_to_clone ).find( 'table > tbody > tr:eq(4) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][including_tax]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(5) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][apply_percentage]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(6) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][shipping_class_priority]' );
		
		// Update attribute "name" of each table row 
		$( table_to_clone ).find( 'tbody.price_table tr' ).each( function( key, value ){
			update_name_attribute( value, size, key );
		});

		$( table_to_clone ).appendTo( 'tbody.special_rate_table' );
		$( document.body ).trigger( 'wc-enhanced-select-init' );
		$( document.body ).trigger( 'init_tooltips' );
	}

	// Clone Local Pickup Table
	function clone_local_pickup_table( table, size ){
		var table_to_clone = $(table).closest('tr').clone( true );
		$( table_to_clone ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'th button' ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'td' ).attr( 'data-region_id', size );
		$( table_to_clone ).find( 'table > tbody > tr:eq(0) td' ).attr( 'id',  wcss_object.id + '_region_' + size );

		// Update attribute "name" of the region general settings
		$( table_to_clone ).find( 'th input[type=text]' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][prices_table_name]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(0) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][table_name]' );
		$( table_to_clone ).find( 'table > tbody > tr:eq(1) select' ).attr( 'name', '' + wcss_object.id + '_regions[' + size + '][shipping_zone]' );
		$( table_to_clone ).find( 'td input[type=hidden]' ).attr( 'name', wcss_object.id + '_regions[' + size + '][type_of_table]' );
		
		// Add new user roles selector
		var selected_options = $( table_to_clone ).find( 'table > tbody > tr:eq(2) select option:selected' );
		var selected_options_array = [];
		$( selected_options ).map(function(i,e){
			selected_options_array[i] = jQuery(e).val();
		});

		$( table_to_clone ).find( 'table > tbody > tr:eq(2)' ).remove();
		$( table_to_clone ).find( 'table > tbody > tr:eq(1)' ).after( '<tr valign="top">\
                  		    <td class="forminp">\
                  		    	<fieldset>\
                  		    		<legend><span>' + wcss_object.apply_by_user_rol_string + '</span></legend>\
                  		        	<select multiple="multiple" name="' + wcss_object.id + '_regions[' + size + '][users_roles][]" style="width:450px;" data-placeholder="' + wcss_object.choose_users_roles + '" title="Users roles" class="chosen_select">\
                  		        	    <option value="guest-user">' + wcss_object.guest_user_option_string + '</option>' + get_html_users_roles_options_list( selected_options_array ) + '\
                  		        	</select><br>\
					</fieldset>\
                  		    </td>\
                  		</tr>'
		);

		$( table_to_clone ).appendTo( 'tbody.special_rate_table' );
		$( document.body ).trigger( 'wc-enhanced-select-init' );
		$( document.body ).trigger( 'init_tooltips' );
	}
	
	// Add New Row 
	$('.add.button').on( 'click', function( event ){
		var region_id = $( this ).attr( 'data-region_id' );
		add_new_cost_row( event, region_id );
	});

	//Function to add new row into the shipping rate table
	function add_new_cost_row( event, idRegion ) {
	
		var html_options = '';
		var json_shipping_classes = jQuery.parseJSON( wcss_object.shipping_classes );
		var calculation_type = $( '#woocommerce_super_shipping_calculation_type' ).val();
		$( json_shipping_classes ).each( function( key, value ){
			html_options += '<option value="' + value.slug + '" >'+ value.name +'</option>';
		});
		var size = $('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody .flat_rate').size();
	
		$( '<tr class="flat_rate">\
					<th class="check-column"><input type="checkbox" name="select" /></th>\
					<td><select name="' + wcss_object.id + '_regions[' + idRegion + '][shipping_class][' + size + ']" class="shipping_class_list">\
						<option value="no-class">' + wcss_object.no_class_string + '</option>' + html_options + '</select>\
					</td>\
					<td><select name="' + wcss_object.id + '_regions[' + idRegion + '][conditional][' + size + ']">\
						<option value="1" selected="selected">' + wcss_object.weight_string + '</option>\
						<option value="2">' + wcss_object.price_string + '</option>\
						<option value="3">' + wcss_object.item_count_string + '</option>\
						<option value="4">' + wcss_object.volume_string + '</option>\
					</select></td>\
					<td>\
						<div class="horizontal-inputs-wrap">\
							<input type="text" name="' + wcss_object.id + '_regions[' + idRegion + '][range][min][' + size + ']" class="text wc_ss_input_decimal required" placeholder="' + wcss_object.min_string + '">\
							<input type="text" name="' + wcss_object.id + '_regions[' + idRegion + '][range][max][' + size + ']" class="text wc_ss_input_decimal required" placeholder="' + wcss_object.max_string + '">\
						</div>\
					</td>\
					<td><input type="text" class="wc_ss_input_decimal required" value="" name="' + wcss_object.id + '_regions[' + idRegion + '][cost][' + size + ']" placeholder="0.00" size="6" /></td>\
					<td><input type="text" class="wc_ss_input_decimal" value="" name="' + wcss_object.id + '_regions[' + idRegion + '][cost_per_additional_unit][' + size + ']" placeholder="0.00" size="6"></td>\
				</tr>').appendTo('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody');
		
		event.preventDefault();
		return false;
	}

	// Duplicate Selected Rows
	$('.duplicate.button').on( 'click', function( event ){
		var region_id = $( this ).attr( 'data-region_id' );
		duplicate_cost_row( event, region_id );
	});

	//Function to duplicate selected rows into the shipping rate table
	function duplicate_cost_row( event, idRegion ){
		var size = jQuery('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody .flat_rate').size();
		var checked_rows = jQuery('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody tr th.check-column input:checked').size();
		if( checked_rows > 0 ){
	
			jQuery( 'tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody tr th.check-column input:checked' ).each( function(){
				var row_to_clone = jQuery( this ).closest( 'tr' ).clone( true );
				row_to_clone.find( 'th.check-column input:checked' ).prop( 'checked', false );
				row_to_clone.appendTo( 'tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody' );
				// Update attibute name of each row
				update_name_attribute( row_to_clone, idRegion, size );
				size++;
			});
		}
	
		event.preventDefault();
		return false;
	}

	// Update the name of attribute for each field
	function update_name_attribute( row_to_clone, idRegion, size ){
		jQuery( row_to_clone ).find( 'td:eq(0) select' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][shipping_class][' + size + ']' );
		jQuery( row_to_clone ).find( 'td:eq(1) select' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][conditional][' + size + ']' );
		jQuery( row_to_clone ).find( 'td:eq(2) input:eq(0)' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][range][min][' + size + ']' );
		jQuery( row_to_clone ).find( 'td:eq(2) input:eq(1)' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][range][max][' + size + ']' );
		jQuery( row_to_clone ).find( 'td:eq(3) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][cost][' + size + ']' );
		jQuery( row_to_clone ).find( 'td:eq(4) input' ).attr( 'name', '' + wcss_object.id + '_regions[' + idRegion + '][cost_per_additional_unit][' + size + ']' );
	}

	// Remove Selected Rows 
	$('.delete.button').on( 'click', function( event ){
		var region_id = $( this ).attr( 'data-region_id' );
		remove_cost_row( event, region_id );
	});
	
	//Function to delete selected rows into the shipping rate table
	function remove_cost_row( event, idRegion ) {
		var size = jQuery('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody tr th.check-column input:checked').size();
		if( size > 0 ){
			var answer = confirm( wcss_object.delete_selected_rates_confirm_string )
			if (answer) {
				jQuery('tbody.special_rate_table table#' + wcss_object.id + '_region_' + idRegion +' tbody tr th.check-column input:checked').each(function(i, el){
					jQuery(el).closest('tr').remove();
				});
			}
		}
		event.preventDefault();
		return false;
	}

	// Show or hide the "Show all free shipping methods" field
	$( '#woocommerce_super_shipping_hide_free_shipping' ).change( function(){
		if ( $( this ).is( ':checked' ) ) {
			$( '#woocommerce_super_shipping_show_all_free_shipping_methods' ).closest( 'tr' ).show();
		} else {
			$( '#woocommerce_super_shipping_show_all_free_shipping_methods' ).closest( 'tr' ).hide();
		}
	}).change();

	// Show or hide the volumetric weight factor field
	$( '#woocommerce_super_shipping_volumetric_weight_measure' ).change( function(){
		if ( $( this ).is( ':checked' ) ) {
			$( '#woocommerce_super_shipping_volumetric_weight_factor' ).closest( 'tr' ).show();
		} else {
			$( '#woocommerce_super_shipping_volumetric_weight_factor' ).closest( 'tr' ).hide();
		}
	}).change();

	// Field validation error tips
	$( document.body )
	.on( 'keyup change', '.wc_ss_input_decimal[type=text]', function() {
		var value    = $( this ).val();
		var regex    = new RegExp( '[^\-0-9\%\\\*' + woocommerce_admin.decimal_point + ']+', 'gi' );
		var newvalue = value.replace( regex, '' );
		if ( value !== newvalue ) {
			$( this ).val( newvalue );
			$( document.body ).triggerHandler( 'wc_add_error_tip', [ $( this ), 'i18n_decimal_error' ] );
		} else {
			$( document.body ).triggerHandler( 'wc_remove_error_tip', [ $( this ), 'i18n_decimal_error' ] );
		}
	});

	// Check if there is required fields empty
	$( '#woocommerce_super_shipping_special_rate' ).closest( 'form' ).submit( function( event ) {
		
		$( 'input[type=text].required' ).each( function( i, el ){
			var value = $.trim( $( el ).val() );

			if ( $.isEmptyObject( value )  ) {

				jQuery( '#message.notice' ).remove();
				$( 'h2' ).before( '<div id="message" class="notice notice-error"><p><strong>'+ wcss_object.error_empty_fields_string +'</strong></p></div>' );
				$( 'html, body' ).animate( { scrollTop: 0 }, "slow" );

				event.preventDefault();
				return false;
			};
		});
	});

	// Toggle the regions rows
	function toggle_region( event, idRegion ){

		$( '#super_shipping_region_' + idRegion ).closest( 'tr' ).closest( 'td' ).toggle();
		if ( $( '.button-link' ).filter( '[data-region_id=' + idRegion + ']' ).hasClass( 'closed' ) ) {

			$( '.button-link' ).filter( '[data-region_id=' + idRegion + ']' ).removeClass( 'closed' );
		}else{

			$( '.button-link' ).filter( '[data-region_id=' + idRegion + ']' ).addClass( 'closed' );
		}

		event.preventDefault();
		return false;
	}

	$( '.button-link' ).on( 'click', function( event ){
		var region_id = $( this ).attr( 'data-region_id' );
		toggle_region( event, region_id );
	});

	// Fire the add_editable_property_for_tables_names function at the beginning
	add_editable_property_for_tables_names();

	// Sortable regions row
	$( '.regions_list' ).sortable({
		update: function( event, ui ){
			var all_regions = $( '.special_region' ).get();
			
			for ( var i = 0; i <= $( all_regions ).length; i++ ) {
				
				var item_region = $( all_regions ).get( i );

				$( item_region ).attr( 'data-region_id', i );
				$( item_region ).find( 'td' ).attr( 'data-region_id', i );
				$( item_region ).find( '.handlediv' ).attr( 'data-region_id', i );

				// Update name of attribute for the region general settings
				$( item_region ).find( 'th.titledesc input:text' ).attr( 'name', wcss_object.id + '_regions[' + i + '][prices_table_name]' );
				$( item_region ).find( 'table > tbody > tr:eq(0) input' ).attr( 'name', wcss_object.id + '_regions[' + i + '][table_name]' );
				$( item_region ).find( 'table > tbody > tr:eq(1) select' ).attr( 'name', wcss_object.id + '_regions[' + i + '][shipping_zone]' );
				$( item_region ).find( 'table > tbody > tr:eq(3) select' ).attr( 'name', wcss_object.id + '_regions[' + i + '][users_roles][]' );
				$( item_region ).find( 'input[type=hidden]' ).attr( 'name', wcss_object.id + '_regions[' + i + '][type_of_table]' );

				// Update id of attribute for the region general settings
				$( item_region ).find( 'table > tbody > tr:eq(1) select' ).attr( 'id', 'woocommerce_region_' + i + '_shipping_zone' );

				if ( 'shipping_rate' == $( item_region ).attr( 'data-table_type' ) ) {

					$( item_region ).find( '.shippingrows' ).attr( 'id', 'super_shipping_region_' + i );
					$( item_region ).find( '.add.button' ).attr( 'id', 'super_shipping_region_' + i + '_add_button' );
					$( item_region ).find( '.add.button' ).attr( 'data-region_id', i );
					$( item_region ).find( '.duplicate.button' ).attr( 'id', 'super_shipping_region_' + i + '_duplicate_button' );
					$( item_region ).find( '.duplicate.button' ).attr( 'data-region_id', i );
					$( item_region ).find( '.delete.button' ).attr( 'id', 'super_shipping_region_' + i + '_delete_button' );
					$( item_region ).find( '.delete.button' ).attr( 'data-region_id', i );

					// Update names of fields
					$( item_region ).find( 'table > tbody > tr:eq(2) select' ).attr( 'name', wcss_object.id + '_regions[' + i + '][calculation_type]' );
					$( item_region ).find( 'table > tbody > tr:eq(4) input' ).attr( 'name', wcss_object.id + '_regions[' + i + '][including_tax]' );
					$( item_region ).find( 'table > tbody > tr:eq(5) input' ).attr( 'name', wcss_object.id + '_regions[' + i + '][apply_percentage]' );
					$( item_region ).find( 'table > tbody > tr:eq(6) input' ).attr( 'name', wcss_object.id + '_regions[' + i + '][shipping_class_priority]' );

					// Update IDs of fields
					$( item_region ).find( 'table > tbody > tr:eq(2) select' ).attr( 'id', 'woocommerce_region_' + i + '_calculation_type' );
					$( item_region ).find( 'table > tbody > tr:eq(4) input' ).attr( 'id', 'woocommerce_region_' + i + '_including_tax' );
					$( item_region ).find( 'table > tbody > tr:eq(5) input' ).attr( 'id', 'woocommerce_region_' + i + '_apply_percentage' );
					$( item_region ).find( 'table > tbody > tr:eq(6) input' ).attr( 'id', 'woocommerce_region_' + i + '_shipping_class_priority' );

					// Rewrite the name attribute of shipping rules
					$( item_region ).find( 'tbody.price_table tr').each( function( pos, el ){
	
						update_name_attribute( el, i, pos );
					});
				};

				if ( 'local_pickup' == $( item_region ).attr( 'data-table_type' ) ) {

					$( item_region ).find( 'table > tbody > tr:eq(0) > td' ).attr( 'id', 'super_shipping_region_' + i );
				};
			};
		}
	});

	//Loop through all Labels with class 'editable'.
	function add_editable_property_for_tables_names(){

		$( ".editable" ).each( function () {
    		    	//Reference the Label.
    		    	var label = $( this );
    		    	var table_num = label.closest( 'th' ).find( 'button' ).data( 'region_id' );
	
    		    	//Add a TextBox next to the Label.
    		    	label.after( '<input type="text" name="' + wcss_object.id + '_regions[' + table_num + '][prices_table_name]" style="display:none; margin-top:10px;"/>' );
	
    		    	//Reference the TextBox.
    		    	var textbox = $( this ).next();
	
    		    	//Assign the value of Label to TextBox.
    		    	textbox.val( label.html() );
	
    		    	//When Label is clicked, hide Label and show TextBox.
    		    	label.click( function () {

    		    		$( this ).hide();
    		    		$( this ).next().show();
    		    		$( this ).next().focus();
    		    	});
	
    		    	//When focus is lost from TextBox, hide TextBox and show Label.
    		    	textbox.focusout( function () {
    		    		if ( $.isEmptyObject( $( this ).val() ) ) {

    		    			var position = $( this ).position();
    		    			$( this ).after( '<div class="wcss_error_tip" style="left: '+ position.left +'px; top: '+ ( position.top + 24 ) +'px;">'+ wcss_object.error_tip_table_name +'</div>' );
    		    			$( 'input[type=submit]' ).attr('disabled', true );
				}else{

    		    			$( this ).hide();
    		    			$( this ).closest( 'th' ).find( '.wcss_error_tip' ).hide();
    		    			$( this ).prev().html( $( this ).val() );
    		    			$( this ).prev().show();
    		    			$( 'input[type=submit]' ).attr('disabled', false );	
    		    		};
    		    	});

    		    	textbox.click( function(){

    		    		// Remove error tip message if it being shown
    		    		$( this ).closest( 'th' ).find( '.wcss_error_tip' ).remove();
    		    	});
    		});	
	}
});