<?php
/**
 * Admin View: Shipping table
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<tbody class="regions_list special_rate_table">
	<?php
		$i = -1;
		if ( $this->special_increase_rates ) {

			foreach ( $this->special_increase_rates as $region => $data ) {
				$i++;
				if ( isset( $data[ 'type_of_table' ] ) && ( 'shipping_rate' === $data[ 'type_of_table' ] ) ) {
	?>
				<tr valign="top" class="special_region" data-region_id="<?php echo $i; ?>" data-table_type="shipping_rate">
					<th scope="row" class="titledesc">
						<input type="checkbox" name="select" /><span class="editable" style="font-size: 12pt; font-weight: bold; color: #0073aa; cursor: auto;"><?php echo !empty( $data[ 'prices_table_name' ] )? $data[ 'prices_table_name' ] : __( "Table", 'wc-ss' ) .' '. $i; ?></span>
						<button type="button" class="handlediv button-link closed" data-region_id="<?php echo $i; ?>"><span class="toggle-indicator"></span></button>
					</th>
					<td class="forminp" data-region_id="<?php echo $i; ?>" style="display: none;">
						<table>
							<tbody>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend>
												<span><?php echo __( "Shipping Method Name", "wc-ss" ); ?></span>
												<?php echo wc_help_tip( __( 'This text will be shown as shipping method title in Cart and Checkout pages.', 'wc-ss' ) ); ?>
											</legend>
											<input type="text" name="<?php echo $this->id .'_regions['. $i .'][table_name]'; ?>" placeholder="<?php echo __( "National Shipping", "wc-ss" ); ?>" size="20" value="<?php echo esc_attr( $data[ 'table_name' ] ); ?>"/><br>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend><span><?php echo __( 'Shipping zone', 'wc-ss' ); ?></span></legend>
											<select class="select" name="<?php echo $this->id .'_regions['. $i .'][shipping_zone]'; ?>" id="woocommerce_region_<?php echo $i; ?>_shipping_zone">
											<?php
												if ( !empty( $this->shipping_zones ) ){
													foreach ( $this->shipping_zones as $key => $shipping_zone ){
											?>
														<option value="<?php echo esc_attr( $shipping_zone[ 'zone_id' ] ); ?>" <?php selected( $shipping_zone[ 'zone_id' ], $data[ 'shipping_zone' ] ); ?> ><?php echo esc_js( $shipping_zone[ 'zone_title' ] ); ?></option>
											<?php
													}
												}
											?>
											</select><br>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend><span><?php echo __( 'Calculation Type', 'wc-ss' ); ?></span></legend>
											<select class="select" name="<?php echo $this->id .'_regions['. $i .'][calculation_type]'; ?>" id="woocommerce_region_<?php echo $i; ?>_calculation_type">
												<option value="order" <?php selected( 'order', $data[ 'calculation_type' ] ); ?> ><?php echo __( 'Per order', 'wc-ss' ); ?></option>
												<option value="item" <?php selected( 'item', $data[ 'calculation_type' ] ); ?> ><?php echo __( 'Per item', 'wc-ss' ); ?></option>
												<option value="class" <?php selected( 'class', $data[ 'calculation_type' ] ); ?> ><?php echo __( 'Per class', 'wc-ss' ); ?></option>
											</select><br>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
                    						    <td class="forminp">
                    						    	<fieldset>
                    						    		<legend><span><?php echo __( 'Apply by user rol', 'wc-ss' ); ?></span></legend>
                    						        	<select multiple="multiple" name="<?php echo $this->id .'_regions['. $i .'][users_roles][]'; ?>" style="width:450px;" data-placeholder="<?php _e( 'Choose users roles', 'wc-ss' ); ?>" title="Users roles" class="chosen_select">
                    						        	    <option value="all-users" <?php selected( in_array( 'all-users', $data[ 'users_roles' ] ), true, true ); ?> ><?php _e( 'All users', 'wc-ss' ); ?></option>
                    						        	    <option value="guest-user" <?php selected( in_array( 'guest-user', $data[ 'users_roles' ] ), true, true ); ?> ><?php _e( 'Guest user', 'wc-ss' ); ?></option>
                    						        	    <?php
                    						        	        if ( !empty( $this->users_roles ) ) {
			
                    						        	    		$roles_list = $this->users_roles;
                    						        	            	foreach ( $roles_list as $role_id => $role_name ) {
                    						        	            	    echo '<option value="'. $role_id .'" ' . selected( in_array( $role_id, $data[ 'users_roles' ] ), true, false ).'>'. $role_name .'</option>';
                    						        	            	}
                    						        	        }
                    						        	    ?>
                    						        	</select><br>
									</fieldset>
                    						    </td>
                    						</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend class="same-row">
												<span><?php _e( 'Including tax', 'wc-ss' ); ?></span>
												<?php echo wc_help_tip( __( 'Use only when you have shipping rules based on price.', 'wc-ss' ) ); ?>
											</legend>
											<input type="checkbox" name="<?php echo $this->id .'_regions['. $i .'][including_tax]'; ?>" id="woocommerce_region_<?php echo $i; ?>_including_tax" style="" value="1" <?php checked( $data[ 'including_tax' ], 1 ); ?>>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend class="same-row">
												<span><?php _e( 'Apply percentage of the cart total cost', 'wc-ss' ); ?></span>
												<?php echo wc_help_tip( __( 'If you check this option, the rules apply a percentage of the cart total cost instead of a fixed cost, i.e: a rule with the cost value 10, it mean that the shipping cost is 10% of the cart total cost.', 'wc-ss' ) ); ?>
											</legend>
											<input type="checkbox" name="<?php echo $this->id .'_regions['. $i .'][apply_percentage]'; ?>" id="woocommerce_region_<?php echo $i; ?>_apply_percentage" style="" value="1" <?php if( isset( $data[ 'apply_percentage' ] ) ) checked( $data[ 'apply_percentage' ], 1 ); ?>>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend class="same-row">
												<span><?php _e( 'Apply shipping class priority', 'wc-ss' ); ?></span>
												<?php echo wc_help_tip( __( 'If you check this option, the final shipping rate will match with the cost of the shipping class with the higher priority.', 'wc-ss' ) ); ?>
											</legend>
											<input type="checkbox" name="<?php echo $this->id .'_regions['. $i .'][shipping_class_priority]'; ?>" id="woocommerce_region_<?php echo $i; ?>_shipping_class_priority" style="" value="1" <?php checked( $data[ 'shipping_class_priority' ], 1 ); ?>>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<table id="<?php echo $this->id .'_region_'. $i; ?>" class="shippingrows widefat" cellspacing="0">
											<thead>
												<tr>
													<td id="cb" class="manage-column column-cb check-column">
														<label class="screen-reader-text" for="cb-select-all-<?php echo $i; ?>"><?php _e( 'Select all', 'wc-ss' ); ?></label>
														<input id="cb-select-all-<?php echo $i; ?>" type="checkbox">
													</td>
													<th class="shipping_class"><?php _e( 'Shipping class', 'wc-ss' ) ?></th>
													<th class="shipping_class"><?php _e( 'Condition', 'wc-ss' ) ?></th>
													<th class="shipping_class"><?php _e( 'Range [min] and [max]', 'wc-ss' ) ?><a class="tips" data-tip="<?php _e( "Enter here the range of values you want to use for the shipping rule. The comparison is made for values greater than [min] and less than or equal to [max].", 'wc-ss' ); ?>"> [?]</a></th>
													<th class="shipping_class"><?php _e( 'Cost', 'wc-ss' ) ?><a class="tips" data-tip="<?php _e( "You can add a percentage (without % symbol) or a fixed cost, excluding tax.", 'wc-ss' ); ?>"> [?]</a></th>
													<th class="shipping_class"><?php _e( 'Cost per additional unit' , 'wc-ss' ) ?></th>
												</tr>
											</thead>
											<tfoot>
												<tr>
													<th colspan="8">
														<a href="#" class="add button" id="<?php echo $this->id .'_region_'. $i .'_add_button'; ?>" data-region_id="<?php echo $i; ?>"><?php _e( 'Add row', 'wc-ss' ); ?></a>
														<a href="#" class="duplicate button" id="<?php echo $this->id .'_region_'. $i .'_duplicate_button'; ?>" data-region_id="<?php echo $i; ?>"><?php _e( 'Duplicate row', 'wc-ss' ); ?></a>
														<a href="#" class="delete button" id="<?php echo $this->id .'_region_'. $i .'_delete_button'; ?>" data-region_id="<?php echo $i; ?>"><?php _e( 'Delete selected rows', 'wc-ss' ); ?></a>
													</th>
												</tr>
											</tfoot>
											<tbody class="price_table">
											<?php
											$j = -1;
											if( $data[ 'taxes' ] ){
												foreach ( $data[ 'taxes' ] as $key => $value ) {
													$j++;
											?>
														<tr class="flat_rate">
															<th class="check-column"><input type="checkbox" name="select" /></th>
															<td><select name="<?php echo esc_attr( $this->id .'_regions['. $i .'][shipping_class]['. $j .']' ); ?>" class="shipping_class_list">
																<option value="no-class" <?php selected( $value[ 'shipping_class' ], 'no-class' ); ?>><?php _e( 'No Class', 'wc-ss' ); ?></option>
															<?php 
																if ( WC()->shipping->get_shipping_classes() ) {
																
																	foreach ( WC()->shipping->get_shipping_classes() as $shipping_class ) {
		
																		echo '<option value="' . esc_attr( $shipping_class->slug ) . '" '.selected( $value[ 'shipping_class' ], $shipping_class->slug , false).'>'.$shipping_class->name.'</option>';
																	}
																} 
															?>
															</select></td>
															<td><select name="<?php echo esc_attr( $this->id .'_regions['. $i .'][conditional]['. $j .']' ); ?>">
																<option value="1" <?php selected( $value[ 'conditional' ], 1 ); ?>><?php _e( 'Weight', 'wc-ss' ) ?></option>
																<option value="2" <?php selected( $value[ 'conditional' ], 2 ); ?>><?php _e( 'Price', 'wc-ss' ) ?></option>
																<option value="3" <?php selected( $value[ 'conditional' ], 3 ); ?>><?php _e( 'Item count', 'wc-ss' ) ?></option>
																<option value="4" <?php selected( $value[ 'conditional' ], 4 ); ?>><?php _e( 'Volume', 'wc-ss' ) ?></option>
															</select></td>
															<td>
																<div class="horizontal-inputs-wrap">
																	<input type="text" name="<?php echo esc_attr( $this->id .'_regions['. $i .'][range][min]['. $j .']' ); ?>" class="text wc_ss_input_decimal required" placeholder="<?php _e( "Min", "wc-ss" ); ?>" value="<?php echo esc_attr( $value[ 'range' ][ 'min' ] ); ?>">
																	<input type="text" name="<?php echo esc_attr( $this->id .'_regions['. $i .'][range][max]['. $j .']' ); ?>" class="text wc_ss_input_decimal required" placeholder="<?php _e( "Max", "wc-ss" ); ?>" value="<?php echo esc_attr( $value[ 'range' ][ 'max' ] ); ?>">
																</div>
															</td>
															<td><input type="text" class="wc_ss_input_decimal required" value="<?php echo esc_attr( $value[ 'cost' ] ); ?>" name="<?php echo esc_attr( $this->id .'_regions['. $i .'][cost]['. $j .']' ); ?>" placeholder="0.00" size="6" /></td>
															<td><input type="text" class="wc_ss_input_decimal" value="<?php echo esc_attr( $value[ 'cost_per_additional_unit' ] ); ?>" name="<?php echo esc_attr( $this->id .'_regions['. $i .'][cost_per_additional_unit]['. $j .']' ); ?>" placeholder="0.00" size="6"></td>
														</tr>
											<?php
												}					
											}
											?>
											</tbody>
										</table>
									</td>
								</tr>
							</tbody>
						</table>
						<input type="hidden" name="<?php echo $this->id .'_regions['. $i .'][type_of_table]'; ?>" value="shipping_rate">
					</td>
				</tr>
				<?php }elseif ( isset( $data[ 'type_of_table' ] ) && ( "local_pickup" === $data[ 'type_of_table' ] ) ) { ?>
				
				<tr valign="top" class="special_region" data-region_id="<?php echo $i; ?>" data-table_type="local_pickup">
					<th scope="row" class="titledesc">
						<input type="checkbox" name="select" /><span class="editable" style="font-size: 12pt; font-weight: bold; color: #0073aa; cursor: auto;"><?php echo !empty( $data[ 'prices_table_name' ] )? $data[ 'prices_table_name' ] : __( "Table", 'wc-ss' ) .' '. $i; ?></span>
						<button type="button" class="handlediv button-link closed" data-region_id="<?php echo $i; ?>"><span class="toggle-indicator"></span></button>
					</th>
					<td class="forminp" data-region_id="<?php echo $i; ?>" style="display: none;">
						<table>
							<tbody>
								<tr valign="top">
									<td id="<?php echo $this->id .'_region_'. $i; ?>" class="forminp">
										<fieldset>
											<legend>
												<span><?php echo __( "Shipping Method Name", "wc-ss" ); ?></span>
												<?php echo wc_help_tip( __( 'This text will be shown as shipping method title in Cart and Checkout pages.', 'wc-ss' ) ); ?>
											</legend>
											<input type="text" name="<?php echo $this->id .'_regions['. $i .'][table_name]'; ?>" placeholder="<?php echo __( "National Shipping", "wc-ss" ); ?>" size="20" value="<?php echo esc_attr( $data[ 'table_name' ] ); ?>"/><br>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
									<td class="forminp">
										<fieldset>
											<legend><span><?php echo __( 'Shipping zone', 'wc-ss' ); ?></span></legend>
											<select class="select" name="<?php echo $this->id .'_regions['. $i .'][shipping_zone]'; ?>" id="woocommerce_region_<?php echo $i; ?>_shipping_zone">
											<?php
												if ( !empty( $this->shipping_zones ) ){
													foreach ( $this->shipping_zones as $key => $shipping_zone ){
											?>
														<option value="<?php echo esc_attr( $shipping_zone[ 'zone_id' ] ); ?>" <?php selected( $shipping_zone[ 'zone_id' ], $data[ 'shipping_zone' ] ); ?> ><?php echo esc_js( $shipping_zone[ 'zone_title' ] ); ?></option>
											<?php
													}
												}
											?>
											</select><br>
										</fieldset>
									</td>
								</tr>
								<tr valign="top">
                    						    <td class="forminp">
                    						    	<fieldset>
                    						    		<legend><span><?php echo __( 'Apply by user rol', 'wc-ss' ); ?></span></legend>
                    						        	<select multiple="multiple" name="<?php echo $this->id .'_regions['. $i .'][users_roles][]'; ?>" style="width:450px;" data-placeholder="<?php _e( 'Choose users roles', 'wc-ss' ); ?>" title="Users roles" class="chosen_select">
                    						        	    <option value="all-users" <?php selected( in_array( 'all-users', $data[ 'users_roles' ] ), true, true ); ?> ><?php _e( 'All users', 'wc-ss' ); ?></option>
                    						        	    <option value="guest-user" <?php selected( in_array( 'guest-user', $data[ 'users_roles' ] ), true, true ); ?> ><?php _e( 'Guest user', 'wc-ss' ); ?></option>
                    						        	    <?php
                    						        	        if ( !empty( $this->users_roles ) ) {
			
                    						        	    		$roles_list = $this->users_roles;
                    						        	            	foreach ( $roles_list as $role_id => $role_name ) {
                    						        	            	    echo '<option value="'. $role_id .'" ' . selected( in_array( $role_id, $data[ 'users_roles' ] ), true, false ).'>'. $role_name .'</option>';
                    						        	            	}
                    						        	        }
                    						        	    ?>
                    						        	</select><br>
									</fieldset>
                    						    </td>
                    						</tr>
							</tbody>
						</table>
						<input type="hidden" name="<?php echo $this->id .'_regions['. $i .'][type_of_table]'; ?>" value="local_pickup">
					</td>
				</tr>	
				<?php }
			}
		}
		?>
</tbody>
<tfoot class="special_rate_table">
	<tr>
		<td colspan="4"><a href="#" class="add button" id="add_table_button"><?php _e( 'Add Table', 'wc-ss' ); ?></a> <a href="#" class="duplicate button" id="duplicate_table_button"><?php _e( 'Duplicate Tables', 'wc-ss' ); ?></a> <a href="#" class="remove button" id="remove_table_button"><?php _e( 'Delete Selected Tables', 'wc-ss' ); ?></a></td>
	</tr>
</tfoot>
<div id="wc-ss-table-shipping-type-dialog" class="hidden" style="max-width:800px;">
  <h4><?php _e( 'What type of shipping table do you need?', 'wc-ss' ); ?></h4><?php echo wc_help_tip( __( 'If you are going to set up your shipping costs based on the weight, volume, price, product units or even if it is free, then select the "Normal" option.<br>If, on the other hand, you want to give your customers the possibility in store pick up, then select "Local pick up".', 'wc-ss' ) ); ?>
  <div class="wc-ss-tot">
  	<a href="#" class="add button" id="add_rate_table"><?php _e( 'Normal', 'wc-ss' ); ?></a>
  	<a href="#" class="add button" id="add_local_pickup_table"><?php _e( 'Local pick up', 'wc-ss' ); ?></a>
  </div>
</div>