<?php
/*
Plugin Name: Pasarela de pago para Redsýs (modulosdepago.es)
Plugin URI: http://modulosdepago.es/
Description: La pasarela de pago Redsýs de para WooCommerce de ZhenIT Software <a href="http://www.modulosdepago.es/">vea otras pasarelas de ZhenIT Software</a>.
Version: 2.1
Author: Mikel Martin (ZhenIt Software)
Author URI: http://ZhenIT.com/

	Copyright: © 2009-2013 ZhenIT Software.
	License: GNU General Public License v3.0
	License URI: http://www.gnu.org/licenses/gpl-3.0.html

*/

add_action('plugins_loaded', 'woocommerce_servired_init', 100);

function woocommerce_servired_init() {
	/**
	* Required functions
	*/
	if ( ! function_exists( 'is_woocommerce_active' ) ) require_once( 'zhenit-includes/zhenit-functions.php' );

	if ( ! class_exists( 'WC_Payment_Gateway' ) || ! is_woocommerce_active() )
		return;

	load_plugin_textdomain( 'wc_redsys', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	/**
	 * Pasarela Redsýs Gateway Class
	 * */
	class woocommerce_servired extends WC_Payment_Gateway {


		public function __construct() {
			global $woocommerce;

			$this->id = 'servired';
			$this->icon = WP_PLUGIN_URL . "/" . plugin_basename(dirname(__FILE__)) . '/images/cards.png';
			$this->has_fields = false;
			$this->liveurl = 'https://sis.redsys.es/sis/realizarPago';
			$this->testurl = 'https://sis-t.redsys.es:25443/sis/realizarPago';

			// Load the form fields
			$this->init_form_fields();

			// Load the settings.
			$this->init_settings();

			// Get setting values
			$this->enabled = $this->settings['enabled'];
			$this->title = $this->settings['title'];
			$this->description = $this->settings['description'];
			$this->merchant = $this->settings['merchant'];
			$this->terminal = $this->settings['terminal'];
			$this->merchantname = $this->settings['merchantname'];
			$currency_codes = array(
				'EUR' => 978,
				'USD' => 840,
				'GBP' => 826
			);
			$this->currency = $currency_codes[ get_woocommerce_currency() ];
			$this->clave = $this->settings['clave'];
			$this->notif_http = $this->settings['notif_http'];
			$this->tipo_firma = $this->settings['tipo_firma'];
			$this->entorno = $this->settings['entorno'];
			$this->debug = $this->settings['debug'];

			// Logs
			if ($this->debug == 'yes')
				$this->log = new WC_Logger();

			// Hooks
			if ( version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) ){
				//BOF dejamos por compatibilidad con las versiones 1.6.x
				add_action('init', array(&$this, 'check_' . $this->id. '_resquest'));
				add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));
				//EOF dejamos por compatibilidad con las versiones 1.6.x			
			}
			add_action('woocommerce_receipt_' . $this->id, array($this, 'receipt_page'));
			add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
			add_action('woocommerce_api_woocommerce_' . $this->id, array( $this, 'check_' . $this->id . '_resquest' ) );			
		}

		/**
		 * Initialize Gateway Settings Form Fields
		 */
		function init_form_fields() {

			$this->form_fields = array(
				'enabled' => array(
					'title' => __('Enable/Disable', 'wc_redsys'),
					'label' => __('Habilitar pasarela Redsýs', 'wc_redsys'),
					'type' => 'checkbox',
					'description' => '',
					'default' => 'no'
				),
				'title' => array(
					'title' => __('Title', 'wc_redsys'),
					'type' => 'text',
					'description' => __('This controls the title which the user sees during checkout.', 'wc_redsys'),
					'default' => __('Tarjeta de crédito o débito (vía Redsýs)', 'wc_redsys')
				),
				'description' => array(
					'title' => __('Description', 'wc_redsys'),
					'type' => 'textarea',
					'description' => __('This controls the description which the user sees during checkout.', 'wc_redsys'),
					'default' => 'Pague con trajeta de crédito de forma segura a través de la pasarela de Redsýs.'
				),
				'merchantname' => array(
					'title' => __('Nombre del comercio', 'wc_redsys'),
					'type' => 'text',
					'description' => __('Se mostrará en la página que solicitar los datos de la tarjeta', 'wc_redsys'),
					'default' => get_option( 'blogname')
				),
				'merchant' => array(
					'title' => __('Número de comercio', 'wc_redsys'),
					'type' => 'text',
					'description' => __('Número de comercio proporcionado por Redsýs.', 'wc_redsys'),
					'default' => ''
				),
				'terminal' => array(
					'title' => __('Número de terminal', 'wc_redsys'),
					'type' => 'text',
					'description' => __('Número de terminal proporcionado por Redsýs.', 'wc_redsys'),
					'default' => ''
				),
				'clave' => array(
					'title' => __('Clave de encriptación', 'wc_redsys'),
					'type' => 'text',
					'description' => __('Clave de encriptación proporcionada por Redsýs.', 'wc_redsys'),
					'default' => ''
				),
				'notif_http' => array(
					'title' => __('Notificación HTTP', 'wc_redsys'),
					'label' => __('Marque esta casilla si usa notificación HTTP+...', 'wc_redsys'),
					'type' => 'checkbox',
					'description' => __('Si no usa notificación HTTP asegúrese de que ha configurado el envío de parámetros en las URLs en https://canales.sermepa.es/', 'wc_redsys'),
					'default' => 'no'
				),
				'tipo_firma' => array(
					'title' => __( 'Tipo de firma', 'wc_redsys' ),
					'type' => 'select',
					'description' => '',
					'default' => 'order',
					'options' => array(
					  'c' => __('SHA-1 Completa', 'wc_redsys'),
					  'a' => __('SHA-1 Completa ampliada', 'wc_redsys')
					)
				),
				'entorno' => array(
					'title' => __( 'Entorno', 'wc_redsys' ),
					'label' => __( 'Marque si está en producción', 'wc_redsys' ),
					'type' => 'select',
					'description' => __( 'Al principio estará en pruebas. Una vez realizadas las pruebas con las tarjetas que le hayan indicado, podrá solicitar el paso a producción y le harán entrega de la clave de encriptación definitiva para el entorno real. Dependiendo de la entidad este proceso puede variar.', 'wc_redsys' ),
					'default' => '1',
					'options' => array(
						'1' => __( 'Pruebas en sis-t', 'wc_redsys' ),
						'0' => __( 'Real', 'wc_redsys' )
					)
				),
				'debug' => array(
					'title' => __('Debugging', 'wc_redsys'),
					'label' => __('Modo debug', 'wc_redsys'),
					'type' => 'checkbox',
					'description' => __('Sólo para desarrolladores.', 'wc_redsys'),
					'default' => 'no'
				)
			);
		}

		/**
		 * There are no payment fields for Redsýs, but we want to show the description if set.
		 * */
		function payment_fields() {
			if ($this->description)
				echo wpautop(wptexturize($this->description));
		}

		/**
		 * Admin Panel Options
		 * - Options for bits like 'title' and availability on a country-by-country basis
		 * */
		public function admin_options() {
			?>
			<h3><?php _e('Pasarela Redsýs', 'wc_redsys'); ?></h3>
			<p><?php _e('<p>La pasarela Redsýs de <a href="http://ZhenIT.com">ZhenIT Software</a> para Woocommerce le permitirá dar la opción de pago por tarjeta de crédito o débito en su comercio. Para ello necesitará un tpv virtual de Redsýs. Conviene que disponga también de acceso al <a href="https://canales.sermepa.es/">Backoffice de sermepa</a></p>', 'wc_redsys'); ?></p>
			<table class="form-table">
				<?php $this->generate_settings_html(); ?>
			</table><!--/.form-table-->
			<?php
		}

		/**
		 * Check for Redsýs IPN Response
		 * */
		function check_servired_resquest() {
			if (!isset($_GET['qbLstr']))
				return;

			if ($_GET['qbLstr'] == 'notify'){
				$ds_amount = $_REQUEST["Ds_Amount"];
				$ds_order  = $_REQUEST["Ds_Order"];
				$ds_merchantcode = $_REQUEST["Ds_MerchantCode"];
				$ds_currency	 = $_REQUEST["Ds_Currency"];
				$respuesta	= $_REQUEST["Ds_Response"];
				$firma_remota = $_REQUEST["Ds_Signature"];
				// Cálculo del SHA1
				$mensaje = $ds_amount . $ds_order . $ds_merchantcode . $ds_currency . $respuesta . $this->getClave();
				$firma_local = strtoupper(sha1($mensaje));
				if ($firma_local != $firma_remota)
					return;

				$order = new WC_Order((int) substr($ds_order,0,8));
				// Check order not already completed
				if ($order->status == 'completed'){
						if ($this->debug=='yes') $this->log->add( 'servired', 'Aborting, Order #' . $posted['custom'] . ' is already complete.' );
						return;
				}

				if ($respuesta < 101){//pago OK
					update_post_meta( (int) $order->id, 'Resultado', $respuesta);
					update_post_meta( (int) $order->id, 'Fecha', $_REQUEST['Ds_Date']);
					update_post_meta( (int) $order->id, 'Hora', $_REQUEST['Ds_Hour']);
					update_post_meta( (int) $order->id, 'Ds_Order (Referencia)', $_REQUEST['Ds_Order']);
					update_post_meta( (int) $order->id, 'Ds_TransactionType', $_REQUEST['Ds_TransactionType']);
					update_post_meta( (int) $order->id, 'Ds_SecurePayment', $_REQUEST['Ds_SecurePayment']);
					update_post_meta( (int) $order->id, 'Ds_MerchantData',  $_REQUEST['Ds_MerchantData']);
					update_post_meta( (int) $order->id, 'Ds_AuthorisationCode',  $_REQUEST['Ds_AuthorisationCode']);
					update_post_meta( (int) $order->id, 'Ds_Card_Country',  $_REQUEST['Ds_Card_Country']);
					// Payment completed
					$order->add_order_note( __('Redsýs payment completed', 'wc_redsys') );
					$order->payment_complete();

					if ($this->debug=='yes') $this->log->add( 'servired', 'Payment complete.' );
					$url = $this->get_return_url( $order );
				}else{
					$url = $order->get_cancel_order_url();
				}
				if($_GET['rd']=='1'){
					wp_redirect($url, 303);
					exit();
				}
			}
		}
		/**
		 * Get Redsýs language code
		 * */
		function _getLanguange() {
			$lng = substr(get_bloginfo('language'),0,2);
			if(function_exists('qtrans_getLanguage')) $lng = qtrans_getLanguage();
			if(defined('ICL_LANGUAGE_CODE'))  $lng = ICL_LANGUAGE_CODE;
			switch ($lng){
				case 'en':
					return '002';
				case 'ca':
					return '003';
				case 'fr':
					return '004';
				case 'de':
					return '005';
				case 'dk':
					return '006';
				case 'it':
					return '007';
				case 'sk':
					return '008';
				case 'pt':
					return '009';
				case 'va':
					return '010';
				case 'po':
					return '011';
				case 'gl':
					return '012';
				case 'eu':
					return '013';
				default:
					return '001';
			}
			return '001';
		}

		/**
		 * Get Redsýs Args for passing to PP
		 * */
		function get_servired_args($order) {
			global $woocommerce;

			$ds_merchant_consumerlanguage = $this->_getLanguange();
			$ds_merchant_order = str_pad($order->id, 8, "0", STR_PAD_LEFT) . date('is');
			$ds_merchant_amount = round($order->get_total()*100);
			$ds_merchant_currency = $this->currency;
			$ds_merchant_code = $this->merchant;
			$ds_merchant_terminal = $this->terminal;
			$ds_merchant_merchanturl = '';
			$ds_merchant_urlok = str_replace( 'https:', 'http:', add_query_arg(array('qbLstr'=>'notify','wc-api'=>'woocommerce_'. $this->id,'rd'=>'1'), home_url( '/' ) ));
			if ( version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) )
				$ds_merchant_urlok = trailingslashit(home_url()).'?qbLstr=notify&rd=1';
			$ds_merchant_transactiontype = 0;
			$ds_merchant_titular = '';

			if($this->notif_http=='yes'){
				$ds_merchant_merchanturl = str_replace( 'https:', 'http:', add_query_arg(array('qbLstr'=>'notify','wc-api'=>'woocommerce_'. $this->id), home_url( '/' ) ));
				$ds_merchant_urlok = $this->get_return_url( $order );
			}
			$ds_merchant_urlko = $order->get_cancel_order_url();

			$mensaje = $ds_merchant_amount . $ds_merchant_order . $ds_merchant_code . $ds_merchant_currency;
			if($this->tipo_firma=='a')
				$mensaje .= $ds_merchant_transactiontype . $ds_merchant_merchanturl;

			$signature = strtoupper(sha1($mensaje.$this->getClave()));

			$servired_args = array(
				'Ds_Merchant_Amount' =>$ds_merchant_amount,
				'Ds_Merchant_Currency' =>$ds_merchant_currency,
				'Ds_Merchant_Order' =>$ds_merchant_order,
				'Ds_Merchant_ProductDescription' =>$ds_merchant_productdescription,
				'Ds_Merchant_Titular' =>$ds_merchant_titular,
				'Ds_Merchant_MerchantCode' =>$ds_merchant_code,
				'Ds_Merchant_MerchantName' =>utf8_decode($this->merchantname),
				'Ds_Merchant_UrlOK' =>$ds_merchant_urlok,
				'Ds_Merchant_UrlKO' =>$ds_merchant_urlko,
				'Ds_Merchant_ConsumerLanguage' =>$ds_merchant_consumerlanguage,
				'Ds_Merchant_MerchantSignature' =>$signature,
				'Ds_Merchant_Terminal' =>$ds_merchant_terminal,
				'Ds_Merchant_MerchantData' =>$ds_merchant_data,
				'Ds_Merchant_TransactionType' =>$ds_merchant_transactiontype,
				'Ds_Merchant_PayMethods' =>'T'
			);
			if($ds_merchant_merchanturl!=''){
				$servired_args['Ds_Merchant_MerchantURL'] = $ds_merchant_merchanturl;
			}
		//$servired_args = apply_filters( 'woocommerce_servired_args', $servired_args );

			return $servired_args;
		}

		function getClave() {
			if ($this->entorno == 1)
				return 'qwertyasdf0123456789';
			return utf8_decode ( $this->clave );
		}

		/**
		 * Generate the servired button link
		 * */
		function generate_servired_form($order_id) {
			global $woocommerce;

			$order = new WC_Order($order_id);

			if ($this->entorno == 1):
				$servired_adr = $this->testurl;
			else :
				$servired_adr = $this->liveurl;
			endif;

			$servired_args = $this->get_servired_args($order);

			$servired_args_array = array();

			foreach ($servired_args as $key => $value) {
				$servired_args_array[] = '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';
			}

			wc_enqueue_js('
			jQuery("body").block({
					message: "<img src=\"' . esc_url($woocommerce->plugin_url()) . '/assets/images/ajax-loader.gif\" alt=\"Redirecting...\" style=\"float:left; margin-right: 10px;\" />' . __('Thank you for your order. We are now redirecting you to Redsýs to make payment.', 'wc_redsys') . '",
					overlayCSS:
					{
						background: "#fff",
						opacity: 0.6
					},
					css: {
						padding:		20,
						textAlign:	  "center",
						color:		  "#555",
						border:		 "3px solid #aaa",
						backgroundColor:"#fff",
						cursor:		 "wait",
						lineHeight:		"32px"
					}
				});
			jQuery("#submit_servired_payment_form").click();
		');

			return '<form action="' . esc_url($servired_adr) . '" method="post" id="servired_payment_form" target="_top">
				' . implode('', $servired_args_array) . '
				<input type="submit" class="button-alt" id="submit_servired_payment_form" value="' . __('Make the payment with your Credit Card', 'wc_redsys') . '" /> <a class="button cancel" href="' . esc_url($order->get_cancel_order_url()) . '">' . __('Cancel order &amp; restore cart', 'wc_redsys') . '</a>
			</form>';
		}

		function process_payment( $order_id ) {

			$order = new WC_Order( $order_id );
			return array(
				'result'	 => 'success',
				'redirect'	=> $order->get_checkout_payment_url( true )
			);
		}

		/**
		 * receipt_page
		 * */
		function receipt_page($order) {
			echo '<p>' . __('Thank you for your order, please click the button below to pay with your Credit Card.', 'wc_redsys') . '</p>';
			echo $this->generate_servired_form($order);
		}

		/**
		 * Get post data if set
		 * */
		private function get_post($name) {
			if (isset($_POST[$name])) {
				return $_POST[$name];
			}
			return NULL;
		}

	}

	/**
	 * Add the gateway to woocommerce
	 * */
	function add_servired_gateway($methods) {
		$methods[] = 'woocommerce_servired';
		return $methods;
	}

	add_filter('woocommerce_payment_gateways', 'add_servired_gateway');
}
